/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.service.internal;

import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.plugins.DefaultPluginRegistry;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.lazy.Lazy;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolutionVisitor;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.service.internal.ClientInjectedClasspathPluginResolver;
import org.gradle.plugin.use.resolve.service.internal.InjectedClasspathInstrumentationStrategy;

public class DefaultInjectedClasspathPluginResolver
implements ClientInjectedClasspathPluginResolver,
PluginResolver {
    private final ClassPath injectedClasspath;
    private final FileCollectionFactory fileCollectionFactory;
    private final ScriptClassPathResolver scriptClassPathResolver;
    private final ClassLoaderScope parentScope;
    private final PluginInspector pluginInspector;
    private final Lazy<PluginRegistry> pluginRegistry;

    public DefaultInjectedClasspathPluginResolver(ClassLoaderScope parentScope, ScriptClassPathResolver scriptClassPathResolver, FileCollectionFactory fileCollectionFactory, PluginInspector pluginInspector, ClassPath injectedClasspath, InjectedClasspathInstrumentationStrategy instrumentationStrategy, Factory<DependencyResolutionServices> dependencyResolutionServicesFactory) {
        this.parentScope = parentScope;
        this.pluginInspector = pluginInspector;
        this.injectedClasspath = injectedClasspath;
        this.fileCollectionFactory = fileCollectionFactory;
        this.scriptClassPathResolver = scriptClassPathResolver;
        this.pluginRegistry = Lazy.locking().of(() -> this.createPluginRegistry(dependencyResolutionServicesFactory));
        DefaultInjectedClasspathPluginResolver.maybeReportAgentUsageWithTestKitProblem(instrumentationStrategy);
    }

    private PluginRegistry createPluginRegistry(Factory<DependencyResolutionServices> dependencyResolutionServicesFactory) {
        DependencyResolutionServices dependencyResolutionServices = (DependencyResolutionServices)dependencyResolutionServicesFactory.create();
        DependencyHandler dependencies = dependencyResolutionServices.getDependencyHandler();
        ConfigurationContainer configurations = dependencyResolutionServices.getConfigurationContainer();
        Dependency injectedClasspathDependency = dependencies.create((Object)this.fileCollectionFactory.fixed((Collection)this.injectedClasspath.getAsFiles()));
        Configuration configuration = configurations.detachedConfiguration(new Dependency[]{injectedClasspathDependency});
        this.scriptClassPathResolver.prepareDependencyHandler(dependencies);
        this.scriptClassPathResolver.prepareClassPath(configuration, dependencies);
        ClassPath instrumentedClassPath = this.scriptClassPathResolver.resolveClassPath(configuration);
        return new DefaultPluginRegistry(this.pluginInspector, this.parentScope.createChild("injected-plugin", null).local(instrumentedClassPath).lock());
    }

    private static void maybeReportAgentUsageWithTestKitProblem(InjectedClasspathInstrumentationStrategy instrumentationStrategy) {
        instrumentationStrategy.getTransform();
    }

    @Override
    public void collectResolversInto(Collection<? super PluginResolver> dest) {
        dest.add(this);
    }

    @Override
    public PluginResolutionResult resolve(PluginRequestInternal pluginRequest) {
        PluginImplementation plugin = ((PluginRegistry)this.pluginRegistry.get()).lookup(pluginRequest.getId());
        if (plugin == null) {
            String classpathStr = this.injectedClasspath.getAsFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
            return PluginResolutionResult.notFound(this.getDescription(), "classpath: " + classpathStr);
        }
        return PluginResolutionResult.found(new InjectedClasspathPluginResolution(plugin));
    }

    public String getDescription() {
        return "Gradle TestKit";
    }

    private static class InjectedClasspathPluginResolution
    implements PluginResolution {
        private final PluginImplementation<?> plugin;

        public InjectedClasspathPluginResolution(PluginImplementation<?> plugin) {
            this.plugin = plugin;
        }

        @Override
        public PluginId getPluginId() {
            return this.plugin.getPluginId();
        }

        @Override
        public void accept(PluginResolutionVisitor visitor) {
            visitor.visitClassLoader(this.plugin.asClass().getClassLoader());
        }

        @Override
        public void applyTo(PluginManagerInternal pluginManager) {
            pluginManager.apply(this.plugin);
        }
    }
}

