;;; support-jitsuu.el --- suport file for "字通"
;; Copyright (C) 2009 KAWABATA Taichi <kawabata.taichi@gmail.com>

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;;; Memo:

;; AJ1-6のIVSでは対応できなかった旧字については、コメントに「旧字」と附した。
;; これらには、四画草冠・はみ出さない「身」・「育・㐬」の上部が三画・「立」の
;; 初画が横画・三画の「止」、等が含まれる。

;; 末尾にコメントアウトしているのは、親字として立てられながら、AJ1-6では対応
;; できていない異体字で、現状では画像として扱うべきと考えられるものである。

;;; Code:

(let 
  ((encoded-jitsuu-gaiji-table
    '(
      ("H1-41" "ə")
      ("H1-42" "ā")
      ("H1-43" "ī")
      ("H1-44" "ṃ")
      ("H1-45" "ṇ")
      ("H1-46" "ô")
      ("H1-47" "ś")
      ("H1-48" "ṣ")
      ("H1-49" "ū")
      ("11-4E00" "彧")
      ("11-4E01" "芍󠄁")
      ("11-4E03" "睽")
      ("11-4E07" "爹")
      ("11-4E08" "冴󠄂")
      ("11-4E09" "偊")
      ("11-4E0A" "冴")
      ("11-4E0B" "延󠄂")
      ("11-4E0D" "傓")
      ("11-4E0E" "黮")
      ("11-4E10" "擢󠄁")
      ("11-4E11" "寏")
      ("11-4E14" "餓")
      ("11-4E15" "擲󠄀")
      ("11-4E16" "潢")
      ("11-4E17" "𧗕")
      ("11-4E18" "頟")
      ("11-4E19" "歬")
      ("11-4E1E" "吳")
      ("11-4E21" "釣󠄁")
      ("11-4E26" "𨖆")
      ("11-4E2A" "擿")
      ("11-4E2D" "這󠄁")
      ("11-4E31" "蹢")
      ("11-4E32" "轘")
      ("11-4E36" "鏑") ;; 旧字
      ("11-4E38" "艾")
      ("11-4E39" "躧")
      ("11-4E3B" "䲔")
      ("11-4E3C" "𩮜")
      ("11-4E3F" "趯󠄀")
      ("11-4E42" "躑󠄀")
      ("11-4E43" "胗")
      ("11-4E45" "斅")
      ("11-4E4B" "裖")
      ("11-4E4D" "㚔")
      ("11-4E4E" "闚")
      ("11-4E4F" "瞍󠄁")
      ("11-4E56" "蹢")
      ("11-4E57" "啎")
      ("11-4E58" "惄")
      ("11-4E59" "㕣󠄀")
      ("11-4E5D" "爤󠄀")
      ("11-4E5E" "噱")
      ("11-4E5F" "逴")
      ("11-4E71" "註󠄁")
      ("11-4E73" "織")
      ("11-4E7E" "䢔")
      ("11-4E80" "碻")
      ("11-4E85" "㲻")
      ("11-4E86" "朓")
      ("11-4E88" "譚󠄁")
      ("11-4E89" "薩󠄁") ;; 旧字
      ("11-4E8A" "叕")
      ("11-4E8B" "倞")
      ("11-4E8C" "跱")
      ("11-4E8E" "惙")
      ("11-4E92" "菊") ;; 旧字
      ("11-4E94" "匊")
      ("11-4E95" "黟")
      ("11-4E98" "啇") ;; 旧字
      ("11-4E99" "倜")
      ("11-4E9B" "跫") ;; 旧字
      ("11-4E9C" "丫")
      ("11-4E9E" "掇")
      ("11-4E9F" "絰")
      ("11-4EA0" "驖")
      ("11-4EA1" "𥈟")
      ("11-4EA2" "苶")
      ("11-4EA4" "屰")
      ("11-4EA5" "壝")
      ("11-4EA6" "鐏")
      ("11-4EAB" "豻")
      ("11-4EAD" "住󠄁")
      ("11-4EAE" "彫󠄁")
      ("11-4EB0" "㐁")
      ("11-4EB3" "㢟") ;; 旧字
      ("11-4EB6" "佔")
      ("11-4EBA" "穅")
      ("11-4EC0" "槷")
      ("11-4EC1" "悻")
      ("11-4EC2" "㓠")
      ("11-4EC4" "㤁")
      ("11-4EC6" "玷")
      ("11-4EC7" "鱷")
      ("11-4ECA" "栱")
      ("11-4ECB" "棜")
      ("11-4ECD" "坫")
      ("11-4ECE" "辿󠄁")
      ("11-4ECF" "蘚")
      ("11-4ED4" "庽")
      ("11-4ED5" "寓") ;; 旧字
      ("11-4ED7" "㥏")
      ("11-4ED8" "揃󠄁")
      ("11-4ED9" "齕")
      ("11-4EDE" "淟")
      ("11-4EDF" "奠󠄀")
      ("11-4EE3" "菑")
      ("11-4EE4" "𦨶")
      ("11-4EE5" "韋") ;; 旧字
      ("11-4EED" "添󠄁")
      ("11-4EEE" "炎") ;; 旧字
      ("11-4EF0" "秆")
      ("11-4EF2" "这")
      ("11-4EF6" "琪")
      ("11-4EF7" "㠭")
      ("11-4EFB" "瞩")
      ("11-4F01" "慨󠄄")
      ("11-4F09" "塡")
      ("11-4F0A" "扆")
      ("11-4F0D" "躹")
      ("11-4F0E" "該") ;; 旧字
      ("11-4F0F" "璇")
      ("11-4F11" "𧊜")
      ("11-4F1A" "隖")
      ("11-4F1C" "殬")
      ("11-4F1D" "緒") ;; 旧字
      ("11-4F2F" "飪")
      ("11-4F30" "滇")
      ("11-4F34" "晟󠄁")
      ("11-4F36" "琛")
      ("11-4F38" "洚")
      ("11-4F3A" "堣")
      ("11-4F3C" "栔")
      ("11-4F3D" "阽")
      ("11-4F43" "遒")
      ("11-4F46" "簁")
      ("11-4F47" "鄽")
      ("11-4F4D" "栘")
      ("11-4F4F" "孼")
      ("11-4F51" "耼")
      ("11-4F53" "茈")
      ("11-4F55" "苑") ;; 旧字
      ("11-4F57" "瑱")
      ("11-4F59" "鐔")
      ("11-4F5B" "瑑")
      ("11-4F5C" "勤󠄁")
      ("11-4F5D" "墊")
      ("11-4F5E" "頻󠄀")
      ("11-4F69" "儃")
      ("11-4F6F" "顚")
      ("11-4F70" "簟")  ;; 旧字
      ("11-4F73" "弇")
      ("11-4F75" "耎")
      ("11-4F7B" "邅")
      ("11-4F7C" "虐󠄁")
      ("11-4F7F" "遇󠄁")
      ("11-4F86" "瘨")
      ("11-4F88" "𥧑")
      ("11-4F8B" "敶")
      ("11-4F8D" "涇")
      ("11-4F8F" "讇")
      ("11-4F91" "闐")
      ("11-4F98" "𩈍")
      ("11-4F9B" "攼")
      ("11-4F9D" "偉󠄁")
      ("11-4FAD" "垜")
      ("11-4FAE" "遷󠄁")
      ("11-4FAF" "逆󠄁")
      ("11-4FB6" "苕")
      ("11-4FBF" "䶥")
      ("11-4FC2" "宄")
      ("11-4FC3" "蘸")
      ("11-4FC4" "嬿")
      ("11-4FCA" "埍")
      ("11-4FCE" "涂")
      ("11-4FD0" "堵󠄁")
      ("11-4FD1" "荼") ;; 旧字
      ("11-4FD4" "兎󠄁")
      ("11-4FD7" "儳")
      ("11-4FD8" "途󠄁")
      ("11-4FDA" "都󠄀")
      ("11-4FDB" "𣥳")
      ("11-4FDD" "㕚")
      ("11-4FDF" "妒")
      ("11-4FE3" "鱒󠄁")
      ("11-4FE4" "屠󠄁")
      ("11-4FE5" "稌")
      ("11-4FEE" "朅")
      ("11-4FEF" "弢")
      ("11-4FF3" "鋟")
      ("11-4FF5" "櫼")
      ("11-4FF6" "砮")
      ("11-4FF8" "牕")
      ("11-4FFA" "䜭")
      ("11-4FFE" "匋")
      ("11-5005" "斁")
      ("11-5006" "舠")
      ("11-5009" "怍")
      ("11-500B" "餼")
      ("11-500D" "鬒")
      ("11-5011" "枓")
      ("11-5012" "宵󠄁")
      ("11-5014" "嵞")
      ("11-5016" "及󠄁")
      ("11-5019" "丩")
      ("11-501A" "菟󠄂")
      ("11-501F" "觿")
      ("11-5021" "冬󠄀")
      ("11-5023" "窗")
      ("11-5024" "餌󠄃")
      ("11-5025" "賭󠄁")
      ("11-5026" "萁")
      ("11-5028" "陼")
      ("11-5029" "忉")
      ("11-502A" "瘏")
      ("11-502B" "嚘") ;; worng
      ("11-502C" "彤")
      ("11-502D" "餟")
      ("11-5036" "翰󠄁")
      ("11-5039" "睎")
      ("11-5043" "洮")
      ("11-5047" "逃󠄂")
      ("11-5049" "𢍚")
      ("11-504F" "愬")
      ("11-5050" "疼󠄁")
      ("11-5055" "㠀")
      ("11-5056" "荅") ;; 旧字
      ("11-505A" "𦐇") ;; 旧字
      ("11-505C" "歰")
      ("11-5065" "葵") ;; 旧字
      ("11-506C" "透󠄁")
      ("11-5072" "愒")
      ("11-5074" "纘")
      ("11-5075" "厹")
      ("11-5076" "雚") ;; 旧字
      ("11-5078" "淖")
      ("11-507D" "虢󠄀")
      ("11-5080" "逗")
      ("11-5085" "婾")
      ("11-508D" "糉")
      ("11-5091" "媐")
      ("11-5098" "踽")
      ("11-5099" "踖")
      ("11-509A" "塔") ;; 旧字
      ("11-50AC" "繈")
      ("11-50AD" "談") ;; 旧字
      ("11-50B2" "愓")
      ("11-50B3" "衕")
      ("11-50B4" "㢏") ;; 旧字
      ("11-50B5" "曏")
      ("11-50B7" "謙󠄁")
      ("11-50BE" "刏")
      ("11-50C2" "嗒")
      ("11-50C5" "雈")
      ("11-50C9" "搭")
      ("11-50CA" "棖")
      ("11-50CD" "蜙")
      ("11-50CF" "劗")
      ("11-50D1" "旰")
      ("11-50D5" "𫁘")
      ("11-50D6" "塘")
      ("11-50DA" "祧")
      ("11-50DE" "幐")
      ("11-50E3" "豋")
      ("11-50E5" "慆")
      ("11-50E7" "䶒")
      ("11-50ED" "董") ;; 旧字
      ("11-50EE" "幢")
      ("11-50F5" "撐")
      ("11-50F9" "憃")
      ("11-50FB" "梳")
      ("11-5101" "樋󠄁")
      ("11-5102" "滕󠄁")
      ("11-5109" "撞") ;; 旧字
      ("11-5112" "鶂")
      ("11-5114" "霅")
      ("11-5115" "鄧")
      ("11-5116" "蹋󠄀")
      ("11-5118" "兔󠄀")
      ("11-511A" "鞉")
      ("11-511F" "繭󠄀")
      ("11-512A" "啖")
      ("11-5132" "鼐")
      ("11-5137" "懂")
      ("11-513B" "橦")
      ("11-513C" "曈")
      ("11-513F" "燙")
      ("11-5141" "𠃉")
      ("11-5143" "徽")
      ("11-5144" "𠦄")
      ("11-5145" "闑")
      ("11-5146" "酌󠄁")
      ("11-5147" "玕")
      ("11-5148" "扤")
      ("11-5149" "彶") ;; 旧字
      ("11-514C" "縢󠄀")
      ("11-514D" "腿󠄁")
      ("11-514E" "曙󠄁")
      ("11-5150" "荊")
      ("11-5152" "餳")
      ("11-5154" "蕩") ;; 旧字
      ("11-515A" "陗")
      ("11-515C" "匃")
      ("11-5162" "螣󠄀")
      ("11-5165" "職") ;; 旧字
      ("11-5168" "𢦒")
      ("11-5169" "璗")
      ("11-516A" "璫")
      ("11-516B" "崧")
      ("11-516C" "勼")
      ("11-516D" "踶")
      ("11-516E" "穜")
      ("11-5171" "䍑")
      ("11-5176" "芝") ;; 旧字
      ("11-5178" "蓴󠄁") ;; 旧字
      ("11-517C" "媿")
      ("11-5180" "謄󠄁")
      ("11-5182" "簦")
      ("11-5185" "狀")
      ("11-5186" "𦶮")
      ("11-5189" "鬭")
      ("11-518A" "釁")
      ("11-518C" "闒")
      ("11-518D" "薑")
      ("11-5192" "樷")
      ("11-5193" "糖")
      ("11-5195" "騊")
      ("11-5196" "𪔳")
      ("11-5197" "迕")
      ("11-5199" "罄")
      ("11-51A0" "恢󠄁")
      ("11-51A2" "韜")
      ("11-51A4" "禱󠄀")
      ("11-51A5" "退󠄁")
      ("11-51A6" "鏜")
      ("11-51A8" "搧")
      ("11-51A9" "餹")
      ("11-51AA" "餳")
      ("11-51AB" "鼗")
      ("11-51AC" "捎")
      ("11-51B0" "籐󠄁")
      ("11-51B1" "翿")
      ("11-51B2" "騰󠄁")
      ("11-51B3" "鞀")
      ("11-51B4" "囷")
      ("11-51B5" "籘󠄁")
      ("11-51B6" "斲")
      ("11-51B7" "追󠄁")
      ("11-51BD" "譶")
      ("11-51C4" "賡")
      ("11-51C5" "戃")
      ("11-51C6" "睠")
      ("11-51C9" "矘")
      ("11-51CB" "焯")
      ("11-51CC" "堞")
      ("11-51CD" "晌")
      ("11-51D6" "芭") ;; 旧字
      ("11-51DB" "讜")
      ("11-51DD" "菅")
      ("11-51E0" "戇")
      ("11-51E1" "遬")
      ("11-51E6" "㓺")
      ("11-51E7" "頾")
      ("11-51EA" "城󠄁")
      ("11-51ED" "童") ;; 旧字
      ("11-51F0" "道󠄁")
      ("11-51F1" "轀")
      ("11-51F5" "僮") ;; 旧字
      ("11-51F8" "薔")
      ("11-51F9" "縈")
      ("11-51FA" "倦󠄁")
      ("11-51FD" "邃") ;; 旧字
      ("11-51FE" "導󠄁")
      ("11-5200" "消󠄁")
      ("11-5203" "悾")
      ("11-5204" "潼")
      ("11-5206" "蹮")
      ("11-5207" "酷󠄁")
      ("11-5208" "芥")
      ("11-520A" "柺")
      ("11-520B" "槈")
      ("11-520E" "獳")
      ("11-5211" "刉")
      ("11-5214" "鎒")
      ("11-5217" "𧖨")
      ("11-5224" "眚")
      ("11-5229" "盩")
      ("11-522A" "夒")
      ("11-522E" "猱")
      ("11-5230" "綃")
      ("11-5233" "獶")
      ("11-5236" "靠󠄁")
      ("11-5238" "戣")
      ("11-5239" "獿")
      ("11-523A" "耦")
      ("11-523B" "𩼪")
      ("11-5243" "尗")
      ("11-5244" "匿󠄁")
      ("11-5247" "鑱")
      ("11-524A" "僅󠄁")
      ("11-524B" "犆")
      ("11-524C" "德")
      ("11-524D" "鏁")
      ("11-524F" "忒")
      ("11-5254" "瀆")
      ("11-5256" "蔟") ;; 旧字
      ("11-525B" "醵")
      ("11-525E" "慝")
      ("11-5264" "輂")
      ("11-5265" "燖")
      ("11-5269" "韇")
      ("11-526A" "櫝")
      ("11-526F" "蟬")
      ("11-5270" "娛")
      ("11-5271" "忳")
      ("11-5273" "韥")
      ("11-5274" "韣")
      ("11-5275" "曬")
      ("11-527D" "栃")
      ("11-527F" "讟")
      ("11-5283" "盉")
      ("11-5287" "起󠄁")
      ("11-5288" "𡱂")
      ("11-5289" "儲󠄁")
      ("11-528D" "𠫓") ;; 旧字
      ("11-5291" "弴")
      ("11-5292" "突󠄁")
      ("11-5294" "㕯")
      ("11-529B" "潮󠄀")
      ("11-529F" "舊") ;; 旧字
      ("11-52A0" "洹")
      ("11-52A9" "𣊡")
      ("11-52AA" "卲")
      ("11-52AB" "䣰") ;; 旧字
      ("11-52AC" "墩")
      ("11-52AD" "遁󠄁")
      ("11-52B1" "槌")
      ("11-52B4" "蜓")
      ("11-52B5" "媆")
      ("11-52BC" "吞")
      ("11-52BE" "韞󠄀")
      ("11-52C1" "那󠄁")
      ("11-52C3" "藏") ;; 旧字
      ("11-52C5" "酋󠄁")
      ("11-52C7" "淡") ;; 旧字
      ("11-52C9" "麤")
      ("11-52CD" "柰")
      ("11-52D5" "譙")
      ("11-52D7" "哪")
      ("11-52D8" "洄")
      ("11-52D9" "驒")
      ("11-52DE" "內")
      ("11-52DF" "𢯱") ;; U+2F8BE
      ("11-52E0" "難󠄀")
      ("11-52E2" "鞈")
      ("11-52E3" "梛󠄁")
      ("11-52E4" "勸") ;; 旧字
      ("11-52E6" "輭")
      ("11-52E7" "海󠄀")
      ("11-52F2" "忨")
      ("11-52F3" "肉󠄁")
      ("11-52F5" "乳󠄁")
      ("11-52F8" "溺󠄁")
      ("11-52F9" "忍󠄁")
      ("11-52FA" "藝") ;; 旧字
      ("11-52FE" "伋󠄀")
      ("11-52FF" "嬯")
      ("11-5301" "椓")
      ("11-5302" "畟")
      ("11-5305" "刱")
      ("11-5306" "您")
      ("11-5308" "認󠄁")
      ("11-530D" "寍")
      ("11-530F" "寧󠄀")
      ("11-5315" "甯")
      ("11-5316" "沿󠄂")
      ("11-5317" "趮")
      ("11-5319" "麇")
      ("11-531A" "揑")
      ("11-531D" "朔") ;; 旧字
      ("11-5320" "罥")
      ("11-5321" "臽")
      ("11-5323" "爇") ;; 旧字
      ("11-532A" "枘")
      ("11-532F" "焫")
      ("11-5331" "㸐")
      ("11-5333" "繎")
      ("11-5338" "㛴")
      ("11-5339" "契󠄂")
      ("11-533B" "愇")
      ("11-533F" "蔣")
      ("11-5340" "納󠄁")
      ("11-5341" "櫱")
      ("11-5343" "阢")
      ("11-5345" "䢉")
      ("11-5346" "匘")
      ("11-5347" "鞬")
      ("11-5348" "麴")
      ("11-5349" "囊")
      ("11-534A" "逝󠄁")
      ("11-534D" "爸")
      ("11-5351" "芮")
      ("11-5352" "𢐋")
      ("11-5353" "資󠄁")
      ("11-5354" "盰")
      ("11-5357" "蕘")
      ("11-5358" "釃")
      ("11-535A" "諶")
      ("11-535C" "灶")
      ("11-5360" "杌")
      ("11-5366" "贗")
      ("11-5369" "派󠄂")
      ("11-536E" "豝")
      ("11-536F" "紖")
      ("11-5370" "鳦󠄁")
      ("11-5371" "賅")
      ("11-5373" "饞")
      ("11-5374" "遌")
      ("11-5375" "輈")
      ("11-5377" "鄱")
      ("11-5378" "夗")
      ("11-537B" "靶")
      ("11-5382" "皤")
      ("11-5384" "濯󠄁")
      ("11-5396" "霸")
      ("11-5398" "調󠄁")
      ("11-539A" "庥")
      ("11-539F" "磯󠄁")
      ("11-53A0" "覇󠄁")
      ("11-53A5" "禡")
      ("11-53A6" "灞")
      ("11-53A9" "㱃")
      ("11-53AE" "扒")
      ("11-53B0" "𣎵")
      ("11-53B3" "禨")
      ("11-53B6" "𠂢")
      ("11-53C2" "絇")
      ("11-53C9" "境") ;; 旧字
      ("11-53CA" "鸑")
      ("11-53CB" "蜑")
      ("11-53CC" "辠")
      ("11-53CD" "淸")
      ("11-53CE" "猲󠄀")
      ("11-53D4" "咺")
      ("11-53D7" "鷊")
      ("11-53D9" "獧")
      ("11-53DB" "盛󠄁")
      ("11-53DF" "芾")
      ("11-53E2" "榊󠄁")
      ("11-53E3" "吸󠄁")
      ("11-53E4" "騤")
      ("11-53E5" "蕑󠄁") ;; ??
      ("11-53EA" "熾")
      ("11-53EB" "姧")
      ("11-53EC" "鬈")
      ("11-53ED" "茷") ;; 旧字
      ("11-53EE" "肺")
      ("11-53EF" "冤󠄁")
      ("11-53F0" "葘")
      ("11-53F1" "綮󠄁")
      ("11-53F2" "欻")
      ("11-53F3" "咽") ;; 旧字
      ("11-53F7" "蘧") ;; 旧字
      ("11-53F8" "藕")
      ("11-53FA" "偝")
      ("11-5401" "捭")
      ("11-5403" "靃")
      ("11-5404" "華") ;; 旧字
      ("11-5408" "鐻")
      ("11-5409" "玃")
      ("11-540A" "驟")
      ("11-540B" "㸒") ;; ⿱爫𡈼
      ("11-540C" "障") ;; 旧字
      ("11-540D" "𢓴")
      ("11-540E" "扱󠄁")
      ("11-540F" "縶")
      ("11-5410" "癙")
      ("11-541B" "抏")
      ("11-541D" "梅󠄀")
      ("11-541F" "㨔")
      ("11-5420" "鬷")
      ("11-5426" "帨󠄀")
      ("11-5429" "𢟡")
      ("11-542B" "劾") ;; 旧字
      ("11-542C" "稗")
      ("11-542D" "粺")
      ("11-542E" "𢨋")
      ("11-5436" "憊")
      ("11-5438" "㓞") ;; 旧字
      ("11-5439" "絞󠄁")
      ("11-543B" "饘")
      ("11-543C" "誖")
      ("11-543D" "桮")
      ("11-543E" "𧂲")
      ("11-5440" "牌󠄁")
      ("11-5442" "隄")
      ("11-5448" "柷")
      ("11-544A" "禦") ;; 旧字
      ("11-544E" "槑")
      ("11-5451" "釂")
      ("11-5468" "絜")
      ("11-546A" "穴󠄁")
      ("11-5470" "𢫦")
      ("11-5471" "黴")
      ("11-5473" "妥󠄁")
      ("11-5475" "禖")
      ("11-5476" "剝")
      ("11-547B" "迫󠄁")
      ("11-547C" "嚱")
      ("11-547D" "帒")
      ("11-5480" "敀")
      ("11-5484" "𠚩")
      ("11-5486" "薄󠄁") ;; 旧字
      ("11-548B" "歆")
      ("11-548C" "鬀")
      ("11-548E" "𩒳")
      ("11-548F" "腜")
      ("11-5490" "博󠄁")
      ("11-5492" "洦")
      ("11-54A2" "簙")
      ("11-54A4" "漠") ;; 旧字
      ("11-54A5" "鑮")
      ("11-54A8" "帕")
      ("11-54AC" "𩌏")
      ("11-54B2" "堇")
      ("11-54B3" "化󠄁")
      ("11-54B8" "鎛")
      ("11-54BC" "㱳")
      ("11-54BD" "佾")
      ("11-54BE" "寞")
      ("11-54C1" "涎󠄀")
      ("11-54C2" "幕") ;; 旧字
      ("11-54C4" "髆")
      ("11-54C7" "䨣")
      ("11-54C8" "帞")
      ("11-54C9" "皦")
      ("11-54D8" "縛󠄁")
      ("11-54E1" "泆")
      ("11-54E2" "犮")
      ("11-54E5" "蟆")
      ("11-54E6" "藐") ;; 旧字
      ("11-54E8" "蘐")
      ("11-54E9" "飱")
      ("11-54ED" "八󠄁")
      ("11-54EE" "驀")
      ("11-54F2" "鵔")
      ("11-54FA" "盋")
      ("11-54FD" "邈󠄀")
      ("11-5504" "喑")
      ("11-5506" "竟") ;; 旧字
      ("11-5507" "耇")
      ("11-550F" "貘")
      ("11-5510" "祥󠄀")
      ("11-5514" "獏")
      ("11-5516" "妸")
      ("11-552E" "軷")
      ("11-552F" "耑")
      ("11-5531" "萱")
      ("11-5533" "𢇷")
      ("11-5538" "茇") ;; 旧字
      ("11-5539" "帗")
      ("11-553E" "哆")
      ("11-5544" "飼󠄁")
      ("11-5545" "瞂")
      ("11-5546" "藼")
      ("11-554C" "胈")
      ("11-554F" "啄󠄁")
      ("11-5553" "危󠄁")
      ("11-5556" "潑󠄁")
      ("11-5557" "醱󠄁") 
      ("11-555C" "𩡩")
      ("11-555D" "橃")
      ("11-5563" "癹")
      ("11-557B" "汎") ;; 旧字
      ("11-557E" "伴󠄁")
      ("11-5580" "襪")
      ("11-5583" "攽󠄀")
      ("11-5584" "莝")
      ("11-5589" "㱙")
      ("11-558A" "半󠄁")
      ("11-558B" "繛")
      ("11-5598" "判󠄁")
      ("11-5599" "韎")
      ("11-559A" "悝")
      ("11-559C" "槪󠄁")
      ("11-559D" "庌")
      ("11-559E" "𠦒")
      ("11-559F" "帆󠄁")
      ("11-55A7" "痵")
      ("11-55A8" "叛󠄁")
      ("11-55AA" "削󠄁")
      ("11-55AB" "躩")
      ("11-55B0" "𥳑")
      ("11-55B6" "蔭")
      ("11-55C4" "𤤻")
      ("11-55C5" "盼")
      ("11-55C7" "痹")
      ("11-55D4" "棥")
      ("11-55DA" "牉")
      ("11-55DC" "畔󠄁")
      ("11-55DF" "范") ;; 旧字
      ("11-55E3" "歘")
      ("11-55E4" "辬")
      ("11-55F7" "媻")
      ("11-55F9" "繁󠄁")
      ("11-55FD" "泮")
      ("11-55FE" "頖")
      ("11-5609" "剡")
      ("11-5614" "飯󠄀")
      ("11-5616" "頒󠄁")
      ("11-5617" "玁")
      ("11-5618" "𩃬")
      ("11-561B" "墦")
      ("11-5629" "榬")
      ("11-562F" "挽󠄁")
      ("11-5631" "㚖")
      ("11-5632" "鞶")
      ("11-5634" "扳")
      ("11-5636" "蹯")
      ("11-5638" "蘩󠄀") ;; 旧字
      ("11-5642" "廕")
      ("11-564C" "祡")
      ("11-564E" "䋣")
      ("11-5650" "㸋")
      ("11-565B" "𡕗")
      ("11-5664" "𡕢")
      ("11-5668" "漑") ;; 傍は「旣」
      ("11-566B" "蠜")
      ("11-566C" "晚")
      ("11-5674" "䉵")
      ("11-5678" "鐎")
      ("11-567A" "政") ;; 旧字
      ("11-5680" "蕃󠄁")
      ("11-5686" "鎜")
      ("11-5687" "荷") ;; 旧字
      ("11-568A" "鞔")
      ("11-568F" "𡚧")
      ("11-5694" "伾")
      ("11-56A0" "圮")
      ("11-56A5" "𢱧")
      ("11-56AE" "帔")
      ("11-56B4" "畁")
      ("11-56B6" "畀")
      ("11-56BC" "朏")
      ("11-56C0" "𠨘")
      ("11-56C1" "柲")
      ("11-56C2" "卑󠄀")
      ("11-56C3" "毖")
      ("11-56C8" "毗")
      ("11-56CE" "𣬈")
      ("11-56D1" "䃾") ;; 旧字
      ("11-56D3" "剕")
      ("11-56D7" "笓")
      ("11-56D8" "藤󠄁")
      ("11-56DA" "氒")
      ("11-56DB" "詘")
      ("11-56DE" "尩")
      ("11-56E0" "逸")
      ("11-56E3" "孳󠄁")
      ("11-56EE" "蚍")
      ("11-56F0" "胷")
      ("11-56F2" "敡")
      ("11-56F3" "稉")
      ("11-56F9" "啚")
      ("11-56FA" "夔")
      ("11-56FD" "𠬞")
      ("11-56FF" "庳")
      ("11-5700" "埤")
      ("11-5703" "㚇")
      ("11-5704" "悱")
      ("11-5708" "扉󠄁")
      ("11-5709" "陴")
      ("11-570B" "斐")
      ("11-570D" "棐")
      ("11-570F" "睢")
      ("11-5712" "惲")
      ("11-5713" "菲") ;; 旧字
      ("11-5716" "痺")
      ("11-5718" "詖")
      ("11-571C" "賁") ;; 旧字
      ("11-571F" "爯")
      ("11-5726" "閟")
      ("11-5727" "晻")
      ("11-5728" "檋")
      ("11-572D" "妀")
      ("11-5730" "壐")
      ("11-5737" "碑󠄀")
      ("11-5738" "緋󠄁")
      ("11-573B" "肶")
      ("11-5740" "駓")
      ("11-5742" "昕")
      ("11-5747" "寛󠄁") ;; 旧字
      ("11-574A" "慅")
      ("11-574E" "膍")
      ("11-574F" "髲")
      ("11-5750" "蕎")
      ("11-5751" "彶")
      ("11-5764" "陿")
      ("11-5766" "次󠄁")
      ("11-5769" "篚")
      ("11-576A" "濈")
      ("11-577F" "騑")
      ("11-5782" "腔󠄁")
      ("11-5788" "奰")
      ("11-5789" "襣")
      ("11-578B" "弃") ;; 旧字
      ("11-5793" "𡚤")
      ("11-57A0" "镾")
      ("11-57A2" "汲󠄁")
      ("11-57A3" "𨔣")
      ("11-57A4" "釁")
      ("11-57AA" "娓")
      ("11-57B0" "敉")
      ("11-57B3" "沬")
      ("11-57C0" "避󠄁")
      ("11-57C3" "𣁋")
      ("11-57C6" "𤰈")
      ("11-57CB" "邨󠄁")
      ("11-57CE" "悞󠄁")
      ("11-57D2" "微󠄁")
      ("11-57D3" "楣")
      ("11-57D4" "湄")
      ("11-57D6" "濞")
      ("11-57DC" "曟")
      ("11-57DF" "韡")
      ("11-57E0" "湔")
      ("11-57E3" "薇󠄁")
      ("11-57F4" "昦")
      ("11-57F7" "儆") ;; 旧字
      ("11-57F9" "㐱")
      ("11-57FA" "獃")
      ("11-5800" "夨")
      ("11-5802" "韶") ;; 旧字
      ("11-5805" "詭")
      ("11-5806" "眡")
      ("11-580A" "鼻󠄁")
      ("11-580B" "獼")
      ("11-5815" "姿󠄁")
      ("11-5819" "劘")
      ("11-581D" "蘪")
      ("11-5821" "溦")
      ("11-5824" "祝󠄀")
      ("11-582A" "晐")
      ("11-5830" "運󠄁")
      ("11-5831" "棗") ;; 旧字
      ("11-5834" "誤󠄁")
      ("11-5835" "薯󠄁")
      ("11-583A" "巹")
      ("11-583D" "畢") ;; 旧字
      ("11-5840" "髥")
      ("11-5841" "鵰")
      ("11-584A" "尣")
      ("11-584B" "亹")
      ("11-5851" "啐")
      ("11-5852" "苾")
      ("11-5854" "秤󠄁")
      ("11-5857" "藷") ;; 旧字
      ("11-5858" "稱󠄁")
      ("11-5859" "曐")
      ("11-585A" "溼")
      ("11-585E" "嚮󠄃")
      ("11-5862" "亹")
      ("11-5869" "銳")
      ("11-586B" "𧭺")
      ("11-5870" "蘼")
      ("11-5872" "霺")
      ("11-5875" "控󠄁")
      ("11-5879" "逼󠄁")
      ("11-587E" "硏")
      ("11-5883" "苷") ;; 旧字
      ("11-5885" "滭")
      ("11-5893" "牂")
      ("11-5897" "饊")
      ("11-589C" "萩") ;; 旧字
      ("11-589F" "蓽")
      ("11-58A8" "驄")
      ("11-58AB" "駜")
      ("11-58AE" "鞸")
      ("11-58B3" "韆") ;; 旧字
      ("11-58B8" "䟆")
      ("11-58B9" "㪤")
      ("11-58BA" "觱")
      ("11-58BB" "篳")
      ("11-58BE" "强")
      ("11-58C1" "疏") ;; 旧字
      ("11-58C5" "韠")
      ("11-58C7" "慈󠄁") ;; 旧字
      ("11-58CA" "往󠄁")
      ("11-58CC" "醐")
      ("11-58D1" "謬󠄁")
      ("11-58D3" "滮")
      ("11-58D5" "虡")
      ("11-58D7" "仌")
      ("11-58D8" "豹󠄁")
      ("11-58D9" "𠬪") ;; 旧字
      ("11-58DC" "𤐫")
      ("11-58DE" "𧤅")
      ("11-58DF" "評󠄁")
      ("11-58E5" "㶾")
      ("11-58EB" "誳")
      ("11-58EC" "祫")
      ("11-58EE" "𣌧")
      ("11-58EF" "僄")
      ("11-58F0" "翺")
      ("11-58F2" "軔󠄁")
      ("11-58F7" "螽")
      ("11-58F9" "勡")
      ("11-58FA" "𠑎")
      ("11-58FB" "凴")
      ("11-58FC" "摽")
      ("11-5902" "熛")
      ("11-5909" "蒩")
      ("11-590A" "麃")
      ("11-590F" "埏") ;; 旧字
      ("11-5910" "瓢") ;; 旧字
      ("11-5915" "襢")
      ("11-5916" "𠤎")
      ("11-5918" "葩") ;; 旧字
      ("11-5919" "姸")
      ("11-591A" "祉󠄁")
      ("11-591B" "猋")
      ("11-591C" "𦘣")
      ("11-5922" "鼉")
      ("11-5925" "苗") ;; 旧字
      ("11-5927" "訾")
      ("11-5929" "遵󠄁")
      ("11-592A" "胑")
      ("11-592B" "剸")
      ("11-592C" "病")
      ("11-592D" "描") ;; 旧字
      ("11-592E" "褮")
      ("11-5931" "劌")
      ("11-5932" "猫") ;; 旧字
      ("11-5937" "萎") ;; 旧字
      ("11-5938" "貓") ;; 旧字
      ("11-593E" "淼")
      ("11-5944" "氳")
      ("11-5947" "蓋") ;; 旧字
      ("11-5948" "宂")
      ("11-5949" "琮")
      ("11-594E" "楅")
      ("11-594F" "𣆩")
      ("11-5950" "皕")
      ("11-5951" "𢺵")
      ("11-5954" "𠟭")
      ("11-5955" "庿")
      ("11-5957" "咲󠄁")
      ("11-5960" "貧󠄁")
      ("11-5965" "繄")
      ("11-5967" "份")
      ("11-5968" "獫")
      ("11-5969" "儐")
      ("11-596A" "𨾦")
      ("11-596C" "賓󠄀")
      ("11-596E" "冄")
      ("11-5974" "倢")
      ("11-5978" "虨")
      ("11-597D" "虯")
      ("11-5981" "豳")
      ("11-5982" "蠋")
      ("11-5983" "脆󠄁")
      ("11-5984" "黱")
      ("11-598A" "蓐") ;; 旧字
      ("11-598D" "蘋")
      ("11-5996" "埊")
      ("11-5999" "馱")
      ("11-599B" "芬") ;; 旧字
      ("11-599D" "邠")
      ("11-59A3" "臏󠄀")
      ("11-59A8" "艘")
      ("11-59AC" "帤")
      ("11-59B2" "髕")
      ("11-59B9" "尊󠄁")
      ("11-59BB" "畺")
      ("11-59BE" "蠲")
      ("11-59C6" "嚬")
      ("11-59C9" "焄")
      ("11-59CB" "喰󠄁")
      ("11-59D0" "盦")
      ("11-59D1" "虁")
      ("11-59D3" "璜")
      ("11-59D4" "意󠄁")
      ("11-59D9" "薲")
      ("11-59DA" "蠙")
      ("11-59E5" "酓")
      ("11-59E6" "㱾")
      ("11-59E8" "瀕")
      ("11-59EA" "隊󠄁")
      ("11-59EB" "褻󠄀")
      ("11-59F6" "鴉󠄁")
      ("11-59FB" "矞")
      ("11-59FF" "裠")
      ("11-5A01" "煒󠄁")
      ("11-5A03" "妿")
      ("11-5A09" "昬")
      ("11-5A11" "忞")
      ("11-5A18" "迨")
      ("11-5A1A" "敯")
      ("11-5A1C" "敃")
      ("11-5A1F" "矉")
      ("11-5A20" "舡")
      ("11-5A25" "顰")
      ("11-5A29" "麄")
      ("11-5A2F" "𥷤")
      ("11-5A35" "僶")
      ("11-5A36" "父󠄁")
      ("11-5A3C" "韅")
      ("11-5A40" "珉")
      ("11-5A41" "鬄")
      ("11-5A46" "宷")
      ("11-5A49" "閩")
      ("11-5A5A" "敎")
      ("11-5A62" "佈")
      ("11-5A66" "𩠹")
      ("11-5A6A" "芙") ;; 旧字
      ("11-5A6C" "敏󠄀")
      ("11-5A7F" "菭")
      ("11-5A92" "刃󠄁")
      ("11-5A9A" "弣")
      ("11-5A9B" "歠")
      ("11-5ABC" "悑")
      ("11-5ABD" "負󠄂")
      ("11-5ABE" "芣")
      ("11-5AC1" "匽")
      ("11-5AC9" "慧󠄁")
      ("11-5ACC" "跪") ;; 旧字
      ("11-5AD0" "𧕰")
      ("11-5AD7" "尃")
      ("11-5AE1" "𦊩")
      ("11-5AE6" "浮󠄁")
      ("11-5AE9" "祔")
      ("11-5AFA" "婦󠄁")
      ("11-5AFB" "莩󠄀") ;; 旧字
      ("11-5B09" "閡")
      ("11-5B0B" "暜")
      ("11-5B16" "跗")
      ("11-5B22" "護") ;; 旧字
      ("11-5B2A" "鄜")
      ("11-5B2C" "繡")
      ("11-5B30" "倈")
      ("11-5B32" "鈇")
      ("11-5B36" "敷󠄁")
      ("11-5B3E" "頫")
      ("11-5B40" "麱")
      ("11-5B43" "駙")
      ("11-5B45" "麩")
      ("11-5B50" "帬")
      ("11-5B51" "鬴")
      ("11-5B54" "虬")
      ("11-5B55" "𢻬")
      ("11-5B57" "荆")
      ("11-5B58" "厎")
      ("11-5B5A" "侮󠄁")
      ("11-5B5B" "敄")
      ("11-5B5C" "攈")
      ("11-5B5D" "急󠄁")
      ("11-5B5F" "薹")
      ("11-5B64" "巇")
      ("11-5B65" "珷")
      ("11-5B66" "頙")
      ("11-5B69" "葡") ;; 旧字
      ("11-5B6B" "忮")
      ("11-5B70" "嫵")
      ("11-5B71" "韍")
      ("11-5B73" "幠")
      ("11-5B75" "𨑑") ;; 旧字
      ("11-5B78" "舞") ;; 旧字
      ("11-5B80" "𦐀") ;; 旧字
      ("11-5B83" "儛")
      ("11-5B85" "屣")
      ("11-5B87" "垔")
      ("11-5B88" "砉")
      ("11-5B89" "异") ;; ⿱已廾
      ("11-5B8B" "丵")
      ("11-5B8C" "晦󠄁")
      ("11-5B8D" "滎")
      ("11-5B8F" "匶") ;; 旧字
      ("11-5B95" "釗")
      ("11-5B97" "傑󠄁")
      ("11-5B98" "痎")
      ("11-5B99" "煮󠄀")
      ("11-5B9A" "盄")
      ("11-5B9B" "鞌")
      ("11-5B9C" "獲") ;; 旧字
      ("11-5B9D" "葬") ;; 旧字
      ("11-5B9F" "䭫")
      ("11-5BA2" "遻")
      ("11-5BA3" "込󠄁")
      ("11-5BA4" "熲")
      ("11-5BA5" "郯")
      ("11-5BA6" "膴")
      ("11-5BAE" "𠯑")
      ("11-5BB0" "繮")
      ("11-5BB3" "卡")
      ("11-5BB4" "熅")
      ("11-5BB5" "鹼")
      ("11-5BB6" "崦")
      ("11-5BB8" "蕪")
      ("11-5BBF" "帣")
      ("11-5BC3" "甒")
      ("11-5BC4" "䢃")
      ("11-5BC5" "瀟")
      ("11-5BC6" "挼")
      ("11-5BC7" "騖")
      ("11-5BCC" "尟")
      ("11-5BD0" "𠬝")
      ("11-5BD2" "悔")
      ("11-5BD3" "顑")
      ("11-5BD4" "飌") ;; 旧字
      ("11-5BDB" "盔")
      ("11-5BDD" "苟") ;; 旧字
      ("11-5BDE" "畐")
      ("11-5BDF" "斦")
      ("11-5BE1" "媕")
      ("11-5BE2" "复")
      ("11-5BE4" "宓")
      ("11-5BE5" "茯")
      ("11-5BE6" "服󠄁")
      ("11-5BE7" "弞")
      ("11-5BE8" "斄")
      ("11-5BE9" "荒󠄁")
      ("11-5BEB" "偪")
      ("11-5BEE" "𡑢")
      ("11-5BF0" "疈")
      ("11-5BF3" "愊")
      ("11-5BF5" "爵󠄂")
      ("11-5BF6" "虙")
      ("11-5BF8" "墝")
      ("11-5BFA" "陘")
      ("11-5BFE" "禩")
      ("11-5BFF" "玦")
      ("11-5C01" "塼󠄀")
      ("11-5C02" "丨")
      ("11-5C04" "罽")
      ("11-5C05" "絥")
      ("11-5C06" "顴") ;; 旧字
      ("11-5C07" "福󠄁")
      ("11-5C08" "箙󠄁")
      ("11-5C09" "瑋")
      ("11-5C0A" "戺")
      ("11-5C0B" "釭")
      ("11-5C0D" "覆󠄁")
      ("11-5C0E" "噍")
      ("11-5C0F" "沅")
      ("11-5C11" "泫")
      ("11-5C13" "鵩")
      ("11-5C16" "𥃩")
      ("11-5C1A" "彦")
      ("11-5C20" "𩍁")
      ("11-5C22" "市󠄀")
      ("11-5C2D" "菡")
      ("11-5C31" "楬")
      ("11-5C3A" "蓺")
      ("11-5C3B" "柙")
      ("11-5C3C" "鑲")
      ("11-5C3D" "喤")
      ("11-5C3E" "鼫")
      ("11-5C3F" "𧹎")
      ("11-5C40" "𦼉") ;; 旧字
      ("11-5C41" "甶")
      ("11-5C45" "轄󠄁")
      ("11-5C46" "茀")
      ("11-5C48" "灌") ;; 旧字
      ("11-5C4A" "醬")
      ("11-5C4B" "悅")
      ("11-5C4D" "葷") ;; 旧字
      ("11-5C4E" "紱")
      ("11-5C4F" "艴")
      ("11-5C50" "綍")
      ("11-5C51" "懽")
      ("11-5C53" "紼")
      ("11-5C5E" "支") ;; 旧字
      ("11-5C60" "紓")
      ("11-5C61" "褧")
      ("11-5C64" "厝")
      ("11-5C65" "馽")
      ("11-5C6E" "沕")
      ("11-5C6F" "鐘") ;; 旧字
      ("11-5C71" "酗")
      ("11-5C76" "脗")
      ("11-5C79" "坋")
      ("11-5C8C" "坌")
      ("11-5C90" "駭")
      ("11-5C91" "𡊄")
      ("11-5CA1" "圛")
      ("11-5CA8" "彩󠄁")
      ("11-5CA9" "陔")
      ("11-5CAB" "㞣")
      ("11-5CB1" "舓")
      ("11-5CB3" "豭")
      ("11-5CB6" "粉󠄁")
      ("11-5CB7" "燓")
      ("11-5CBB" "粉󠄁")
      ("11-5CBC" "棼")
      ("11-5CBE" "噴󠄀") ;; 旧字
      ("11-5CC5" "雰󠄁")
      ("11-5CC7" "墳") ;; 旧字
      ("11-5CD9" "憤󠄁")
      ("11-5CE0" "緟")
      ("11-5CE1" "衎")
      ("11-5CE9" "濆") ;; 旧字
      ("11-5CED" "䩿")
      ("11-5CEF" "喿")
      ("11-5CF0" "僧")
      ("11-5CF6" "偁")
      ("11-5CFA" "鼖")
      ("11-5CFB" "拳󠄁")
      ("11-5CFD" "羵")
      ("11-5D07" "嘐")
      ("11-5D11" "彣")
      ("11-5D14" "抆")
      ("11-5D15" "饙")
      ("11-5D16" "瓜󠄁")
      ("11-5D17" "𩞑")
      ("11-5D1A" "蟁")
      ("11-5D1F" "文󠄁")
      ("11-5D22" "蚊󠄁")
      ("11-5D29" "嫂󠄁")
      ("11-5D4B" "甹")
      ("11-5D4C" "𩢌")
      ("11-5D4E" "平󠄁")
      ("11-5D52" "丙󠄁")
      ("11-5D5C" "分󠄁")
      ("11-5D69" "彄")
      ("11-5D6C" "𤲀")
      ("11-5D6F" "誩")
      ("11-5D76" "倂")
      ("11-5D82" "幷")
      ("11-5D84" "㡀")
      ("11-5D87" "坪󠄁")
      ("11-5D8B" "唼")
      ("11-5D8C" "𢹔")
      ("11-5D90" "棅")
      ("11-5DA2" "俜")
      ("11-5DAC" "昞󠄁")
      ("11-5DAE" "枰󠄀")
      ("11-5DB7" "昺")
      ("11-5DBA" "墜󠄀")
      ("11-5DBC" "苹󠄀")
      ("11-5DBD" "柄󠄁")
      ("11-5DC9" "狴")
      ("11-5DCC" "咳")
      ("11-5DCD" "𨻼")
      ("11-5DD3" "屛")
      ("11-5DDB" "塀󠄁")
      ("11-5DDD" "𣏔")
      ("11-5DDE" "劂")
      ("11-5DE1" "嫌󠄁")
      ("11-5DE3" "茁") ;; 旧字
      ("11-5DE6" "銎")
      ("11-5DE7" "級󠄁")
      ("11-5DE8" "鶡")
      ("11-5DEB" "荓")
      ("11-5DEE" "勰")
      ("11-5DF1" "巋")
      ("11-5DF2" "萍󠄀")
      ("11-5DF3" "娜󠄁")
      ("11-5DF4" "寖")
      ("11-5DF7" "捄")
      ("11-5DFB" "恝")
      ("11-5DFD" "蹝")
      ("11-5DFE" "榦")
      ("11-5E02" "纁")
      ("11-5E03" "煎󠄁")
      ("11-5E06" "𠭥")
      ("11-5E0B" "箄")
      ("11-5E0C" "骸") ;; 旧字
      ("11-5E11" "甁")
      ("11-5E16" "繳")
      ("11-5E19" "缾󠄁")
      ("11-5E1A" "箅")
      ("11-5E1B" "幣󠄁")
      ("11-5E1D" "𪫥")
      ("11-5E25" "閎")
      ("11-5E2B" "勛")
      ("11-5E2D" "灝")
      ("11-5E2F" "茝")
      ("11-5E30" "殻󠄁")
      ("11-5E33" "𦅾")
      ("11-5E36" "弊󠄁")
      ("11-5E38" "鼯")
      ("11-5E3D" "甑󠄃")
      ("11-5E40" "蓱")
      ("11-5E43" "潎")
      ("11-5E45" "衻")
      ("11-5E47" "餅󠄁")
      ("11-5E4C" "卽")
      ("11-5E4E" "蔽󠄁") ;; 旧字
      ("11-5E54" "𢓳")
      ("11-5E55" "愻")
      ("11-5E57" "𢖊")
      ("11-5E5F" "䛣")
      ("11-5E61" "蘂")
      ("11-5E62" "薜")
      ("11-5E63" "髯󠄁")
      ("11-5E64" "鞞")
      ("11-5E72" "𤪿")
      ("11-5E74" "神󠄀")
      ("11-5E75" "斃")
      ("11-5E76" "獘")
      ("11-5E78" "笈󠄁")
      ("11-5E79" "喈")
      ("11-5E7A" "鼙")
      ("11-5E7B" "簋")
      ("11-5E7C" "餪")
      ("11-5E7D" "酖󠄁")
      ("11-5E7E" "𧽊")
      ("11-5E7F" "麛")
      ("11-5E81" "爝")
      ("11-5E83" "赳󠄁")
      ("11-5E84" "彥")
      ("11-5E87" "脃")
      ("11-5E8A" "炫")
      ("11-5E8F" "縑")
      ("11-5E95" "倏")
      ("11-5E96" "㛮")
      ("11-5E97" "所󠄁")
      ("11-5E9C" "詮󠄁")
      ("11-5EA0" "擗")
      ("11-5EA7" "頰")
      ("11-5EAB" "蘄")
      ("11-5EAD" "倐")
      ("11-5EB5" "𦣝")
      ("11-5EB6" "蒹")
      ("11-5EB7" "躳")
      ("11-5EB8" "坻")
      ("11-5EC1" "𣦢")
      ("11-5EC2" "鼏")
      ("11-5EC3" "䰠")
      ("11-5EC8" "冪") ;; 旧字
      ("11-5EC9" "酊")
      ("11-5ECA" "禘")
      ("11-5ECF" "撇")
      ("11-5ED0" "幦")
      ("11-5ED3" "崋")
      ("11-5ED6" "撆")
      ("11-5EDA" "𤊾") ;; 旧字
      ("11-5EDD" "苜") ;; 旧字
      ("11-5EDF" "洊")
      ("11-5EE0" "𠫐")
      ("11-5EE1" "瞥󠄁")
      ("11-5EE3" "憋")
      ("11-5EE8" "幭")
      ("11-5EE9" "蹩")
      ("11-5EEC" "𥣫")
      ("11-5EF0" "韈")
      ("11-5EF1" "蔑󠄀") ;; 旧字
      ("11-5EF3" "韤")
      ("11-5EF4" "蟞")
      ("11-5EF6" "縕")
      ("11-5EF7" "粛󠄀")
      ("11-5EF8" "返󠄁")
      ("11-5EFB" "暀")
      ("11-5EFC" "秦")
      ("11-5EFF" "飾󠄁")
      ("11-5F01" "卅")
      ("11-5F03" "柉")
      ("11-5F04" "蝃")
      ("11-5F09" "扁󠄁")
      ("11-5F0A" "蝡")
      ("11-5F0B" "偏󠄁")
      ("11-5F0C" "敵") ;; 旧字
      ("11-5F0D" "悊")
      ("11-5F0F" "硎")
      ("11-5F10" "饟")
      ("11-5F11" "匾")
      ("11-5F13" "𠜜")
      ("11-5F14" "皭")
      ("11-5F15" "溢󠄁")
      ("11-5F17" "鬋")
      ("11-5F1B" "鷀󠄁")
      ("11-5F1F" "莤")
      ("11-5F25" "橐")
      ("11-5F26" "𣪘")
      ("11-5F27" "鬐")
      ("11-5F29" "腁")
      ("11-5F2D" "遍󠄁")
      ("11-5F2F" "翩󠄁")
      ("11-5F35" "叒")
      ("11-5F37" "倌")
      ("11-5F38" "徧")
      ("11-5F3C" "節󠄂")
      ("11-5F3E" "㤵")
      ("11-5F41" "褊󠄁")
      ("11-5F48" "惼")
      ("11-5F4A" "倝")
      ("11-5F4C" "篇󠄁")
      ("11-5F4E" "編󠄁")
      ("11-5F51" "蝙󠄁")
      ("11-5F53" "𤓪")
      ("11-5F56" "蹁")
      ("11-5F57" "騈󠄀")
      ("11-5F59" "骿")
      ("11-5F5C" "窆")
      ("11-5F5D" "砭")
      ("11-5F61" "騙󠄁")
      ("11-5F66" "梲")
      ("11-5F69" "蹻")
      ("11-5F6A" "㚒")
      ("11-5F6B" "若") ;; 旧字
      ("11-5F6C" "㳄")
      ("11-5F6D" "籩")
      ("11-5F71" "駰")
      ("11-5F73" "丏")
      ("11-5F77" "𡭪")
      ("11-5F79" "謫") ;; 旧字
      ("11-5F7C" "稅")
      ("11-5F7F" "忭")
      ("11-5F80" "霙")
      ("11-5F82" "𡧍")
      ("11-5F83" "瓣")
      ("11-5F84" "歧")
      ("11-5F85" "茨󠄁") ;; 旧字
      ("11-5F87" "便󠄁")
      ("11-5F88" "沔")
      ("11-5F8B" "著󠄁")
      ("11-5F8C" "仡")
      ("11-5F90" "褰")
      ("11-5F91" "拚")
      ("11-5F92" "茹") ;; 旧字
      ("11-5F93" "蘖") ;; 12-773A
      ("11-5F97" "蕉") ;; 旧字
      ("11-5F98" "㝃")
      ("11-5F99" "娩󠄁")
      ("11-5F9E" "勉󠄀")
      ("11-5FA0" "浼")
      ("11-5FA1" "㐹")
      ("11-5FA8" "辡")
      ("11-5FA9" "襜")
      ("11-5FAA" "𩡧")
      ("11-5FAD" "辦")
      ("11-5FAE" "籍󠄁")
      ("11-5FB3" "𧶜") ;; 旧字
      ("11-5FB4" "弱󠄁")
      ("11-5FB9" "鬊")
      ("11-5FBC" "澠")
      ("11-5FBD" "䡈")
      ("11-5FC3" "訇")
      ("11-5FC5" "𢧵")
      ("11-5FCC" "騃")
      ("11-5FCD" "兂")
      ("11-5FD6" "𡫛")
      ("11-5FD7" "薰") ;; 旧字
      ("11-5FD8" "䰝")
      ("11-5FD9" "矰")
      ("11-5FDC" "瀛󠄁")
      ("11-5FDD" "莆")
      ("11-5FE0" "榭")
      ("11-5FE4" "步")
      ("11-5FEB" "盎")
      ("11-5FF0" "捀")
      ("11-5FF1" "晡")
      ("11-5FF5" "𦘔")
      ("11-5FF8" "畮")
      ("11-5FFB" "㝰")
      ("11-5FFD" "㹤")
      ("11-5FFF" "葆") ;; 旧字
      ("11-600E" "娒")
      ("11-600F" "莫") ;; 旧字
      ("11-6010" "𠤱")
      ("11-6012" "哨󠄁")
      ("11-6015" "墓") ;; 旧字
      ("11-6016" "詹")
      ("11-6019" "簠")
      ("11-601B" "菩") ;; 旧字
      ("11-601C" "墜󠄁")
      ("11-601D" "麇")
      ("11-6020" "𨑭")
      ("11-6021" "蒲") ;; 旧字
      ("11-6025" "𢬸")
      ("11-6026" "暮") ;; 旧字
      ("11-6027" "篙")
      ("11-6028" "醞")
      ("11-6029" "𠤳")
      ("11-602A" "翁󠄂")
      ("11-602B" "慕") ;; 旧字
      ("11-602F" "圅")
      ("11-6031" "募")
      ("11-603A" "摹")
      ("11-6041" "簿󠄁")
      ("11-6042" "庖󠄁")
      ("11-6043" "邦󠄂")
      ("11-6046" "捊")
      ("11-604A" "夆")
      ("11-604B" "娣")
      ("11-604D" "芃")
      ("11-6050" "垸")
      ("11-6055" "諼")
      ("11-6059" "袌")
      ("11-605A" "謨")
      ("11-6060" "酺")
      ("11-6062" "漚")
      ("11-6063" "芳") ;; 旧字
      ("11-6064" "宲")
      ("11-6065" "識") ;; 旧字
      ("11-6068" "眶")
      ("11-6069" "㫃")
      ("11-606A" "丰")
      ("11-606B" "抱󠄁")
      ("11-606C" "抨󠄀")
      ("11-606F" "𣦻")
      ("11-6070" "芽󠄀") ;; 旧字体
      ("11-6075" "徉")
      ("11-6077" "包󠄁")
      ("11-6081" "抛") ;; 旧字
      ("11-6083" "泡󠄁") ;; 旧字
      ("11-6084" "炰")
      ("11-6089" "瞏")
      ("11-608B" "倗")
      ("11-608C" "菽") ;; 旧字
      ("11-608D" "朋󠄁")
      ("11-6092" "胞󠄁") ;; 旧字
      ("11-6094" "滃")
      ("11-6096" "𥛱")
      ("11-6097" "閍")
      ("11-609B" "祊")
      ("11-609F" "𠯏")
      ("11-60A0" "媅")
      ("11-60A6" "茴")
      ("11-60A7" "苞󠄀")
      ("11-60A9" "𣓀")
      ("11-60AA" "僾")
      ("11-60B2" "蜹")
      ("11-60B3" "痡")
      ("11-60B4" "崩󠄁")
      ("11-60B5" "萌󠄁")
      ("11-60B6" "涿")
      ("11-60B8" "砲󠄁")
      ("11-60BC" "商󠄁")
      ("11-60BD" "掊")
      ("11-60C5" "丂")
      ("11-60C6" "㷭")
      ("11-60C7" "𪚰")
      ("11-60D1" "的󠄁")
      ("11-60D3" "覂")
      ("11-60D8" "逢󠄁")
      ("11-60DA" "怳")
      ("11-60DC" "卬")
      ("11-60E0" "礮")
      ("11-60E1" "砰")
      ("11-60E3" "迮")
      ("11-60E7" "灋")
      ("11-60E8" "𤘐")
      ("11-60F0" "枲")
      ("11-60F1" "飽󠄁")
      ("11-60F3" "欶")
      ("11-60F4" "徬")
      ("11-60F6" "跑")
      ("11-60F7" "鈁")
      ("11-60F9" "囈")
      ("11-60FA" "瓿")
      ("11-60FB" "裒")
      ("11-6100" "雱")
      ("11-6101" "駃")
      ("11-6103" "葑")
      ("11-6106" "菶")
      ("11-6108" "達󠄁")
      ("11-6109" "敓")
      ("11-610D" "絣󠄁")
      ("11-610E" "蜯")
      ("11-610F" "葦") ;; 旧字
      ("11-6115" "琫")
      ("11-611A" "鍰")
      ("11-611B" "疴")
      ("11-611F" "𢢚")
      ("11-6121" "蠭")
      ("11-6127" "駂")
      ("11-6128" "鞄󠄁")
      ("11-612C" "蔀")
      ("11-6134" "鏠")
      ("11-613C" "蓬󠄁")
      ("11-613D" "縫󠄁")
      ("11-613F" "緥")
      ("11-6142" "艕")
      ("11-6144" "虣")
      ("11-6147" "蚌") ;; 旧字
      ("11-6148" "啓󠄁")
      ("11-614A" "仿")
      ("11-614B" "榟")
      ("11-614C" "裘")
      ("11-614D" "棚󠄁")
      ("11-614E" "倥")
      ("11-6153" "忙󠄁")
      ("11-6155" "𧎮")
      ("11-6158" "㯱")
      ("11-6159" "篰")
      ("11-615A" "繃󠄁")
      ("11-615D" "冃")
      ("11-615F" "亡󠄁")
      ("11-6162" "酡")
      ("11-6163" "祴") ;; 旧字
      ("11-6165" "騯")
      ("11-6168" "冎")
      ("11-616B" "綳")
      ("11-616E" "倀")
      ("11-616F" "龐") ;; 旧字
      ("11-6170" "葳")
      ("11-6171" "酆")
      ("11-6173" "𩍂")
      ("11-6174" "鵬󠄁")
      ("11-6175" "邙")
      ("11-6177" "幫")
      ("11-617E" "筑󠄁")
      ("11-6187" "杗")
      ("11-618A" "房󠄁")
      ("11-618E" "攢")
      ("11-6190" "庭󠄁")
      ("11-6194" "埅")
      ("11-6196" "忘󠄁")
      ("11-6199" "尨")
      ("11-619A" "侔")
      ("11-61A4" "鱣")
      ("11-61A7" "歗")
      ("11-61A9" "汔")
      ("11-61AB" "甿")
      ("11-61AC" "芒󠄁")
      ("11-61AE" "茅") ;; 旧字
      ("11-61B2" "頍")
      ("11-61B6" "剉")
      ("11-61BA" "望󠄂")
      ("11-61BE" "堦")
      ("11-61C3" "㫄")
      ("11-61C6" "茫") ;; 旧字
      ("11-61C8" "茆") ;; 旧字
      ("11-61C9" "某")
      ("11-61CA" "厖")
      ("11-61CB" "朢")
      ("11-61CC" "冒󠄁")
      ("11-61CD" "帽󠄁")
      ("11-61D0" "蓊") ;; 旧字
      ("11-61E3" "茻")
      ("11-61E6" "棓")
      ("11-61F2" "惹") ;; 旧字
      ("11-61F4" "牓")
      ("11-61F6" "𢄐")
      ("11-61F7" "眊")
      ("11-61F8" "頎")
      ("11-61FD" "曓")
      ("11-61FF" "瞀")
      ("11-6200" "蝱")
      ("11-6208" "髳")
      ("11-620A" "巢")
      ("11-620C" "瞢󠄁")
      ("11-620D" "甍") ;; 旧字
      ("11-620E" "𣡌")
      ("11-6210" "篝󠄁")
      ("11-6211" "鵷")
      ("11-6212" "橫")
      ("11-6214" "賵")
      ("11-6216" "黯") ;; 旧字
      ("11-621A" "奡")
      ("11-621E" "懞")
      ("11-621F" "飢󠄁")
      ("11-6221" "蟊")
      ("11-6226" "圂")
      ("11-622A" "蝥")
      ("11-622E" "鍪")
      ("11-622F" "翮")
      ("11-6230" "駹")
      ("11-6232" "麰")
      ("11-6233" "𧫢")
      ("11-6234" "㭰")
      ("11-6238" "鞿")
      ("11-623B" "坼")
      ("11-6240" "藼")
      ("11-6241" "懵")
      ("11-6247" "捆")
      ("11-6249" "澨")
      ("11-624B" "𡭴")
      ("11-624D" "鏡") ;; 旧字
      ("11-624E" "懜")
      ("11-6253" "㭒")
      ("11-6255" "騸")
      ("11-6258" "榰")
      ("11-625B" "僰")
      ("11-625E" "𩭾")
      ("11-6260" "踣")
      ("11-6263" "菐")
      ("11-626E" "鸇")
      ("11-6271" "暗󠄁")
      ("11-6276" "遄")
      ("11-6279" "㡿")
      ("11-627C" "楘")
      ("11-627E" "穆")
      ("11-627F" "瓞")
      ("11-6280" "翯")
      ("11-6282" "墨󠄀")
      ("11-6283" "浡")
      ("11-6284" "蚖")
      ("11-6289" "扑")
      ("11-628A" "㝲")
      ("11-6291" "蓄") ;; 旧字
      ("11-6292" "襆")
      ("11-6293" "餑")
      ("11-6294" "脖")
      ("11-6297" "觩")
      ("11-6298" "俈")
      ("11-629B" "魔󠄁")
      ("11-629E" "禔󠄀")
      ("11-62AB" "祏")
      ("11-62AC" "戹")
      ("11-62B5" "踧")
      ("11-62B9" "侂")
      ("11-62BB" "湓")
      ("11-62BC" "攖")
      ("11-62BD" "賖")
      ("11-62C2" "磨󠄁")
      ("11-62C5" "佀")
      ("11-62C6" "翻󠄁")
      ("11-62C7" "䃺")
      ("11-62C8" "盆")
      ("11-62C9" "每")
      ("11-62CA" "摩󠄁")
      ("11-62CC" "麽")
      ("11-62CD" "㶳")
      ("11-62CF" "奔") ;; 旧字
      ("11-62D0" "隩")
      ("11-62D2" "鬠")
      ("11-62D4" "歾")
      ("11-62D7" "鵓")
      ("11-62D8" "觓")
      ("11-62D9" "縠")
      ("11-62DB" "螈")
      ("11-62DC" "麻󠄁")
      ("11-62DD" "縝󠄀")
      ("11-62E0" "髺")
      ("11-62E1" "菓") ;; 旧字
      ("11-62EC" "迓")
      ("11-62ED" "炕")
      ("11-62EE" "玫")
      ("11-62EF" "膜") ;; 旧字
      ("11-62F1" "苺")
      ("11-62F3" "墍")
      ("11-62F5" "茉")
      ("11-62F6" "㹜")
      ("11-62F7" "𧇽")
      ("11-62FE" "憰")
      ("11-6301" "啔") ;; 旧字
      ("11-6302" "薶")
      ("11-6307" "獯")
      ("11-6308" "邁󠄀")
      ("11-6309" "医󠄀")
      ("11-630C" "玟")
      ("11-6311" "箬")
      ("11-6319" "歺")
      ("11-631F" "𢇇")
      ("11-6327" "莓") ;; 旧字
      ("11-6328" "瘂")
      ("11-632B" "鴞")
      ("11-632F" "冓") ;; 旧字
      ("11-633A" "蹜")
      ("11-633D" "瀞󠄁")
      ("11-633E" "麿")
      ("11-633F" "幘")
      ("11-6349" "𣦼")
      ("11-634C" "苦") ;; 旧字
      ("11-634D" "萬") ;; 旧字
      ("11-634F" "㒼")
      ("11-6350" "䬴")
      ("11-6355" "莊") ;; 旧字
      ("11-6357" "褎")
      ("11-635C" "笮")
      ("11-6367" "搔")
      ("11-6368" "薊") ;; 旧字
      ("11-6369" "夢") ;; 旧字
      ("11-636B" "玅")
      ("11-636E" "槀")
      ("11-6372" "幑")
      ("11-6376" "蔓") ;; 旧字
      ("11-6377" "喭")
      ("11-637A" "蒸") ;; 旧字
      ("11-637B" "㬜")
      ("11-6380" "僈")
      ("11-6383" "斮")
      ("11-6388" "挈")
      ("11-6389" "𧖅")
      ("11-638C" "𧗳")
      ("11-638E" "嫚󠄁")
      ("11-638F" "鬽")
      ("11-6392" "薪") ;; 旧字
      ("11-6396" "㬅")
      ("11-6398" "爟")
      ("11-639B" "嘩") ;; 旧字
      ("11-639F" "脈󠄂")
      ("11-63A0" "箸󠄁")
      ("11-63A1" "響󠄂")
      ("11-63A2" "𠒆")
      ("11-63A3" "𪍩")
      ("11-63A5" "鵠")
      ("11-63A7" "賕")
      ("11-63A8" "嗃")
      ("11-63A9" "餫")
      ("11-63AA" "採󠄁")
      ("11-63AB" "㡢")
      ("11-63AC" "鞟")
      ("11-63B2" "䢋")
      ("11-63B4" "葺")
      ("11-63B5" "衇")
      ("11-63BB" "槊")
      ("11-63BE" "㝱") ;; 旧字
      ("11-63C0" "雺")
      ("11-63C3" "佌")
      ("11-63C4" "𥁰")
      ("11-63C6" "明󠄁")
      ("11-63C9" "迷󠄁")
      ("11-63CF" "瀳")
      ("11-63D0" "儵")
      ("11-63D2" "茗")
      ("11-63DA" "眙")
      ("11-63DB" "凷")
      ("11-63E1" "鞵")
      ("11-63E3" "朙")
      ("11-63E9" "霚")
      ("11-63EE" "玨")
      ("11-63F4" "蘊") ;; 旧字
      ("11-63F6" "盟󠄁")
      ("11-63FA" "偫")
      ("11-6406" "謎󠄁")
      ("11-640D" "使󠄁")
      ("11-640F" "模")
      ("11-6413" "免󠄁")
      ("11-6416" "酩")
      ("11-6417" "茂") ;; 旧字
      ("11-641C" "芇")
      ("11-6426" "偭")
      ("11-6428" "摸") ;; 旧字
      ("11-642C" "晴󠄀")
      ("11-642D" "婕")
      ("11-6434" "蓂")
      ("11-6436" "麪󠄁")
      ("11-643A" "佹") ;; 旧字
      ("11-643E" "橑")
      ("11-6442" "嚳")
      ("11-6458" "畯")
      ("11-6467" "妄󠄁")
      ("11-6469" "賊󠄁")
      ("11-6476" "盲󠄁")
      ("11-6478" "穨")
      ("11-647A" "鞃")
      ("11-6488" "漭")
      ("11-6492" "𥇛")
      ("11-6493" "網󠄁")
      ("11-6495" "莽󠄁")
      ("11-649A" "浸󠄁")
      ("11-649E" "屧")
      ("11-64A4" "巡󠄁")
      ("11-64A5" "蒙") ;; 旧字
      ("11-64A9" "蝄")
      ("11-64AB" "選󠄁")
      ("11-64AD" "昚")
      ("11-64AE" "狺")
      ("11-64B0" "衮")
      ("11-64B2" "鱢")
      ("11-64B9" "貨󠄁")
      ("11-64BB" "矇")
      ("11-64BC" "幪")
      ("11-64C1" "庤")
      ("11-64C2" "嘿")
      ("11-64C5" "魍󠄀")
      ("11-64C7" "蛧")
      ("11-64CD" "醋")
      ("11-64D2" "蟒󠄁")
      ("11-64D4" "凡󠄁")
      ("11-64D8" "艨")
      ("11-64DA" "濛")
      ("11-64E0" "𡐨")
      ("11-64E2" "舜󠄁")
      ("11-64E3" "伇")
      ("11-64E6" "唫")
      ("11-64E7" "汶")
      ("11-64EF" "搹")
      ("11-64F1" "籾󠄁")
      ("11-64F2" "約󠄁")
      ("11-64F4" "禴")
      ("11-64F6" "礿")
      ("11-64FA" "軶")
      ("11-64FD" "葯")
      ("11-64FE" "公󠄁")
      ("11-6500" "搤󠄀")
      ("11-6505" "爚")
      ("11-6518" "藥") ;; 旧字
      ("11-651C" "瀹")
      ("11-651D" "麵")
      ("11-6523" "𨷲")
      ("11-6524" "躍󠄁")
      ("11-652A" "芼")
      ("11-652B" "龥")
      ("11-652C" "阸")
      ("11-652F" "曛")
      ("11-6535" "㼌")
      ("11-6536" "愉󠄁")
      ("11-6537" "庾")
      ("11-6538" "隃")
      ("11-6539" "罋")
      ("11-653B" "嘼")
      ("11-653E" "腠")
      ("11-653F" "糕")
      ("11-6545" "饎")
      ("11-654D" "窳")
      ("11-6551" "𣴠")
      ("11-6555" "褕")
      ("11-6556" "窬")
      ("11-6557" "螓")
      ("11-6558" "羭")
      ("11-6559" "莞")
      ("11-655D" "諭󠄀")
      ("11-655E" "諛󠄁")
      ("11-6562" "嘅󠄁")
      ("11-6563" "詡󠄀")
      ("11-6566" "蠨")
      ("11-656C" "呬")
      ("11-6570" "忼")
      ("11-6572" "輸󠄁")
      ("11-6574" "嚆") ;; 旧字
      ("11-6575" "䑞")
      ("11-6577" "僎")
      ("11-6578" "癒󠄁")
      ("11-6582" "𥸤")
      ("11-6583" "又") ;; 旧字
      ("11-6588" "舞") ;; 旧字
      ("11-6589" "卝")
      ("11-658C" "㵪")
      ("11-658E" "𦥑")
      ("11-6591" "夝")
      ("11-6597" "鉏")
      ("11-6599" "塚󠄁")
      ("11-659B" "有󠄁")
      ("11-659C" "鍥")
      ("11-659F" "卣")
      ("11-65A1" "菴") ;; 旧字
      ("11-65A4" "祼")
      ("11-65A5" "慠")
      ("11-65A7" "僝")
      ("11-65AB" "肜")
      ("11-65AC" "俱󠄀")
      ("11-65AF" "捃")
      ("11-65B0" "𢂷")
      ("11-65B7" "䑣")
      ("11-65B9" "葱") ;; 旧字
      ("11-65BC" "㓹")
      ("11-65BD" "纁")
      ("11-65C3" "酉") ;; 旧字
      ("11-65C4" "呦")
      ("11-65C6" "姷")
      ("11-65CB" "閫")
      ("11-65CC" "狖")
      ("11-65CF" "史󠄁")
      ("11-65D2" "貁") ;; 旧字
      ("11-65D7" "愙")
      ("11-65D9" "勈")
      ("11-65DB" "勇󠄁")
      ("11-65E0" "斿")
      ("11-65E1" "祐󠄀")
      ("11-65E2" "𠲱") ;; ⿱丯各
      ("11-65E5" "蝕󠄁")
      ("11-65E6" "叓")
      ("11-65E7" "秸")
      ("11-65E8" "䙧")
      ("11-65E9" "賾")
      ("11-65EC" "吅")
      ("11-65ED" "㿄")
      ("11-65F1" "羑")
      ("11-65FA" "贏")
      ("11-65FB" "莠") ;; 旧字
      ("11-6602" "噏")
      ("11-6606" "郷󠄁")
      ("11-6607" "唁")
      ("11-660A" "浥")
      ("11-660C" "噞")
      ("11-660E" "逮󠄁")
      ("11-660F" "莢")
      ("11-6613" "違󠄂")
      ("11-6614" "獒")
      ("11-661C" "猶󠄁")
      ("11-661F" "嶸")
      ("11-6620" "檃")
      ("11-6625" "赶")
      ("11-6627" "𢍜")
      ("11-662D" "諺󠄁")
      ("11-662F" "絚")
      ("11-6635" "逌")
      ("11-6636" "𠧴")
      ("11-663C" "遮󠄁")
      ("11-663F" "祅")
      ("11-6641" "猷󠄂")
      ("11-6642" "揭")
      ("11-6643" "潝")
      ("11-6644" "遊󠄁")
      ("11-6649" "楢󠄁")
      ("11-664B" "韐")
      ("11-6652" "訏")
      ("11-665D" "麀")
      ("11-665E" "裛")
      ("11-665F" "熠")
      ("11-6662" "牖")
      ("11-6664" "㕗")
      ("11-6666" "襖")
      ("11-6667" "𢝊")
      ("11-6668" "槱")
      ("11-6669" "穧")
      ("11-666E" "𠊩")
      ("11-666F" "㰟")
      ("11-6670" "輶")
      ("11-6674" "穅")
      ("11-6676" "鬳")
      ("11-667A" "恧")
      ("11-6681" "萈") ;; 旧字
      ("11-6683" "懮")
      ("11-6684" "櫌")
      ("11-6687" "揜")
      ("11-6688" "鯈")
      ("11-6689" "耰")
      ("11-668E" "鼬")
      ("11-6691" "蕿")
      ("11-6696" "𤔲")
      ("11-6697" "醫") ;; 旧字
      ("11-6698" "舁")
      ("11-669D" "畬")
      ("11-66A2" "主󠄁")
      ("11-66A6" "杕")
      ("11-66AB" "虞󠄁")
      ("11-66AE" "悤󠄀")
      ("11-66B4" "罾")
      ("11-66B8" "𠈫")
      ("11-66B9" "𩜈")
      ("11-66BC" "旟")
      ("11-66BE" "礜")
      ("11-66C1" "艅")
      ("11-66C4" "𡝩")
      ("11-66C7" "趫")
      ("11-66C9" "蕷")
      ("11-66D6" "㑞")
      ("11-66D9" "遣󠄁")
      ("11-66DC" "离") ;; 旧字
      ("11-66DD" "箠")
      ("11-66E0" "枼")
      ("11-66F2" "逭")
      ("11-66F3" "螾")
      ("11-66F4" "璆")
      ("11-66F8" "權") ;; 旧字
      ("11-66F9" "笧")
      ("11-66FC" "邶")
      ("11-66FD" "斎󠄁")
      ("11-66FE" "菜󠄁") ;; 旧字
      ("11-66FF" "淄")
      ("11-6700" "䕬")
      ("11-6703" "唐󠄁")
      ("11-6708" "琦")
      ("11-6709" "漙")
      ("11-670B" "蔥")
      ("11-670D" "𩔊")
      ("11-670F" "窅")
      ("11-6714" "靳")
      ("11-6715" "終󠄁")
      ("11-6716" "邕")
      ("11-6717" "酲󠄁")
      ("11-671B" "臊")
      ("11-671D" "蘙")
      ("11-671E" "訞")
      ("11-671F" "捔")
      ("11-6726" "𧨶")
      ("11-6727" "䚻")
      ("11-6728" "醍")
      ("11-672A" "陁")
      ("11-672B" "拖")
      ("11-672C" "涑")
      ("11-672D" "誾")
      ("11-672E" "湧") ;; 旧字
      ("11-6731" "虩")
      ("11-6734" "雥")
      ("11-6736" "遙󠄀")
      ("11-6737" "猺")
      ("11-6738" "㑾")
      ("11-673A" "瑴")
      ("11-673D" "栝")
      ("11-673F" "葉") ;; 旧字
      ("11-6741" "媵")
      ("11-6746" "腰󠄁")
      ("11-6749" "構󠄁")
      ("11-674E" "𠷎")
      ("11-674F" "苡")
      ("11-6750" "衋")
      ("11-6751" "姉󠄁")
      ("11-6753" "迎󠄁")
      ("11-6756" "夅")
      ("11-6759" "墉")
      ("11-675C" "𥃝")
      ("11-675E" "要󠄁")
      ("11-675F" "嶃")
      ("11-6760" "蓉") ;; 旧字
      ("11-6761" "交󠄁")
      ("11-6762" "奶")
      ("11-6763" "樣")
      ("11-6764" "漾")
      ("11-6765" "牏")
      ("11-676A" "𢹬")
      ("11-676D" "窮") ;; 旧字
      ("11-676F" "駪")
      ("11-6771" "寁")
      ("11-6772" "挹")
      ("11-6773" "訧")
      ("11-6777" "溱")
      ("11-677C" "𡓱")
      ("11-677E" "甋")
      ("11-677F" "菁")
      ("11-6785" "邎")
      ("11-6787" "卪")
      ("11-6789" "鄘")
      ("11-678B" "燁")
      ("11-678C" "曄")
      ("11-6790" "壕")
      ("11-6795" "噂󠄁")
      ("11-6797" "賬")
      ("11-679A" "巽󠄀")
      ("11-679C" "援󠄁")
      ("11-679D" "醺󠄁")
      ("11-67A0" "旳") ;; 旧字
      ("11-67A1" "䌛")
      ("11-67A2" "摳")
      ("11-67A6" "繇")
      ("11-67A9" "養󠄁")
      ("11-67AF" "饑󠄀")
      ("11-67B3" "曜󠄁")
      ("11-67B4" "擪")
      ("11-67B6" "焰")
      ("11-67B7" "賸")
      ("11-67B8" "雝")
      ("11-67B9" "燿󠄁")
      ("11-67C1" "梩")
      ("11-67C6" "𩟷")
      ("11-67CA" "㞕")
      ("11-67CE" "饔")
      ("11-67CF" "藎")
      ("11-67D0" "螬")
      ("11-67D1" "犗")
      ("11-67D3" "慁")
      ("11-67D4" "糱")
      ("11-67D8" "醻")
      ("11-67DA" "褖")
      ("11-67DD" "饁")
      ("11-67DE" "鏞")
      ("11-67E2" "爗")
      ("11-67E4" "颺")
      ("11-67E7" "鷕")
      ("11-67EC" "擫")
      ("11-67EE" "耀󠄁")
      ("11-67EF" "𧷽") ;; 旧字
      ("11-67F1" "謝") ;; 旧字
      ("11-67F3" "羍")
      ("11-67F4" "殸")
      ("11-67F5" "墐")
      ("11-67FB" "嶠")
      ("11-67FE" "樽󠄁")
      ("11-67FF" "哿")
      ("11-6803" "𤏻")
      ("11-6804" "闉󠄀")
      ("11-6813" "惛")
      ("11-6816" "茠")
      ("11-6817" "罐󠄀")
      ("11-681E" "鸉")
      ("11-6821" "竆󠄁")
      ("11-6822" "攺")
      ("11-6829" "𣵽")
      ("11-682A" "匄")
      ("11-682B" "隿")
      ("11-6834" "㡓")
      ("11-6838" "斝")
      ("11-6839" "愜")
      ("11-683C" "媧")
      ("11-683D" "韁")
      ("11-6841" "㠱")
      ("11-6842" "炁")
      ("11-6843" "惝󠄀")
      ("11-6848" "毉")
      ("11-684D" "淢")
      ("11-684E" "翌󠄀")
      ("11-6850" "閒")
      ("11-6851" "鸛") ;; 旧字
      ("11-6853" "蒯")
      ("11-6859" "棫")
      ("11-685C" "謹󠄀")
      ("11-685D" "蹲")
      ("11-685F" "寠")
      ("11-6863" "廙")
      ("11-6867" "薛") ;; 旧字
      ("11-6874" "𧝹")
      ("11-6876" "謁󠄀")
      ("11-6877" "㡴")
      ("11-687E" "蠃󠄁")
      ("11-687F" "蜮")
      ("11-6881" "旐")
      ("11-6883" "魊")
      ("11-6885" "迅󠄁")
      ("11-688D" "𦌴")
      ("11-688F" "鋈")
      ("11-6894" "翼󠄂")
      ("11-6897" "糗")
      ("11-689B" "薏")
      ("11-689D" "𩙺")
      ("11-68A0" "𦟀")
      ("11-68A2" "黿")
      ("11-68A6" "鑣")
      ("11-68A7" "䏌")
      ("11-68A8" "籒")
      ("11-68AD" "翼󠄀")
      ("11-68AF" "顣")
      ("11-68B0" "甖")
      ("11-68B1" "筇")
      ("11-68B3" "翌󠄁")
      ("11-68B5" "臝")
      ("11-68B6" "靴󠄁")
      ("11-68BA" "蓏") ;; 旧字
      ("11-68BC" "𢠵")
      ("11-68C4" "郝")
      ("11-68C6" "攔")
      ("11-68C9" "蔕")
      ("11-68CA" "蘿")
      ("11-68CB" "核") ;; 旧字
      ("11-68CD" "賴") ;; 旧字
      ("11-68D2" "鍤")
      ("11-68D4" "蕾")
      ("11-68D5" "瀨")
      ("11-68D7" "落") ;; 旧字
      ("11-68D8" "萊") ;; 旧字
      ("11-68DA" "觗")
      ("11-68DF" "梢󠄁")
      ("11-68E0" "𤔔")
      ("11-68E1" "酹")
      ("11-68E3" "雒")
      ("11-68E7" "騋")
      ("11-68EE" "校󠄁")
      ("11-68EF" "𢿢")
      ("11-68F2" "薅")
      ("11-68FA" "䯰")
      ("11-6900" "摘") ;; 旧字
      ("11-6905" "漪")
      ("11-6908" "驘")
      ("11-690B" "苔")
      ("11-690C" "頪")
      ("11-690D" "肎")
      ("11-690E" "眾")
      ("11-6919" "搆󠄁")
      ("11-691A" "藍") ;; 旧字
      ("11-691B" "匄")
      ("11-691C" "綦")
      ("11-6921" "䜌")
      ("11-6923" "蘭󠄁")
      ("11-6925" "捋")
      ("11-6926" "靁")
      ("11-6928" "𢿳")
      ("11-692A" "懢")
      ("11-6930" "𠩺")
      ("11-6934" "𨢩")
      ("11-6936" "礧")
      ("11-6939" "㸚")
      ("11-693F" "蝤")
      ("11-6953" "薦") ;; 旧字
      ("11-6954" "吏󠄁")
      ("11-6955" "柹")
      ("11-6959" "莉")
      ("11-695A" "𪗒")
      ("11-695C" "擥")
      ("11-695D" "涖")
      ("11-695E" "莅") ;; 旧字
      ("11-6960" "𢺕")
      ("11-6961" "棃")
      ("11-6962" "褭")
      ("11-696A" "𤛿")
      ("11-696B" "譋")
      ("11-696D" "萑")
      ("11-696E" "杍")
      ("11-696F" "揵")
      ("11-6973" "牣")
      ("11-6975" "𩁧")
      ("11-6978" "讕")
      ("11-6979" "欄󠄀")
      ("11-697C" "締")
      ("11-697D" "鴚")
      ("11-697E" "𥝢")
      ("11-6981" "䇐")
      ("11-6982" "吪")
      ("11-698A" "樆")
      ("11-698E" "芸") ;; 旧字
      ("11-6991" "稑")
      ("11-6994" "緹")
      ("11-6995" "葎")
      ("11-699B" "𣐊")
      ("11-699C" "寽")
      ("11-69A0" "穋")
      ("11-69A7" "坴")
      ("11-69AE" "嫠")
      ("11-69B1" "鎏")
      ("11-69BB" "邐")
      ("11-69BE" "醨")
      ("11-69BF" "氂")
      ("11-69C1" "犛")
      ("11-69C3" "鸝")
      ("11-69CA" "𠩬")
      ("11-69CB" "髹")
      ("11-69CC" "雧")
      ("11-69CD" "殺󠄀")
      ("11-69CE" "𠭰")
      ("11-69D0" "𡳐")
      ("11-69D3" "縭")
      ("11-69D8" "稺")
      ("11-69D9" "僔")
      ("11-69DD" "黧")
      ("11-69DE" "琉") ;; 旧字
      ("11-69E7" "癃")
      ("11-69E8" "畱")
      ("11-69EB" "飂")
      ("11-69ED" "騮")
      ("11-69F2" "疁")
      ("11-69F9" "罶")
      ("11-69FB" "詶")
      ("11-69FD" "煞")
      ("11-69FF" "旒") ;; 旧字
      ("11-6A02" "龍󠄂")
      ("11-6A05" "蟉")
      ("11-6A0A" "𩞷")
      ("11-6A0B" "膌")
      ("11-6A0C" "淩") ;; 旧字
      ("11-6A12" "旅󠄁")
      ("11-6A13" "𣎎")
      ("11-6A14" "懰")
      ("11-6A17" "杓󠄁")
      ("11-6A1B" "隆󠄁")
      ("11-6A1E" "駵")
      ("11-6A1F" "邍")
      ("11-6A21" "鮐")
      ("11-6A22" "漻")
      ("11-6A23" "夌")
      ("11-6A29" "綥")
      ("11-6A2A" "癭")
      ("11-6A2B" "麚")
      ("11-6A2E" "僇󠄀")
      ("11-6A35" "甗")
      ("11-6A36" "𣄴")
      ("11-6A38" "憀")
      ("11-6A39" "桀")
      ("11-6A3A" "丯")
      ("11-6A3D" "籭")
      ("11-6A44" "悢")
      ("11-6A47" "蔆")
      ("11-6A48" "廫")
      ("11-6A4B" "𦺊")
      ("11-6A58" "㖾")
      ("11-6A59" "𤊽")
      ("11-6A5F" "隺")
      ("11-6A61" "𢕈")
      ("11-6A66" "棱")
      ("11-6A72" "翏󠄀")
      ("11-6A78" "菱") ;; 旧字
      ("11-6A7F" "鞾")
      ("11-6A80" "𡭗")
      ("11-6A84" "憭")
      ("11-6A8D" "膫")
      ("11-6A8E" "迄󠄁")
      ("11-6A90" "膋")
      ("11-6A97" "蓼") ;; 旧字
      ("11-6A9C" "𤸰")
      ("11-6AA0" "巤")
      ("11-6AA2" "敹")
      ("11-6AA3" "獠")
      ("11-6AAA" "綠")
      ("11-6AAC" "躐")
      ("11-6AAE" "倮")
      ("11-6AB3" "鯪")
      ("11-6AB8" "蜽")
      ("11-6ABB" "遼󠄁")
      ("11-6AC1" "虜󠄀")
      ("11-6AC2" "𤻲")
      ("11-6AC3" "瘳")
      ("11-6AD3" "楨")
      ("11-6ADA" "醁")
      ("11-6ADB" "闞")
      ("11-6ADE" "鬣")
      ("11-6ADF" "菉")
      ("11-6AE8" "蕊")
      ("11-6AEA" "騄")
      ("11-6AFA" "粦") ;; 旧字
      ("11-6B05" "恡")
      ("11-6B12" "粼")
      ("11-6B16" "癛")
      ("11-6B1D" "堙󠄁")
      ("11-6B1F" "燐󠄁")
      ("11-6B20" "幾󠄁")
      ("11-6B21" "磎")
      ("11-6B23" "筦")
      ("11-6B27" "鷖")
      ("11-6B32" "築󠄁")
      ("11-6B37" "遴")
      ("11-6B38" "璘")
      ("11-6B39" "隣󠄁")
      ("11-6B3A" "嚄")
      ("11-6B3D" "貆")
      ("11-6B3E" "儈")
      ("11-6B43" "藺") ;; 旧字
      ("11-6B47" "轔")
      ("11-6B49" "鱗󠄁")
      ("11-6B4C" "燄")
      ("11-6B4E" "兕")
      ("11-6B50" "麟󠄁")
      ("11-6B53" "憒")
      ("11-6B54" "躪")
      ("11-6B59" "麐")
      ("11-6B5B" "蹸")
      ("11-6B5F" "慺")
      ("11-6B61" "膢")
      ("11-6B62" "𠣞")
      ("11-6B63" "薧")
      ("11-6B64" "恐󠄁")
      ("11-6B66" "幨")
      ("11-6B69" "草") ;; 旧字
      ("11-6B6A" "鞮")
      ("11-6B6F" "扃")
      ("11-6B73" "饗󠄃")
      ("11-6B74" "㣇")
      ("11-6B78" "厽")
      ("11-6B79" "淚")
      ("11-6B7F" "絫")
      ("11-6B80" "讄")
      ("11-6B83" "類󠄀")
      ("11-6B86" "贈󠄁")
      ("11-6B89" "棬")
      ("11-6B8B" "空󠄁")
      ("11-6B8D" "羸") ;; 旧字
      ("11-6B95" "纍")
      ("11-6B96" "厷")
      ("11-6B98" "藟") ;; 旧字
      ("11-6B9E" "儽")
      ("11-6BA4" "禷")
      ("11-6BAA" "勵")
      ("11-6BAB" "戾")
      ("11-6BAF" "沴")
      ("11-6BB1" "苓")
      ("11-6BB2" "泠")
      ("11-6BB3" "瓴")
      ("11-6BB4" "黳")
      ("11-6BB5" "𥔵")
      ("11-6BB7" "荔")
      ("11-6BBA" "趛")
      ("11-6BBB" "過󠄁")
      ("11-6BBC" "唳󠄂")
      ("11-6BBF" "糈")
      ("11-6BC0" "佖")
      ("11-6BC5" "𣪊")
      ("11-6BC6" "捩󠄁")
      ("11-6BCB" "笭")
      ("11-6BCD" "掃󠄁")
      ("11-6BCE" "飧")
      ("11-6BD2" "錆󠄁")
      ("11-6BD3" "麢")
      ("11-6BD4" "𨒪")
      ("11-6BD8" "尐")
      ("11-6BDB" "魋")
      ("11-6BDF" "翎")
      ("11-6BEB" "盠")
      ("11-6BEC" "舲")
      ("11-6BEF" "𤫊")
      ("11-6BF3" "厲") ;; 旧字
      ("11-6C08" "霝")
      ("11-6C11" "鬌")
      ("11-6C13" "癘")
      ("11-6C14" "㾐")
      ("11-6C17" "䘔")
      ("11-6C1B" "藜")
      ("11-6C23" "孁")
      ("11-6C24" "丽") ;; 旧字
      ("11-6C34" "嗥")
      ("11-6C38" "霣")
      ("11-6C3E" "萋")
      ("11-6C40" "鷫")
      ("11-6C42" "桰")
      ("11-6C4E" "聖󠄁") ;; 聖の下は「𡈼」
      ("11-6C50" "煢󠄁")
      ("11-6C55" "礪") ;; 旧字
      ("11-6C57" "艐")
      ("11-6C5A" "嬴")
      ("11-6C5D" "釀")
      ("11-6C5E" "盭")
      ("11-6C60" "䘐")
      ("11-6C62" "醴󠄁")
      ("11-6C68" "秝")
      ("11-6C6A" "儷")
      ("11-6C70" "芷")
      ("11-6C72" "喝󠄁")
      ("11-6C73" "厤")
      ("11-6C7A" "惎")
      ("11-6C7D" "确")
      ("11-6C7E" "龗")
      ("11-6C81" "蠇")
      ("11-6C82" "糲")
      ("11-6C83" "挃")
      ("11-6C88" "習󠄀")
      ("11-6C8C" "麞")
      ("11-6C8D" "䊪")
      ("11-6C90" "歷")
      ("11-6C92" "曆")
      ("11-6C93" "囏󠄀")
      ("11-6C96" "嶧")
      ("11-6C99" "憍")
      ("11-6C9A" "蠣")
      ("11-6C9B" "𣀷")
      ("11-6CA1" "臟")
      ("11-6CA2" "蓍")
      ("11-6CAB" "拕")
      ("11-6CAE" "廉󠄀")
      ("11-6CB3" "焱")
      ("11-6CB8" "羼")
      ("11-6CB9" "𩍕")
      ("11-6CBA" "蓮󠄀")
      ("11-6CBB" "嵆")
      ("11-6CBC" "讞")
      ("11-6CBD" "茢")
      ("11-6CBE" "煉󠄀")
      ("11-6CBF" "薀")
      ("11-6CC1" "豻")
      ("11-6CC4" "皪")
      ("11-6CC5" "帘")
      ("11-6CC9" "菎")
      ("11-6CCA" "賮")
      ("11-6CCC" "𡧯")
      ("11-6CD3" "𡿪")
      ("11-6CD5" "蒼") ;; 旧字
      ("11-6CD7" "迾")
      ("11-6CD9" "漣󠄀")
      ("11-6CDB" "奩")
      ("11-6CDD" "連󠄀")
      ("11-6CE1" "蛸󠄁")
      ("11-6CE2" "榛")
      ("11-6CE3" "渴")
      ("11-6CE5" "奞")
      ("11-6CEA" "練󠄀")
      ("11-6CEF" "籢")
      ("11-6CF0" "枱")
      ("11-6CF1" "酈")
      ("11-6CF3" "韻") ;; 旧字
      ("11-6D0B" "絺")
      ("11-6D0C" "孌")
      ("11-6D12" "薟")
      ("11-6D17" "髡")
      ("11-6D19" "簾")
      ("11-6D1B" "注󠄁")
      ("11-6D1E" "屟")
      ("11-6D1F" "憐󠄀")
      ("11-6D25" "㗊")
      ("11-6D29" "亏")
      ("11-6D2A" "鵂")
      ("11-6D32" "撅")
      ("11-6D33" "蘞")
      ("11-6D35" "鬑")
      ("11-6D36" "鍊")
      ("11-6D38" "鎌󠄁")
      ("11-6D3B" "訝󠄂")
      ("11-6D3D" "殮")
      ("11-6D3E" "漘")
      ("11-6D41" "攄")
      ("11-6D45" "䖵")
      ("11-6D59" "樐")
      ("11-6D5A" "蕗") ;; 旧字
      ("11-6D5C" "牷")
      ("11-6D63" "孿")
      ("11-6D64" "擄")
      ("11-6D66" "筠")
      ("11-6D69" "闟")
      ("11-6D6A" "衹")
      ("11-6D6C" "姱")
      ("11-6D74" "豑")
      ("11-6D77" "鷗")
      ("11-6D78" "浩󠄁")
      ("11-6D79" "壚")
      ("11-6D85" "鸕")
      ("11-6D88" "夃")
      ("11-6D8C" "儋")
      ("11-6D8E" "蘆") ;; 旧字
      ("11-6D93" "玈")
      ("11-6D95" "芦󠄁")
      ("11-6D99" "亍")
      ("11-6D9B" "訟󠄁")
      ("11-6D9C" "氅")
      ("11-6DAF" "囮󠄁")
      ("11-6DB2" "竽")
      ("11-6DB5" "𨹟")
      ("11-6DB8" "浪") ;; 旧字
      ("11-6DBC" "朝󠄁")
      ("11-6DC5" "嫪")
      ("11-6DC7" "朗") ;; 旧字
      ("11-6DCB" "蹀")
      ("11-6DCC" "稂")
      ("11-6DD1" "建󠄁")
      ("11-6DD2" "塿")
      ("11-6DD5" "蔞")
      ("11-6DD8" "章") ;; 旧字
      ("11-6DD9" "摟")
      ("11-6DDE" "廊󠄁")
      ("11-6DE1" "𧰽")
      ("11-6DE4" "屚")
      ("11-6DE6" "朖")
      ("11-6DE8" "瀧") ;; 旧字
      ("11-6DEA" "閬")
      ("11-6DEB" "鴥") ;; 旧字
      ("11-6DEC" "莨")
      ("11-6DEE" "耬")
      ("11-6DF1" "烄")
      ("11-6DF3" "𥆞")
      ("11-6DF5" "譔")
      ("11-6DF7" "蛩") ;; 旧字
      ("11-6DF9" "黸") ;; 旧字
      ("11-6DFA" "廔")
      ("11-6DFB" "苴") ;; 旧字
      ("11-6E05" "薨") ;; 旧字
      ("11-6E07" "嚅")
      ("11-6E08" "驚") ;; 旧字
      ("11-6E09" "戶")
      ("11-6E0A" "郞")
      ("11-6E0B" "䇂")
      ("11-6E13" "祁")
      ("11-6E15" "㔷")
      ("11-6E19" "壠") ;; 旧字
      ("11-6E1A" "甄󠄁")
      ("11-6E1D" "㯟")
      ("11-6E1F" "扐")
      ("11-6E20" "𣦵")
      ("11-6E21" "訩")
      ("11-6E23" "瓏")
      ("11-6E24" "淥")
      ("11-6E25" "噯")
      ("11-6E26" "侌")
      ("11-6E29" "妟")
      ("11-6E2B" "蠟")
      ("11-6E2C" "毚")
      ("11-6E2E" "壟") ;; 旧字
      ("11-6E2F" "䰍")
      ("11-6E38" "籙")
      ("11-6E3A" "彔")
      ("11-6E3E" "朧") ;; 旧字
      ("11-6E43" "阞")
      ("11-6E4A" "涶")
      ("11-6E4D" "聾󠄁")
      ("11-6E4E" "泐")
      ("11-6E56" "齮")
      ("11-6E58" "呱")
      ("11-6E5B" "刵")
      ("11-6E5F" "隴")
      ("11-6E67" "髧")
      ("11-6E6B" "礱")
      ("11-6E6E" "醪")
      ("11-6E6F" "菖")
      ("11-6E72" "臈")
      ("11-6E76" "籠") ;; 旧字
      ("11-6E7E" "滴") ;; 旧字
      ("11-6E7F" "睘")
      ("11-6E80" "撾")
      ("11-6E82" "掄")
      ("11-6E8C" "犓")
      ("11-6E8F" "雘")
      ("11-6E96" "䅌")
      ("11-6E98" "窊")
      ("11-6E9C" "瀦󠄁")
      ("11-6E9D" "髹")
      ("11-6E9F" "矱")
      ("11-6EA2" "毓")
      ("11-6EA5" "彠")
      ("11-6EAF" "煨")
      ("11-6EB2" "薈") ;; 旧字
      ("11-6EB6" "摛")
      ("11-6EB7" "洼")
      ("11-6EBA" "瞚")
      ("11-6EBD" "竵")
      ("11-6EC2" "蒦")
      ("11-6EC4" "碨")
      ("11-6EC5" "𢊁")
      ("11-6EC9" "譮")
      ("11-6ECB" "卿󠄀")
      ("11-6ED1" "莪")
      ("11-6ED3" "龢")
      ("11-6ED4" "薉")
      ("11-6ED5" "篗")
      ("11-6EDD" "蒔") ;; 旧字
      ("11-6EDE" "胔")
      ("11-6EEC" "惋")
      ("11-6EF4" "踆")
      ("11-6EF8" "盌")
      ("11-6EFF" "錄")
      ("11-6F01" "㢧")
      ("11-6F02" "芊") ;; 旧字
      ("11-6F06" "䭫")
      ("11-6F09" "邛")
      ("11-6F0F" "鄭󠄁")
      ("11-6F14" "英") ;; 旧字
      ("11-6F15" "劄")
      ("11-6F20" "翠󠄁")
      ("11-6F22" "噦")
      ("11-6F23" "荑") ;; 旧字
      ("11-6F2B" "朵")
      ("11-6F2C" "逎󠄁")
      ("11-6F38" "𡿧")
      ("11-6F41" "剜")
      ("11-6F45" "澮")
      ("11-6F54" "揆󠄁")
      ("11-6F5C" "簏")
      ("11-6F5F" "牙󠄁")
      ("11-6F64" "絭")
      ("11-6F6E" "杸")
      ("11-6F70" "鏽")
      ("11-6F84" "遘󠄁")
      ("11-6F97" "廥")
      ("11-6FB1" "翥")
      ("11-6FC0" "匭")
      ("11-6FC1" "緦")
      ("11-6FE0" "籧")
      ("11-6FE4" "籚")
      ("11-6FEB" "㕑")
      ("11-6FEF" "鳲")
      ("11-7015" "荃")
      ("11-701E" "醮")
      ("11-7026" "彴") ;; 旧字
      ("11-7027" "䛗")
      ("11-702C" "皞")
      ("11-704C" "㼝")
      ("11-7058" "情󠄁")
      ("11-706F" "勝󠄁")
      ("11-7070" "億") ;; 旧字
      ("11-707C" "羿󠄀")
      ("11-707D" "龔")
      ("11-7089" "矴")
      ("11-708A" "嘷")
      ("11-708E" "拽")
      ("11-70AD" "呢")
      ("11-70BA" "蜲")
      ("11-70C8" "帝󠄁")
      ("11-70F9" "嘈")
      ("11-7114" "抴")
      ("11-711A" "鱻")
      ("11-7121" "𠂤")
      ("11-7126" "狐") ;; 旧字
      ("11-7136" "𢦏")
      ("11-713C" "岵")
      ("11-7149" "脡")
      ("11-714E" "滚")
      ("11-7159" "枻")
      ("11-7164" "紝")
      ("11-7167" "孤") ;; 旧字
      ("11-7169" "隮")
      ("11-716E" "蟪")
      ("11-717D" "蒟")
      ("11-718A" "讙")
      ("11-7194" "疐")
      ("11-719F" "祆")
      ("11-71B1" "矤")
      ("11-71C3" "𡫏")
      ("11-71C8" "椒")
      ("11-71D5" "栧")
      ("11-71DF" "藩")
      ("11-71E5" "剳")
      ("11-71E6" "箜") ;; 旧字
      ("11-71EE" "肧")
      ("11-7206" "𥝩") ;; 旧字
      ("11-722A" "襲") ;; 旧字
      ("11-7235" "𦐧")
      ("11-7236" "嫥")
      ("11-723A" "磔󠄁")
      ("11-723D" "迮")
      ("11-723E" "嵇")
      ("11-7247" "遡󠄁")
      ("11-7248" "胜")
      ("11-724C" "簪") ;; 旧字
      ("11-7252" "姝")
      ("11-7259" "爓")
      ("11-725B" "㵣")
      ("11-725D" "廌")
      ("11-725F" "汏")
      ("11-7261" "閱")
      ("11-7262" "骶")
      ("11-7267" "造󠄁")
      ("11-7272" "覯󠄁")
      ("11-7279" "燋")
      ("11-727D" "褘")
      ("11-72A0" "觳")
      ("11-72AC" "誒")
      ("11-72AF" "誠󠄁")
      ("11-72B6" "巟") ;; 旧字
      ("11-72C2" "犴")
      ("11-72D0" "屭")
      ("11-72D7" "諴")
      ("11-72D9" "最󠄁")
      ("11-72E9" "鶪")
      ("11-72EC" "閶")
      ("11-72ED" "𢽎")
      ("11-72F8" "齍")
      ("11-72FC" "璏")
      ("11-72FD" "荏") ;; 旧字
      ("11-731B" "蠆")
      ("11-731F" "琱")
      ("11-732A" "仢") ;; 旧字
      ("11-732B" "侵󠄁")
      ("11-732E" "豨")
      ("11-7336" "噉")
      ("11-7337" "歎󠄁")
      ("11-7344" "弜")
      ("11-7345" "彐󠄀")
      ("11-7363" "券󠄁")
      ("11-7372" "嫁") ;; 旧字
      ("11-7384" "蟣")
      ("11-7387" "柠")
      ("11-7389" "酣")
      ("11-738B" "帟")
      ("11-7396" "還󠄁")
      ("11-73B2" "懟")
      ("11-73CA" "敺")
      ("11-73CD" "習󠄁")
      ("11-73E0" "𢧢")
      ("11-73EA" "屺")
      ("11-73ED" "靖󠄁")
      ("11-73FE" "隳")
      ("11-7403" "割󠄀")
      ("11-7406" "譸")
      ("11-7409" "躇󠄀") ;; 旧字
      ("11-7422" "幟")
      ("11-7433" "鞗")
      ("11-7434" "狟")
      ("11-7435" "㪿")
      ("11-7436" "蓁") ;; 旧字
      ("11-745A" "肸")
      ("11-745E" "跲")
      ("11-7460" "鯛󠄁")
      ("11-7473" "撟")
      ("11-7483" "躕")
      ("11-74B0" "巜")
      ("11-74BD" "惸")
      ("11-74DC" "靷")
      ("11-74E2" "叀")
      ("11-74E6" "㣛")
      ("11-7511" "㧬") ;; 旧字
      ("11-7518" "濊")
      ("11-751A" "黃")
      ("11-751C" "䏣")
      ("11-751F" "講󠄁")
      ("11-7523" "鴝")
      ("11-7525" "曀")
      ("11-7528" "疐")
      ("11-752B" "送󠄁")
      ("11-7530" "蔗") ;; 旧字
      ("11-7531" "𣥁")
      ("11-7532" "髤")
      ("11-7533" "烘")
      ("11-7537" "辤")
      ("11-7538" "訒")
      ("11-753A" "炷")
      ("11-753B" "鼴")
      ("11-754B" "愈󠄁")
      ("11-754C" "憶") ;; 旧字
      ("11-754F" "蜼")
      ("11-7554" "精󠄀")
      ("11-7559" "䠧")
      ("11-755C" "礩")
      ("11-755D" "緪")
      ("11-7560" "菘")
      ("11-7562" "說")
      ("11-7565" "筯")
      ("11-7566" "祈󠄀")
      ("11-756A" "鯖󠄁")
      ("11-7570" "飴󠄁")
      ("11-7573" "阬")
      ("11-7577" "𣯍")
      ("11-757F" "搉")
      ("11-758E" "晬")
      ("11-758F" "冣")
      ("11-7591" "穫") ;; 旧字
      ("11-75AB" "雩")
      ("11-75B2" "𧵩")
      ("11-75B9" "珩")
      ("11-75C5" "穿󠄁")
      ("11-75C7" "弧") ;; 旧字
      ("11-75D4" "𢞛")
      ("11-75D5" "貺")
      ("11-75D8" "硝󠄁") ;; 旧字
      ("11-75DB" "楫")
      ("11-75E2" "𦬸") ;; 旧字（朮）
      ("11-75E9" "檆")
      ("11-75F4" "𠮟")
      ("11-7642" "鼦")
      ("11-764C" "垓") ;; 旧字
      ("11-7652" "脫")
      ("11-7656" "菹")
      ("11-767A" "縐")
      ("11-767D" "㒸") ;; 旧字
      ("11-767E" "𢇍")
      ("11-7684" "蕣󠄀")
      ("11-7686" "臆") ;; 旧字
      ("11-7687" "齅")
      ("11-7690" "呴")
      ("11-76BF" "榘")
      ("11-76C3" "齔")
      ("11-76C6" "屬")
      ("11-76C8" "㝢")
      ("11-76CA" "齲")
      ("11-76D7" "涉")
      ("11-76DB" "購󠄂")
      ("11-76DC" "僯")
      ("11-76DF" "釱")
      ("11-76E3" "獬")
      ("11-76E4" "蠐")
      ("11-76EE" "嬭")
      ("11-76F2" "錞")
      ("11-76F4" "琇")
      ("11-76F8" "芟") ;; 旧字
      ("11-76FE" "鈐")
      ("11-7701" "㱠")
      ("11-7709" "剎")
      ("11-770B" "褢")
      ("11-770C" "撝")
      ("11-771F" "紭")
      ("11-7720" "𩴓")
      ("11-773A" "𦣻")
      ("11-773C" "孩") ;; 旧字
      ("11-7740" "罝")
      ("11-7761" "媾󠄁")
      ("11-7763" "瘴")
      ("11-7766" "像󠄁")
      ("11-77A5" "酥󠄁")
      ("11-77AC" "健󠄁")
      ("11-77AD" "覜")
      ("11-77B3" "廠󠄁")
      ("11-77DB" "炱")
      ("11-77E2" "斀")
      ("11-77E7" "煁")
      ("11-77E9" "館󠄁")
      ("11-77ED" "姒")
      ("11-77EF" "琀")
      ("11-77F3" "聱󠄀")
      ("11-7802" "皛")
      ("11-7814" "跽")
      ("11-7815" "喁")
      ("11-7825" "疌")
      ("11-7826" "鄴")
      ("11-7832" "層󠄁")
      ("11-7834" "䢅")
      ("11-783F" "簴")
      ("11-785D" "祜")
      ("11-786B" "刁")
      ("11-786C" "鬮󠄁")
      ("11-786F" "嘻")
      ("11-7872" "鵻")
      ("11-7881" "喫󠄂")
      ("11-788D" "㘥")
      ("11-7891" "晳")
      ("11-7897" "翟󠄀")
      ("11-78A7" "𦼬")
      ("11-78A9" "穀󠄀")
      ("11-78BA" "𣄸")
      ("11-78C1" "敬") ;; 旧字
      ("11-78D0" "𪗍")
      ("11-78E8" "捽")
      ("11-78EF" "昱")
      ("11-7901" "羖")
      ("11-790E" "焠")
      ("11-793A" "晵")
      ("11-793C" "鎚󠄁")
      ("11-793E" "醯󠄁")
      ("11-7941" "丌")
      ("11-7947" "𩅢")
      ("11-7950" "嘆󠄀")
      ("11-7956" "歲")
      ("11-795D" "畎")
      ("11-795E" "耕󠄁")
      ("11-7962" "囟")
      ("11-7965" "扈󠄁")
      ("11-7968" "㦰")
      ("11-796D" "顒")
      ("11-7977" "翔󠄁")
      ("11-7981" "摜")
      ("11-7984" "薙")
      ("11-7985" "災")
      ("11-798D" "菀")
      ("11-798E" "崒")
      ("11-798F" "顓")
      ("11-79A6" "𢎥")
      ("11-79BD" "琯")
      ("11-79BE" "菸")
      ("11-79BF" "蕭") ;; 旧字
      ("11-79C0" "潏")
      ("11-79C1" "卟")
      ("11-79CB" "潔󠄁")
      ("11-79D1" "媛󠄁")
      ("11-79D2" "苫") ;; 旧字
      ("11-79D8" "腊")
      ("11-79DF" "嘬")
      ("11-79E4" "韌")
      ("11-79E6" "耗󠄁")
      ("11-79E9" "卸󠄀")
      ("11-79F0" "瓠󠄁")
      ("11-79FB" "遺󠄁")
      ("11-7A0B" "卹")
      ("11-7A0E" "纊")
      ("11-7A14" "憜")
      ("11-7A17" "偰")
      ("11-7A1A" "桼")
      ("11-7A1C" "徵󠄁")
      ("11-7A2E" "綌")
      ("11-7A32" "煜")
      ("11-7A3C" "煙") ;; 旧字
      ("11-7A3F" "𠙴")
      ("11-7A40" "劦")
      ("11-7A42" "搜󠄁")
      ("11-7A46" "增")
      ("11-7A4D" "嚙")
      ("11-7A4E" "羽󠄀")
      ("11-7A4F" "肙")
      ("11-7A50" "㤅")
      ("11-7A63" "𡥈")
      ("11-7A6B" "禍󠄀")
      ("11-7A74" "攲")
      ("11-7A76" "舝")
      ("11-7A7A" "觀") ;; 旧字
      ("11-7A7F" "閽")
      ("11-7A81" "魈")
      ("11-7A83" "圣")
      ("11-7A84" "殣")
      ("11-7A92" "射") ;; 旧字
      ("11-7A93" "祘")
      ("11-7A9F" "鬫")
      ("11-7AAA" "贛")
      ("11-7AAE" "葛󠄁")
      ("11-7AAF" "墀")
      ("11-7ACB" "摴")
      ("11-7AD2" "廟󠄁")
      ("11-7ADC" "岧")
      ("11-7AE0" "虖")
      ("11-7AE3" "捲")
      ("11-7AE5" "憧")
      ("11-7AEA" "颸")
      ("11-7AEF" "咡")
      ("11-7AF6" "𤥚")
      ("11-7AF8" "檔")
      ("11-7AF9" "騭")
      ("11-7AFA" "嘒")
      ("11-7AFF" "褱")
      ("11-7B08" "褐󠄁")
      ("11-7B11" "絝")
      ("11-7B1B" "踳")
      ("11-7B20" "騧")
      ("11-7B25" "㺅")
      ("11-7B26" "戩")
      ("11-7B2C" "媸")
      ("11-7B39" "麏")
      ("11-7B46" "辥")
      ("11-7B48" "緌")
      ("11-7B49" "象") ;; 旧字
      ("11-7B4B" "暵")
      ("11-7B4F" "𨒌")
      ("11-7B51" "暱")
      ("11-7B52" "炤")
      ("11-7B54" "塍󠄀")
      ("11-7B86" "塐")
      ("11-7B87" "蝯")
      ("11-7B94" "衰") ;; 旧字
      ("11-7B95" "挪")
      ("11-7B97" "屨")
      ("11-7BA1" "韰")
      ("11-7BAD" "𥊽")
      ("11-7BB1" "旞")
      ("11-7BB8" "龡")
      ("11-7BC0" "扢")
      ("11-7BC4" "篲")
      ("11-7BC7" "溯")
      ("11-7BC9" "櫛󠄂")
      ("11-7BE0" "嬛")
      ("11-7BE4" "歱")
      ("11-7BED" "諦") ;; 旧字
      ("11-7C21" "頮")
      ("11-7C38" "趞")
      ("11-7C3E" "逞󠄁")
      ("11-7C3F" "埽")
      ("11-7C4D" "謷")
      ("11-7C73" "殂")
      ("11-7C7E" "摭")
      ("11-7C81" "𨳢")
      ("11-7C82" "鑵") ;; 旧字
      ("11-7C89" "冉󠄁")
      ("11-7C8B" "彀")
      ("11-7C8D" "嶞")
      ("11-7C92" "𠧞")
      ("11-7C95" "醉")
      ("11-7C97" "㝮")
      ("11-7C98" "涔")
      ("11-7C9B" "甽")
      ("11-7C9F" "匜")
      ("11-7CA5" "屆")
      ("11-7CA7" "菰") ;; 旧字
      ("11-7CBE" "骾")
      ("11-7CCA" "覉")
      ("11-7CCE" "采󠄁")
      ("11-7CD6" "䀹")
      ("11-7CDE" "全󠄁")
      ("11-7CDF" "蠶")
      ("11-7CE0" "𥬔")
      ("11-7CE7" "畼")
      ("11-7CF8" "𥝌")
      ("11-7CFB" "𣄨")
      ("11-7CFE" "嘎")
      ("11-7D00" "較󠄁")
      ("11-7D04" "讁") ;; 旧字
      ("11-7D0B" "琢")
      ("11-7D0D" "祳") ;; 旧字
      ("11-7D10" "絕")
      ("11-7D14" "嗛")
      ("11-7D17" "巂")
      ("11-7D18" "巨󠄁")
      ("11-7D19" "乩")
      ("11-7D1A" "劀")
      ("11-7D1B" "𡰫")
      ("11-7D20" "蔡") ;; 旧字
      ("11-7D21" "藂")
      ("11-7D22" "禽") ;; 旧字
      ("11-7D2B" "𠛬")
      ("11-7D2C" "鰌")
      ("11-7D2F" "捗󠄁")
      ("11-7D30" "侷")
      ("11-7D33" "秏")
      ("11-7D39" "苽") ;; 旧字
      ("11-7D3A" "敫")
      ("11-7D42" "鴂")
      ("11-7D44" "瘵")
      ("11-7D4C" "芰") ;; 旧字
      ("11-7D50" "晷")
      ("11-7D5E" "榘")
      ("11-7D61" "柱󠄁")
      ("11-7D62" "黤")
      ("11-7D66" "稭")
      ("11-7D71" "筲")
      ("11-7D75" "肊")
      ("11-7D76" "曶")
      ("11-7D79" "器󠄁")
      ("11-7D99" "茤")
      ("11-7D9C" "㪔") ;; 旧字
      ("11-7DAC" "烕")
      ("11-7DAD" "噫") ;; 旧字
      ("11-7DB1" "凥")
      ("11-7DB4" "聚󠄁")
      ("11-7DBB" "柅")
      ("11-7DBE" "鷃")
      ("11-7DBF" "隤")
      ("11-7DCA" "歡") ;; 旧字
      ("11-7DCB" "舃")
      ("11-7DCF" "產")
      ("11-7DD1" "𣶃")
      ("11-7DD2" "儇")
      ("11-7DDA" "晜")
      ("11-7DE0" "怵")
      ("11-7DE8" "蔬") ;; 旧字
      ("11-7DEC" "儓")
      ("11-7DEF" "緯󠄁")
      ("11-7DF4" "啼") ;; 旧字
      ("11-7E01" "郢")
      ("11-7E04" "氄")
      ("11-7E1B" "誶")
      ("11-7E1E" "擎") ;; 旧字
      ("11-7E26" "肩󠄁")
      ("11-7E2B" "憁")
      ("11-7E2E" "𡿨")
      ("11-7E3E" "驁")
      ("11-7E41" "請󠄁")
      ("11-7E4A" "鮌")
      ("11-7E4B" "姬󠄁")
      ("11-7E4D" "橛")
      ("11-7E54" "矦")
      ("11-7E55" "烖")
      ("11-7E6D" "垛")
      ("11-7E70" "驩") ;; 旧字
      ("11-7E82" "軀") ;; 旧字
      ("11-7E8F" "渚󠄀")
      ("11-7F36" "頯")
      ("11-7F6A" "樝")
      ("11-7F6B" "巸")
      ("11-7F72" "揅")
      ("11-7F75" "禛")
      ("11-7F77" "舄")
      ("11-7F79" "牻")
      ("11-7F85" "嫡") ;; 旧字
      ("11-7F8A" "徲")
      ("11-7F8E" "㕞")
      ("11-7FA4" "莟")
      ("11-7FA8" "鵾")
      ("11-7FA9" "騞")
      ("11-7FBD" "陻") ;; 旧字
      ("11-7FC1" "益󠄁")
      ("11-7FCC" "茶") ;; 旧字
      ("11-7FD2" "蕨")
      ("11-7FEB" "害󠄂")
      ("11-7FF0" "檞")
      ("11-7FFB" "速󠄁")
      ("11-7FFC" "辵")
      ("11-8000" "䰡")
      ("11-8001" "赬")
      ("11-8003" "歫")
      ("11-8005" "繫")
      ("11-800C" "棨")
      ("11-8010" "秭")
      ("11-8015" "拒󠄁")
      ("11-8033" "䈂") ;; 旧字
      ("11-8036" "諑")
      ("11-803D" "耏")
      ("11-8056" "獷")
      ("11-805E" "前󠄁")
      ("11-8061" "朁")
      ("11-806F" "彘")
      ("11-8074" "硃")
      ("11-8077" "垕")
      ("11-807E" "䞓")
      ("11-8087" "惢")
      ("11-8089" "湜")
      ("11-808B" "螮")
      ("11-808C" "蒭")
      ("11-8096" "觚")
      ("11-8098" "摂󠄁")
      ("11-809D" "薤")
      ("11-80A1" "祇")
      ("11-80A2" "㓝")
      ("11-80A5" "媳")
      ("11-80A9" "潙")
      ("11-80AA" "繒")
      ("11-80AF" "炬") ;; 旧字
      ("11-80B1" "苣󠄁")
      ("11-80B4" "觔")
      ("11-80BA" "鬵󠄁")
      ("11-80C3" "簃")
      ("11-80C6" "旹")
      ("11-80CC" "兂")
      ("11-80CE" "骴")
      ("11-80DE" "瑲")
      ("11-80E4" "鰯󠄁")
      ("11-80F4" "槳")
      ("11-80F8" "閈")
      ("11-80FD" "莘")
      ("11-8102" "囧")
      ("11-8105" "寒󠄁")
      ("11-8106" "顥")
      ("11-8107" "禰󠄁")
      ("11-8108" "媠")
      ("11-810A" "吿")
      ("11-8131" "𤺊")
      ("11-8133" "進󠄁")
      ("11-8139" "馵")
      ("11-814E" "堠")
      ("11-8150" "漩")
      ("11-8154" "胠")
      ("11-8155" "適󠄁")
      ("11-816B" "隙󠄁")
      ("11-8170" "𢀜")
      ("11-8178" "嬃")
      ("11-8179" "旜")
      ("11-817A" "𠂇")
      ("11-817F" "視󠄁")
      ("11-818F" "祛󠄀")
      ("11-819A" "煽󠄂")
      ("11-819C" "遜󠄁")
      ("11-819D" "雪󠄁")
      ("11-81A8" "𦀓")
      ("11-81B3" "灾")
      ("11-81BF" "寑")
      ("11-81C6" "暍")
      ("11-81D3" "酇")
      ("11-81E3" "𣃚")
      ("11-81E5" "饜")
      ("11-81E8" "嬥󠄀")
      ("11-81ED" "擷")
      ("11-81F3" "启")
      ("11-81F4" "㑵")
      ("11-81FC" "淫󠄁")
      ("11-8208" "掔")
      ("11-8209" "紋")
      ("11-820C" "㸓")
      ("11-820E" "檠") ;; 旧字
      ("11-8212" "迭󠄁")
      ("11-8217" "帀")
      ("11-821B" "杈")
      ("11-821C" "眴")
      ("11-821E" "𢍱")
      ("11-821F" "囓")
      ("11-822A" "𩰤")
      ("11-822C" "靚")
      ("11-8235" "柶")
      ("11-8236" "棰")
      ("11-8237" "魌")
      ("11-8239" "𧴪")
      ("11-8247" "述󠄁")
      ("11-826E" "㰾")
      ("11-826F" "粻")
      ("11-8272" "㖃")
      ("11-8276" "殹")
      ("11-828B" "𧷏")
      ("11-8299" "颭")
      ("11-829D" "蕙")
      ("11-82A5" "嗢")
      ("11-82A6" "藹")
      ("11-82AD" "稹󠄀")
      ("11-82AF" "茭")
      ("11-82B1" "猨󠄀")
      ("11-82B3" "稯")
      ("11-82B8" "既󠄁")
      ("11-82B9" "㵎")
      ("11-82BD" "豔")
      ("11-82C5" "𠧩")
      ("11-82D3" "通󠄁")
      ("11-82D4" "飤")
      ("11-82DB" "畹")
      ("11-82E5" "蜺")
      ("11-82E6" "環󠄁")
      ("11-82E7" "杓󠄁")
      ("11-82EB" "弽")
      ("11-8302" "黛󠄁")
      ("11-8304" "筵󠄀")
      ("11-830E" "媐")
      ("11-831C" "鼃")
      ("11-8328" "𧶠")
      ("11-8336" "捨󠄁")
      ("11-8338" "輺")
      ("11-8349" "琖")
      ("11-834A" "洎")
      ("11-834F" "禋")
      ("11-8352" "袪")
      ("11-8358" "剷")
      ("11-8377" "蜒")
      ("11-837B" "醳")
      ("11-839E" "𨗥")
      ("11-83AB" "蕤")
      ("11-83B1" "忡")
      ("11-83C5" "槔")
      ("11-83CA" "鑊") ;; 旧字
      ("11-83CC" "熯")
      ("11-83D3" "遠󠄁")
      ("11-83D6" "酤")
      ("11-83DC" "挶")
      ("11-83DF" "肖󠄁") ;; 旧字
      ("11-83E9" "𣍘")
      ("11-83EF" "𧻚")
      ("11-83F1" "禼")
      ("11-8404" "樟") ;; 旧字
      ("11-840E" "誃")
      ("11-8429" "葚")
      ("11-8431" "咍")
      ("11-843D" "酎") ;; 旧字
      ("11-8449" "篪")
      ("11-844E" "褚")
      ("11-8457" "勺󠄀")
      ("11-845B" "訝󠄂")
      ("11-8461" "䙴") ;; 旧字
      ("11-8463" "翛")
      ("11-8466" "薆")
      ("11-846C" "筭")
      ("11-8471" "芯")
      ("11-8475" "䵷")
      ("11-847A" "韱")
      ("11-848B" "雇󠄁")
      ("11-8490" "鱖")
      ("11-8494" "廎")
      ("11-849C" "扇󠄁")
      ("11-84B2" "䢔")
      ("11-84BC" "蒜")
      ("11-84C4" "社󠄁")
      ("11-84C9" "䶵")
      ("11-84CB" "花󠄁")
      ("11-84D1" "隓")
      ("11-84EC" "總") ;; 旧字
      ("11-84EE" "揥")
      ("11-8500" "駉")
      ("11-8513" "兊")
      ("11-851A" "愔")
      ("11-8526" "滫")
      ("11-852D" "乚")
      ("11-8535" "欑")
      ("11-8543" "虀")
      ("11-8549" "楛")
      ("11-854A" "鉶") ;; 旧字
      ("11-854E" "欿")
      ("11-8557" "璿")
      ("11-8568" "馰")
      ("11-8569" "頌")
      ("11-856A" "憸")
      ("11-8584" "萃") ;; 旧字
      ("11-8597" "瑛")
      ("11-8599" "抍")
      ("11-85A6" "挲")
      ("11-85A9" "嚚")
      ("11-85AA" "荇")
      ("11-85AB" "貦")
      ("11-85AC" "蘀")
      ("11-85AE" "挩")
      ("11-85AF" "踡")
      ("11-85C1" "逷")
      ("11-85CD" "駐󠄁")
      ("11-85E4" "𩔜")
      ("11-85E9" "醒")
      ("11-85F7" "憲󠄂")
      ("11-85FB" "憯")
      ("11-8607" "縗")
      ("11-8616" "惏")
      ("11-8617" "輬")
      ("11-862D" "𠍻")
      ("11-864E" "𠤗")
      ("11-8650" "噩")
      ("11-8655" "怓")
      ("11-865A" "屵")
      ("11-865C" "凋")
      ("11-865E" "韓󠄁")
      ("11-8679" "戠")
      ("11-867B" "諳")
      ("11-868A" "懕")
      ("11-8695" "戵")
      ("11-86A4" "脤")
      ("11-86C7" "𦇧")
      ("11-86CB" "茲") ;; 旧字
      ("11-86CD" "虺")
      ("11-86CE" "𩑠")
      ("11-86D9" "迦󠄁")
      ("11-86E4" "阱")
      ("11-86EE" "汭")
      ("11-86F8" "㣈")
      ("11-86FE" "灩")
      ("11-8702" "揔")
      ("11-8718" "柒")
      ("11-871C" "捼")
      ("11-8749" "淈")
      ("11-8755" "衖")
      ("11-8766" "鉛󠄁")
      ("11-8776" "盨")
      ("11-877F" "靭")
      ("11-878D" "簞")
      ("11-87BA" "邾")
      ("11-87F9" "音󠄁")
      ("11-87FB" "藿") ;; 旧字
      ("11-8840" "期󠄁")
      ("11-8846" "月󠄁")
      ("11-884C" "莒")
      ("11-884D" "溓")
      ("11-8853" "兼󠄁")
      ("11-8857" "咜")
      ("11-885B" "迂󠄁")
      ("11-885D" "㽽")
      ("11-8863" "闈")
      ("11-8868" "秈")
      ("11-8870" "溝󠄁")
      ("11-8877" "邪󠄂")
      ("11-8888" "龕")
      ("11-888B" "食󠄁")
      ("11-8896" "汜")
      ("11-88AB" "摭")
      ("11-88B7" "圯")
      ("11-88C1" "勖")
      ("11-88C2" "鼑")
      ("11-88C5" "澘󠄁")
      ("11-88CF" "絀")
      ("11-88D5" "潭") ;; 旧字
      ("11-88DC" "叟󠄁")
      ("11-88DF" "敽")
      ("11-88E1" "迍")
      ("11-88F3" "葫")
      ("11-88F8" "鼄")
      ("11-88FD" "藁") ;; 旧字
      ("11-88FE" "蒿") ;; 旧字
      ("11-8907" "羴")
      ("11-8910" "嚨")
      ("11-8912" "聰󠄁")
      ("11-8956" "埸")
      ("11-8972" "刖")
      ("11-897F" "餱")
      ("11-8981" "螭")
      ("11-8986" "蟺")
      ("11-8987" "搢")
      ("11-898B" "翬")
      ("11-898F" "隔󠄁")
      ("11-8996" "巠")
      ("11-8997" "祳") ;; 旧字
      ("11-899A" "窠")
      ("11-89A7" "幬")
      ("11-89AA" "莕")
      ("11-89B3" "醢")
      ("11-89D2" "葭") ;; 旧字
      ("11-89E3" "坳")
      ("11-89E6" "姮")
      ("11-8A00" "䫏")
      ("11-8A02" "秫")
      ("11-8A08" "倛")
      ("11-8A0A" "偟")
      ("11-8A0E" "僬")
      ("11-8A13" "紈")
      ("11-8A17" "漦")
      ("11-8A18" "𢡱")
      ("11-8A1F" "鼔")
      ("11-8A23" "棄") ;; 旧字
      ("11-8A2A" "遭󠄁")
      ("11-8A2D" "鷇")
      ("11-8A31" "厈")
      ("11-8A33" "籜")
      ("11-8A34" "蕞")
      ("11-8A3A" "虓")
      ("11-8A3B" "衺")
      ("11-8A3C" "𡔷")
      ("11-8A50" "鞏")
      ("11-8A54" "嘑")
      ("11-8A55" "孨")
      ("11-8A5E" "形󠄁")
      ("11-8A60" "杅")
      ("11-8A66" "邢")
      ("11-8A69" "𢒈")
      ("11-8A6B" "荻") ;; 旧字
      ("11-8A6E" "挱")
      ("11-8A70" "噩")
      ("11-8A71" "鴺")
      ("11-8A72" "𢦚")
      ("11-8A73" "滬󠄁")
      ("11-8A87" "𧱏")
      ("11-8A89" "灘󠄁")
      ("11-8A8C" "刲")
      ("11-8A93" "櫜")
      ("11-8A95" "滋󠄁")
      ("11-8A98" "誕󠄁")
      ("11-8AA0" "鯁")
      ("11-8AA4" "𠶸")
      ("11-8AAC" "抇")
      ("11-8AAD" "鞘󠄁")
      ("11-8AB0" "纚")
      ("11-8AB2" "猒")
      ("11-8AB9" "耤")
      ("11-8ABC" "蠖") ;; 旧字
      ("11-8ABF" "尌")
      ("11-8AC7" "辝")
      ("11-8ACB" "𩱧")
      ("11-8ACC" "禬")
      ("11-8ACF" "皓󠄁")
      ("11-8AD2" "肇󠄁")
      ("11-8AD6" "蹄") ;; 旧字
      ("11-8ADC" "亼")
      ("11-8AE6" "術󠄁")
      ("11-8AEE" "坰")
      ("11-8AF8" "撿")
      ("11-8AFA" "譆")
      ("11-8AFE" "翨")
      ("11-8B00" "繅")
      ("11-8B01" "蔚") ;; 旧字
      ("11-8B04" "嶂")
      ("11-8B0E" "茸")
      ("11-8B19" "觭")
      ("11-8B1B" "渠") ;; 旧字
      ("11-8B1D" "警") ;; 旧字
      ("11-8B21" "齝")
      ("11-8B2C" "僊󠄂")
      ("11-8B39" "緩󠄁")
      ("11-8B58" "継") ;; 旧字
      ("11-8B70" "鞹")
      ("11-8B72" "更󠄁")
      ("11-8B77" "臄")
      ("11-8B83" "臞")
      ("11-8B8A" "𢆶")
      ("11-8C37" "觗")
      ("11-8C46" "彰")
      ("11-8C4A" "噌")
      ("11-8C5A" "獐")
      ("11-8C61" "汻")
      ("11-8C6A" "敔")
      ("11-8C6B" "屮󠄀")
      ("11-8C79" "拴")
      ("11-8C8C" "藪") ;; 旧字
      ("11-8C9D" "溫")
      ("11-8C9E" "叔") ;; 旧字
      ("11-8CA0" "墠")
      ("11-8CA1" "近󠄁")
      ("11-8CA2" "琚")
      ("11-8CA7" "荐")
      ("11-8CA8" "𪀝")
      ("11-8CA9" "嚌")
      ("11-8CAB" "繢")
      ("11-8CAC" "刻") ;; 旧字
      ("11-8CAF" "灼󠄁")
      ("11-8CB0" "𣟄")
      ("11-8CB4" "摑")
      ("11-8CB7" "訊󠄁")
      ("11-8CB8" "啻")
      ("11-8CBB" "藉")
      ("11-8CBC" "暑󠄁")
      ("11-8CBF" "藻") ;; 旧字
      ("11-8CC0" "灧")
      ("11-8CC2" "禎󠄁")
      ("11-8CC3" "週󠄁")
      ("11-8CC4" "薾")
      ("11-8CC7" "冋")
      ("11-8CCA" "𠂔")
      ("11-8CCE" "莎") ;; 旧字
      ("11-8CD1" "喞") ;; 旧字
      ("11-8CD3" "訕")
      ("11-8CDB" "癯")
      ("11-8CDC" "泂")
      ("11-8CDE" "滹")
      ("11-8CE0" "敶")
      ("11-8CE2" "諆")
      ("11-8CE6" "撰󠄁")
      ("11-8CEA" "𩒨")
      ("11-8CED" "尙")
      ("11-8CFC" "詎")
      ("11-8D08" "瓚")
      ("11-8D0B" "欬")
      ("11-8D64" "牿")
      ("11-8D66" "徯")
      ("11-8D70" "篡")
      ("11-8D77" "斠")
      ("11-8D85" "𠣘")
      ("11-8D8A" "𩰪")
      ("11-8DA3" "𨻶")
      ("11-8DA8" "暠")
      ("11-8DB3" "竄") ;; 旧字
      ("11-8DDD" "𢎘")
      ("11-8DE1" "黑")
      ("11-8DE8" "嬀")
      ("11-8DEF" "筳")
      ("11-8DF3" "周󠄀")
      ("11-8DF5" "𠭯")
      ("11-8E0A" "魑")
      ("11-8E0F" "摺󠄁")
      ("11-8E44" "夋")
      ("11-8E5F" "榖")
      ("11-8E74" "抈")
      ("11-8E8D" "疒")
      ("11-8EAB" "郟")
      ("11-8EAF" "𤯍")
      ("11-8ECA" "雞󠄀")
      ("11-8ECC" "榷")
      ("11-8ECD" "頑󠄁")
      ("11-8ED2" "踦")
      ("11-8EDF" "穠󠄁")
      ("11-8EE2" "湑")
      ("11-8EF8" "𢿌")
      ("11-8EFD" "庪")
      ("11-8F03" "𩰫")
      ("11-8F09" "勗")
      ("11-8F14" "叜")
      ("11-8F1D" "毃")
      ("11-8F29" "寴")
      ("11-8F2A" "韔")
      ("11-8F38" "炭󠄁")
      ("11-8F3F" "暖󠄁")
      ("11-8F44" "雅󠄂")
      ("11-8F4D" "紃")
      ("11-8F5F" "御") ;; 旧字
      ("11-8F61" "罐")
      ("11-8F9B" "降󠄁")
      ("11-8FA8" "腯")
      ("11-8FB0" "諮󠄁")
      ("11-8FB1" "挍")
      ("11-8FB2" "祲")
      ("11-8FBA" "駔")
      ("11-8FBB" "殠")
      ("11-8FBC" "𥄉")
      ("11-8FBF" "觶")
      ("11-8FC2" "姻") ;; 旧字
      ("11-8FC4" "吒")
      ("11-8FC5" "硌")
      ("11-8FCE" "旣")
      ("11-8FD1" "𦅻")
      ("11-8FD4" "穌")
      ("11-8FE6" "緣")
      ("11-8FE9" "食󠄁")
      ("11-8FEB" "遂󠄂")
      ("11-8FED" "荀") ;; 旧字
      ("11-8FF7" "暜")
      ("11-8FFD" "廋󠄀")
      ("11-9000" "弒")
      ("11-9001" "餐󠄁")
      ("11-9003" "漳")
      ("11-9006" "㕡")
      ("11-9010" "者󠄁")
      ("11-9013" "萅")
      ("11-9014" "戕")
      ("11-9019" "𢒫")
      ("11-901A" "檝")
      ("11-901F" "蹔")
      ("11-9022" "鵶")
      ("11-9023" "稊")
      ("11-902E" "餈")
      ("11-9031" "𡴎")
      ("11-9032" "婞")
      ("11-9038" "育") ;; 旧字
      ("11-903C" "蕝󠄁")
      ("11-9041" "讋")
      ("11-9042" "滈")
      ("11-9045" "厀")
      ("11-9047" "簳")
      ("11-904A" "醓")
      ("11-904B" "㦩")
      ("11-904D" "蘇") ;; 旧字
      ("11-904E" "蝘")
      ("11-9053" "璋") ;; 旧字
      ("11-9054" "諟")
      ("11-9055" "謻")
      ("11-905C" "姊")
      ("11-9060" "勩")
      ("11-9061" "鼒")
      ("11-9063" "煇")
      ("11-9065" "黐")
      ("11-9069" "餕")
      ("11-906D" "篹")
      ("11-906E" "𢥘")
      ("11-9075" "諐")
      ("11-9077" "蓑")
      ("11-9078" "楂")
      ("11-907A" "韙")
      ("11-907C" "肈")
      ("11-907F" "蓆") ;; 旧字
      ("11-9084" "聵")
      ("11-9091" "癉")
      ("11-90A3" "扔")
      ("11-90A6" "嶒")
      ("11-90AA" "鼷")
      ("11-90B8" "狻")
      ("11-90CA" "距󠄁")
      ("11-90E1" "翫")
      ("11-90E8" "燀")
      ("11-90ED" "嘏")
      ("11-90F5" "禫")
      ("11-90FD" "松󠄁")
      ("11-912D" "珣")
      ("11-9149" "譙")
      ("11-914B" "臬")
      ("11-914C" "𢏗")
      ("11-914D" "櫬")
      ("11-914E" "虵")
      ("11-9152" "毄")
      ("11-9154" "秔")
      ("11-9162" "硬󠄁")
      ("11-916A" "啁")
      ("11-9175" "豦")
      ("11-9177" "匩")
      ("11-9178" "具󠄁")
      ("11-9187" "楗")
      ("11-918D" "寘")
      ("11-9190" "腳")
      ("11-9192" "韝")
      ("11-9197" "騶")
      ("11-919C" "隉")
      ("11-91A4" "笟") ;; 旧字
      ("11-91B8" "㪅")
      ("11-91C6" "𥱵") ;; 旧字
      ("11-91C7" "龏")
      ("11-91C8" "輗")
      ("11-91CC" "宁")
      ("11-91CD" "肩󠄁")
      ("11-91CE" "踔")
      ("11-91CF" "蔦")
      ("11-91D1" "憨")
      ("11-91D8" "䀢")
      ("11-91DD" "宼") ;; 旧字
      ("11-91E3" "禸") ;; 旧字
      ("11-91E6" "憎󠄀")
      ("11-91E7" "嚾") ;; 旧字
      ("11-920D" "丈󠄁")
      ("11-920E" "家") ;; 旧字
      ("11-9234" "𢓶")
      ("11-9237" "儗")
      ("11-9244" "犉")
      ("11-925B" "瘞")
      ("11-9262" "郰")
      ("11-9266" "箶")
      ("11-927E" "薻")
      ("11-9280" "擐")
      ("11-9283" "臤")
      ("11-9285" "緗")
      ("11-9291" "瘥")
      ("11-9298" "瑇")
      ("11-929A" "咠")
      ("11-92AD" "蜡")
      ("11-92D2" "潨")
      ("11-92E4" "壎")
      ("11-92EA" "皁")
      ("11-92ED" "禹") ;; 旧字
      ("11-92F2" "剗")
      ("11-92F3" "𧉮")
      ("11-9306" "䀠")
      ("11-9310" "綆")
      ("11-9318" "觥")
      ("11-9320" "沆")
      ("11-9326" "漢󠄁")
      ("11-9328" "蒨")
      ("11-932B" "棿")
      ("11-932C" "程󠄁")
      ("11-932F" "捦")
      ("11-9332" "蹏")
      ("11-934B" "裊")
      ("11-934D" "㮤")
      ("11-9354" "蒐") ;; 旧字
      ("11-935B" "衈")
      ("11-936C" "刓")
      ("11-9375" "機󠄁")
      ("11-937E" "𪏻")
      ("11-938C" "灰󠄁")
      ("11-9396" "噭")
      ("11-9397" "繖")
      ("11-939A" "戢")
      ("11-93A7" "茄")
      ("11-93AE" "蚹")
      ("11-93D1" "瞬󠄁")
      ("11-93E1" "睆")
      ("11-9418" "盬")
      ("11-9438" "澌")
      ("11-9451" "闓")
      ("11-9453" "窋")
      ("11-9577" "柊󠄁")
      ("11-9580" "𢽚")
      ("11-9583" "髽")
      ("11-958B" "昷")
      ("11-958F" "夤")
      ("11-9591" "瀣")
      ("11-9593" "旝")
      ("11-95A2" "翽")
      ("11-95A3" "樺")
      ("11-95A5" "靑")
      ("11-95B2" "沄")
      ("11-95C7" "咿")
      ("11-95D8" "翣")
      ("11-9632" "顙")
      ("11-963B" "𩛥") ;; 旧字
      ("11-963F" "婭")
      ("11-9640" "牭")
      ("11-9644" "箭󠄁")
      ("11-964D" "噓")
      ("11-9650" "譏")
      ("11-965B" "阼")
      ("11-9663" "殽")
      ("11-9664" "塤")
      ("11-9665" "瓌")
      ("11-966A" "尋󠄁")
      ("11-9670" "冘")
      ("11-9673" "鄹")
      ("11-9675" "𧊓")
      ("11-9676" "禓")
      ("11-9678" "猪󠄀")
      ("11-967A" "璣")
      ("11-967D" "豖")
      ("11-9685" "𩔞")
      ("11-9686" "耴")
      ("11-9688" "貛󠄁")
      ("11-968A" "䭣") ;; 旧字
      ("11-968E" "唵")
      ("11-968F" "觵")
      ("11-9694" "蜾")
      ("11-969B" "殛")
      ("11-969C" "顧󠄁")
      ("11-96A0" "匀󠄀")
      ("11-96A3" "懲󠄂")
      ("11-96B7" "辻󠄁")
      ("11-96BB" "齩")
      ("11-96C0" "睾󠄀")
      ("11-96C1" "厓")
      ("11-96C4" "膻")
      ("11-96C5" "圬")
      ("11-96C6" "跀")
      ("11-96C7" "劓")
      ("11-96CC" "莖")
      ("11-96D1" "齗")
      ("11-96D9" "𣏟")
      ("11-96DB" "榼")
      ("11-96E2" "苧")
      ("11-96E3" "襛")
      ("11-96E8" "𤔌")
      ("11-96EA" "汩")
      ("11-96EB" "熒")
      ("11-96F0" "㞋") ;; 旧字
      ("11-96F2" "瘖") ;; 旧字
      ("11-96F6" "𡈼")
      ("11-96F7" "㩅")
      ("11-96FB" "諸󠄀")
      ("11-9700" "袺")
      ("11-9707" "崤")
      ("11-970A" "氐")
      ("11-971C" "鏟")
      ("11-971E" "匵") ;; 旧字
      ("11-9732" "艇󠄁")
      ("11-9738" "傜")
      ("11-9752" "餻")
      ("11-9756" "諾") ;; 旧字
      ("11-9759" "磺")
      ("11-975E" "奭")
      ("11-9762" "憝")
      ("11-9769" "𧒘")
      ("11-976D" "港󠄁")
      ("11-9774" "𡅻")
      ("11-978D" "宧")
      ("11-9798" "䇘")
      ("11-97A0" "戄")
      ("11-97AD" "𠦃")
      ("11-97D3" "靧")
      ("11-97EE" "斸")
      ("11-97F3" "𡘹")
      ("11-97FB" "印") ;; 旧字
      ("11-97FF" "睅")
      ("11-9801" "祖󠄁")
      ("11-9802" "𥤛")
      ("11-9803" "⿰龏兄")
      ("11-9805" "虛")
      ("11-9806" "犍")
      ("11-9808" "硜")
      ("11-9810" "煗")
      ("11-9811" "塏")
      ("11-9812" "騂")
      ("11-9813" "䵼")
      ("11-9817" "熇")
      ("11-9818" "嘲󠄁")
      ("11-981A" "庋")
      ("11-982C" "鯫")
      ("11-982D" "箑")
      ("11-983B" "船󠄁")
      ("11-983C" "侜")
      ("11-984C" "㺇")
      ("11-984D" "檟")
      ("11-984E" "譁󠄁")
      ("11-9854" "愷")
      ("11-9855" "蕢")
      ("11-9858" "慨󠄀")
      ("11-985B" "署󠄀")
      ("11-985E" "朕󠄂")
      ("11-9867" "㓷")
      ("11-98A8" "篿")
      ("11-98DB" "慼")
      ("11-98DF" "巷󠄁")
      ("11-98E2" "聝")
      ("11-98ED" "枏")
      ("11-98EF" "薺") ;; 旧字
      ("11-98F2" "遹")
      ("11-98F4" "闇") ;; 旧字
      ("11-98FC" "洓")
      ("11-98FD" "瘙")
      ("11-9905" "乇")
      ("11-990A" "逐󠄁")
      ("11-990C" "酳")
      ("11-9910" "禺󠄁")
      ("11-9913" "汙")
      ("11-9928" "䪥")
      ("11-9957" "嵑")
      ("11-9996" "擊")
      ("11-9999" "鄦")
      ("11-99A8" "苛") ;; 旧字
      ("11-99AC" "諗")
      ("11-99B3" "劕")
      ("11-99B4" "嬈")
      ("11-99C1" "顇")
      ("11-99C4" "玼")
      ("11-99C6" "癇")
      ("11-99C8" "瞯")
      ("11-99D2" "窾")
      ("11-99D5" "洿")
      ("11-99FF" "䀏")
      ("11-9A12" "攙")
      ("11-9A13" "諱") ;; 旧字
      ("11-9A28" "耔")
      ("11-9A30" "䈉")
      ("11-9A5A" "睆")
      ("11-9AA8" "俠")
      ("11-9AB8" "叚")
      ("11-9AC4" "礚")
      ("11-9AD8" "駏")
      ("11-9AEA" "成󠄁")
      ("11-9AED" "晣")
      ("11-9B31" "㐭")
      ("11-9B3C" "貈")
      ("11-9B41" "𦉥")
      ("11-9B42" "誆")
      ("11-9B45" "挐")
      ("11-9B54" "率󠄁")
      ("11-9B5A" "毌")
      ("11-9B6F" "嗁")
      ("11-9B8E" "鴳")
      ("11-9B92" "躚")
      ("11-9BAA" "壿")
      ("11-9BAB" "矩󠄁")
      ("11-9BAD" "䘳")
      ("11-9BAE" "鎖󠄁")
      ("11-9BC9" "屩")
      ("11-9BD6" "盱")
      ("11-9BDB" "莿")
      ("11-9BE8" "狶")
      ("11-9BF5" "喔")
      ("11-9C0D" "驊")
      ("11-9C10" "惕")
      ("11-9C2D" "栓")
      ("11-9C2F" "𢒰")
      ("11-9C39" "齖")
      ("11-9C3B" "湮󠄁")
      ("11-9C48" "𩌦")
      ("11-9C52" "罇󠄀")
      ("11-9C57" "鼂")
      ("11-9CE5" "臭󠄁")
      ("11-9CE9" "恓")
      ("11-9CF3" "瘦󠄀") ;; 旧字
      ("11-9CF4" "隊") ;; 旧字
      ("11-9CF6" "韘")
      ("11-9D07" "𤕌")
      ("11-9D0E" "嗌󠄀")
      ("11-9D1B" "禜")
      ("11-9D2B" "㡭")
      ("11-9D2C" "棭")
      ("11-9D3B" "蕖")
      ("11-9D5C" "茵") ;; 旧字
      ("11-9D61" "祋")
      ("11-9D6C" "𤸃")
      ("11-9D8F" "旂")
      ("11-9DF2" "迪󠄁")
      ("11-9DF9" "𨽸")
      ("11-9DFA" "訢")
      ("11-9E78" "錡")
      ("11-9E7F" "㷀")
      ("11-9E93" "檉")
      ("11-9E97" "呈󠄁")
      ("11-9E9F" "寵") ;; 旧字
      ("11-9EA6" "襚")
      ("11-9EB9" "𩣓")
      ("11-9EBA" "頹")
      ("11-9EBB" "窣")
      ("11-9EBC" "眯")
      ("11-9EBE" "澧")
      ("11-9EBF" "陊")
      ("11-9EC4" "睪")
      ("11-9ECD" "萼")
      ("11-9ED9" "餧")
      ("11-9EDB" "胾")
      ("11-9F0E" "瞚")
      ("11-9F13" "螘")
      ("11-9F20" "鎡󠄁")
      ("11-9F3B" "屑󠄁")
      ("11-9F62" "廷󠄁")
      ("11-9F8D" "𠧪")
      ("12-4E01" "蔾")
      ("12-4E07" "鵊")
      ("12-4E08" "瘣")
      ("12-4E0A" "瘌")
      ("12-4E0D" "隟")
      ("12-4E11" "兩") ;; 旧字
      ("12-4E14" "囋")
      ("12-4E21" "𠮱")
      ("12-4E31" "譀")
      ("12-4E38" "㚌")
      ("12-4E4E" "扦")
      ("12-4E57" "瘼")
      ("12-4E58" "𧧒")
      ("12-4E5E" "擻")
      ("12-4E82" "䜚")
      ("12-4E85" "𧧢")
      ("12-4E89" "繀")
      ("12-4E8A" "謵")
      ("12-4E8C" "跱")
      ("12-4E94" "搒")
      ("12-4EA4" "攉")
      ("12-4EAB" "尫")
      ("12-4EAC" "尦")
      ("12-4EAD" "蠥")
      ("12-4EB6" "逜")
      ("12-4EBA" "矟")
      ("12-4EC4" "𨓤")
      ("12-4ECB" "㔾")
      ("12-4EDF" "𥔳")
      ("12-4EE3" "脞")
      ("12-4EED" "礊")
      ("12-4EEE" "𠜾")
      ("12-4EF0" "嵓")
      ("12-4EF2" "蒻")
      ("12-4F0A" "开")
      ("12-4F0D" "摋")
      ("12-4F10" "郴")
      ("12-4F1C" "㮓")
      ("12-4F1D" "觫")
      ("12-4F46" "臱")
      ("12-4F47" "𥴧")
      ("12-4F55" "劒") ;; 旧字
      ("12-4F57" "𥰠")
      ("12-4F59" "瀄") ;; 旧字
      ("12-4F5C" "㯕")
      ("12-4F69" "笢")
      ("12-4F76" "筊")
      ("12-4F7F" "殥")
      ("12-4F83" "垚")
      ("12-4F88" "簜")
      ("12-4F8D" "涘")
      ("12-4F8F" "𥬸")
      ("12-4F96" "䀛")
      ("12-4F9B" "㞐")
      ("12-4F9D" "丣")
      ("12-4FA0" "屖")
      ("12-4FAE" "𩂣")
      ("12-4FAF" "攏")
      ("12-4FB6" "㑂")
      ("12-4FCA" "獝")
      ("12-4FD8" "榤")
      ("12-4FDF" "矂")
      ("12-4FF8" "𩛢")
      ("12-4FFA" "㓼")
      ("12-4FFE" "𡚱")
      ("12-5009" "絿")
      ("12-500B" "抅")
      ("12-5012" "詾")
      ("12-5016" "攗")
      ("12-5026" "悷")
      ("12-5029" "𡞞")
      ("12-502B" "嚘")
      ("12-5036" "幮")
      ("12-5039" "悆")
      ("12-5043" "𡟰")
      ("12-5047" "㛪")
      ("12-5056" "㿋")
      ("12-5074" "罣")
      ("12-5099" "錔")
      ("12-509A" "瘝")
      ("12-50B4" "𤴨")
      ("12-50B7" "瑒")
      ("12-50C5" "㞦")
      ("12-50C9" "汃")
      ("12-50CF" "䍃󠄀")
      ("12-50ED" "濭")
      ("12-50FB" "顦")
      ("12-5101" "鞻")
      ("12-5112" "熢")
      ("12-5114" "𥚚") ;; 旧字
      ("12-5115" "祤")
      ("12-5116" "轂")
      ("12-511F" "瑉")
      ("12-5121" "釁")
      ("12-512A" "悇")
      ("12-5132" "鼽")
      ("12-513B" "蘉")
      ("12-5143" "戁")
      ("12-5147" "屢")
      ("12-5149" "攟")
      ("12-514B" "朣")
      ("12-514C" "𦺶")
      ("12-5150" "涊")
      ("12-5152" "艼")
      ("12-515C" "园")
      ("12-5162" "荁")
      ("12-5165" "䠙")
      ("12-5168" "䊳")
      ("12-516C" "攞")
      ("12-5175" "𩑦")
      ("12-5178" "覛")
      ("12-5180" "崆")
      ("12-518D" "椔")
      ("12-5197" "瘭")
      ("12-51A0" "垗")
      ("12-51AA" "鵵")
      ("12-51AB" "鷢")
      ("12-51B0" "䑎")
      ("12-51B3" "鳺")
      ("12-51C4" "秅")
      ("12-51C5" "糚")
      ("12-51C9" "𥻆")
      ("12-51CD" "詵")
      ("12-51E1" "魾")
      ("12-51E6" "珏")
      ("12-51ED" "蘰") ;; 旧字
      ("12-51F5" "藄")
      ("12-5200" "詷")
      ("12-5203" "𥏻")
      ("12-5207" "竑")
      ("12-5208" "坷")
      ("12-520A" "垒")
      ("12-5214" "蘦")
      ("12-5224" "鄣")
      ("12-5227" "䢽")
      ("12-5229" "抌")
      ("12-5237" "櫍")
      ("12-523A" "㱯")
      ("12-523B" "䑍")
      ("12-5247" "罭")
      ("12-524D" "籺")
      ("12-5256" "骪")
      ("12-5265" "逬")
      ("12-5272" "嘾")
      ("12-5273" "㠯")
      ("12-5275" "絟")
      ("12-5283" "唈")
      ("12-529F" "攩")
      ("12-52A9" "琬")
      ("12-52B4" "萹")
      ("12-52BC" "啙")
      ("12-52BE" "吕")
      ("12-52D5" "豗")
      ("12-52DF" "饛")
      ("12-52F2" "𢍰")
      ("12-52FF" "齚")
      ("12-5305" "馝")
      ("12-5319" "檽")
      ("12-533A" "幒")
      ("12-533F" "貣")
      ("12-5341" "犫")
      ("12-5343" "筩")
      ("12-5347" "璀")
      ("12-5348" "掺")
      ("12-534A" "𨛜")
      ("12-5351" "鈋")
      ("12-5352" "羕")
      ("12-5353" "腝")
      ("12-5354" "㞓")
      ("12-5357" "跎")
      ("12-535A" "逿")
      ("12-535C" "鬺")
      ("12-5366" "弨")
      ("12-536F" "拴󠄀")
      ("12-5374" "孽")
      ("12-53A9" "侻")
      ("12-53AD" "僦")
      ("12-53C2" "歁")
      ("12-53C8" "鱯")
      ("12-53C9" "枅")
      ("12-53CA" "宬")
      ("12-53CB" "𢢞")
      ("12-53CC" "綈")
      ("12-53D6" "烜")
      ("12-53DB" "鄫")
      ("12-53E2" "絻")
      ("12-53E3" "㩻")
      ("12-53E5" "帊")
      ("12-53EB" "㞷")
      ("12-53F1" "溔")
      ("12-53F3" "佷")
      ("12-5404" "哳")
      ("12-540A" "蠃")
      ("12-540B" "侐")
      ("12-5411" "𢻃")
      ("12-5439" "磤")
      ("12-5442" "茮")
      ("12-5468" "檾")
      ("12-546A" "熳")
      ("12-5473" "鶘")
      ("12-547D" "鹺")
      ("12-548C" "躆")
      ("12-54B2" "樾")
      ("12-54B3" "吚")
      ("12-54E1" "伃")
      ("12-54E8" "璁")
      ("12-54E9" "鰼")
      ("12-54F2" "襺")
      ("12-5506" "桚")
      ("12-5510" "誋")
      ("12-5531" "璡")
      ("12-5546" "璉")
      ("12-558B" "薌")
      ("12-559C" "妤")
      ("12-559D" "嘹")
      ("12-55A7" "愖")
      ("12-55AC" "𡴆")
      ("12-5617" "璠")
      ("12-5618" "俅")
      ("12-5629" "匛")
      ("12-564C" "𥹃")
      ("12-5678" "赩")
      ("12-567A" "鄗")
      ("12-5687" "唅")
      ("12-56DB" "𣨙")
      ("12-56E0" "伀")
      ("12-56E3" "芺")
      ("12-56F0" "杻")
      ("12-56F3" "碫")
      ("12-56FD" "脙")
      ("12-5703" "餗")
      ("12-570F" "愞")
      ("12-572D" "𠬶")
      ("12-5730" "茘")
      ("12-574A" "骫")
      ("12-5750" "梪")
      ("12-5751" "敂")
      ("12-5766" "甛")
      ("12-576A" "蟩")
      ("12-57A3" "咮")
      ("12-57CE" "癕")
      ("12-57E0" "隥")
      ("12-57F9" "𨐔")
      ("12-5805" "惵")
      ("12-582A" "埌")
      ("12-5830" "僗")
      ("12-5834" "癤󠄀")
      ("12-583A" "樠")
      ("12-5859" "鄏")
      ("12-585A" "蝀")
      ("12-5869" "𠔯")
      ("12-586B" "䚂")
      ("12-5875" "𥏫")
      ("12-5897" "缻")
      ("12-58C1" "顨")
      ("12-58C7" "芴") ;; 旧字
      ("12-58CA" "卼")
      ("12-58EC" "矸")
      ("12-58EE" "緄")
      ("12-58F0" "䄷")
      ("12-58F2" "迋󠄀")
      ("12-591A" "翃")
      ("12-5927" "脰")
      ("12-5944" "㒓")
      ("12-5947" "姍")
      ("12-5948" "𧾍")
      ("12-594F" "綷")
      ("12-596A" "𦤞")
      ("12-596E" "韛")
      ("12-5973" "琨")
      ("12-598A" "蹺")
      ("12-5996" "灂")
      ("12-59B9" "鯹")
      ("12-59BE" "璐")
      ("12-59D0" "舁")
      ("12-59E5" "俏")
      ("12-59EB" "鐍")
      ("12-59FF" "𣫞")
      ("12-5A01" "㠯")
      ("12-5A3C" "璩")
      ("12-5A41" "芀") ;; 旧字
      ("12-5A46" "輮")
      ("12-5A5A" "极")
      ("12-5A9B" "鏶")
      ("12-5ACC" "愐")
      ("12-5AE1" "萸")
      ("12-5B2C" "蟮")
      ("12-5B30" "倈")
      ("12-5B57" "涴")
      ("12-5B87" "佽")
      ("12-5B88" "烓")
      ("12-5B89" "醋")
      ("12-5B8C" "埳")
      ("12-5B8F" "敱")
      ("12-5B98" "堄")
      ("12-5B99" "蓀")
      ("12-5BA4" "漶")
      ("12-5BAE" "寃󠄁")
      ("12-5BB0" "椑")
      ("12-5BB3" "呃")
      ("12-5BB5" "璨")
      ("12-5BC4" "妭")
      ("12-5BDB" "埶")
      ("12-5BE7" "躂")
      ("12-5BE9" "眜")
      ("12-5BF5" "薋") ;; 旧字
      ("12-5C02" "箎")
      ("12-5C04" "澶")
      ("12-5C06" "璪")
      ("12-5C0A" "𦍕")
      ("12-5C0B" "矻")
      ("12-5C11" "璵")
      ("12-5C16" "箁")
      ("12-5C2D" "嵂")
      ("12-5C3C" "踠")
      ("12-5C3E" "鉼")
      ("12-5C3F" "𨄅")
      ("12-5C40" "嶔")
      ("12-5C61" "澈")
      ("12-5C64" "緆")
      ("12-5C6F" "趄")
      ("12-5CA9" "奓")
      ("12-5CAC" "鷀")
      ("12-5CE0" "貜")
      ("12-5CE1" "𡴫")
      ("12-5CF0" "䮄")
      ("12-5D07" "礨")
      ("12-5D16" "吰")
      ("12-5D8B" "諰")
      ("12-5DDD" "箐")
      ("12-5DEE" "桄")
      ("12-5DF1" "拄")
      ("12-5DF3" "鶱")
      ("12-5DFE" "崅")
      ("12-5E02" "毐")
      ("12-5E1D" "衊")
      ("12-5E25" "磕")
      ("12-5E2B" "𣬉")
      ("12-5E4C" "鮏")
      ("12-5E55" "鱓")
      ("12-5E63" "頞")
      ("12-5E72" "埵")
      ("12-5E73" "頠")
      ("12-5E79" "埭")
      ("12-5E7E" "姣")
      ("12-5E87" "鉥")
      ("12-5EA6" "詄")
      ("12-5EA7" "梆")
      ("12-5EAB" "挖")
      ("12-5EAD" "𧖴")
      ("12-5EB5" "韵")
      ("12-5EC3" "轚")
      ("12-5EF6" "儞")
      ("12-5EF7" "䘒")
      ("12-5EFB" "厃")
      ("12-5EFF" "踼")
      ("12-5F01" "飣")
      ("12-5F13" "𡨦")
      ("12-5F14" "藋")
      ("12-5F1B" "莚")
      ("12-5F1F" "衩")
      ("12-5F27" "㧢")
      ("12-5F35" "藇")
      ("12-5F4A" "屼")
      ("12-5F62" "𢓊")
      ("12-5F69" "棻")
      ("12-5F70" "璂")
      ("12-5F71" "偓")
      ("12-5F80" "冡")
      ("12-5F81" "𥝸")
      ("12-5F84" "𢓇")
      ("12-5F85" "𦘒")
      ("12-5F90" "琤")
      ("12-5F92" "訑")
      ("12-5FBD" "婷")
      ("12-5FC3" "眭")
      ("12-5FCC" "姤")
      ("12-5FCD" "蹷")
      ("12-5FEB" "𥎦")
      ("12-5FF5" "躞")
      ("12-601C" "繶")
      ("12-601D" "毦")
      ("12-6028" "儜")
      ("12-6050" "岈")
      ("12-6055" "琭")
      ("12-6065" "莧")
      ("12-6068" "罙")
      ("12-6069" "劊")
      ("12-606D" "岠")
      ("12-606F" "罻")
      ("12-6070" "噲")
      ("12-6075" "徉")
      ("12-608C" "袨")
      ("12-60B2" "鈸")
      ("12-60BC" "諝")
      ("12-60C7" "趑")
      ("12-60DA" "朾")
      ("12-60F0" "𦏻")
      ("12-60F3" "緱")
      ("12-6101" "㸏")
      ("12-610F" "乀")
      ("12-611F" "𡎐")
      ("12-614E" "眵")
      ("12-6155" "䭈") ;; 旧字
      ("12-616E" "𠆲")
      ("12-6176" "𢓜")
      ("12-617E" "𨪋")
      ("12-6182" "怮")
      ("12-618E" "罃")
      ("12-6190" "芓")
      ("12-61A4" "䩭")
      ("12-61B6" "剉")
      ("12-61C7" "柜")
      ("12-61F2" "藘")
      ("12-6210" "秪")
      ("12-6211" "卂")
      ("12-621F" "恞")
      ("12-622F" "嫜")
      ("12-623F" "𩪦")
      ("12-6240" "珌")
      ("12-6247" "箾")
      ("12-6249" "鉧")
      ("12-624B" "𤇾")
      ("12-624D" "棙")
      ("12-6255" "䩨")
      ("12-6271" "硼")
      ("12-627F" "瓞")
      ("12-6280" "嫰")
      ("12-628A" "輀")
      ("12-6291" "䤄")
      ("12-62B9" "𩽵")
      ("12-62BC" "㓃")
      ("12-62D2" "𡪷")
      ("12-62D8" "斨")
      ("12-62DB" "瓫")
      ("12-62DD" "轝")
      ("12-62E1" "啞")
      ("12-62EC" "噣")
      ("12-6311" "蘅")
      ("12-634C" "欵")
      ("12-6355" "餚")
      ("12-6368" "澼")
      ("12-637A" "𧿁")
      ("12-637B" "䠱")
      ("12-6388" "熺")
      ("12-638C" "㼜")
      ("12-63A5" "竞")
      ("12-63A9" "儥")
      ("12-63AA" "紇")
      ("12-63AC" "嬻")
      ("12-63B4" "蝑")
      ("12-63BB" "緫")
      ("12-63C3" "𦎧")
      ("12-63CF" "鬩")
      ("12-63D0" "袜")
      ("12-63EE" "姹")
      ("12-643E" "橑")
      ("12-6458" "襀")
      ("12-6469" "鮦")
      ("12-647A" "䄠") ;; 旧字
      ("12-6492" "歈")
      ("12-64AE" "櫫")
      ("12-64B9" "唬")
      ("12-64CD" "緵")
      ("12-64E2" "褾")
      ("12-64FE" "痝")
      ("12-6539" "㕒")
      ("12-653B" "斵")
      ("12-653E" "駴")
      ("12-6545" "拲")
      ("12-6562" "塉")
      ("12-6566" "趍")
      ("12-6574" "稃")
      ("12-6575" "褵")
      ("12-6587" "韮") ;; 旧字
      ("12-6589" "窔")
      ("12-658C" "𨸏")
      ("12-65A7" "䧘")
      ("12-65B0" "眹")
      ("12-65BC" "𠔁")
      ("12-65C5" "僆")
      ("12-65D7" "娭")
      ("12-65E2" "娙")
      ("12-65E5" "蹎")
      ("12-65E6" "䑲")
      ("12-65EC" "𤞛")
      ("12-65ED" "妁")
      ("12-65FA" "冟")
      ("12-6606" "枿")
      ("12-6613" "𠂆")
      ("12-6614" "窗")
      ("12-6625" "獮")
      ("12-662D" "甊")
      ("12-662F" "秄")
      ("12-6642" "涷")
      ("12-6652" "歊")
      ("12-6669" "醶")
      ("12-6674" "䅣")
      ("12-6691" "珙")
      ("12-6696" "苢")
      ("12-66A2" "蘢")
      ("12-66C7" "趫")
      ("12-66F3" "偢")
      ("12-66F4" "斾")
      ("12-6700" "棽")
      ("12-6708" "悐")
      ("12-6715" "蚧")
      ("12-6717" "𦭮")
      ("12-671D" "蘙")
      ("12-6728" "齌")
      ("12-672B" "鳦󠄀")
      ("12-673A" "娀")
      ("12-673D" "𡩠")
      ("12-6750" "槩")
      ("12-675F" "羃")
      ("12-6762" "齞")
      ("12-6765" "𢳎")
      ("12-676F" "轊")
      ("12-6771" "䛻")
      ("12-677E" "甋") ;; 旧字
      ("12-6795" "鱐")
      ("12-67A0" "跦")
      ("12-67A2" "礡")
      ("12-67AF" "捂")
      ("12-67B6" "勌")
      ("12-67CA" "鍇")
      ("12-67CF" "遟")
      ("12-67D0" "髩")
      ("12-67D3" "篾")
      ("12-67DA" "憏")
      ("12-67F4" "澍")
      ("12-67F5" "檥")
      ("12-67FB" "栭")
      ("12-67FF" "咷")
      ("12-6804" "偄")
      ("12-6821" "旘")
      ("12-6822" "坙")
      ("12-6839" "查")
      ("12-683C" "唶")
      ("12-6842" "徦")
      ("12-6850" "巘")
      ("12-6851" "弈")
      ("12-6854" "㜅")
      ("12-685F" "欪")
      ("12-6881" "𠿑")
      ("12-6897" "𣃘")
      ("12-68A2" "𤯌")
      ("12-68AF" "裀")
      ("12-68B0" "厸")
      ("12-68B6" "噆")
      ("12-68C4" "婣")
      ("12-68C9" "黈")
      ("12-68CB" "娿")
      ("12-68DF" "謊")
      ("12-68F2" "稬")
      ("12-68FA" "塴")
      ("12-6905" "㇉")
      ("12-691B" "囐")
      ("12-6934" "𧸇")
      ("12-6953" "霩")
      ("12-695A" "紒")
      ("12-6962" "趿")
      ("12-696D" "嵫") ;; 旧字
      ("12-698A" "樆")
      ("12-698E" "僱")
      ("12-6994" "虯")
      ("12-69CB" "旍")
      ("12-69CC" "蛚")
      ("12-69D9" "鰱")
      ("12-69FB" "蝍")
      ("12-6A17" "蔔")
      ("12-6A1F" "甡")
      ("12-6A2B" "嘵")
      ("12-6A35" "甤")
      ("12-6A3D" "臿") ;; 「千」
      ("12-6A4B" "峓")
      ("12-6A5F" "娸")
      ("12-6A61" "𧸐")
      ("12-6A80" "茍")
      ("12-6AD3" "蘠")
      ("12-6B21" "淝")
      ("12-6B4C" "勑")
      ("12-6B62" "汋")
      ("12-6B64" "枒")
      ("12-6B66" "霂")
      ("12-6B6F" "洏")
      ("12-6BB4" "凊")
      ("12-6BB5" "苒󠄁") ;; 旧字
      ("12-6BBA" "槾")
      ("12-6BBB" "啑")
      ("12-6BC5" "姘") ;; 旧字
      ("12-6BD8" "鍝")
      ("12-6C0F" "汛")
      ("12-6C11" "鸃")
      ("12-6C70" "翱")
      ("12-6C8C" "趕")
      ("12-6C96" "𠙷")
      ("12-6C99" "栳")
      ("12-6CB8" "䩬")
      ("12-6CBF" "儦")
      ("12-6CC9" "篨")
      ("12-6CCA" "遝")
      ("12-6CCC" "鉸")
      ("12-6CD5" "騠")
      ("12-6CE3" "㝬")
      ("12-6CE5" "褯")
      ("12-6CE8" "蔫")
      ("12-6D25" "蛣")
      ("12-6D3B" "噹")
      ("12-6D3E" "輧")
      ("12-6D41" "㐳")
      ("12-6D45" "篽")
      ("12-6D5C" "陒")
      ("12-6D66" "侹")
      ("12-6D6C" "咅")
      ("12-6D74" "𠔼")
      ("12-6D78" "睒")
      ("12-6D9B" "謼")
      ("12-6DB2" "傯")
      ("12-6DBC" "㖔")
      ("12-6DCB" "坶")
      ("12-6DE1" "艎")
      ("12-6DEB" "佋")
      ("12-6DF3" "玆")
      ("12-6E05" "穟")
      ("12-6E07" "嚅")
      ("12-6E09" "甾")
      ("12-6E0B" "狁")
      ("12-6E13" "徛")
      ("12-6E1A" "珓")
      ("12-6E21" "訩")
      ("12-6E26" "俙")
      ("12-6E2F" "旤")
      ("12-6E4A" "鷟")
      ("12-6E58" "𤰝")
      ("12-6E5B" "艣")
      ("12-6E6F" "䜅")
      ("12-6E7E" "㷇")
      ("12-6E80" "鵕")
      ("12-6E96" "玎")
      ("12-6E9C" "傂")
      ("12-6E9D" "旴")
      ("12-6EDD" "腄")
      ("12-6EDE" "胦")
      ("12-6F02" "鐮")
      ("12-6F06" "漵")
      ("12-6F09" "𦞤")
      ("12-6F0F" "襐")
      ("12-6F15" "縚")
      ("12-6F22" "墣")
      ("12-6F23" "蒢")
      ("12-6F2C" "螗")
      ("12-6F5C" "簏")
      ("12-6F5F" "嘽")
      ("12-6F64" "玗")
      ("12-6F84" "祢")
      ("12-6F97" "墼")
      ("12-6FC0" "恇")
      ("12-6FC1" "䏔")
      ("12-6FC3" "䡅")
      ("12-6FE0" "朇")
      ("12-6FE1" "蹬")
      ("12-701E" "㕢")
      ("12-7026" "𦹋") ;; 旧字
      ("12-7027" "腨")
      ("12-706F" "𧫻")
      ("12-7070" "㐬") ;; 旧字
      ("12-70AD" "䑦")
      ("12-70B9" "觡")
      ("12-70BA" "么")
      ("12-7114" "兖")
      ("12-7121" "䴏")
      ("12-7136" "糝")
      ("12-713C" "备")
      ("12-7159" "兓")
      ("12-7164" "䢈")
      ("12-7169" "醑")
      ("12-71B1" "躒")
      ("12-71D5" "兗")
      ("12-7206" "邌")
      ("12-723A" "藾")
      ("12-723D" "緅")
      ("12-723E" "洴")
      ("12-7252" "蘗")
      ("12-7261" "剟")
      ("12-7267" "𩰲")
      ("12-727D" "慽")
      ("12-7280" "楑")
      ("12-72B6" "㿝")
      ("12-72C2" "峗")
      ("12-72D9" "紟")
      ("12-72DB" "杇")
      ("12-72FD" "迆󠄀")
      ("12-732E" "慲")
      ("12-7336" "𢜱")
      ("12-733F" "兟")
      ("12-7387" "僪")
      ("12-73CA" "𣥠")
      ("12-73CD" "蚡")
      ("12-73E0" "焞")
      ("12-73ED" "酏")
      ("12-7406" "挻")
      ("12-7433" "堁")
      ("12-7434" "𡿯")
      ("12-7435" "鍳")
      ("12-745A" "擋")
      ("12-74DC" "俌")
      ("12-74E6" "垝")
      ("12-7518" "壈")
      ("12-751A" "砅")
      ("12-7530" "觤")
      ("12-7533" "睞")
      ("12-7537" "苻") ;; 旧字
      ("12-754C" "𠫤")
      ("12-7559" "侸")
      ("12-755C" "萄") ;; 旧字
      ("12-7560" "郇")
      ("12-756A" "醲")
      ("12-758E" "紑")
      ("12-758F" "紞")
      ("12-75AB" "傺")
      ("12-75B2" "銍")
      ("12-75B9" "睩") ;; 旧字
      ("12-75C5" "閵")
      ("12-75D4" "湋")
      ("12-75D5" "柫")
      ("12-75D8" "譊")
      ("12-75DB" "蜋")
      ("12-75E9" "縰")
      ("12-7684" "襏")
      ("12-7687" "㫗")
      ("12-7690" "㰦")
      ("12-76C6" "鮞")
      ("12-76E3" "壒")
      ("12-76F2" "𪔉")
      ("12-76F4" "䖟")
      ("12-76F8" "縿")
      ("12-7701" "畕")
      ("12-7709" "鍧")
      ("12-773A" "蘖") ;; 旧字 11-5F93
      ("12-7766" "𩲏")
      ("12-77AC" "獱")
      ("12-77DB" "鸘")
      ("12-77E2" "慜")
      ("12-77E7" "迵")
      ("12-77ED" "𦪇")
      ("12-77EF" "峋")
      ("12-7802" "梮")
      ("12-7814" "慤")
      ("12-7825" "訹")
      ("12-785D" "畗")
      ("12-7872" "邳")
      ("12-7887" "袽")
      ("12-7891" "鋙")
      ("12-7893" "佪")
      ("12-7897" "𤑤")
      ("12-78BA" "唪")
      ("12-78D0" "醽")
      ("12-7901" "畣")
      ("12-793A" "湣")
      ("12-793C" "𦃇")
      ("12-793E" "濩")
      ("12-7941" "弰")
      ("12-7950" "椌") ;; 旧字
      ("12-7956" "絁")
      ("12-7965" "畡")
      ("12-7968" "鑕")
      ("12-7985" "糳")
      ("12-798D" "勨")
      ("12-798E" "裓")
      ("12-798F" "䨼")
      ("12-79A6" "尞")
      ("12-79C1" "沇")
      ("12-79CB" "𤕟")
      ("12-79D2" "闋")
      ("12-79E4" "迻")
      ("12-79E6" "𥈾")
      ("12-79E9" "蒂") ;; 旧字
      ("12-79F0" "畽")
      ("12-7A0E" "𫁍")
      ("12-7A14" "鷰")
      ("12-7A17" "鍚")
      ("12-7A1C" "嗼")
      ("12-7A32" "仃")
      ("12-7A3C" "勱")
      ("12-7A3D" "㣥")
      ("12-7A40" "𦞠")
      ("12-7A46" "鬾")
      ("12-7A4E" "傖")
      ("12-7A6B" "𦰩")
      ("12-7A74" "惈")
      ("12-7A7A" "𢇓")
      ("12-7A83" "笴")
      ("12-7A84" "㯯")
      ("12-7A9F" "廧")
      ("12-7AAF" "鋄")
      ("12-7AE0" "畾")
      ("12-7AF8" "䕡")
      ("12-7AF9" "菔")
      ("12-7AFF" "壍")
      ("12-7B08" "𡫳")
      ("12-7B11" "疄")
      ("12-7B1B" "襘")
      ("12-7B26" "䧹")
      ("12-7B2C" "脬")
      ("12-7B54" "譍")
      ("12-7B87" "勶")
      ("12-7B94" "遦")
      ("12-7B95" "鶼")
      ("12-7B97" "歭")
      ("12-7BB1" "邰")
      ("12-7BB8" "邴")
      ("12-7BC0" "笱")
      ("12-7BC4" "醅")
      ("12-7BC9" "菪")
      ("12-7BE0" "澒")
      ("12-7BE4" "賨")
      ("12-7C3F" "飻")
      ("12-7C4D" "竁")
      ("12-7C73" "顗")
      ("12-7C81" "㟭")
      ("12-7C8D" "䴊")
      ("12-7C98" "䠶")
      ("12-7CA5" "坨")
      ("12-7CCE" "𥹷")
      ("12-7CDF" "繘")
      ("12-7CE0" "昉")
      ("12-7D00" "媟")
      ("12-7D0D" "軏")
      ("12-7D14" "玠")
      ("12-7D17" "瀅")
      ("12-7D20" "紾")
      ("12-7D33" "䁟")
      ("12-7D42" "𤕦")
      ("12-7D44" "紩")
      ("12-7D4C" "𢓡")
      ("12-7D50" "惊")
      ("12-7D5E" "昳")
      ("12-7D61" "摼")
      ("12-7D71" "譡")
      ("12-7D76" "笣")
      ("12-7DAD" "𣶒")
      ("12-7DB1" "昩")
      ("12-7DCF" "繐")
      ("12-7DDA" "簬")
      ("12-7DF4" "藑")
      ("12-7E1B" "𨙅")
      ("12-7E1E" "澥")
      ("12-7E26" "狌")
      ("12-7E2E" "猌")
      ("12-7E41" "酙")
      ("12-7E54" "盅")
      ("12-7E6D" "鵃")
      ("12-7E70" "弆")
      ("12-7F36" "壩")
      ("12-7F6A" "樝")
      ("12-7F6B" "㣻")
      ("12-7F75" "輴")
      ("12-7FA8" "籋")
      ("12-7FBD" "侄")
      ("12-7FC1" "凓")
      ("12-7FE0" "礀")
      ("12-7FEB" "𡚐")
      ("12-8000" "鏕")
      ("12-8010" "䎲")
      ("12-803D" "艽")
      ("12-8061" "𦅫")
      ("12-8074" "蘺") ;; 旧字
      ("12-8096" "𤴙")
      ("12-80A1" "揠")
      ("12-80A2" "汴")
      ("12-80A5" "鋬")
      ("12-80B2" "亓")
      ("12-80C3" "𠂹")
      ("12-80C6" "艿")
      ("12-80CE" "朐")
      ("12-80DE" "騺")
      ("12-80F8" "峒")
      ("12-80FD" "軑")
      ("12-8102" "汸")
      ("12-8105" "峴")
      ("12-8106" "窡")
      ("12-8107" "踤")
      ("12-8131" "臲")
      ("12-8139" "虒")
      ("12-814E" "砢")
      ("12-8150" "雐")
      ("12-8154" "晅")
      ("12-816B" "煊")
      ("12-8178" "虘")
      ("12-8179" "䩉")
      ("12-817A" "籓")
      ("12-819C" "鱉")
      ("12-81D3" "𦉜")
      ("12-81E5" "𠦪")
      ("12-81E8" "垐")
      ("12-81FC" "侒")
      ("12-820C" "䇫")
      ("12-820E" "濅")
      ("12-8217" "飶")
      ("12-8218" "够")
      ("12-821B" "𥶶")
      ("12-821C" "𤜵") ;; 旧字
      ("12-822C" "醆")
      ("12-8235" "耍")
      ("12-8236" "遰")
      ("12-8239" "籞")
      ("12-8247" "裎")
      ("12-826F" "㗬")
      ("12-8276" "㒭")
      ("12-828B" "仛")
      ("12-82B9" "帓")
      ("12-82C5" "坺")
      ("12-82D4" "胭")
      ("12-82E6" "㠾")
      ("12-82E7" "蕈") ;; 旧字
      ("12-82EB" "贜")
      ("12-830E" "忪")
      ("12-831C" "榔")
      ("12-834A" "忲")
      ("12-8358" "繯")
      ("12-837B" "刅")
      ("12-83AB" "𨒅")
      ("12-83D6" "疢")
      ("12-8404" "貑")
      ("12-845B" "嚎")
      ("12-8466" "朞")
      ("12-8471" "躃")
      ("12-849C" "阤")
      ("12-84B2" "囤")
      ("12-84BC" "繾")
      ("12-84D1" "鷞")
      ("12-8500" "澖")
      ("12-851A" "俉")
      ("12-8535" "罏")
      ("12-8549" "痁")
      ("12-8557" "霋")
      ("12-8568" "踘")
      ("12-8597" "㒰")
      ("12-85A9" "柍")
      ("12-85AB" "弎")
      ("12-85AE" "𢢩")
      ("12-85E9" "醊")
      ("12-85F7" "琁")
      ("12-865C" "呱")
      ("12-865E" "兹󠄀")
      ("12-867B" "艟")
      ("12-86A4" "軨")
      ("12-86CB" "芄")
      ("12-86CE" "唉")
      ("12-8702" "𠫑")
      ("12-8718" "菼")
      ("12-871C" "鶹")
      ("12-8749" "筁")
      ("12-8755" "𧗁")
      ("12-8776" "𧆨")
      ("12-878D" "𤄒")
      ("12-87BA" "㩃")
      ("12-87F9" "𠭖")
      ("12-87FB" "嬙")
      ("12-8846" "牗")
      ("12-8853" "㺒")
      ("12-8857" "吒")
      ("12-885D" "痏")
      ("12-8870" "磵")
      ("12-8877" "蓰")
      ("12-888B" "胲")
      ("12-88AB" "鋌")
      ("12-88D5" "栠")
      ("12-88DC" "餲")
      ("12-88F3" "痤")
      ("12-88FD" "𥝣")
      ("12-88FE" "𥘎")
      ("12-8907" "䩌")
      ("12-8910" "嚨") ;; 旧字
      ("12-8912" "䯂")
      ("12-897F" "穵")
      ("12-8981" "錭")
      ("12-898B" "憹")
      ("12-8996" "泔")
      ("12-8997" "𨋚")
      ("12-89B3" "堮")
      ("12-89E6" "𥁞")
      ("12-8A00" "𢦟")
      ("12-8A17" "臛")
      ("12-8A23" "惔")
      ("12-8A2D" "笔")
      ("12-8A33" "㤨")
      ("12-8A34" "絪")
      ("12-8A3A" "矓")
      ("12-8A3C" "痗")
      ("12-8A50" "梂")
      ("12-8A5E" "泬󠄀")
      ("12-8A66" "沝")
      ("12-8A70" "孒")
      ("12-8A71" "𧿶")
      ("12-8A89" "洅")
      ("12-8A8C" "泚")
      ("12-8A95" "芑") ;; 旧字
      ("12-8AA4" "擭")
      ("12-8AAC" "笫")
      ("12-8AB0" "舀")
      ("12-8ABF" "䖒")
      ("12-8AD2" "㕮")
      ("12-8AE6" "裯")
      ("12-8AF8" "琰")
      ("12-8B1D" "㶁")
      ("12-8B2C" "鐋")
      ("12-8B39" "幛")
      ("12-8B5C" "雔")
      ("12-8B72" "𦤎")
      ("12-8C46" "讘")
      ("12-8C5A" "趠")
      ("12-8C61" "瘃")
      ("12-8CA0" "雗")
      ("12-8CA1" "樕")
      ("12-8CA8" "匧")
      ("12-8CAB" "墬")
      ("12-8CAF" "蕕")
      ("12-8CB4" "媢󠄀")
      ("12-8CB8" "胻")
      ("12-8CBB" "鋩")
      ("12-8CBF" "䰌")
      ("12-8CC2" "荄") ;; 旧字
      ("12-8CCE" "籮")
      ("12-8CDC" "洧")
      ("12-8CE0" "迒")
      ("12-8CE2" "憼") ;; 旧字
      ("12-8CFC" "暐")
      ("12-8D64" "窨")
      ("12-8D70" "纑")
      ("12-8D74" "𩁹")
      ("12-8D8A" "僩")
      ("12-8DA3" "煑")
      ("12-8DA8" "䃚")
      ("12-8DB3" "罛")
      ("12-8DE1" "䆞")
      ("12-8DEF" "𦺇")
      ("12-8E44" "裱")
      ("12-8EAB" "矙")
      ("12-8EE2" "觖")
      ("12-8EF8" "滁")
      ("12-8F09" "榨")
      ("12-8F14" "餴")
      ("12-8F38" "忕")
      ("12-8F44" "嚭")
      ("12-8F61" "廇")
      ("12-8FA8" "耑")
      ("12-8FB0" "𦤝")
      ("12-8FB1" "𥂴") ;; 旧字
      ("12-8FBB" "蟂")
      ("12-8FC2" "侁")
      ("12-8FC4" "䳇")
      ("12-8FC5" "硌")
      ("12-8FD1" "幙")
      ("12-8FD4" "颻")
      ("12-8FE9" "踢")
      ("12-8FF0" "獍")
      ("12-8FFD" "蜎")
      ("12-9001" "纕")
      ("12-9010" "葅")
      ("12-9019" "迤")
      ("12-9020" "罡󠄀")
      ("12-9022" "桝󠄂")
      ("12-9023" "茦")
      ("12-902E" "胵")
      ("12-9031" "牼")
      ("12-9041" "𧽙")
      ("12-9042" "磾")
      ("12-9045" "萏")
      ("12-904D" "飇")
      ("12-9054" "𦤙")
      ("12-9060" "㒳")
      ("12-9063" "懥")
      ("12-9069" "𧝑")
      ("12-9075" "玞")
      ("12-9078" "䉵")
      ("12-90A3" "𧾱")
      ("12-90A6" "駠")
      ("12-90B8" "裻")
      ("12-90CE" "𧙥")
      ("12-90ED" "喣")
      ("12-90F5" "朻")
      ("12-90FD" "𧦝")
      ("12-914B" "犅")
      ("12-914E" "蓧")
      ("12-9177" "脀")
      ("12-9192" "窌")
      ("12-91B8" "𪽾")
      ("12-91C6" "醎")
      ("12-91C8" "灤")
      ("12-91CC" "蟨")
      ("12-91D8" "褲")
      ("12-91E3" "蠚")
      ("12-91E6" "魖")
      ("12-9262" "郗")
      ("12-9280" "幞")
      ("12-9285" "貙")
      ("12-929A" "䖘")
      ("12-92D2" "𩡺")
      ("12-92E4" "瑀")
      ("12-92F3" "蔌")
      ("12-9310" "磷")
      ("12-9320" "皜")
      ("12-9326" "𡾊")
      ("12-934B" "趹")
      ("12-934D" "訿")
      ("12-9354" "蟇")
      ("12-935B" "芐")
      ("12-937E" "瘕")
      ("12-938C" "圊")
      ("12-9397" "綹")
      ("12-93AE" "蚹")
      ("12-93E1" "崪")
      ("12-9580" "鼈󠄁")
      ("12-9589" "頳")
      ("12-958F" "俍")
      ("12-9593" "壴")
      ("12-95A3" "喆")
      ("12-95A4" "曅")
      ("12-95D8" "𢍪")
      ("12-961C" "𩂉")
      ("12-963B" "絙")
      ("12-9644" "䨒")
      ("12-9664" "瑗󠄀")
      ("12-9673" "蚴")
      ("12-9676" "豉")
      ("12-967A" "懩")
      ("12-967D" "𨬍")
      ("12-9688" "𢌛")
      ("12-968F" "礉")
      ("12-9694" "嗑")
      ("12-9699" "恉")
      ("12-969B" "榍")
      ("12-969C" "瘈󠄀")
      ("12-96A0" "侉")
      ("12-96BB" "窻")
      ("12-96C5" "𠧙")
      ("12-96D1" "𣢆")
      ("12-96E3" "趼")
      ("12-96F0" "韏")
      ("12-96F7" "攐")
      ("12-96FB" "䚧")
      ("12-9700" "燾")
      ("12-9707" "䀻")
      ("12-971E" "匵")
      ("12-9732" "茿")
      ("12-9759" "窐")
      ("12-976D" "硠")
      ("12-9784" "𡆧")
      ("12-97AD" "飡")
      ("12-97EE" "蹡")
      ("12-9803" "枑")
      ("12-9805" "矇")
      ("12-9806" "玭")
      ("12-9817" "禕")
      ("12-982C" "𩰬")
      ("12-9854" "奼")
      ("12-985B" "觕")
      ("12-985E" "𤪌")
      ("12-9867" "搥")
      ("12-98E2" "嫄")
      ("12-98FC" "洓")
      ("12-98FD" "驉")
      ("12-990A" "鑍")
      ("12-9928" "𡖊")
      ("12-9957" "嵑")
      ("12-9999" "曡")
      ("12-99A8" "咻")
      ("12-99B3" "萇") ;; 旧字
      ("12-99C4" "耾")
      ("12-99C6" "𢅏")
      ("12-9A28" "耹")
      ("12-9A30" "𧰙")
      ("12-9A5A" "崿")
      ("12-9AB8" "咈")
      ("12-9AC4" "礚")
      ("12-9AD8" "曨")
      ("12-9AEA" "郪")
      ("12-9B3C" "媲")
      ("12-9B41" "厞")
      ("12-9B54" "鯞")
      ("12-9B92" "鞳")
      ("12-9BAA" "鱮")
      ("12-9BAB" "歂")
      ("12-9BDB" "脘")
      ("12-9BF5" "櫳")
      ("12-9C2D" "阩")
      ("12-9C39" "囉")
      ("12-9C48" "")
      ("12-9C52" "鱺")
      ("12-9CE5" "廬")
      ("12-9CF3" "騱")
      ("12-9D2C" "凘")
      ("12-9D5C" "侗")
      ("12-9D6C" "駼")
      ("12-9D8F" "怗")
      ("12-9DF2" "𨄌")
      ("12-9E97" "繣")
      ("12-9EB9" "朦") ;; 旧字
      ("12-9F0E" "褠")
      ("12-9F13" "搣")
      ("12-9F20" "絑")
      ("12-9F3B" "鍑")
      ("13-5727" "③") ;; square three
      ("13-59D0" "☱")
      ("13-5B9B" "☰")
      ("13-6216" "☷")
      ("13-6271" "⑤") ;; square five
      ("13-63E1" "⌺")
      ("13-65A1" "④") ;; square four
      ("13-6893" "②") ;; square two
      ("13-7D62" "☴")
      ("13-7DBE" "☵")
      ("13-82A6" "〻")
      ("13-867B" "☲")
      ("13-98F4" "☳")
      ("13-9B8E" "☶")
      ("13-9BF5" "①") ;; square one
      ("12-5E9A" "𢻫")
      ("12-91D1" "幖")
      ("12-5104" "刌")
      ("12-7895" "樴")
      ("12-968E" "叏")
      ;; ("12-865A" "⿱宀𣪘") ;; 攺
      ;; ("11-4F4E" "⿰卣夒") ;; 跱
      ;; ("11-4F50" "⿳吅丩吅") ;; 「嘂」
      ;; ("11-4F83" "⿲𠂎合卩") ;; 合
      ;; ("11-5048" "眔") ;; 中国・台湾字形
      ;; ("11-514B" "⿰𫊣又")
      ;; ("11-5175" "⿳艹冗瓦") ;; 㞋
      ;; ("11-5227" "瞳") ;; 旧字
      ;; ("11-52DD" "繭󠄁") ;; 旧字
      ;; ("11-53D6" "丮") ;; 旧字
      ;; ("11-53E1" "⿰𠦪允") ;; 000150
      ;; ("11-5449" "⿱竹⿰㚔匊")
      ;; ("11-557C" "釆") ;; 旧字
      ;; ("11-559E" "") ;; 弃
      ;; ("11-57FC" "菌") ;; 旧字
      ;; ("11-5D18" "⿰耳昬") ;; 𦖫
      ;; ("11-5D73" "⿰口𤲀")
      ;; ("11-5DE5" "糾") ;; 旧字
      ;; ("11-5E9A" "赳") ;; 旧字
      ;; ("11-6296" "𠬛") ;; 歿の旁
      ;; ("11-62D3" "⿰糸才")
      ;; ("11-64EC" "𩫏") ;; 郭
      ;; ("11-6587" "⿰犬")
      ;; ("11-6590" "⿺辶𧵩")
      ;; ("11-6590" "⿺辶𧵩")
      ;; ("11-66E6" "⿰示芺")
      ;; ("11-66F0" "⿰月𠔉")
      ;; ("11-66F5" "⿰舟𠔉")
      ;; ("11-6840" "⿱或巛") ;; 𡿿
      ;; ("11-69B4" "流") ;; 旧字
      ;; ("11-6B0A" "硫") ;; 旧字
      ;; ("11-6EFE" "⿱⿰口㕚手")
      ;; ("11-725B" "⿰渴欠")
      ;; ("11-7280" "⿰龏兄") ;; 7047
      ;; ("11-733F" "⿱炏乂") ;; 遂、蛍
      ;; ("11-745B" "⿰干弓") ;; 夸
      ;; ("11-77E5" "⿺辶𡭗")
      ;; ("11-7887" "⿰𦎫丮") ;; 𦏧
      ;; ("11-7893" "⿱寅皿")
      ;; ("11-7895" "堇") ;; 禾  (菫)
      ;; ("11-81EA" "⿳亠口⿵冂冋") ;; 冂
      ;; ("11-8218" "亥") ;; 旧字
      ;; ("11-82D7" "茜") ;; 旧字
      ;; ("11-82D7" "茜") ;; 旧字
      ;; ("11-8305" "𠂿") ;; 下はねなし。
      ;; ("11-8511" "塑") ;; 旧字
      ;; ("11-8A9E" "⿱仌口")
      ;; ("11-8F2F" "⿱屮㠯") ;; 𡴎 (𠂤)
      ;; ("11-8FF0" "⿱𠀐𠂤") ;; 𠳋 (𠂤)
      ;; ("11-901D" "⿱⿲弓羊弓鬲")
      ;; ("11-9020" "⿱艹醮") ;; 「蘸」の中国字形
      ;; ("11-9834" "芋") ;; 旧字
      ;; ("11-9A0E" "⿷匚貈") ;; 印
      ;; ("11-9D60" "⿺辶匩")
      ;; ("12-4E39" "⿱⿴𦥑冉土")
      ;; ("12-4E95" "㇡") ;; 市
      ;; ("12-4ED8" "⿰阝𢍜") ;; 丰
      ;; ("12-5023" "⿹𢦏𩙿") ;; 在
      ;; ("12-5049" "⿰不不")
      ;; ("12-5065" "⿱呂心") ;; 慮
      ;; ("12-50B5" "⿰𡉣丮")
      ;; ("12-516E" "⿳艹⿱𠆢方廾") ;; 莽󠄁
      ;; ("12-52DD" "⿰王面") ;; 面
      ;; ("12-5317" "⿱⿳一一鬲") ;; 瓚
      ;; ("12-53B3" "⿹戈冬") ;; 廾
      ;; ("12-5420" "⿰鬲又")
      ;; ("12-565B" "⿴囗𠂭") ;; 胃
      ;; ("12-56DE" "⿰午卩")
      ;; ("12-58EB" "⿰乍殳") ;; 戎
      ;; ("12-5915" "⿰氵⿱一𢇁")
      ;; ("12-5929" "⿰⿱日尹見")
      ;; ("12-5A7F" "⿰鳥矞")
      ;; ("12-5B54" "⿰育攵") ;; 徹
      ;; ("12-5DF7" "⿰豐攵") ;; 鏗
      ;; ("12-5E7B" "⿹戈肉")
      ;; ("12-6027" "⿰禾尤")
      ;; ("12-6027" "") ;; 禾
      ;; ("12-611A" "⿰干尃") ;; 博󠄁
      ;; ("12-61A9" "⿰彳⿱止口")
      ;; ("12-62CD" "⿺辶食") ;; 饋
      ;; ("12-63A7" "⿰單斤") ;; 蘄
      ;; ("12-6551" "𡩜") ;; 旧字
      ;; ("12-6557" "⿰車乙") ;; 軋
      ;; ("12-65CF" "𦍋") ;; 好
      ;; ("12-66D9" "⿱玨人") ;; 琵
      ;; ("12-676D" "⿰方")
      ;; ("12-6787" "⿰金命") ;; 令に倣い鈴に同じ
      ;; ("12-683D" "⿰𠂤朿") ;; 𠂤
      ;; ("12-685D" "⿰魚庶") ;; 鰯󠄁
      ;; ("12-6885" "⿱辰止") ;; 金文「祳」、「唇」
      ;; ("12-6B20" "⿱𡗗心") ;; 憃
      ;; ("12-6B3D" "⿰川頻") ;; 瀕
      ;; ("12-6B3E" "⿱陳土")
      ;; ("12-6D88" "")
      ;; ("12-6EC5" "⿺麥幷") ;; 麴
      ;; ("12-73C2" "⿰⿱吅冊力") ;; 龥
      ;; ("12-7523" "⿱止它") ;; 「虫」
      ;; ("12-77B3" "⿱豕豩") ;; 飌
      ;; ("12-786B" "⿱𠆢疌")
      ;; ("12-78A9" "⿱立㇉") ;; 䇂
      ;; ("12-7B4B" "⿰巳巳")
      ;; ("12-7C21" "⿱𨛜土")
      ;; ("12-7D05" "⿱双曰")
      ;; ("12-7D1A" "⿱宀䜌") ;; 変
      ;; ("12-7DCA" "⿱丞巳") ;; 卺（合）
      ;; ("12-7FD2" "⿱片由") ;; 荘
      ;; ("12-818F" "⿰⿱日丂丮")
      ;; ("12-826E" "⿰木厈")
      ;; ("12-8352" "")
      ;; ("12-8429" "⿺辶各") ;; 各
      ;; ("12-84C9" "⿰金莽")
      ;; ("12-856A" "⿱雨桼") ;; 䰍
      ;; ("12-85E4" "⿱宀譶") ;; 譶
      ;; ("12-8695" "") ;; 癶
      ;; ("12-86D9" "⿱劦口")
      ;; ("12-86EE" "⿰酉夒") ;; 跱
      ;; ("12-8AB2" "⿷匚乙") ;; 匚
      ;; ("12-8B90" "⿱冖牛")
      ;; ("12-9065" "⿰金臾") ;; 妃
      ;; ("12-90AA" "⿱⿳⺈𠔿比泉") ;; 鏗
      ;; ("12-90E8" "⿱雨無")
      ;; ("12-91DC" "⿱龴⿴囗弓") ;; 韣
      ;; ("12-92F2" "⿵門兪")
      ;; ("12-958B" "⿰柰又") ;; 柰
      ;; ("12-9665" "⿱旡夂")
      ;; ("12-96C1" "⿰㚔匊") ;; 𧂲
      ;; ("12-984D" "⿰否否")
      ;; ("12-9BE8" "⿹戈心")
      ;; ("12-9EDB" "⿱次月") ;; 答
      )))
  (setq ndjitsuu-gaiji-table
    (lookup-new-gaiji-table
     encoded-jitsuu-gaiji-table)))

;;; support-jitsuu.el ends here
