// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package abi

import (
	"math/big"
	"strings"

	ethereum "energi.world/core/gen3"
	"energi.world/core/gen3/accounts/abi"
	"energi.world/core/gen3/accounts/abi/bind"
	"energi.world/core/gen3/common"
	"energi.world/core/gen3/core/types"
	"energi.world/core/gen3/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = abi.U256
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// SporkRegistryV2ABI is the input ABI used to generate the binding from.
const SporkRegistryV2ABI = "[{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_proxy\",\"type\":\"address\"},{\"internalType\":\"contractIGovernedProxy\",\"name\":\"_mnregistry_proxy\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"_emergency_signer\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"payable\":true,\"stateMutability\":\"payable\",\"type\":\"fallback\"},{\"constant\":true,\"inputs\":[],\"name\":\"Emergency_signer\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"consensusGasLimits\",\"outputs\":[{\"internalType\":\"uint256\",\"name\":\"callGas\",\"type\":\"uint256\"},{\"internalType\":\"uint256\",\"name\":\"xferGas\",\"type\":\"uint256\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_impl\",\"type\":\"address\"},{\"internalType\":\"uint256\",\"name\":\"_period\",\"type\":\"uint256\"},{\"internalType\":\"addresspayable\",\"name\":\"_fee_payer\",\"type\":\"address\"}],\"name\":\"createUpgradeProposal\",\"outputs\":[{\"internalType\":\"contractIUpgradeProposal\",\"name\":\"proposal\",\"type\":\"address\"}],\"payable\":true,\"stateMutability\":\"payable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_newImpl\",\"type\":\"address\"}],\"name\":\"destroy\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_oldImpl\",\"type\":\"address\"}],\"name\":\"migrate\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"mnregistry_proxy\",\"outputs\":[{\"internalType\":\"contractIGovernedProxy\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"proxy\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"}]"

// SporkRegistryV2Bin is the compiled bytecode used for deploying new contracts.
const SporkRegistryV2Bin = `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`

// DeploySporkRegistryV2 deploys a new Ethereum contract, binding an instance of SporkRegistryV2 to it.
func DeploySporkRegistryV2(auth *bind.TransactOpts, backend bind.ContractBackend, _proxy common.Address, _mnregistry_proxy common.Address, _emergency_signer common.Address) (common.Address, *types.Transaction, *SporkRegistryV2, error) {
	parsed, err := abi.JSON(strings.NewReader(SporkRegistryV2ABI))
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	address, tx, contract, err := bind.DeployContract(auth, parsed, common.FromHex(SporkRegistryV2Bin), backend, _proxy, _mnregistry_proxy, _emergency_signer)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &SporkRegistryV2{SporkRegistryV2Caller: SporkRegistryV2Caller{contract: contract}, SporkRegistryV2Transactor: SporkRegistryV2Transactor{contract: contract}, SporkRegistryV2Filterer: SporkRegistryV2Filterer{contract: contract}}, nil
}

// SporkRegistryV2Bin is the compiled bytecode of contract after deployment.
const SporkRegistryV2RuntimeBin = `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`

// SporkRegistryV2 is an auto generated Go binding around an Ethereum contract.
type SporkRegistryV2 struct {
	SporkRegistryV2Caller     // Read-only binding to the contract
	SporkRegistryV2Transactor // Write-only binding to the contract
	SporkRegistryV2Filterer   // Log filterer for contract events
}

// SporkRegistryV2Caller is an auto generated read-only Go binding around an Ethereum contract.
type SporkRegistryV2Caller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// SporkRegistryV2Transactor is an auto generated write-only Go binding around an Ethereum contract.
type SporkRegistryV2Transactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// SporkRegistryV2Filterer is an auto generated log filtering Go binding around an Ethereum contract events.
type SporkRegistryV2Filterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// SporkRegistryV2Session is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type SporkRegistryV2Session struct {
	Contract     *SporkRegistryV2  // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// SporkRegistryV2CallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type SporkRegistryV2CallerSession struct {
	Contract *SporkRegistryV2Caller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts          // Call options to use throughout this session
}

// SporkRegistryV2TransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type SporkRegistryV2TransactorSession struct {
	Contract     *SporkRegistryV2Transactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts          // Transaction auth options to use throughout this session
}

// SporkRegistryV2Raw is an auto generated low-level Go binding around an Ethereum contract.
type SporkRegistryV2Raw struct {
	Contract *SporkRegistryV2 // Generic contract binding to access the raw methods on
}

// SporkRegistryV2CallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type SporkRegistryV2CallerRaw struct {
	Contract *SporkRegistryV2Caller // Generic read-only contract binding to access the raw methods on
}

// SporkRegistryV2TransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type SporkRegistryV2TransactorRaw struct {
	Contract *SporkRegistryV2Transactor // Generic write-only contract binding to access the raw methods on
}

// NewSporkRegistryV2 creates a new instance of SporkRegistryV2, bound to a specific deployed contract.
func NewSporkRegistryV2(address common.Address, backend bind.ContractBackend) (*SporkRegistryV2, error) {
	contract, err := bindSporkRegistryV2(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &SporkRegistryV2{SporkRegistryV2Caller: SporkRegistryV2Caller{contract: contract}, SporkRegistryV2Transactor: SporkRegistryV2Transactor{contract: contract}, SporkRegistryV2Filterer: SporkRegistryV2Filterer{contract: contract}}, nil
}

// NewSporkRegistryV2Caller creates a new read-only instance of SporkRegistryV2, bound to a specific deployed contract.
func NewSporkRegistryV2Caller(address common.Address, caller bind.ContractCaller) (*SporkRegistryV2Caller, error) {
	contract, err := bindSporkRegistryV2(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &SporkRegistryV2Caller{contract: contract}, nil
}

// NewSporkRegistryV2Transactor creates a new write-only instance of SporkRegistryV2, bound to a specific deployed contract.
func NewSporkRegistryV2Transactor(address common.Address, transactor bind.ContractTransactor) (*SporkRegistryV2Transactor, error) {
	contract, err := bindSporkRegistryV2(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &SporkRegistryV2Transactor{contract: contract}, nil
}

// NewSporkRegistryV2Filterer creates a new log filterer instance of SporkRegistryV2, bound to a specific deployed contract.
func NewSporkRegistryV2Filterer(address common.Address, filterer bind.ContractFilterer) (*SporkRegistryV2Filterer, error) {
	contract, err := bindSporkRegistryV2(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &SporkRegistryV2Filterer{contract: contract}, nil
}

// bindSporkRegistryV2 binds a generic wrapper to an already deployed contract.
func bindSporkRegistryV2(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(SporkRegistryV2ABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_SporkRegistryV2 *SporkRegistryV2Raw) Call(opts *bind.CallOpts, result interface{}, method string, params ...interface{}) error {
	return _SporkRegistryV2.Contract.SporkRegistryV2Caller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_SporkRegistryV2 *SporkRegistryV2Raw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _SporkRegistryV2.Contract.SporkRegistryV2Transactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_SporkRegistryV2 *SporkRegistryV2Raw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _SporkRegistryV2.Contract.SporkRegistryV2Transactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_SporkRegistryV2 *SporkRegistryV2CallerRaw) Call(opts *bind.CallOpts, result interface{}, method string, params ...interface{}) error {
	return _SporkRegistryV2.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_SporkRegistryV2 *SporkRegistryV2TransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _SporkRegistryV2.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_SporkRegistryV2 *SporkRegistryV2TransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _SporkRegistryV2.Contract.contract.Transact(opts, method, params...)
}

// EmergencySigner is a free data retrieval call binding the contract method 0xd4f7068a.
//
// Solidity: function Emergency_signer() constant returns(address)
func (_SporkRegistryV2 *SporkRegistryV2Caller) EmergencySigner(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _SporkRegistryV2.contract.Call(opts, out, "Emergency_signer")
	return *ret0, err
}

// EmergencySigner is a free data retrieval call binding the contract method 0xd4f7068a.
//
// Solidity: function Emergency_signer() constant returns(address)
func (_SporkRegistryV2 *SporkRegistryV2Session) EmergencySigner() (common.Address, error) {
	return _SporkRegistryV2.Contract.EmergencySigner(&_SporkRegistryV2.CallOpts)
}

// EmergencySigner is a free data retrieval call binding the contract method 0xd4f7068a.
//
// Solidity: function Emergency_signer() constant returns(address)
func (_SporkRegistryV2 *SporkRegistryV2CallerSession) EmergencySigner() (common.Address, error) {
	return _SporkRegistryV2.Contract.EmergencySigner(&_SporkRegistryV2.CallOpts)
}

// ConsensusGasLimits is a free data retrieval call binding the contract method 0xc00ebced.
//
// Solidity: function consensusGasLimits() constant returns(uint256 callGas, uint256 xferGas)
func (_SporkRegistryV2 *SporkRegistryV2Caller) ConsensusGasLimits(opts *bind.CallOpts) (struct {
	CallGas *big.Int
	XferGas *big.Int
}, error) {
	ret := new(struct {
		CallGas *big.Int
		XferGas *big.Int
	})
	out := ret
	err := _SporkRegistryV2.contract.Call(opts, out, "consensusGasLimits")
	return *ret, err
}

// ConsensusGasLimits is a free data retrieval call binding the contract method 0xc00ebced.
//
// Solidity: function consensusGasLimits() constant returns(uint256 callGas, uint256 xferGas)
func (_SporkRegistryV2 *SporkRegistryV2Session) ConsensusGasLimits() (struct {
	CallGas *big.Int
	XferGas *big.Int
}, error) {
	return _SporkRegistryV2.Contract.ConsensusGasLimits(&_SporkRegistryV2.CallOpts)
}

// ConsensusGasLimits is a free data retrieval call binding the contract method 0xc00ebced.
//
// Solidity: function consensusGasLimits() constant returns(uint256 callGas, uint256 xferGas)
func (_SporkRegistryV2 *SporkRegistryV2CallerSession) ConsensusGasLimits() (struct {
	CallGas *big.Int
	XferGas *big.Int
}, error) {
	return _SporkRegistryV2.Contract.ConsensusGasLimits(&_SporkRegistryV2.CallOpts)
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_SporkRegistryV2 *SporkRegistryV2Caller) MnregistryProxy(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _SporkRegistryV2.contract.Call(opts, out, "mnregistry_proxy")
	return *ret0, err
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_SporkRegistryV2 *SporkRegistryV2Session) MnregistryProxy() (common.Address, error) {
	return _SporkRegistryV2.Contract.MnregistryProxy(&_SporkRegistryV2.CallOpts)
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_SporkRegistryV2 *SporkRegistryV2CallerSession) MnregistryProxy() (common.Address, error) {
	return _SporkRegistryV2.Contract.MnregistryProxy(&_SporkRegistryV2.CallOpts)
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_SporkRegistryV2 *SporkRegistryV2Caller) Proxy(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _SporkRegistryV2.contract.Call(opts, out, "proxy")
	return *ret0, err
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_SporkRegistryV2 *SporkRegistryV2Session) Proxy() (common.Address, error) {
	return _SporkRegistryV2.Contract.Proxy(&_SporkRegistryV2.CallOpts)
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_SporkRegistryV2 *SporkRegistryV2CallerSession) Proxy() (common.Address, error) {
	return _SporkRegistryV2.Contract.Proxy(&_SporkRegistryV2.CallOpts)
}

// CreateUpgradeProposal is a paid mutator transaction binding the contract method 0x62877ccd.
//
// Solidity: function createUpgradeProposal(address _impl, uint256 _period, address _fee_payer) returns(address proposal)
func (_SporkRegistryV2 *SporkRegistryV2Transactor) CreateUpgradeProposal(opts *bind.TransactOpts, _impl common.Address, _period *big.Int, _fee_payer common.Address) (*types.Transaction, error) {
	return _SporkRegistryV2.contract.Transact(opts, "createUpgradeProposal", _impl, _period, _fee_payer)
}

// CreateUpgradeProposal is a paid mutator transaction binding the contract method 0x62877ccd.
//
// Solidity: function createUpgradeProposal(address _impl, uint256 _period, address _fee_payer) returns(address proposal)
func (_SporkRegistryV2 *SporkRegistryV2Session) CreateUpgradeProposal(_impl common.Address, _period *big.Int, _fee_payer common.Address) (*types.Transaction, error) {
	return _SporkRegistryV2.Contract.CreateUpgradeProposal(&_SporkRegistryV2.TransactOpts, _impl, _period, _fee_payer)
}

// CreateUpgradeProposal is a paid mutator transaction binding the contract method 0x62877ccd.
//
// Solidity: function createUpgradeProposal(address _impl, uint256 _period, address _fee_payer) returns(address proposal)
func (_SporkRegistryV2 *SporkRegistryV2TransactorSession) CreateUpgradeProposal(_impl common.Address, _period *big.Int, _fee_payer common.Address) (*types.Transaction, error) {
	return _SporkRegistryV2.Contract.CreateUpgradeProposal(&_SporkRegistryV2.TransactOpts, _impl, _period, _fee_payer)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_SporkRegistryV2 *SporkRegistryV2Transactor) Destroy(opts *bind.TransactOpts, _newImpl common.Address) (*types.Transaction, error) {
	return _SporkRegistryV2.contract.Transact(opts, "destroy", _newImpl)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_SporkRegistryV2 *SporkRegistryV2Session) Destroy(_newImpl common.Address) (*types.Transaction, error) {
	return _SporkRegistryV2.Contract.Destroy(&_SporkRegistryV2.TransactOpts, _newImpl)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_SporkRegistryV2 *SporkRegistryV2TransactorSession) Destroy(_newImpl common.Address) (*types.Transaction, error) {
	return _SporkRegistryV2.Contract.Destroy(&_SporkRegistryV2.TransactOpts, _newImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_SporkRegistryV2 *SporkRegistryV2Transactor) Migrate(opts *bind.TransactOpts, _oldImpl common.Address) (*types.Transaction, error) {
	return _SporkRegistryV2.contract.Transact(opts, "migrate", _oldImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_SporkRegistryV2 *SporkRegistryV2Session) Migrate(_oldImpl common.Address) (*types.Transaction, error) {
	return _SporkRegistryV2.Contract.Migrate(&_SporkRegistryV2.TransactOpts, _oldImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_SporkRegistryV2 *SporkRegistryV2TransactorSession) Migrate(_oldImpl common.Address) (*types.Transaction, error) {
	return _SporkRegistryV2.Contract.Migrate(&_SporkRegistryV2.TransactOpts, _oldImpl)
}
