/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;

public class DockLayout
extends BorderLayout {
    private static final long serialVersionUID = 5488248873659570282L;
    private ArrayList north = new ArrayList(1);
    private ArrayList south = new ArrayList(1);
    private ArrayList east = new ArrayList(1);
    private ArrayList west = new ArrayList(1);
    private Component center = null;
    private static final int VERTICAL = 1;
    private static final int HORIZONTAL = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object != null) {
                String string = object.toString();
                if (string.equals("North")) {
                    this.north.add(component);
                } else if (string.equals("South")) {
                    this.south.add(component);
                } else if (string.equals("East")) {
                    this.east.add(component);
                } else if (string.equals("West")) {
                    this.west.add(component);
                } else if (string.equals("Center")) {
                    this.center = component;
                }
            }
        }
    }

    public void removeLayoutComponent(Component component) {
        this.north.remove(component);
        this.south.remove(component);
        this.east.remove(component);
        this.west.remove(component);
        if (component == this.center) {
            this.center = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = insets.top;
            int n2 = container.getHeight() - insets.bottom;
            int n3 = insets.left;
            int n4 = container.getWidth() - insets.right;
            int n5 = this.getPreferredDimension((ArrayList)this.north).height;
            int n6 = this.getPreferredDimension((ArrayList)this.south).height;
            int n7 = this.getPreferredDimension((ArrayList)this.east).width;
            int n8 = this.getPreferredDimension((ArrayList)this.west).width;
            this.placeComponents(this.north, n3, n, n4 - n3, n5, 0);
            this.placeComponents(this.south, n3, n2 - n6, n4 - n3, n6, 0);
            this.placeComponents(this.east, n4 - n7, n += n5 + this.getVgap(), n7, (n2 -= n6 + this.getVgap()) - n, 1);
            n4 -= n7 + this.getHgap();
            this.placeComponents(this.west, n3, n, n8, n2 - n, 1);
            n3 += n8 + this.getHgap();
            if (this.center != null) {
                this.center.setBounds(n3, n, n4 - n3, n2 - n);
            }
        }
    }

    private Dimension getPreferredDimension(ArrayList arrayList) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Component component = (Component)arrayList.get(i);
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
        }
        return new Dimension(n, n2);
    }

    private void placeComponents(ArrayList arrayList, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        Component component = null;
        if (n5 == 0) {
            n6 = n;
            for (int i = 0; i < arrayList.size(); ++i) {
                component = (Component)arrayList.get(i);
                int n7 = component.getPreferredSize().width;
                if (i == arrayList.size() - 1) {
                    n7 = n3 - n6;
                }
                component.setBounds(n + n6, n2, n7, n4);
                n6 += n7;
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                component = (Component)arrayList.get(i);
                int n8 = component.getPreferredSize().height;
                if (i == arrayList.size() - 1) {
                    n8 = n4 - n6;
                }
                component.setBounds(n, n2 + n6, n3, n8);
                n6 += n8;
            }
        }
    }
}

