/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.argouml.model.CoreHelper;
import org.argouml.model.Model;
import org.argouml.model.NotImplementedException;
import org.argouml.model.euml.ChangeCommand;
import org.argouml.model.euml.EUMLModelImplementation;
import org.argouml.model.euml.ModelEventPumpEUMLImpl;
import org.argouml.model.euml.ModelManagementHelperEUMLImpl;
import org.argouml.model.euml.NotYetImplementedException;
import org.argouml.model.euml.RunnableClass;
import org.argouml.model.euml.UMLUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.CallConcurrencyKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CoreHelperEUMLImpl
implements CoreHelper {
    private static final Logger LOG = Logger.getLogger(CoreHelperEUMLImpl.class);
    private EUMLModelImplementation modelImpl;
    private EditingDomain editingDomain;

    public CoreHelperEUMLImpl(EUMLModelImplementation implementation) {
        this.modelImpl = implementation;
        this.editingDomain = implementation.getEditingDomain();
    }

    @Override
    public void addAllStereotypes(final Object modelElement, final Collection stereos) {
        if (!(modelElement instanceof Element)) {
            throw new IllegalArgumentException("modelElement must be instance of Element");
        }
        if (stereos == null) {
            throw new NullPointerException("stereos must be non-null");
        }
        final Element element = (Element)modelElement;
        for (Object o : stereos) {
            if (!(o instanceof Stereotype)) {
                throw new IllegalArgumentException("The stereotypes from stereo collection must be instances of Stereotype");
            }
            if (element.isStereotypeApplicable((Stereotype)o)) continue;
            throw new UnsupportedOperationException("The stereotype " + o + " cannot be applied to " + modelElement);
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                for (Object o : stereos) {
                    Stereotype stereotype = (Stereotype)o;
                    EObject eo = element.applyStereotype(stereotype);
                    if (element.isStereotypeApplied(stereotype)) {
                        this.fireApplyStereotypeEvent(modelElement, stereotype);
                        continue;
                    }
                    EcoreUtil.remove((EObject)eo);
                }
            }

            private void fireApplyStereotypeEvent(Object modelElement2, Object stereotype) {
                ModelEventPumpEUMLImpl pump = (ModelEventPumpEUMLImpl)Model.getPump();
                pump.fireEvent(modelElement2, null, stereotype, 3, "stereotype", null);
            }
        };
        ChangeCommand cmd = stereos.size() == 1 ? new ChangeCommand(this.modelImpl, run, "Apply the stereotype # to the element #", stereos.iterator().next(), modelElement) : new ChangeCommand(this.modelImpl, run, "Apply # stereotypes to the element #", stereos.size(), modelElement);
        this.editingDomain.getCommandStack().execute((Command)cmd);
    }

    @Override
    public void addAnnotatedElement(final Object comment, final Object annotatedElement) {
        if (!(annotatedElement instanceof Element)) {
            throw new IllegalArgumentException("annotatedElement must be instance of Element");
        }
        if (!(comment instanceof Comment)) {
            throw new IllegalArgumentException("comment must be instance of Comment");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Comment)comment).getAnnotatedElements().add((Object)((Element)annotatedElement));
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Add the comment # to the element #", comment, annotatedElement));
    }

    @Override
    public void addClient(final Object dependency, final Object element) {
        if (!(dependency instanceof Dependency)) {
            throw new IllegalArgumentException("The dependency must be instance of Dependency");
        }
        if (!(element instanceof NamedElement)) {
            throw new IllegalArgumentException("The element must be instance of NamedElement");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Dependency)dependency).getClients().add((Object)((NamedElement)element));
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Add the client # to the dependency #", element, dependency));
    }

    @Override
    public void addClientDependency(Object handle, Object dependency) {
        this.addClient(dependency, handle);
    }

    @Override
    public void addComment(Object element, Object comment) {
        this.addAnnotatedElement(comment, element);
    }

    @Override
    public void addConnection(Object handle, Object connection) {
        this.addConnection(handle, -1, connection);
    }

    @Override
    public void addConnection(Object handle, int position, Object connection) {
        if (!(handle instanceof Association)) {
            throw new IllegalArgumentException("The handle must be instance of Association");
        }
        if (!(connection instanceof Property)) {
            throw new IllegalArgumentException("The connection must be instance of Property");
        }
        RunnableClass run = this.getRunnableClassForAddCommand((Element)((Association)handle), position, (Element)((Property)connection));
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Add the AssociationEnd (Property) # to the Association #", connection, handle));
    }

    @Override
    public void addConstraint(Object handle, final Object mc) {
        if (!(handle instanceof Element)) {
            throw new IllegalArgumentException("The handle must be instance of Element");
        }
        if (!(mc instanceof Constraint)) {
            throw new IllegalArgumentException("mc must be instance of Constraint");
        }
        final Element element = (Element)handle;
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Constraint)mc).getConstrainedElements().add((Object)element);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Add the constraint # to the element #", mc, handle));
    }

    @Override
    public void addDeploymentLocation(Object handle, Object node) {
        throw new NotYetImplementedException();
    }

    @Override
    public void addElementResidence(Object handle, Object residence) {
        throw new NotYetImplementedException();
    }

    private RunnableClass getRunnableClassForAddCommand(Element owner, Element element) {
        return this.getRunnableClassForAddCommand(owner, -1, element);
    }

    private RunnableClass getRunnableClassForAddCommand(Element owner, int index, Element element) {
        final Command cmd = AddCommand.create((EditingDomain)this.editingDomain, (Object)owner, null, (Object)element, (int)index);
        if (cmd == null || !cmd.canExecute()) {
            throw new UnsupportedOperationException("The element " + element + " cannot be added to the element " + owner);
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                cmd.execute();
            }
        };
        return run;
    }

    private RunnableClass getRunnableClassForRemoveCommand(Element element) {
        final Command cmd = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)element);
        if (cmd == null || !cmd.canExecute()) {
            String s = "The element " + element;
            if (element.getOwner() != null) {
                s = s + ", owned by " + element.getOwner() + ", ";
            }
            s = s + " cannot be removed";
            throw new UnsupportedOperationException(s);
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                cmd.execute();
            }
        };
        return run;
    }

    @Override
    public void addFeature(Object handle, int index, Object f) {
        if (!(handle instanceof Classifier)) {
            throw new IllegalArgumentException("The handle must be instance of Classifier");
        }
        if (!(f instanceof Feature)) {
            throw new IllegalArgumentException("f must be instance of Feature");
        }
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, this.getRunnableClassForAddCommand((Element)((Classifier)handle), index, (Element)((Feature)f)), "Add the feature # to the classifier #", f, handle));
    }

    @Override
    public void addFeature(Object handle, Object f) {
        this.addFeature(handle, -1, f);
    }

    @Override
    public void addLink(Object handle, Object link) {
        throw new NotYetImplementedException();
    }

    @Override
    public void addLiteral(Object handle, int index, Object literal) {
        if (!(handle instanceof Enumeration)) {
            throw new IllegalArgumentException("The handle must be instance of Enumeration");
        }
        if (!(literal instanceof EnumerationLiteral)) {
            throw new IllegalArgumentException("literal must be instance of EnumerationLiteral");
        }
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, this.getRunnableClassForAddCommand((Element)((Enumeration)handle), index, (Element)((EnumerationLiteral)literal)), "Add the EnumerationLiteral # to the Enumeration #", literal, handle));
    }

    @Override
    public void addManifestation(Object handle, Object manifestation) {
        if (!(handle instanceof Artifact)) {
            throw new IllegalArgumentException("The handle must be instance of Artifact");
        }
        if (!(manifestation instanceof Manifestation)) {
            throw new IllegalArgumentException("The manifestation must be instance of Manifestation");
        }
        ((Artifact)handle).getManifestations().add((Object)((Manifestation)manifestation));
    }

    @Override
    public void addMethod(final Object handle, Object method) {
        if (!(handle instanceof BehavioralFeature)) {
            throw new IllegalArgumentException("The handle must be instance of BehavioralFeature");
        }
        if (!(method instanceof Behavior)) {
            throw new IllegalArgumentException("method must be instance of Behavior");
        }
        final Behavior behavior = (Behavior)method;
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((BehavioralFeature)handle).getMethods().add((Object)behavior);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Add the Behavior (method) # to the BehavioralFeature (operation) #", method, handle));
    }

    public void addOwnedElement(Object handle, Object me, String msg, Object ... objects) {
        if (!(handle instanceof Namespace)) {
            throw new IllegalArgumentException("The handle must be instance of Namespace");
        }
        if (!(me instanceof Element)) {
            throw new IllegalArgumentException("'me' must be instance of Element, we got a " + me);
        }
        Element element = (Element)me;
        if (element.getOwner() != null) {
            LOG.info((Object)("Setting ignore delete for " + element));
            ModelEventPumpEUMLImpl pump = (ModelEventPumpEUMLImpl)Model.getPump();
            pump.addElementForDeleteEventIgnore(element);
        }
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, this.getRunnableClassForAddCommand((Element)((Namespace)handle), (Element)me), msg, objects));
    }

    @Override
    public void addOwnedElement(Object handle, Object me) {
        this.addOwnedElement(handle, me, "Add the owned element # to the owner #", me, handle);
    }

    @Override
    public void addParameter(Object handle, int index, Object parameter) {
        if (!(handle instanceof BehavioralFeature)) {
            throw new IllegalArgumentException("handle must be instance of BehavioralFeature");
        }
        if (!(parameter instanceof Parameter)) {
            throw new IllegalArgumentException("parameter must be instance of Parameter");
        }
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, this.getRunnableClassForAddCommand((Element)((BehavioralFeature)handle), index, (Element)((Parameter)parameter)), "Add the owned element # to the owner #", parameter, handle));
    }

    @Override
    public void addParameter(Object handle, Object parameter) {
        this.addParameter(handle, -1, parameter);
    }

    @Override
    public void addQualifier(Object handle, int position, Object qualifier) {
        if (!(handle instanceof Property) || !(qualifier instanceof Property)) {
            throw new IllegalArgumentException("handle and qualifier must be instances of Property");
        }
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, this.getRunnableClassForAddCommand((Element)((Property)handle), position, (Element)((Property)qualifier)), "Add the qualifier # to the property #", qualifier, handle));
    }

    @Override
    public void addRaisedSignal(Object handle, Object sig) {
        throw new NotYetImplementedException();
    }

    @Override
    public void addRaisedException(Object handle, Object exception) {
        UMLUtil.checkArgs(new Object[]{handle, exception}, new java.lang.Class[]{Operation.class, Type.class});
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, this.getRunnableClassForAddCommand((Element)((Operation)handle), (Element)((Type)exception)), "Add the Exception # to the Operation #", exception, handle));
    }

    @Override
    public void addSourceFlow(Object handle, Object flow) {
        throw new NotYetImplementedException();
    }

    @Override
    public void addStereotype(Object modelElement, Object stereo) {
        this.addAllStereotypes(modelElement, Collections.singleton(stereo));
    }

    @Override
    public void addSupplier(final Object dependency, final Object element) {
        if (!(dependency instanceof Dependency)) {
            throw new IllegalArgumentException("The dependency must be instance of Dependency");
        }
        if (!(element instanceof NamedElement)) {
            throw new IllegalArgumentException("The element must be instance of NamedElement");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Dependency)dependency).getSuppliers().add((Object)((NamedElement)element));
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Add the supplier # to the dependency #", element, dependency));
    }

    @Override
    public void addSupplierDependency(Object supplier, Object dependency) {
        this.addSupplier(dependency, supplier);
    }

    @Override
    public void addTargetFlow(Object handle, Object flow) {
        throw new NotYetImplementedException();
    }

    @Override
    public void addTemplateArgument(Object handle, int index, Object argument) {
        throw new NotYetImplementedException();
    }

    @Override
    public void addTemplateArgument(Object handle, Object argument) {
        throw new NotYetImplementedException();
    }

    @Override
    public void addTemplateParameter(Object handle, int index, Object parameter) {
        throw new NotYetImplementedException();
    }

    @Override
    public void addTemplateParameter(Object handle, Object parameter) {
        throw new NotYetImplementedException();
    }

    @Override
    public void clearStereotypes(Object handle) {
        throw new NotYetImplementedException();
    }

    @Override
    public boolean equalsAggregationKind(Object associationEnd, String kindType) {
        if (!(associationEnd instanceof Property)) {
            throw new IllegalArgumentException("associationEnd must be instance of Property");
        }
        return ((Property)associationEnd).getAggregation().getLiteral().equals(kindType);
    }

    @Override
    public Collection getAllAttributes(Object classifier) {
        if (!(classifier instanceof Classifier)) {
            throw new IllegalArgumentException("classifier must be instance of Classifier");
        }
        HashSet result = new HashSet();
        result.addAll(((Classifier)classifier).getAttributes());
        for (Classifier c : ((Classifier)classifier).allParents()) {
            result.addAll(c.getAttributes());
        }
        return result;
    }

    @Override
    public Collection getAllBehavioralFeatures(Object element) {
        return this.modelImpl.getModelManagementHelper().getAllModelElementsOfKind(element, BehavioralFeature.class);
    }

    @Override
    public Collection getAllClasses(Object ns) {
        return this.modelImpl.getModelManagementHelper().getAllModelElementsOfKind(ns, Class.class);
    }

    @Override
    public Collection getAllClassifiers(Object namespace) {
        return this.modelImpl.getModelManagementHelper().getAllModelElementsOfKind(namespace, Classifier.class);
    }

    @Override
    public Collection getAllComponents(Object ns) {
        return this.modelImpl.getModelManagementHelper().getAllModelElementsOfKind(ns, Component.class);
    }

    @Override
    public Collection getAllDataTypes(Object ns) {
        return this.modelImpl.getModelManagementHelper().getAllModelElementsOfKind(ns, DataType.class);
    }

    @Override
    public Collection getAllInterfaces(Object ns) {
        return this.modelImpl.getModelManagementHelper().getAllModelElementsOfKind(ns, Interface.class);
    }

    @Override
    public Collection<String> getAllMetaDatatypeNames() {
        return Collections.emptySet();
    }

    @Override
    public Collection<String> getAllMetatypeNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Field f : UMLPackage.Literals.class.getDeclaredFields()) {
            Object o;
            try {
                o = f.get(null);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (!(o instanceof EClass)) continue;
            result.add(((EClass)o).getName());
        }
        return result;
    }

    @Override
    public Collection getAllNodes(Object ns) {
        ModelManagementHelperEUMLImpl helper = this.modelImpl.getModelManagementHelper();
        return helper.getAllModelElementsOfKind(ns, Node.class);
    }

    @Override
    public Collection getAllPossibleNamespaces(Object modelElement, Object model) {
        if (!(model instanceof Element) || !(modelElement instanceof Element)) {
            throw new IllegalArgumentException("modelElement and model must be instances of Element");
        }
        ArrayList<Namespace> result = new ArrayList<Namespace>();
        if (this.isValidNamespace(modelElement, model)) {
            result.add((Namespace)model);
        }
        ModelManagementHelperEUMLImpl helper = this.modelImpl.getModelManagementHelper();
        for (Object o : helper.getAllModelElementsOfKind(model, Namespace.class)) {
            if (!this.isValidNamespace(modelElement, o)) continue;
            result.add((Namespace)o);
        }
        return result;
    }

    @Override
    public Collection getAllRealizedInterfaces(Object element) {
        if (!(element instanceof Class)) {
            throw new IllegalArgumentException("element must be instance of UML2 Class");
        }
        Class theClass = (Class)element;
        return theClass.getAllImplementedInterfaces();
    }

    @Override
    public Collection getAllSupertypes(Object classifier) {
        if (!(classifier instanceof Classifier)) {
            throw new IllegalArgumentException("classifier must be instance of Classifier");
        }
        return ((Classifier)classifier).allParents();
    }

    @Override
    public Collection getAllVisibleElements(Object ns) {
        if (!(ns instanceof Namespace)) {
            throw new IllegalArgumentException("ns must be instance of Namespace");
        }
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        for (NamedElement e : ((Namespace)ns).getOwnedMembers()) {
            if (e.getVisibility() != VisibilityKind.PUBLIC_LITERAL) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public Collection getAssociateEndsInh(Object classifier) {
        if (!(classifier instanceof Classifier)) {
            throw new IllegalArgumentException("classifier must be instance of Classifier");
        }
        ArrayList<Property> result = new ArrayList<Property>();
        result.addAll(this.modelImpl.getFacade().getAssociationEnds(classifier));
        for (Classifier o : ((Classifier)classifier).allParents()) {
            result.addAll(this.modelImpl.getFacade().getAssociationEnds(o));
        }
        return result;
    }

    @Override
    public Collection<Classifier> getAssociatedClassifiers(Object aclassifier) {
        if (!(aclassifier instanceof Classifier)) {
            throw new IllegalArgumentException("aclassifier must be instance of Classifier");
        }
        ArrayList<Classifier> result = new ArrayList<Classifier>();
        for (Association a : ((Classifier)aclassifier).getAssociations()) {
            for (Type t : a.getEndTypes()) {
                if (t == aclassifier || !(t instanceof Classifier)) continue;
                result.add((Classifier)t);
            }
        }
        return result;
    }

    public Property getAssociationEnd(Object type, Object assoc) {
        if (!(type instanceof Classifier)) {
            throw new IllegalArgumentException("type must be instance of Classifier");
        }
        if (!(assoc instanceof Association)) {
            throw new IllegalArgumentException("assoc must be instance of Association");
        }
        return ((Association)assoc).getMemberEnd(null, (Type)((Classifier)type));
    }

    @Override
    public Collection<Association> getAssociations(Object from, Object to) {
        if (from == null || to == null) {
            return Collections.emptyList();
        }
        if (!(from instanceof Classifier) || !(to instanceof Classifier)) {
            throw new IllegalArgumentException("'from' and 'to' must be instances of Classifier");
        }
        ArrayList<Association> result = new ArrayList<Association>();
        for (Association a : ((Classifier)from).getAssociations()) {
            if (!((Classifier)to).getAssociations().contains((Object)a)) continue;
            result.add(a);
        }
        return result;
    }

    @Override
    public Collection getAssociations(Object classifier) {
        if (!(classifier instanceof Classifier)) {
            throw new IllegalArgumentException("'classifier' must be instance of Classifier");
        }
        return ((Classifier)classifier).getAssociations();
    }

    @Override
    public Collection getAttributesInh(Object classifier) {
        if (!(classifier instanceof Classifier)) {
            throw new IllegalArgumentException("'classifier' must be instance of Classifier");
        }
        return ((Classifier)classifier).getAllAttributes();
    }

    @Override
    public List<BehavioralFeature> getBehavioralFeatures(Object classifier) {
        if (!(classifier instanceof Classifier)) {
            throw new IllegalArgumentException("'classifier' must be instance of Classifier");
        }
        ArrayList<BehavioralFeature> result = new ArrayList<BehavioralFeature>();
        for (Feature feature : ((Classifier)classifier).getFeatures()) {
            if (!(feature instanceof BehavioralFeature)) continue;
            result.add((BehavioralFeature)feature);
        }
        return result;
    }

    @Override
    public String getBody(Object comment) {
        if (!(comment instanceof Comment)) {
            throw new IllegalArgumentException("'comment' must be instance of Comment");
        }
        return ((Comment)comment).getBody();
    }

    @Override
    public Collection<Classifier> getChildren(Object element) {
        Classifier c;
        if (!(element instanceof Classifier)) {
            throw new IllegalArgumentException("'element' must be instance of Classifier");
        }
        HashSet<Classifier> results = new HashSet<Classifier>();
        LinkedList<Classifier> classifiers = new LinkedList<Classifier>();
        classifiers.add((Classifier)element);
        while (!classifiers.isEmpty() && !results.contains(c = (Classifier)classifiers.removeFirst())) {
            results.add(c);
            for (DirectedRelationship d : c.getTargetDirectedRelationships(UMLPackage.Literals.GENERALIZATION)) {
                for (Element e : d.getSources()) {
                    if (!(e instanceof Classifier) || results.contains(e)) continue;
                    classifiers.add((Classifier)e);
                }
            }
        }
        results.remove(element);
        return results;
    }

    @Override
    public Collection<Dependency> getDependencies(Object supplierObj, Object clientObj) {
        if (!(supplierObj instanceof NamedElement) || !(clientObj instanceof NamedElement)) {
            throw new IllegalArgumentException("supplierObj and clientObj must be instances of NamedElement");
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency d : ((NamedElement)clientObj).getClientDependencies()) {
            if (!d.getSuppliers().contains(supplierObj)) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    public Collection<Classifier> getExtendedClassifiers(Object element) {
        if (!(element instanceof Classifier)) {
            throw new IllegalArgumentException("'element' must be instance of Classifier");
        }
        return ((Classifier)element).getGenerals();
    }

    @Override
    public Collection<Element> getExtendingClassifiers(Object classifier) {
        if (!(classifier instanceof Classifier)) {
            throw new IllegalArgumentException("'classifier' must be instance of Classifier");
        }
        HashSet<Element> result = new HashSet<Element>();
        for (Element e : this.getExtendingElements(classifier)) {
            if (!(e instanceof Classifier)) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public Collection<Element> getExtendingElements(Object element) {
        if (!(element instanceof Classifier)) {
            throw new IllegalArgumentException("'element' must be instance of Classifier");
        }
        HashSet<Element> result = new HashSet<Element>();
        for (DirectedRelationship d : ((Classifier)element).getTargetDirectedRelationships(UMLPackage.Literals.GENERALIZATION)) {
            for (Element e : d.getSources()) {
                result.add(e);
            }
        }
        return result;
    }

    public Namespace getFirstSharedNamespace(Object ns1, Object ns2) {
        if (!(ns1 instanceof Namespace) || !(ns2 instanceof Namespace)) {
            throw new IllegalArgumentException("ns1 and ns2 must be instances of Namespace");
        }
        Namespace result = null;
        ArrayList<Namespace> l1 = new ArrayList<Namespace>();
        l1.add((Namespace)ns1);
        l1.addAll((Collection<Namespace>)((Namespace)ns1).allNamespaces());
        ArrayList<Namespace> l2 = new ArrayList<Namespace>();
        l2.add((Namespace)ns2);
        l2.addAll((Collection<Namespace>)((Namespace)ns2).allNamespaces());
        int i = l1.size() - 1;
        for (int j = l2.size() - 1; i >= 0 && j >= 0 && l1.get(i) == l2.get(j); --i, --j) {
            result = (Namespace)l1.get(i);
        }
        return result;
    }

    @Override
    public Collection getFlows(Object source, Object target) {
        throw new NotYetImplementedException();
    }

    public Generalization getGeneralization(Object achild, Object aparent) {
        if (!(achild instanceof Classifier) || !(aparent instanceof Classifier)) {
            throw new IllegalArgumentException("'achild' and 'aparent' must be instances of Classifier");
        }
        return ((Classifier)achild).getGeneralization((Classifier)aparent);
    }

    @Override
    public Collection<PackageableElement> getUtilizedElements(Object artifact) {
        if (!(artifact instanceof Artifact)) {
            throw new IllegalArgumentException("'artifact' must be instance of Artifact");
        }
        ArrayList<PackageableElement> c = new ArrayList<PackageableElement>();
        for (Manifestation m : ((Artifact)artifact).getManifestations()) {
            PackageableElement pe = m.getUtilizedElement();
            if (pe == null) continue;
            c.add(pe);
        }
        return c;
    }

    @Override
    public Collection<Operation> getOperationsInh(Object classifier) {
        if (!(classifier instanceof Classifier)) {
            throw new IllegalArgumentException("'classifier' must be instance of Classifier");
        }
        return ((Classifier)classifier).getAllOperations();
    }

    @Override
    public Collection<Interface> getRealizedInterfaces(Object cls) {
        if (!(cls instanceof Class)) {
            throw new IllegalArgumentException("'cls' must be instance of UML2 Class");
        }
        return ((Class)cls).getImplementedInterfaces();
    }

    @Override
    public Collection<DirectedRelationship> getRelationships(Object source, Object dest) {
        if (!(source instanceof Element) || !(dest instanceof Element)) {
            throw new IllegalArgumentException("'source' and 'dest' must be instances of Element");
        }
        ArrayList<DirectedRelationship> result = new ArrayList<DirectedRelationship>();
        for (DirectedRelationship d : ((Element)source).getSourceDirectedRelationships()) {
            if (!d.getTargets().contains(dest)) continue;
            result.add(d);
        }
        for (DirectedRelationship d : ((Element)source).getTargetDirectedRelationships()) {
            if (!d.getSources().contains(dest)) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    public List<Parameter> getReturnParameters(Object bf) {
        if (!(bf instanceof BehavioralFeature)) {
            throw new IllegalArgumentException("'bf' must be instance of BehavioralFeature");
        }
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (Parameter p : ((Operation)bf).getOwnedParameters()) {
            if (p.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            result.add(p);
        }
        return result;
    }

    @Override
    public Object getSource(Object relationship) {
        if (!(relationship instanceof Relationship) && !(relationship instanceof Property)) {
            throw new IllegalArgumentException("'relationship' must be instance of Relationship or Property");
        }
        if (relationship instanceof Association) {
            EList conns = ((Association)relationship).getMemberEnds();
            if (conns.size() < 2) {
                return null;
            }
            return ((Property)conns.get(1)).getType();
        }
        if (relationship instanceof DirectedRelationship) {
            EList sources = ((DirectedRelationship)relationship).getSources();
            if (sources.isEmpty()) {
                return null;
            }
            return sources.get(0);
        }
        if (relationship instanceof Property) {
            return ((Property)relationship).getAssociation();
        }
        return null;
    }

    @Override
    public Object getDestination(Object relationship) {
        if (!(relationship instanceof Relationship) && !(relationship instanceof Property)) {
            throw new IllegalArgumentException("'relationship' must be instance of Relationship or Property");
        }
        if (relationship instanceof Association) {
            EList conns = ((Association)relationship).getMemberEnds();
            if (conns.isEmpty()) {
                return null;
            }
            return ((Property)conns.get(0)).getType();
        }
        if (relationship instanceof DirectedRelationship) {
            EList targets = ((DirectedRelationship)relationship).getTargets();
            if (targets.isEmpty()) {
                return null;
            }
            return targets.get(0);
        }
        if (relationship instanceof Property) {
            return ((Property)relationship).getAssociation();
        }
        return null;
    }

    @Override
    public Object getSpecification(Object object) {
        if (!(object instanceof Behavior)) {
            throw new IllegalArgumentException("'object' must be instance of Behavior");
        }
        return ((Behavior)object).getSpecification();
    }

    @Override
    public Collection<Element> getSubtypes(Object cls) {
        if (!(cls instanceof Classifier)) {
            throw new IllegalArgumentException("'cls' must be instance of Classifier");
        }
        HashSet<Element> results = new HashSet<Element>();
        for (DirectedRelationship d : ((Classifier)cls).getTargetDirectedRelationships(UMLPackage.Literals.GENERALIZATION)) {
            results.addAll((Collection<Element>)d.getSources());
        }
        return results;
    }

    @Override
    public Collection<Classifier> getSupertypes(Object generalizableElement) {
        if (!(generalizableElement instanceof Classifier)) {
            throw new IllegalArgumentException("'generalizableElement' must be instance of Classifier");
        }
        return ((Classifier)generalizableElement).getGenerals();
    }

    @Override
    public boolean hasCompositeEnd(Object association) {
        if (!(association instanceof Association)) {
            throw new IllegalArgumentException("'association' must be instance of Association");
        }
        for (Property p : ((Association)association).getMemberEnds()) {
            if (p.getAggregation() != AggregationKind.COMPOSITE_LITERAL) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubType(Object type, Object subType) {
        if (!(type instanceof java.lang.Class) || !(subType instanceof java.lang.Class)) {
            throw new IllegalArgumentException("type and subType must be instances of java.lang.Class");
        }
        return ((java.lang.Class)type).isAssignableFrom((java.lang.Class)subType);
    }

    @Override
    public boolean isValidNamespace(Object element, Object namespace) {
        if (!(element instanceof NamedElement) || !(namespace instanceof Namespace)) {
            return false;
        }
        if (((NamedElement)element).getNamespace() == namespace) {
            return true;
        }
        try {
            this.getRunnableClassForAddCommand((Element)((Namespace)namespace), (Element)((NamedElement)element));
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return true;
    }

    @Override
    public void removeAnnotatedElement(final Object comment, final Object annotatedElement) {
        if (!(annotatedElement instanceof Element)) {
            throw new IllegalArgumentException("annotatedElement must be instance of Element");
        }
        if (!(comment instanceof Comment)) {
            throw new IllegalArgumentException("comment must be instance of Comment");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Comment)comment).getAnnotatedElements().remove((Object)((Element)annotatedElement));
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Remove the link between the comment # and the element #", comment, annotatedElement));
    }

    @Override
    public void removeClientDependency(final Object handle, final Object dep) {
        if (!(handle instanceof NamedElement)) {
            throw new IllegalArgumentException("handle must be instance of NamedElement");
        }
        if (!(dep instanceof Dependency)) {
            throw new IllegalArgumentException("dep must be instance of Dependency");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((NamedElement)handle).getClientDependencies().remove(dep);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Remove the client dependency # from the element #", handle, dep));
    }

    @Override
    public void removeConnection(final Object handle, final Object connection) {
        if (!(handle instanceof Association)) {
            throw new IllegalArgumentException("handle must be instance of Association");
        }
        if (!(connection instanceof Property)) {
            throw new IllegalArgumentException("connection must be instance of Property");
        }
        final Association association = (Association)handle;
        RunnableClass run = new RunnableClass(){

            public void run() {
                if (association.getOwnedEnds().contains(connection)) {
                    association.getOwnedEnds().remove(connection);
                }
                if (((Property)connection).getAssociation() == handle) {
                    ((Property)connection).setAssociation(null);
                }
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Remove the association end # from the association #", connection, handle));
    }

    @Override
    public void removeConstraint(Object handle, Object cons) {
        throw new NotYetImplementedException();
    }

    @Override
    public void removeDeploymentLocation(Object handle, Object node) {
        throw new NotYetImplementedException();
    }

    @Override
    public void removeElementResidence(Object handle, Object residence) {
        throw new NotYetImplementedException();
    }

    @Override
    public void removeFeature(Object cls, Object feature) {
        this.removeOwnedElement(cls, feature);
    }

    @Override
    public void removeLiteral(Object enumeration, Object literal) {
        this.removeOwnedElement(enumeration, literal);
    }

    @Override
    public void removeOwnedElement(Object handle, Object value) {
        if (!(handle instanceof Element)) {
            throw new IllegalArgumentException("handle must be instance of Element");
        }
        if (!(value instanceof Element)) {
            throw new IllegalArgumentException("value must be instance of Element");
        }
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, this.getRunnableClassForRemoveCommand((Element)value), "Remove the element # from the owner #", value, handle));
    }

    @Override
    public void removeParameter(Object handle, Object parameter) {
        this.removeOwnedElement(handle, parameter);
    }

    @Override
    public void removeQualifier(Object handle, Object qualifier) {
        this.removeOwnedElement(handle, qualifier);
    }

    @Override
    public void removeSourceFlow(Object handle, Object flow) {
        throw new NotYetImplementedException();
    }

    @Override
    public void removeStereotype(final Object modelElement, final Object stereo) {
        UMLUtil.checkArgs(new Object[]{modelElement, stereo}, new java.lang.Class[]{Element.class, Stereotype.class});
        RunnableClass run = new RunnableClass(){

            public void run() {
                Stereotype stereotype = (Stereotype)stereo;
                ((Element)modelElement).unapplyStereotype(stereotype);
                this.fireUnapplyStereotypeEvent(modelElement, stereotype);
            }

            private void fireUnapplyStereotypeEvent(Object modelElement2, Object stereotype) {
                ModelEventPumpEUMLImpl pump = (ModelEventPumpEUMLImpl)Model.getPump();
                pump.fireEvent(modelElement2, stereotype, null, 4, "stereotype", null);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Remove the stereotype # from the element #", stereo, modelElement));
    }

    @Override
    public void removeSupplierDependency(final Object supplier, final Object dependency) {
        if (!(supplier instanceof NamedElement)) {
            throw new IllegalArgumentException("supplier must be instance of NamedElement");
        }
        if (!(dependency instanceof Dependency)) {
            throw new IllegalArgumentException("dependency must be instance of Dependency");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Dependency)dependency).getSuppliers().remove(supplier);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Remove the supplier # from the dependency #", supplier, dependency));
    }

    @Override
    public void removeTargetFlow(Object handle, Object flow) {
        throw new NotYetImplementedException();
    }

    @Override
    public void removeTemplateArgument(Object binding, Object argument) {
        throw new NotYetImplementedException();
    }

    @Override
    public void removeTemplateParameter(Object handle, Object parameter) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setAbstract(final Object handle, final boolean isAbstract) {
        if (!(handle instanceof Classifier) && !(handle instanceof BehavioralFeature)) {
            throw new IllegalArgumentException("handle must be instance of Classifier or BehavioralFeature");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                if (handle instanceof Classifier) {
                    ((Classifier)handle).setIsAbstract(isAbstract);
                } else if (handle instanceof BehavioralFeature) {
                    ((BehavioralFeature)handle).setIsAbstract(isAbstract);
                }
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set isAbstract to # for #", isAbstract, handle));
    }

    @Override
    public void setActive(final Object handle, final boolean isActive) {
        if (!(handle instanceof Class)) {
            throw new IllegalArgumentException("handle must be instance of UML2 Class");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Class)handle).setIsActive(isActive);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set isActive to # for #", isActive, handle));
    }

    @Override
    public void setAggregation(Object handle, Object aggregationKind) {
        this.setAggregation2(handle, aggregationKind);
    }

    @Override
    public void setAggregation1(Object handle, Object aggregationKind) {
        Property p = (Property)handle;
        Association ass = p.getAssociation();
        Collection assEnds = this.modelImpl.getFacade().getConnections(ass);
        Iterator it = assEnds.iterator();
        Object other = it.next();
        if (other == handle) {
            other = it.next();
        }
        this.setAggregation2(handle, aggregationKind);
    }

    @Override
    public void setAggregation2(Object handle, Object aggregationKind) {
        if (!(handle instanceof Property)) {
            throw new IllegalArgumentException("handle must be instance of Property");
        }
        if (!(aggregationKind instanceof AggregationKind)) {
            throw new IllegalArgumentException("aggregationKind must be instance of AggregationKind " + aggregationKind + " recieved");
        }
        final Property property = (Property)handle;
        final AggregationKind aggregation = (AggregationKind)aggregationKind;
        RunnableClass run = new RunnableClass(){

            public void run() {
                property.setAggregation(aggregation);
                if (aggregation == AggregationKind.COMPOSITE_LITERAL || aggregation == AggregationKind.SHARED_LITERAL) {
                    for (Property end : property.getAssociation().getMemberEnds()) {
                        if (end.equals(property)) continue;
                        end.setAggregation(AggregationKind.NONE_LITERAL);
                    }
                }
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set the aggregation # to the association end #", aggregationKind, handle));
    }

    @Override
    public void setAnnotatedElements(final Object handle, final Collection elems) {
        if (!(handle instanceof Comment)) {
            throw new IllegalArgumentException("handle must be instance of Comment");
        }
        if (elems == null) {
            throw new NullPointerException("elems must be non-null");
        }
        for (Object o : elems) {
            if (o instanceof Element) continue;
            throw new IllegalArgumentException("the collection must contain only instances of Element");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Comment)handle).getAnnotatedElements().clear();
                for (Object o : elems) {
                    ((Comment)handle).getAnnotatedElements().add((Object)((Element)o));
                }
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set # annotated alements for the comment #", elems.size(), handle));
    }

    @Override
    public void setAssociation(Object handle, Object association) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setAttributes(Object classifier, List attributes) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setBody(Object handle, Object expr) {
        throw new NotImplementedException();
    }

    @Override
    public void setBody(Object handle, String body) {
        if (handle instanceof Comment) {
            ((Comment)handle).setBody(body);
            return;
        }
        if (handle instanceof Operation) {
            OpaqueBehavior methodImpl = null;
            for (Behavior impl : ((Operation)handle).getMethods()) {
                if (!(impl instanceof OpaqueBehavior)) continue;
                methodImpl = (OpaqueBehavior)impl;
                break;
            }
            if (methodImpl == null) {
                methodImpl = UMLFactory.eINSTANCE.createOpaqueBehavior();
                methodImpl.setSpecification((BehavioralFeature)((Operation)handle));
                ((Operation)handle).getMethods().add((Object)methodImpl);
            }
            if (methodImpl.isSetLanguages()) {
                int bodyIndex = 0;
                for (String language : methodImpl.getLanguages()) {
                    if ("java".equals(language)) {
                        methodImpl.getBodies().set(bodyIndex, (Object)body);
                        return;
                    }
                    ++bodyIndex;
                }
            }
            methodImpl.getLanguages().add((Object)"java");
            methodImpl.getBodies().add((Object)body);
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Deprecated
    public void setChangeability(Object handle, Object ck) {
        throw new NotImplementedException();
    }

    @Override
    public void setChild(final Object handle, final Object child) {
        if (!(handle instanceof Generalization)) {
            throw new IllegalArgumentException("handle must be instance of Generalization");
        }
        if (!(child instanceof Classifier)) {
            throw new IllegalArgumentException("child must be instance of Classifier");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Generalization)handle).setSpecific((Classifier)child);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set the # as the specific classifier of the generalization #", child, handle));
    }

    @Override
    public void setConcurrency(final Object handle, final Object concurrencyKind) {
        UMLUtil.checkArgs(new Object[]{handle, concurrencyKind}, new java.lang.Class[]{Element.class, CallConcurrencyKind.class});
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Operation)handle).setConcurrency((CallConcurrencyKind)concurrencyKind);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set the concurrencyKind # of the element #", concurrencyKind, handle));
    }

    @Override
    public void setConnections(Object handle, Collection ends) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setContainer(Object handle, Object component) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setDefaultElement(Object handle, Object element) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setDefaultValue(Object handle, Object expression) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setDiscriminator(Object handle, String discriminator) {
        throw new NotImplementedException();
    }

    @Override
    public void setEnumerationLiterals(Object enumeration, List literals) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setFeature(Object classifier, int index, Object feature) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setFeatures(Object classifier, Collection features) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setInitialValue(Object attribute, Object expression) {
        ((Property)attribute).setDefaultValue((ValueSpecification)expression);
    }

    @Override
    public void setKind(Object handle, Object kind) {
        if (handle instanceof Parameter && kind instanceof ParameterDirectionKind) {
            ((Parameter)handle).setDirection((ParameterDirectionKind)kind);
            return;
        }
        if (handle instanceof Pseudostate && kind instanceof PseudostateKind) {
            ((Pseudostate)handle).setKind((PseudostateKind)kind);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or kind: " + kind);
    }

    @Override
    public void setLeaf(final Object handle, final boolean isLeaf) {
        if (!(handle instanceof RedefinableElement)) {
            throw new IllegalArgumentException("handle must be instance of RedefinableElement");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((RedefinableElement)handle).setIsLeaf(isLeaf);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set isLeaf to # for #", isLeaf, handle));
    }

    @Override
    public void setModelElementContainer(Object handle, Object container) {
        this.addOwnedElement(container, handle);
    }

    @Override
    @Deprecated
    public void setMultiplicity(Object handle, Object arg) {
        throw new NotImplementedException();
    }

    @Override
    public void setMultiplicity(final Object handle, String arg) {
        if (!(handle instanceof MultiplicityElement)) {
            throw new IllegalArgumentException("A MultiplicityElement was expected");
        }
        if (arg == null || arg.equals("")) {
            RunnableClass run = new RunnableClass(){

                public void run() {
                    ((MultiplicityElement)handle).setLowerValue(null);
                    ((MultiplicityElement)handle).setUpperValue(null);
                }
            };
            this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Removing the multiplicity from element #", handle));
            return;
        }
        int[] range = this.parseMultiplicity(arg);
        this.setMultiplicity(handle, range[0], range[1]);
    }

    private int[] parseMultiplicity(String arg) {
        int lower = 1;
        int upper = 1;
        if ("*".equals(arg.trim())) {
            lower = 0;
            upper = -1;
        } else if (arg.contains("..")) {
            String[] pieces = arg.trim().split("\\.\\.");
            if (pieces.length > 2) {
                throw new IllegalArgumentException(arg);
            }
            lower = Integer.parseInt(pieces[0]);
            upper = "*".equals(pieces[1]) ? -1 : Integer.parseInt(pieces[1]);
        } else if (arg.contains("_")) {
            String[] pieces = arg.trim().split("_");
            if (pieces.length > 2) {
                throw new IllegalArgumentException(arg);
            }
            lower = Integer.parseInt(pieces[0]);
            upper = "*".equals(pieces[1]) || "N".equals(pieces[1]) ? -1 : Integer.parseInt(pieces[1]);
        } else {
            upper = lower = Integer.parseInt(arg);
        }
        return new int[]{lower, upper};
    }

    @Override
    public void setMultiplicity(final Object handle, final int lower, final int upper) {
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((MultiplicityElement)handle).setLowerValue(null);
                ((MultiplicityElement)handle).setUpperValue(null);
                ((MultiplicityElement)handle).setLower(lower);
                ((MultiplicityElement)handle).setUpper(upper);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set the multiplicity #..# to the element #", lower, upper, handle));
    }

    @Override
    public void setName(final Object handle, final String name) {
        if (!(handle instanceof NamedElement)) {
            if (handle instanceof Generalization) {
                LOG.warn((Object)("Attempting to set the name of a generalization which is no longer a NamedElement in UML 2" + name + handle.toString()));
                return;
            }
            throw new IllegalArgumentException("handle must be instance of NamedElement");
        }
        if (name == null) {
            throw new NullPointerException("name must be non-null");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((NamedElement)handle).setName(name);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set the name \"#\" to the named element #", name, handle));
    }

    @Override
    public void setNamespace(Object handle, Object ns) {
        this.addOwnedElement(ns, handle);
    }

    @Override
    public void setNavigable(Object handle, final boolean flag) {
        if (!(handle instanceof Property)) {
            throw new IllegalArgumentException("handle must be instance of Property");
        }
        final Property prop = (Property)handle;
        if (flag == prop.isNavigable()) {
            return;
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                if (!flag) {
                    ModelEventPumpEUMLImpl pump = (ModelEventPumpEUMLImpl)Model.getPump();
                    pump.addElementForDeleteEventIgnore((Element)prop);
                }
                prop.setIsNavigable(flag);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set isNavigable to # for the association end #", flag, handle));
    }

    @Override
    public void setOperations(Object classifier, List operations) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setOrdering(Object handle, Object ordering) {
        ((MultiplicityElement)handle).setIsOrdered("ordered".equals(ordering));
    }

    @Override
    public void setOwner(Object handle, Object owner) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setParameter(Object handle, Object parameter) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setParameters(Object handle, Collection parameters) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setParent(final Object handle, final Object parent) {
        if (!(handle instanceof Generalization)) {
            throw new IllegalArgumentException("handle must be instance of Generalization");
        }
        if (!(parent instanceof Classifier)) {
            throw new IllegalArgumentException("parent must be instance of Classifier");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Generalization)handle).setGeneral((Classifier)parent);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set the # as the general classifier of the generalization #", parent, handle));
    }

    @Override
    public void setPowertype(Object handle, Object powerType) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setQualifiers(Object handle, List qualifiers) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setQuery(final Object handle, final boolean isQuery) {
        if (!(handle instanceof Operation)) {
            throw new IllegalArgumentException("handle must be instance of Operation");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Operation)handle).setIsQuery(isQuery);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set isQuery to # for the operation #", isQuery, handle));
    }

    @Override
    public void setRaisedSignals(Object handle, Collection raisedSignals) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setReadOnly(final Object handle, final boolean isReadOnly) {
        if (!(handle instanceof StructuralFeature)) {
            throw new IllegalArgumentException("handle must be instance of StructuralFeature");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((StructuralFeature)handle).setIsReadOnly(isReadOnly);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set isReadOnly to # for the structural feature #", isReadOnly, handle));
    }

    @Override
    public void setResident(Object handle, Object resident) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setResidents(Object handle, Collection residents) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setRoot(Object handle, boolean isRoot) {
        throw new NotImplementedException();
    }

    @Override
    public void setSources(Object handle, Collection specifications) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setSpecification(Object handle, boolean isSpecification) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setSpecification(Object method, Object specification) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setSpecification(Object operation, String specification) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setSpecifications(Object handle, Collection specifications) {
        throw new NotYetImplementedException();
    }

    @Override
    public void setStatic(final Object feature, final boolean isStatic) {
        if (!(feature instanceof Feature)) {
            throw new IllegalArgumentException("feature must be instance of Feature");
        }
        RunnableClass run = new RunnableClass(){

            public void run() {
                ((Feature)feature).setIsStatic(isStatic);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set isStatic to # for the feature #", isStatic, feature));
    }

    @Override
    @Deprecated
    public void setTaggedValue(Object handle, String tag, String value) {
        throw new NotYetImplementedException();
    }

    @Override
    @Deprecated
    public void setTargetScope(Object handle, Object targetScope) {
        throw new NotImplementedException();
    }

    @Override
    public void setType(Object handle, final Object type) {
        if (!(handle instanceof TypedElement) && !(handle instanceof Operation)) {
            throw new IllegalArgumentException("handle must be instance of TypedElement");
        }
        if (type != null && !(type instanceof Type)) {
            throw new IllegalArgumentException("type must be instance of Type");
        }
        final TypedElement typedElement = handle instanceof Operation ? (TypedElement)this.getReturnParameters(handle).get(0) : (TypedElement)handle;
        RunnableClass run = new RunnableClass(){

            public void run() {
                typedElement.setType((Type)type);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set the type # for the typed element #", type, handle));
    }

    @Override
    public void setVisibility(Object handle, final Object visibility) {
        if (!(handle instanceof NamedElement)) {
            throw new IllegalArgumentException("handle must be instance of NamedElement");
        }
        if (!(visibility instanceof VisibilityKind)) {
            throw new IllegalArgumentException("visibility must be instance of VisibilityKind");
        }
        final NamedElement namedElement = (NamedElement)handle;
        RunnableClass run = new RunnableClass(){

            public void run() {
                namedElement.setVisibility((VisibilityKind)visibility);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.modelImpl, run, "Set the visibility # to the named element #", visibility, handle));
    }

    @Override
    public Collection getParents(Object generalizableElement) {
        throw new NotYetImplementedException();
    }

    @Override
    public Object getPackageImport(Object supplier, Object client) {
        throw new NotYetImplementedException();
    }

    @Override
    public Collection getPackageImports(Object client) {
        throw new NotYetImplementedException();
    }
}

