/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.HashSet;
import tudresden.ocl.ConstraintNameFinder;
import tudresden.ocl.NameCreator;
import tudresden.ocl.check.NameBoundQueryable;
import tudresden.ocl.check.QueryableFactory;
import tudresden.ocl.check.TypeCheckerFactory;
import tudresden.ocl.check.TypeQueryable;
import tudresden.ocl.check.bootstrap.GeneratedTests;
import tudresden.ocl.check.bootstrap.SableNameAdapter;
import tudresden.ocl.check.bootstrap.SableOclFactory;
import tudresden.ocl.check.types.DefaultTypeFactory;
import tudresden.ocl.check.types.ModelFacade;
import tudresden.ocl.check.types.Type;
import tudresden.ocl.check.types.TypeFactory;
import tudresden.ocl.codegen.CodeFragment;
import tudresden.ocl.codegen.CodeGenerator;
import tudresden.ocl.lib.Ocl;
import tudresden.ocl.normalize.CompoundNormalizer;
import tudresden.ocl.normalize.ConstraintNaming;
import tudresden.ocl.normalize.DefaultContextInsertion;
import tudresden.ocl.normalize.IteratorInsertion;
import tudresden.ocl.normalize.MultipleIteratorSolving;
import tudresden.ocl.normalize.NormalizerPass;
import tudresden.ocl.normalize.PreconditionViolatedException;
import tudresden.ocl.normalize.TypeInformationInsertion;
import tudresden.ocl.normalize.VariableClarification;
import tudresden.ocl.parser.OclParser;
import tudresden.ocl.parser.OclParserException;
import tudresden.ocl.parser.lexer.Lexer;
import tudresden.ocl.parser.lexer.LexerException;
import tudresden.ocl.parser.node.Node;
import tudresden.ocl.parser.node.Start;
import tudresden.ocl.parser.node.Switch;
import tudresden.ocl.parser.node.Switchable;
import tudresden.ocl.parser.parser.ParserException;

public class OclTree
implements NameBoundQueryable,
TypeQueryable,
Switchable {
    protected static final String NAME_SEPARATOR = "; ";
    protected Start ast;
    protected String name;
    protected HashSet invariants;
    protected NameCreator nameCreator;
    protected TypeQueryable typeQueryable;
    protected NameBoundQueryable nameBoundQueryable;
    protected QueryableFactory qFactory = new TypeCheckerFactory();
    protected TypeFactory tFactory;

    public OclTree(Start ast) {
        this();
        this.ast = ast;
        ConstraintNameFinder nameFinder = new ConstraintNameFinder();
        ast.apply(nameFinder);
        this.name = nameFinder.getName();
    }

    protected OclTree() {
        this.invariants = new HashSet();
    }

    public static OclTree createTree(String oclExpression, ModelFacade mf) throws OclParserException, IOException {
        return OclTree.createTree(oclExpression, mf, null);
    }

    /*
     * WARNING - void declaration
     */
    public static OclTree createTree(String oclExpression, ModelFacade mf, QueryableFactory qf) throws IOException {
        try {
            void e;
            Start startNode;
            OclTree tree = new OclTree();
            if (qf != null) {
                tree.setQueryableFactory(qf);
            }
            tree.tFactory = OclTree.createTypeFactory(mf);
            Lexer lexer = new Lexer(new PushbackReader(new StringReader(oclExpression), 2));
            OclParser p = new OclParser(lexer);
            tree.ast = startNode = p.parse();
            ConstraintNameFinder nameFinder = new ConstraintNameFinder();
            startNode.apply(nameFinder);
            tree.name = nameFinder.getName();
            return e;
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new OclParserException(e.getMessage() + " in string '" + oclExpression + "'");
        }
        catch (LexerException e) {
            e.printStackTrace();
            throw new OclParserException(e.getMessage() + " in string '" + oclExpression + "'");
        }
    }

    protected static TypeFactory createTypeFactory(ModelFacade mf) {
        return new DefaultTypeFactory(mf);
    }

    public void assureTypes() {
        this.checkTypeQueryable();
    }

    public void applyGeneratedTests() {
        Ocl.setNameAdapter(new SableNameAdapter());
        Ocl.setFactory(new SableOclFactory(this));
        GeneratedTests gt = new GeneratedTests();
        this.apply(gt);
    }

    public void applyDefaultNormalizations() {
        CompoundNormalizer cn = new CompoundNormalizer();
        NormalizerPass np1 = new NormalizerPass();
        NormalizerPass np2 = new NormalizerPass();
        cn.add(np1);
        cn.add(new MultipleIteratorSolving());
        cn.add(np2);
        cn.add(new VariableClarification());
        np1.add(new ConstraintNaming());
        np1.add(new IteratorInsertion());
        np2.add(new DefaultContextInsertion());
        np2.add(new TypeInformationInsertion());
        cn.normalize(this);
    }

    public boolean equalsExpression(OclTree tree) {
        return this.getExpression().equals(tree.getExpression());
    }

    public String getConstraintName() {
        return this.name;
    }

    public Start getRoot() {
        return this.ast;
    }

    public String getExpression() {
        return this.ast.toString();
    }

    public void setNameCreator(NameCreator nc) {
        this.nameCreator = nc;
        this.nameCreator.reserveAllNames(this);
    }

    public NameCreator getNameCreator() {
        if (this.nameCreator == null) {
            this.nameCreator = new NameCreator();
            this.nameCreator.reserveAllNames(this);
        }
        return this.nameCreator;
    }

    public void assureInvariant(String oclConstraint) {
        this.invariants.add(oclConstraint.trim());
    }

    public boolean fulfillsInvariant(String oclConstraint) {
        return this.invariants.contains(oclConstraint.trim());
    }

    public void requireInvariant(String oclConstraint) throws PreconditionViolatedException {
        if (!this.fulfillsInvariant(oclConstraint)) {
            throw new PreconditionViolatedException(oclConstraint);
        }
    }

    public void breakInvariant(String oclConstraint) {
        this.invariants.remove(oclConstraint.trim());
    }

    public String toString() {
        if (this.ast == null) {
            return "empty OCLTree";
        }
        return this.getExpression();
    }

    public void apply(Switch s) {
        this.ast.apply(s);
    }

    public CodeFragment[] getCode(CodeGenerator cgen) {
        return cgen.getCode(this);
    }

    public String getDefaultContext(Node n) {
        this.checkNameBoundQueryable();
        return this.nameBoundQueryable.getDefaultContext(n);
    }

    public void changeNotify() {
        this.changeNotify(this.ast);
    }

    public void changeNotify(Node subtree) {
        this.checkNameBoundQueryable();
        this.nameBoundQueryable.changeNotify(subtree);
        if (this.nameBoundQueryable != this.typeQueryable && this.typeQueryable != null) {
            this.typeQueryable.changeNotify(subtree);
        }
    }

    public Type getTypeFor(String name, Node node) {
        this.checkTypeQueryable();
        return this.typeQueryable.getTypeFor(name, node);
    }

    public Type getNodeType(Node n) {
        this.checkTypeQueryable();
        return this.typeQueryable.getNodeType(n);
    }

    public boolean isNameBound(String name, Node node) {
        this.checkNameBoundQueryable();
        return this.nameBoundQueryable.isNameBound(name, node);
    }

    public HashSet getBoundNames(Node n) {
        this.checkNameBoundQueryable();
        return this.nameBoundQueryable.getBoundNames(n);
    }

    protected void checkNameBoundQueryable() {
        if (this.nameBoundQueryable == null) {
            this.nameBoundQueryable = this.qFactory.getNameBoundQueryable(this.typeQueryable, this, this.tFactory);
            this.ast.apply(this.nameBoundQueryable);
        }
    }

    protected void checkTypeQueryable() {
        if (this.typeQueryable == null) {
            this.typeQueryable = this.qFactory.getTypeQueryable(this.nameBoundQueryable, this, this.tFactory);
            this.ast.apply(this.typeQueryable);
        }
    }

    public void setQueryableFactory(QueryableFactory qf) {
        this.qFactory = qf;
    }
}

