/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.apache.log4j.Logger;
import org.argouml.model.UmlException;
import org.argouml.model.XmiReferenceRuntimeException;
import org.argouml.model.mdr.MDRModelImplementation;
import org.argouml.model.mdr.XmiReaderImpl;
import org.argouml.model.mdr.XmiReference;
import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.lib.jmi.util.DebugException;
import org.netbeans.lib.jmi.xmi.XmiContext;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmiReferenceResolverImpl
extends XmiContext {
    private static final Logger LOG = Logger.getLogger(XmiReferenceResolverImpl.class);
    private Map<String, Map<String, Object>> idToObject = Collections.synchronizedMap(new HashMap());
    private Map<String, XmiReference> mofidToXmiref;
    private String topSystemId;
    private Map<String, URL> pendingProfiles = new HashMap<String, URL>();
    private URI baseUri;
    private List<String> modulesPath = new ArrayList<String>();
    private Map<String, URL> urlMap = new HashMap<String, URL>();
    private Map<String, String> reverseUrlMap = new HashMap<String, String>();
    private boolean profile;
    private Map<String, String> public2SystemIds;
    private String modelPublicId;
    private MDRModelImplementation modelImpl;
    protected static final String[] CLASSPATH_MODEL_SUFFIXES = new String[]{"xml", "xmi"};

    XmiReferenceResolverImpl(RefPackage[] extents, XMIInputConfig config, Map<String, XmiReference> objectToXmiref, Map<String, String> publicIds, Map<String, Map<String, Object>> idToObject, List<String> searchDirs, boolean isProfile, String publicId, String systemId, MDRModelImplementation modelImplementation) {
        super(extents, config);
        this.modelImpl = modelImplementation;
        this.mofidToXmiref = objectToXmiref;
        this.modulesPath = searchDirs;
        this.profile = isProfile;
        this.public2SystemIds = publicIds;
        this.idToObject = idToObject;
        this.modelPublicId = publicId;
        if (isProfile) {
            if (publicId == null) {
                LOG.warn((Object)("Profile load with null public ID.  Using system ID - " + systemId));
                this.modelPublicId = publicId = systemId;
            }
            if (this.public2SystemIds.containsKey(this.modelPublicId)) {
                if (systemId.equals(this.public2SystemIds.get(publicId))) {
                    LOG.warn((Object)("Loaded profile is being re-read publicId = \"" + publicId + "\";  systemId = \"" + systemId + "\"."));
                } else {
                    LOG.warn((Object)("Profile with the duplicate publicId is being loaded! publicId = \"" + publicId + "\"; existing systemId = \"" + this.public2SystemIds.get(publicId) + "\"; new systemId = \"" + systemId + "\"."));
                }
            }
            this.public2SystemIds.put(publicId, systemId);
        }
    }

    public void register(String systemId, String xmiId, RefObject object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering XMI ID '" + xmiId + "' in system ID '" + systemId + "' to object with MOF ID '" + object.refMofId() + "'"));
        }
        if (this.topSystemId == null) {
            this.topSystemId = systemId;
            try {
                this.baseUri = new URI(systemId.substring(0, systemId.lastIndexOf(47) + 1));
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("Bad URI syntax for base URI from XMI document " + systemId), (Throwable)e);
                this.baseUri = null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Top system ID set to " + this.topSystemId));
            }
        }
        String resolvedSystemId = systemId;
        if (this.profile && systemId.equals(this.topSystemId)) {
            resolvedSystemId = this.modelPublicId;
        } else if (this.reverseUrlMap.get(systemId) != null) {
            resolvedSystemId = this.reverseUrlMap.get(systemId);
        } else {
            LOG.debug((Object)("Unable to map systemId - " + systemId));
        }
        RefObject o = this.getReferenceInt(resolvedSystemId, xmiId);
        if (o == null) {
            if (this.mofidToXmiref.containsKey(object.refMofId())) {
                XmiReference ref = this.mofidToXmiref.get(object.refMofId());
                LOG.debug((Object)"register called twice for the same object - ignoring second");
                LOG.debug((Object)(" - first reference = " + ref.getSystemId() + "#" + ref.getXmiId()));
                LOG.debug((Object)(" - 2nd reference   = " + systemId + "#" + xmiId));
                LOG.debug((Object)(" -   resolved system id   = " + resolvedSystemId));
            } else {
                this.registerInt(resolvedSystemId, xmiId, object);
                super.register(resolvedSystemId, xmiId, object);
            }
        } else if (o.equals(object)) {
            super.register(resolvedSystemId, xmiId, object);
        } else {
            LOG.error((Object)("Collision - multiple elements with same xmi.id : " + xmiId));
            throw new IllegalStateException("Multiple elements with same xmi.id");
        }
    }

    private RefObject getReferenceInt(String docId, String xmiId) {
        Map<String, Object> map = this.idToObject.get(docId);
        if (map != null) {
            RefObject result = (RefObject)map.get(xmiId);
            if (result == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("No internal reference for - " + docId + "#" + xmiId));
            }
            return result;
        }
        return null;
    }

    private void registerInt(String docId, String xmiId, RefObject object) {
        Map<String, Object> map = this.idToObject.get(docId);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.idToObject.put(docId, map);
        }
        map.put(xmiId, object);
        this.mofidToXmiref.put(object.refMofId(), new XmiReference(docId, xmiId));
    }

    public RefObject getReference(String docId, String xmiId) {
        RefObject ro = this.getReferenceInt(docId, xmiId);
        if (ro == null && !this.idToObject.containsKey(docId)) {
            ro = super.getReference(docId, xmiId);
        }
        if (ro == null) {
            LOG.error((Object)("Failed to resolve " + docId + "#" + xmiId));
        }
        return ro;
    }

    Map<String, Object> getIdToObjectMap() {
        return this.getIdToObjectMaps().get(this.topSystemId);
    }

    Map<String, Map<String, Object>> getIdToObjectMaps() {
        return this.idToObject;
    }

    void clearIdMaps() {
        this.getIdToObjectMap().clear();
        this.mofidToXmiref.clear();
        this.topSystemId = null;
    }

    public URL toURL(String systemId) {
        String exts;
        String suffix;
        String suffixWithExt;
        URL modelUrl;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("attempting to resolve Xmi Href --> '" + systemId + "'"));
        }
        if ((modelUrl = this.urlMap.get(suffixWithExt = (suffix = this.getSuffix(systemId)).replaceAll(exts = "\\.jar|\\.zip", ""))) == null) {
            if (this.public2SystemIds.containsKey(systemId)) {
                modelUrl = this.getValidURL(this.public2SystemIds.get(systemId));
            }
            if (modelUrl == null) {
                modelUrl = this.getValidURL(this.fixupURL(systemId));
            }
            if (modelUrl == null) {
                String modelUrlAsString = this.findModuleURL(suffix);
                if (modelUrlAsString != null && !"".equals(modelUrlAsString)) {
                    modelUrl = this.getValidURL(modelUrlAsString);
                }
                if (modelUrl == null) {
                    modelUrl = this.findModelUrlOnClasspath(systemId);
                }
                if (modelUrl == null) {
                    modelUrl = super.toURL(systemId);
                }
            }
            if (modelUrl != null) {
                LOG.info((Object)("Referenced model --> '" + modelUrl + "'"));
                this.urlMap.put(suffixWithExt, modelUrl);
                this.pendingProfiles.put(systemId, modelUrl);
                String relativeUri = systemId;
                try {
                    if (this.baseUri != null) {
                        relativeUri = this.baseUri.relativize(modelUrl.toURI()).toString();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("       system ID " + systemId + " modelUrl " + modelUrl + "\n  relativized as " + relativeUri));
                        }
                    } else {
                        relativeUri = systemId;
                    }
                }
                catch (URISyntaxException e) {
                    LOG.error((Object)("Error relativizing system ID " + systemId), (Throwable)e);
                    relativeUri = systemId;
                }
                this.reverseUrlMap.put(modelUrl.toString(), relativeUri);
                this.reverseUrlMap.put(systemId, relativeUri);
            }
        }
        return modelUrl;
    }

    private String findModuleURL(String moduleName) {
        if (this.modulesPath == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("findModuleURL: modulesPath.size() = " + this.modulesPath.size()));
        }
        for (String moduleDirectory : this.modulesPath) {
            String urlString;
            File candidate = new File(moduleDirectory, moduleName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("candidate '" + candidate.toString() + "' exists=" + candidate.exists()));
            }
            if (!candidate.exists()) continue;
            try {
                urlString = candidate.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException e) {
                return null;
            }
            return this.fixupURL(urlString);
        }
        if (this.public2SystemIds.containsKey(moduleName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Couldn't find user model (\"" + moduleName + "\") in modulesPath, attempt " + "to use a model stored within the zargo file."));
            }
            return moduleName;
        }
        return null;
    }

    private String getSuffix(String systemId) {
        int lastSlash = systemId.lastIndexOf("/");
        if (lastSlash > 0) {
            String suffix = systemId.substring(lastSlash + 1);
            return suffix;
        }
        return systemId;
    }

    private URL findModelUrlOnClasspath(String systemId) {
        String dot = ".";
        String modelName = systemId;
        if (this.public2SystemIds.containsKey(systemId)) {
            modelName = this.public2SystemIds.get(systemId);
        } else {
            int filenameIndex = systemId.lastIndexOf("/");
            if (filenameIndex > 0) {
                modelName = systemId.substring(filenameIndex + 1, systemId.length());
            } else {
                LOG.warn((Object)("Received systemId with no '/'" + systemId));
            }
            if (modelName.lastIndexOf(".") > 0) {
                modelName = modelName.substring(0, modelName.lastIndexOf("."));
            }
        }
        URL modelUrl = Thread.currentThread().getContextClassLoader().getResource(modelName);
        if (modelUrl == null) {
            modelUrl = ((Object)((Object)this)).getClass().getResource(modelName);
        }
        if (modelUrl == null && CLASSPATH_MODEL_SUFFIXES != null && CLASSPATH_MODEL_SUFFIXES.length > 0) {
            for (String suffix : CLASSPATH_MODEL_SUFFIXES) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("searching for model reference --> '" + modelUrl + "'"));
                }
                if ((modelUrl = Thread.currentThread().getContextClassLoader().getResource(modelName + "." + suffix)) != null || (modelUrl = ((Object)((Object)this)).getClass().getResource(modelName)) != null) break;
            }
        }
        return modelUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getValidURL(String systemId) {
        InputStream stream = null;
        URL url = null;
        try {
            url = new URL(systemId);
            stream = url.openStream();
            stream.close();
        }
        catch (MalformedURLException e) {
            url = null;
        }
        catch (IOException e) {
            url = null;
        }
        finally {
            stream = null;
        }
        return url;
    }

    private String fixupURL(String url) {
        String suffix = this.getSuffix(url);
        if (suffix.endsWith(".zargo")) {
            url = "jar:" + url + "!/" + suffix.substring(0, suffix.length() - 6) + ".xmi";
        } else if (suffix.endsWith(".zip") || suffix.endsWith(".jar")) {
            url = "jar:" + url + "!/" + suffix.substring(0, suffix.length() - 4);
        }
        return url;
    }

    public void readExternalDocument(String arg0) {
        URL url = this.pendingProfiles.remove(arg0);
        if (url != null) {
            InputSource is = new InputSource(url.toExternalForm());
            is.setPublicId(arg0);
            XmiReaderImpl reader = new XmiReaderImpl(this.modelImpl);
            try {
                reader.parse(is, true);
            }
            catch (UmlException e) {
                LOG.error((Object)("Error reading referenced profile " + arg0));
                throw new XmiReferenceRuntimeException(arg0, e);
            }
        }
        if (!this.public2SystemIds.containsKey(arg0)) {
            try {
                super.readExternalDocument(arg0);
            }
            catch (DebugException e) {
                LOG.error((Object)("Error reading external document " + arg0));
                throw new XmiReferenceRuntimeException(arg0, e);
            }
        }
    }
}

