//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `warn!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn warn() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = 3); // DEBUG:warn,tp,-,-,-,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3); // DEBUG:warn,tp,-,p,-,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = 3, qux = 3); // DEBUG:warn,tp,-,f,-,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3, qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = 3, "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3, "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = 3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = 3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = 3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = false); // DEBUG:warn,tp,-,-,-,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false); // DEBUG:warn,tp,-,p,-,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = false, qux = 3); // DEBUG:warn,tp,-,f,-,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false, qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = false, "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false, "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = false, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = false }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = false }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?3); // DEBUG:warn,tp,-,-,-,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3); // DEBUG:warn,tp,-,p,-,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?3, qux = 3); // DEBUG:warn,tp,-,f,-,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3, qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?3, "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3, "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %3); // DEBUG:warn,tp,-,-,-,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3); // DEBUG:warn,tp,-,p,-,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %3, qux = 3); // DEBUG:warn,tp,-,f,-,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3, qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %3, "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3, "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?deb); // DEBUG:warn,tp,-,-,-,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb); // DEBUG:warn,tp,-,p,-,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?deb, qux = 3); // DEBUG:warn,tp,-,f,-,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb, qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?deb, "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb, "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?deb }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?deb }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %disp); // DEBUG:warn,tp,-,-,-,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp); // DEBUG:warn,tp,-,p,-,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %disp, qux = 3); // DEBUG:warn,tp,-,f,-,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp, qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %disp, "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp, "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %disp }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %disp }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field); // DEBUG:warn,tp,-,-,-,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field); // DEBUG:warn,tp,-,p,-,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %sub.field); // DEBUG:warn,tp,-,-,-,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field); // DEBUG:warn,tp,-,p,-,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb)); // DEBUG:warn,tp,-,-,-,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb)); // DEBUG:warn,tp,-,p,-,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb), qux = 3); // DEBUG:warn,tp,-,f,-,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb), qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb), "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb), "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = debug(&deb) }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = display(&disp)); // DEBUG:warn,tp,-,-,-,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp)); // DEBUG:warn,tp,-,p,-,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = display(&disp), qux = 3); // DEBUG:warn,tp,-,f,-,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp), qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = display(&disp), "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp), "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = display(&disp) }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty); // DEBUG:warn,tp,-,-,-,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty); // DEBUG:warn,tp,-,p,-,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty, qux = 3); // DEBUG:warn,tp,-,f,-,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:warn,tp,-,pf,-,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,tp,-,-,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,tp,-,p,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,tp,{},-,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,tp,{},p,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3); // DEBUG:warn,tp,-,-,-,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3); // DEBUG:warn,tp,-,p,-,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3, qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3, qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3, "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3, "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = 3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = false); // DEBUG:warn,tp,-,-,-,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false); // DEBUG:warn,tp,-,p,-,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = false, qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false, qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = false, "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false, "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = false }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3); // DEBUG:warn,tp,-,-,-,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3); // DEBUG:warn,tp,-,p,-,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3, qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3, qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3, "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3); // DEBUG:warn,tp,-,-,-,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3); // DEBUG:warn,tp,-,p,-,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3, qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3, qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3, "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3, "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb); // DEBUG:warn,tp,-,-,-,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb); // DEBUG:warn,tp,-,p,-,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb, qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb, "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?deb }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp); // DEBUG:warn,tp,-,-,-,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp); // DEBUG:warn,tp,-,p,-,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp, qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp, qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp, "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %disp }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field); // DEBUG:warn,tp,-,-,-,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field); // DEBUG:warn,tp,-,p,-,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field); // DEBUG:warn,tp,-,-,-,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field); // DEBUG:warn,tp,-,p,-,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb)); // DEBUG:warn,tp,-,-,-,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb)); // DEBUG:warn,tp,-,p,-,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb), qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb), "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp)); // DEBUG:warn,tp,-,-,-,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp)); // DEBUG:warn,tp,-,p,-,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp), qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp), "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty); // DEBUG:warn,tp,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty); // DEBUG:warn,tp,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:warn,tp,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:warn,tp,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,tp,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,tp,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,tp,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,tp,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = 3); // DEBUG:warn,tp,-,-,-,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3); // DEBUG:warn,tp,-,p,-,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = 3, qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3, qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = 3, "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3, "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = 3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = 3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = false); // DEBUG:warn,tp,-,-,-,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false); // DEBUG:warn,tp,-,p,-,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = false, qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false, qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = false, "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false, "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = false, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = false }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = false }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?3); // DEBUG:warn,tp,-,-,-,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3); // DEBUG:warn,tp,-,p,-,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?3, qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3, qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?3, "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3, "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %3); // DEBUG:warn,tp,-,-,-,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3); // DEBUG:warn,tp,-,p,-,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %3, qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3, qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %3, "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3, "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb); // DEBUG:warn,tp,-,-,-,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb); // DEBUG:warn,tp,-,p,-,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb, qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb, qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb, "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb, "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?deb }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %disp); // DEBUG:warn,tp,-,-,-,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp); // DEBUG:warn,tp,-,p,-,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %disp, qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp, qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %disp, "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp, "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %disp }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field); // DEBUG:warn,tp,-,-,-,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field); // DEBUG:warn,tp,-,p,-,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field); // DEBUG:warn,tp,-,-,-,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field); // DEBUG:warn,tp,-,p,-,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb)); // DEBUG:warn,tp,-,-,-,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb)); // DEBUG:warn,tp,-,p,-,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb), qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb), "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = debug(&deb) }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp)); // DEBUG:warn,tp,-,-,-,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp)); // DEBUG:warn,tp,-,p,-,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp), qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp), qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp), "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = display(&disp) }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty); // DEBUG:warn,tp,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty); // DEBUG:warn,tp,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty, qux = 3); // DEBUG:warn,tp,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:warn,tp,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:warn,tp,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:warn,tp,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:warn,tp,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:warn,tp,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3, qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3, "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false, qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false, "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = false }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3, qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3, "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3, qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3, "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb, qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp, qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp, "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb)); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp)); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp)); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty); // DEBUG:warn,tp,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:warn,tp,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:warn,tp,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:warn,tp,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:warn,tp,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:warn,tp,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:warn,tp,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:warn,tp,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = 3); // DEBUG:warn,tp,-,-,-,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3); // DEBUG:warn,tp,-,p,-,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = 3, qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3, qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = 3, "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3, "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = 3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = 3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = 3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = false); // DEBUG:warn,tp,-,-,-,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false); // DEBUG:warn,tp,-,p,-,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = false, qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false, qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = false, "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false, "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = false, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = false }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = false }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = false, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = false, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","false"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?3); // DEBUG:warn,tp,-,-,-,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3); // DEBUG:warn,tp,-,p,-,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?3, qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3, qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?3, "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3, "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","?3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %3); // DEBUG:warn,tp,-,-,-,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3); // DEBUG:warn,tp,-,p,-,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %3, qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3, qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %3, "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3, "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %3 }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %3 }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","%3"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?deb); // DEBUG:warn,tp,-,-,-,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb); // DEBUG:warn,tp,-,p,-,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?deb, qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb, qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?deb, "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb, "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?deb }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %disp); // DEBUG:warn,tp,-,-,-,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp); // DEBUG:warn,tp,-,p,-,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %disp, qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp, qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %disp, "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp, "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %disp }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %disp }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field); // DEBUG:warn,tp,-,-,-,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field); // DEBUG:warn,tp,-,p,-,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field); // DEBUG:warn,tp,-,-,-,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field); // DEBUG:warn,tp,-,p,-,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb)); // DEBUG:warn,tp,-,-,-,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb)); // DEBUG:warn,tp,-,p,-,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb), qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb), qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb), "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = debug(&deb) }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","debug(&deb)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp)); // DEBUG:warn,tp,-,-,-,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp)); // DEBUG:warn,tp,-,p,-,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp), qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp), qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp), "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp), "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = display(&disp) }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","display(&disp)"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty); // DEBUG:warn,tp,-,-,-,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty); // DEBUG:warn,tp,-,p,-,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty, qux = 3); // DEBUG:warn,tp,-,f,-,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:warn,tp,-,pf,-,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty, "msg without args"); // DEBUG:warn,tp,-,-,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:warn,tp,-,p,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:warn,tp,{},-,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:warn,tp,{},p,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, var); // DEBUG:warn,tp,-,-,-,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, var); // DEBUG:warn,tp,-,p,-,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, var, qux = 3); // DEBUG:warn,tp,-,f,-,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, var, qux = 3); // DEBUG:warn,tp,-,pf,-,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, var, "msg without args"); // DEBUG:warn,tp,-,-,m,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, var, "msg without args"); // DEBUG:warn,tp,-,p,m,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, var, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, var, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { var }, "msg without args"); // DEBUG:warn,tp,{},-,m,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, var }, "msg without args"); // DEBUG:warn,tp,{},p,m,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { var, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, var, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, var, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { var }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,-,"var"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, sub.field); // DEBUG:warn,tp,-,-,-,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field); // DEBUG:warn,tp,-,p,-,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,-,"sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %disp); // DEBUG:warn,tp,-,-,-,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %disp); // DEBUG:warn,tp,-,p,-,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %disp, qux = 3); // DEBUG:warn,tp,-,f,-,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %disp, qux = 3); // DEBUG:warn,tp,-,pf,-,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %disp, "msg without args"); // DEBUG:warn,tp,-,-,m,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %disp, "msg without args"); // DEBUG:warn,tp,-,p,m,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %disp, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { %disp }, "msg without args"); // DEBUG:warn,tp,{},-,m,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, %disp }, "msg without args"); // DEBUG:warn,tp,{},p,m,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,-,"%disp"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?deb); // DEBUG:warn,tp,-,-,-,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb); // DEBUG:warn,tp,-,p,-,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?deb, qux = 3); // DEBUG:warn,tp,-,f,-,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb, qux = 3); // DEBUG:warn,tp,-,pf,-,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?deb, "msg without args"); // DEBUG:warn,tp,-,-,m,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb, "msg without args"); // DEBUG:warn,tp,-,p,m,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ?deb }, "msg without args"); // DEBUG:warn,tp,{},-,m,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ?deb }, "msg without args"); // DEBUG:warn,tp,{},p,m,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,-,"?deb"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %sub.field); // DEBUG:warn,tp,-,-,-,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field); // DEBUG:warn,tp,-,p,-,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { %sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, %sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,-,"%sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?sub.field); // DEBUG:warn,tp,-,-,-,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field); // DEBUG:warn,tp,-,p,-,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?sub.field, qux = 3); // DEBUG:warn,tp,-,f,-,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field, qux = 3); // DEBUG:warn,tp,-,pf,-,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?sub.field, "msg without args"); // DEBUG:warn,tp,-,-,m,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field, "msg without args"); // DEBUG:warn,tp,-,p,m,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,f,m,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,tp,-,pf,m,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},-,m,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ?sub.field }, "msg without args"); // DEBUG:warn,tp,{},p,m,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},f,m,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,tp,{},pf,m,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,-,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,p,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,f,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,tp,-,pf,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},-,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},p,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},f,ma,-,"?sub.field"
    tracing::warn!(target: "my::module", parent: ::core::option::Option::None, { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,tp,{},pf,ma,-,"?sub.field"
}
