--
-- SQL script to create the trigger(s) enabling the load API for
-- SGLD_Biosequences.
--
-- Scaffold auto-generated by gen-api.pl.
--
--
-- $Id: Biosequences.trg,v 1.1.1.2 2003-01-29 08:54:36 lapp Exp $
--

--
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE TRIGGER BIUR_Biosequences
       INSTEAD OF INSERT OR UPDATE
       ON SGLD_Biosequences
       REFERENCING NEW AS new OLD AS old
       FOR EACH ROW
DECLARE
	pk		SG_BIOSEQUENCE.OID%TYPE DEFAULT :new.Seq_Oid;
	do_DML		INTEGER DEFAULT BSStd.DML_NO;
BEGIN
	IF INSERTING THEN
		do_DML := BSStd.DML_I;
	ELSE
		-- this is an update
		do_DML := BSStd.DML_UI;
	END IF;
	-- do insert or update (depending on whether it exists or not)
	pk := Seq.get_oid(
			Seq_OID => pk,
		        Seq_VERSION => Seq_VERSION,
			Seq_LENGTH => Seq_LENGTH,
			Seq_SEQ => Seq_SEQ,
			do_DML             => do_DML);
END;
/
