/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.NodeToBytes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class SendMail
extends DefaultStep {
    public static final String NS_EMAIL = "URN:ietf:params:email-xml:";
    public static final String NS_RFC822 = "URN:ietf:params:rfc822:";
    public static final QName _content_type = new QName("content-type");
    public static final QName em_Message = new QName("em", "URN:ietf:params:email-xml:", "Message");
    public static final QName em_Address = new QName("em", "URN:ietf:params:email-xml:", "Address");
    public static final QName em_name = new QName("em", "URN:ietf:params:email-xml:", "name");
    public static final QName em_adrs = new QName("em", "URN:ietf:params:email-xml:", "adrs");
    public static final QName em_content = new QName("em", "URN:ietf:params:email-xml:", "content");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public SendMail(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        Object object;
        super.run();
        XdmNode xdmNode = S9apiUtils.getDocumentElement(this.source.read());
        if (!xdmNode.getNodeName().equals((Object)em_Message)) {
            throw new XProcException("cx:send-mail source is not an em:Message");
        }
        Properties properties = new Properties();
        if (this.runtime.getSendmailHost() != null) {
            properties.put("mail.smtp.host", this.runtime.getSendmailHost());
        }
        if (this.runtime.getSendmailPort() != null) {
            properties.put("mail.smtp.port", this.runtime.getSendmailPort());
        }
        if (this.runtime.getSendmailUsername() != null) {
            properties.put("mail.smtp.auth", "true");
        }
        MimeMultipart mimeMultipart = null;
        try {
            Object object2;
            MimeBodyPart mimeBodyPart;
            String string;
            XdmNode xdmNode2;
            object = new SMTPAuthenticator();
            Session session = Session.getDefaultInstance((Properties)properties, (Authenticator)object);
            session.setDebug(this.runtime.getDebug());
            MimeMessage mimeMessage = new MimeMessage(session);
            XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
            while (xdmSequenceIterator.hasNext()) {
                xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                if (!xdmNode2.getNodeKind().equals((Object)XdmNodeKind.ELEMENT)) continue;
                if (NS_RFC822.equals(xdmNode2.getNodeName().getNamespaceURI())) {
                    string = xdmNode2.getNodeName().getLocalName();
                    if ("to".equals(string)) {
                        InternetAddress[] internetAddressArray = this.parseAddresses(xdmNode2);
                        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
                        continue;
                    }
                    if ("from".equals(string)) {
                        InternetAddress internetAddress = this.parseAddress(xdmNode2);
                        mimeMessage.setFrom((Address)internetAddress);
                        continue;
                    }
                    if ("sender".equals(string)) {
                        InternetAddress internetAddress = this.parseAddress(xdmNode2);
                        mimeMessage.setSender((Address)internetAddress);
                        continue;
                    }
                    if ("subject".equals(string)) {
                        mimeMessage.setSubject(xdmNode2.getStringValue());
                        continue;
                    }
                    if ("cc".equals(string)) {
                        InternetAddress[] internetAddressArray = this.parseAddresses(xdmNode2);
                        mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])internetAddressArray);
                        continue;
                    }
                    if ("bcc".equals(string)) {
                        InternetAddress[] internetAddressArray = this.parseAddresses(xdmNode2);
                        mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])internetAddressArray);
                        continue;
                    }
                    throw new XProcException("Unexpected RFC 822 element in email message: " + string);
                }
                if (em_content.equals((Object)xdmNode2.getNodeName())) {
                    Object object3;
                    ByteArrayOutputStream byteArrayOutputStream;
                    boolean bl = false;
                    boolean bl2 = false;
                    Vector<XdmNode> vector = new Vector<XdmNode>();
                    mimeBodyPart = xdmNode2.axisIterator(Axis.CHILD);
                    while (mimeBodyPart.hasNext()) {
                        object2 = (XdmNode)mimeBodyPart.next();
                        vector.add((XdmNode)object2);
                        if (bl2 || bl) continue;
                        if (object2.getNodeKind().equals((Object)XdmNodeKind.ELEMENT)) {
                            bl2 = "http://www.w3.org/1999/xhtml".equals(object2.getNodeName().getNamespaceURI());
                            continue;
                        }
                        if (!object2.getNodeKind().equals((Object)XdmNodeKind.TEXT)) continue;
                        bl = !"".equals(object2.getStringValue().trim());
                    }
                    object2 = null;
                    String string2 = null;
                    if (bl2) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        object3 = new Serializer();
                        object3.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
                        object3.setOutputProperty(Serializer.Property.INDENT, "no");
                        object3.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                        object3.setOutputProperty(Serializer.Property.METHOD, "html");
                        object3.setOutputStream((OutputStream)byteArrayOutputStream);
                        S9apiUtils.serialize(this.runtime, vector, object3);
                        object2 = byteArrayOutputStream.toString();
                        string2 = "text/html; charset=utf-8";
                    } else {
                        object2 = xdmNode2.getStringValue();
                        string2 = "text/plain; charset=utf-8";
                    }
                    if (this.source.moreDocuments()) {
                        mimeMultipart = new MimeMultipart();
                        byteArrayOutputStream = new MimeBodyPart();
                        object3 = new PartDataSource(((String)object2).getBytes("utf-8"), string2, "irrelevant");
                        byteArrayOutputStream.setDataHandler(new DataHandler((DataSource)object3));
                        byteArrayOutputStream.setDisposition("inline");
                        mimeMultipart.addBodyPart((BodyPart)byteArrayOutputStream);
                        continue;
                    }
                    mimeMessage.setContent(object2, string2);
                    continue;
                }
                throw new XProcException("Unexpected element in email message: " + xdmNode2.getNodeName());
            }
            while (this.source.moreDocuments()) {
                xdmNode2 = S9apiUtils.getDocumentElement(this.source.read());
                string = xdmNode2.getAttributeValue(_content_type);
                String string3 = xdmNode2.getBaseURI().getPath();
                int n = string3.lastIndexOf("/");
                if (n >= 0) {
                    string3 = string3.substring(n + 1);
                }
                if (string == null) {
                    string = "application/octet-stream";
                }
                mimeBodyPart = new MimeBodyPart();
                object2 = new PartDataSource(NodeToBytes.convert(this.runtime, xdmNode2, true), string, "irrelevant");
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)object2));
                mimeBodyPart.setFileName(string3);
                mimeBodyPart.setDisposition("attachment");
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            }
            mimeMessage.setContent(mimeMultipart);
            Transport.send((Message)mimeMessage);
        }
        catch (AddressException addressException) {
            throw new XProcException(addressException);
        }
        catch (MessagingException messagingException) {
            throw new XProcException(messagingException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XProcException(unsupportedEncodingException);
        }
        object = new TreeWriter(this.runtime);
        ((TreeWriter)object).startDocument(this.step.getNode().getBaseURI());
        ((TreeWriter)object).addStartElement(XProcConstants.c_result);
        ((TreeWriter)object).startContent();
        ((TreeWriter)object).addText("true");
        ((TreeWriter)object).addEndElement();
        ((TreeWriter)object).endDocument();
        this.result.write(((TreeWriter)object).getResult());
    }

    private InternetAddress parseAddress(XdmNode xdmNode) {
        InternetAddress internetAddress = null;
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            if (!xdmNode2.getNodeKind().equals((Object)XdmNodeKind.ELEMENT)) continue;
            if (em_Address.equals((Object)xdmNode2.getNodeName())) {
                if (internetAddress == null) {
                    internetAddress = this.parseEmail(xdmNode2);
                    continue;
                }
                throw new XProcException("Expected only a single email address in " + xdmNode.getNodeName());
            }
            throw new XProcException("Only <em:Address> is supported in " + xdmNode.getNodeName());
        }
        return internetAddress;
    }

    private InternetAddress[] parseAddresses(XdmNode xdmNode) {
        InternetAddress[] internetAddressArray;
        Vector<InternetAddress> vector = new Vector<InternetAddress>();
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            internetAddressArray = (InternetAddress[])xdmSequenceIterator.next();
            if (!internetAddressArray.getNodeKind().equals((Object)XdmNodeKind.ELEMENT)) continue;
            if (em_Address.equals((Object)internetAddressArray.getNodeName())) {
                vector.add(this.parseEmail((XdmNode)internetAddressArray));
                continue;
            }
            throw new XProcException("Only <em:Address> is supported in " + xdmNode.getNodeName());
        }
        internetAddressArray = new InternetAddress[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            internetAddressArray[i] = (InternetAddress)vector.get(i);
        }
        return internetAddressArray;
    }

    private InternetAddress parseEmail(XdmNode xdmNode) {
        XdmNode xdmNode2;
        String string = null;
        String string2 = null;
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            if (!xdmNode2.getNodeKind().equals((Object)XdmNodeKind.ELEMENT)) continue;
            if (em_name.equals((Object)xdmNode2.getNodeName())) {
                string = xdmNode2.getStringValue();
                continue;
            }
            if (em_adrs.equals((Object)xdmNode2.getNodeName())) {
                string2 = xdmNode2.getStringValue();
                continue;
            }
            throw new XProcException("Only <em:name> and <em:adrs> are supported in " + xdmNode.getNodeName());
        }
        if (string2 == null) {
            throw new XProcException("Email address specified without an <em:adrs>");
        }
        xdmNode2 = null;
        try {
            xdmNode2 = string == null ? new InternetAddress(string2) : new InternetAddress(string2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XProcException(unsupportedEncodingException);
        }
        catch (AddressException addressException) {
            throw new XProcException(addressException);
        }
        return xdmNode2;
    }

    private class PartDataSource
    implements DataSource {
        private byte[] data = null;
        private String contentType = null;
        private String name = null;

        public PartDataSource(byte[] byArray, String string, String string2) {
            this.data = byArray;
            this.contentType = string;
            this.name = string2;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new XProcException("Called getOutputStream() on PartDataSource for cx:send-mail???");
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return this.name;
        }
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private SMTPAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(SendMail.this.runtime.getSendmailUsername(), SendMail.this.runtime.getSendmailPassword());
        }
    }
}

