/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.XPointer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class XInclude
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName xi_include = new QName("http://www.w3.org/2001/XInclude", "include");
    private static final QName xi_fallback = new QName("http://www.w3.org/2001/XInclude", "fallback");
    private static final QName _fixup_xml_base = new QName("", "fixup-xml-base");
    private static final QName _fixup_xml_lang = new QName("", "fixup-xml-lang");
    private static final QName cx_mark_roots = new QName("cx", "http://xmlcalabash.com/ns/extensions", "mark-roots");
    private static final QName cx_copy_attributes = new QName("cx", "http://xmlcalabash.com/ns/extensions", "copy-attributes");
    private static final QName cx_root = new QName("cx", "http://xmlcalabash.com/ns/extensions", "root");
    private static final QName _encoding = new QName("", "encoding");
    private static final QName _href = new QName("", "href");
    private static final QName _parse = new QName("", "parse");
    private static final QName _xpointer = new QName("", "xpointer");
    private static final Pattern linesXptrRE = Pattern.compile("\\s*lines\\s*\\(\\s*(\\d+)\\s*-\\s*(\\d+)\\s*\\)\\s*");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Stack<ProcessMatch> matcherStack = new Stack();
    private Stack<String> inside = new Stack();
    private boolean fixupBase = false;
    private boolean fixupLang = false;
    private boolean markRoots = false;
    private boolean copyAttributes = false;
    private Exception mostRecentException = null;

    public XInclude(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.fixupBase = this.getOption(_fixup_xml_base, false);
        this.fixupLang = this.getOption(_fixup_xml_lang, false);
        String string = this.getStep().getExtensionAttribute(cx_copy_attributes);
        if (string != null && !"false".equals(string)) {
            if ("true".equals(string)) {
                this.copyAttributes = true;
            } else {
                throw new XProcException("On p:xinclude, cx:copy-attributes must be 'true' or 'false'.");
            }
        }
        if ((string = this.getStep().getExtensionAttribute(cx_mark_roots)) != null && !"false".equals(string)) {
            if ("true".equals(string)) {
                this.markRoots = true;
            } else {
                throw new XProcException("On p:xinclude, cx:mark-roots must be 'true' or 'false'.");
            }
        }
        XdmNode xdmNode = this.source.read();
        XdmNode xdmNode2 = this.expandXIncludes(xdmNode);
        this.result.write(xdmNode2);
    }

    private XdmNode expandXIncludes(XdmNode xdmNode) {
        this.finest(xdmNode, "Starting expandXIncludes");
        ProcessMatch processMatch = new ProcessMatch(this.runtime, this);
        this.matcherStack.push(processMatch);
        processMatch.match(xdmNode, new RuntimeValue("/|*", this.step.getNode()));
        XdmNode xdmNode2 = processMatch.getResult();
        processMatch = this.matcherStack.pop();
        return xdmNode2;
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        this.matcherStack.peek().startDocument(xdmNode.getBaseURI());
        return true;
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
        this.matcherStack.peek().endDocument();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        ProcessMatch processMatch = this.matcherStack.peek();
        if (xi_include.equals((Object)xdmNode.getNodeName())) {
            Object object;
            String string = xdmNode.getAttributeValue(_href);
            String string2 = xdmNode.getAttributeValue(_parse);
            String string3 = xdmNode.getAttributeValue(_xpointer);
            XPointer xPointer = null;
            XdmNode xdmNode2 = null;
            if (string3 != null) {
                xPointer = new XPointer(string3);
            }
            if ("text".equals(string2)) {
                if (!this.runtime.getAllowXPointerOnText() && xPointer != null) {
                    throw XProcException.stepError(1, "XPointer is not allowed on XInclude when parse='text'");
                }
                String string4 = this.readText(string, xdmNode, xdmNode.getBaseURI().toASCIIString(), xPointer);
                if (string4 == null) {
                    this.finest(xdmNode, "XInclude text parse failed: " + string);
                    this.fallback(xdmNode, string);
                    return false;
                }
                this.finest(xdmNode, "XInclude text parse: " + string);
                processMatch.addText(string4);
                return false;
            }
            xdmNode2 = this.readXML(string, xdmNode.getBaseURI().toASCIIString());
            String string5 = null;
            if (xdmNode2 == null) {
                this.finest(xdmNode, "XInclude parse failed: " + string);
                this.fallback(xdmNode, string);
                return false;
            }
            string5 = xdmNode2.getBaseURI().toASCIIString();
            if (string3 != null) {
                string5 = string5 + "#" + string3;
            }
            if (this.inside.contains(string5)) {
                throw XProcException.stepError(29, "XInclude document includes itself: " + string);
            }
            this.finest(xdmNode, "XInclude parse: " + string);
            Vector<Object> vector = null;
            if (xPointer == null) {
                vector = new Vector();
                object = xdmNode2.axisIterator(Axis.CHILD);
                while (object.hasNext()) {
                    XdmNode xdmNode3 = (XdmNode)object.next();
                    vector.add(xdmNode3);
                }
            } else {
                object = xPointer.xpathNamespaces();
                vector = xPointer.selectNodes(this.runtime, xdmNode2);
            }
            for (XdmNode xdmNode3 : vector) {
                void var11_16;
                Fixup fixup;
                if ((this.fixupBase || this.fixupLang || this.markRoots || this.copyAttributes) && xdmNode3.getNodeKind() == XdmNodeKind.ELEMENT) {
                    fixup = new Fixup(this.runtime, xdmNode);
                    XdmNode xdmNode4 = fixup.fixup(xdmNode3);
                }
                if (var11_16.getNodeKind() == XdmNodeKind.ELEMENT || var11_16.getNodeKind() == XdmNodeKind.DOCUMENT) {
                    this.inside.push(string5);
                    fixup = this.expandXIncludes((XdmNode)var11_16);
                    processMatch.addSubtree((XdmNode)fixup);
                    this.inside.pop();
                    continue;
                }
                processMatch.addSubtree((XdmNode)var11_16);
            }
            return false;
        }
        processMatch.addStartElement(xdmNode);
        processMatch.addAttributes(xdmNode);
        processMatch.startContent();
        return true;
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        throw new UnsupportedOperationException("processAttribute can't happen in XInclude");
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
        if (!xi_include.equals((Object)xdmNode.getNodeName())) {
            this.matcherStack.peek().addEndElement();
        }
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        throw new UnsupportedOperationException("processText can't happen in XInclude");
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        throw new UnsupportedOperationException("processComment can't happen in XInclude");
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        throw new UnsupportedOperationException("processPI can't happen in XInclude");
    }

    public String readText(String string, XdmNode xdmNode, String string2, XPointer xPointer) {
        this.finest(null, "XInclude read text: " + string + " (" + string2 + ")");
        URI uRI = null;
        try {
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XProcException(uRISyntaxException);
        }
        URI uRI2 = uRI.resolve(string);
        String string3 = "";
        try {
            URL uRL = uRI2.toURL();
            URLConnection uRLConnection = uRL.openConnection();
            String string4 = uRLConnection.getContentType();
            int n = uRLConnection.getContentLength();
            String string5 = HttpUtils.getCharset(string4);
            if (string5 == null && xdmNode.getAttributeValue(_encoding) != null) {
                string5 = xdmNode.getAttributeValue(_encoding);
            }
            if (string5 == null) {
                string5 = "utf-8";
            }
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            inputStreamReader = string5 == null ? new InputStreamReader(uRLConnection.getInputStream()) : new InputStreamReader(uRLConnection.getInputStream(), string5);
            if (xPointer != null) {
                string3 = xPointer.selectText(inputStreamReader, n);
            } else {
                String string6;
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string6 = bufferedReader.readLine()) != null) {
                    string3 = string3 + string6 + "\n";
                }
                bufferedReader.close();
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            this.finest(null, "XInclude read text failed");
            this.mostRecentException = exception;
            return null;
        }
        return string3;
    }

    public XdmNode readXML(String string, String string2) {
        this.finest(null, "XInclude read XML: " + string + " (" + string2 + ")");
        try {
            XdmNode xdmNode = this.runtime.parse(string, string2);
            return xdmNode;
        }
        catch (Exception exception) {
            this.finest(null, "XInclude read XML failed");
            this.mostRecentException = exception;
            return null;
        }
    }

    public void fallback(XdmNode xdmNode, String string) {
        this.finest(xdmNode, "fallback: " + xdmNode.getNodeName());
        boolean bl = true;
        XdmNode xdmNode2 = null;
        for (XdmNode xdmNode3 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
            if (xdmNode3.getNodeKind() == XdmNodeKind.ELEMENT) {
                bl = bl && xi_fallback.equals((Object)xdmNode3.getNodeName()) && xdmNode2 == null;
                xdmNode2 = xdmNode3;
                continue;
            }
            bl = false;
        }
        if (!bl) {
            throw new XProcException(this.step.getNode(), "XInclude element must contain exactly one xi:fallback element.");
        }
        if (xdmNode2 == null) {
            if (this.mostRecentException != null) {
                throw new XProcException(this.step.getNode(), "XInclude resource error (" + string + ") and no fallback provided.", (Throwable)this.mostRecentException);
            }
            throw new XProcException(this.step.getNode(), "XInclude resource error (" + string + ") and no fallback provided.");
        }
        XdmSequenceIterator xdmSequenceIterator = xdmNode2.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode3;
            xdmNode3 = (XdmNode)xdmSequenceIterator.next();
            if (xdmNode3.getNodeKind() == XdmNodeKind.ELEMENT) {
                xdmNode3 = this.expandXIncludes(xdmNode3);
            }
            this.matcherStack.peek().addSubtree(xdmNode3);
        }
    }

    private class Fixup
    implements ProcessMatchingNodes {
        private XProcRuntime runtime = null;
        private ProcessMatch matcher = null;
        private boolean root = true;
        private XdmNode xinclude = null;

        public Fixup(XProcRuntime xProcRuntime, XdmNode xdmNode) {
            this.runtime = xProcRuntime;
            this.xinclude = xdmNode;
        }

        public XdmNode fixup(XdmNode xdmNode) {
            this.matcher = new ProcessMatch(this.runtime, this);
            this.matcher.match(xdmNode, new RuntimeValue("*", XInclude.this.step.getNode()));
            XdmNode xdmNode2 = this.matcher.getResult();
            return xdmNode2;
        }

        @Override
        public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
            this.matcher.startDocument(xdmNode.getBaseURI());
            return true;
        }

        @Override
        public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
            this.matcher.endDocument();
        }

        @Override
        public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
            this.matcher.addStartElement(xdmNode);
            if (this.root) {
                Object object;
                XdmSequenceIterator xdmSequenceIterator;
                this.root = false;
                if (XInclude.this.copyAttributes) {
                    xdmSequenceIterator = this.xinclude.axisIterator(Axis.ATTRIBUTE);
                    while (xdmSequenceIterator.hasNext()) {
                        object = (XdmNode)xdmSequenceIterator.next();
                        if ("".equals(object.getNodeName().getNamespaceURI())) continue;
                        this.matcher.addAttribute((XdmNode)object);
                    }
                }
                xdmSequenceIterator = xdmNode.axisIterator(Axis.ATTRIBUTE);
                while (xdmSequenceIterator.hasNext()) {
                    object = (XdmNode)xdmSequenceIterator.next();
                    if (XProcConstants.xml_base.equals((Object)object.getNodeName()) && XInclude.this.fixupBase || XProcConstants.xml_lang.equals((Object)object.getNodeName()) && XInclude.this.fixupLang || cx_mark_roots.equals((Object)object.getNodeName()) && XInclude.this.markRoots) continue;
                    this.matcher.addAttribute((XdmNode)object);
                }
                if (XInclude.this.fixupBase) {
                    this.matcher.addAttribute(XProcConstants.xml_base, xdmNode.getBaseURI().toASCIIString());
                }
                if (XInclude.this.markRoots) {
                    this.matcher.addAttribute(cx_root, "true");
                }
                object = this.getLang(xdmNode);
                if (XInclude.this.fixupLang && object != null) {
                    this.matcher.addAttribute(XProcConstants.xml_lang, (String)object);
                }
            } else {
                this.matcher.addAttributes(xdmNode);
            }
            this.matcher.startContent();
            return true;
        }

        @Override
        public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
            throw new XProcException(xdmNode, "This can't happen!?");
        }

        @Override
        public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
            this.matcher.addEndElement();
        }

        @Override
        public void processText(XdmNode xdmNode) throws SaxonApiException {
            throw new XProcException(xdmNode, "This can't happen!?");
        }

        @Override
        public void processComment(XdmNode xdmNode) throws SaxonApiException {
            throw new XProcException(xdmNode, "This can't happen!?");
        }

        @Override
        public void processPI(XdmNode xdmNode) throws SaxonApiException {
            throw new XProcException(xdmNode, "This can't happen!?");
        }

        private String getLang(XdmNode xdmNode) {
            String string = null;
            while (string == null && xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
                string = xdmNode.getAttributeValue(XProcConstants.xml_lang);
                xdmNode = xdmNode.getParent();
            }
            return string;
        }
    }
}

