<?php

declare(strict_types=1);

/**
 * @copyright 2021 Christoph Wurst <christoph@winzerhof-wurst.at>
 *
 * @author Christoph Wurst <christoph@winzerhof-wurst.at>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */
namespace OC\AppFramework\Bootstrap;

/**
 * @psalm-immutable
 */
class ServiceAliasRegistration extends ARegistration {
	/**
	 * @var string
	 * @psalm-var string|class-string
	 */
	private $alias;

	/**
	 * @var string
	 * @psalm-var string|class-string
	 */
	private $target;

	/**
	 * @psalm-param string|class-string $alias
	 * @paslm-param string|class-string $target
	 */
	public function __construct(string $appId,
		string $alias,
		string $target) {
		parent::__construct($appId);
		$this->alias = $alias;
		$this->target = $target;
	}

	/**
	 * @psalm-return string|class-string
	 */
	public function getAlias(): string {
		return $this->alias;
	}

	/**
	 * @psalm-return string|class-string
	 */
	public function getTarget(): string {
		return $this->target;
	}
}
