/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.querypen;

import ca.sqlpower.query.SQLJoin;
import ca.sqlpower.swingui.querypen.CleanupPNode;
import ca.sqlpower.swingui.querypen.QueryPen;
import ca.sqlpower.swingui.querypen.UnmodifiableItemPNode;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolox.event.PNotification;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import edu.umd.cs.piccolox.nodes.PStyledText;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class JoinLine
extends PNode
implements CleanupPNode {
    private static Logger logger = Logger.getLogger(JoinLine.class);
    private static final float BORDER_WIDTH = 5.0f;
    private static final float JOIN_LINE_STICKOUT_LENGTH = 50.0f;
    private static final int MOUSE_CLICK_BUFFER = 4;
    private static final float DASH_WIDTH = 5.0f;
    private UnmodifiableItemPNode leftNode;
    private UnmodifiableItemPNode rightNode;
    private final PNode leftContainerPane;
    private final PNode rightContainerPane;
    private final PStyledText symbolText;
    private final PPath textCircle;
    private final PNode optionBox;
    private JEditorPane editorPane;
    private boolean isJoinedTablesSwapped;
    private boolean oldIsJoinedTableSwapped;
    private String viewCom;
    private final PPath leftPath;
    private final PPath rightPath;
    private final PNode joinCombo;
    private boolean clickedOnLeftPath;
    private final PInputEventListener joinChangeListener = new PBasicInputEventHandler(){

        public void mouseReleased(PInputEvent event) {
            this.maybeShowPopup(event);
        }

        public void mousePressed(PInputEvent event) {
            this.maybeShowPopup(event);
        }

        public void mouseClicked(PInputEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(PInputEvent event) {
            if (event.isPopupTrigger()) {
                JoinLine.this.optionBox.translate(event.getPosition().getX() - JoinLine.this.optionBox.getFullBounds().getX() - 5.0, event.getPosition().getY() - JoinLine.this.optionBox.getFullBounds().getY() - 5.0);
                if (JoinLine.this.checkClickOnPath(event.getPosition().getX(), event.getPosition().getY(), JoinLine.this.textCircle)) {
                    JoinLine.this.canvas.getLayer().addChild(JoinLine.this.optionBox);
                    logger.debug((Object)"Clicked on textCircle");
                    return;
                }
                if (JoinLine.this.canvas.getLayer().getAllNodes().contains(JoinLine.this.optionBox)) {
                    JoinLine.this.canvas.getLayer().removeChild(JoinLine.this.optionBox);
                }
                JoinLine.this.joinCombo.translate(event.getPosition().getX() - JoinLine.this.joinCombo.getFullBounds().getX() - 5.0, event.getPosition().getY() - JoinLine.this.joinCombo.getFullBounds().getY() - 5.0);
                if (JoinLine.this.canvas.getLayer().getAllNodes().contains(JoinLine.this.joinCombo)) {
                    JoinLine.this.canvas.getLayer().removeChild(JoinLine.this.joinCombo);
                }
                if (JoinLine.this.checkClickOnPath(event.getPosition().getX(), event.getPosition().getY(), JoinLine.this.leftPath)) {
                    JoinLine.this.clickedOnLeftPath = true;
                    JoinLine.this.canvas.getLayer().addChild(JoinLine.this.joinCombo);
                    logger.debug((Object)"Clicked on left path");
                    return;
                }
                if (JoinLine.this.checkClickOnPath(event.getPosition().getX(), event.getPosition().getY(), JoinLine.this.rightPath)) {
                    JoinLine.this.clickedOnLeftPath = false;
                    JoinLine.this.canvas.getLayer().addChild(JoinLine.this.joinCombo);
                    logger.debug((Object)"Clicked on right path");
                }
            }
        }
    };
    private final PCanvas canvas;
    private SQLJoin model;
    private final PropertyChangeListener joinListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JoinLine.this.updateLine();
        }
    };
    private final QueryPen queryPen;
    private final ImageIcon joinSelectedIcon;
    private final ImageIcon joinUnselectedIcon;
    private PImage selectedImageNode;
    private PImage unselectedImageNode;

    public JoinLine(QueryPen queryPen, PCanvas c, SQLJoin joinModel) throws IllegalStateException {
        Collection allNodes = queryPen.getTopLayer().getAllNodes();
        this.leftNode = null;
        this.rightNode = null;
        for (PNode node : allNodes) {
            if (!(node instanceof UnmodifiableItemPNode)) continue;
            UnmodifiableItemPNode pnode = (UnmodifiableItemPNode)node;
            if (this.leftNode == null && pnode.getModel() == joinModel.getLeftColumn()) {
                this.leftNode = pnode;
            } else if (this.rightNode == null && pnode.getModel() == joinModel.getRightColumn()) {
                this.rightNode = pnode;
            }
            if (this.leftNode == null || this.rightNode == null) continue;
            break;
        }
        if (this.leftNode == null) {
            throw new IllegalStateException("The view and model are inconsistent. Could not find a view component for " + joinModel.getLeftColumn());
        }
        if (this.rightNode == null) {
            throw new IllegalStateException("The view and model are inconsistent. Could not find a view component for " + joinModel.getRightColumn());
        }
        this.model = joinModel;
        this.queryPen = queryPen;
        this.canvas = c;
        this.model.addJoinChangeListener(this.joinListener);
        this.leftNode.JoinTo(this);
        this.rightNode.JoinTo(this);
        this.leftContainerPane = this.leftNode.getParent();
        this.rightContainerPane = this.rightNode.getParent();
        this.leftContainerPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JoinLine.this.updateLine();
            }
        });
        this.rightContainerPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JoinLine.this.updateLine();
            }
        });
        this.leftPath = new PPath();
        this.addChild((PNode)this.leftPath);
        this.leftPath.setStroke((Stroke)new BasicStroke(2.0f));
        this.rightPath = new PPath();
        this.addChild((PNode)this.rightPath);
        this.rightPath.setStroke((Stroke)new BasicStroke(2.0f));
        this.joinSelectedIcon = new ImageIcon(JoinLine.class.getClassLoader().getResource("ca/sqlpower/swingui/querypen/node_on.png"));
        this.joinUnselectedIcon = new ImageIcon(JoinLine.class.getClassLoader().getResource("ca/sqlpower/swingui/querypen/node_off.png"));
        this.selectedImageNode = new PImage(this.joinSelectedIcon.getImage());
        this.unselectedImageNode = new PImage(this.joinUnselectedIcon.getImage());
        this.addChild((PNode)this.selectedImageNode);
        this.addChild((PNode)this.unselectedImageNode);
        this.selectedImageNode.setVisible(false);
        this.textCircle = PPath.createEllipse((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.addChild((PNode)this.textCircle);
        this.textCircle.setStroke((Stroke)new BasicStroke(2.0f));
        this.oldIsJoinedTableSwapped = false;
        this.viewCom = "=";
        this.isJoinedTablesSwapped = false;
        this.optionBox = new PNode();
        this.symbolText = new PStyledText();
        this.editorPane = new JEditorPane();
        this.editorPane.setText("=");
        this.symbolText.setDocument(this.editorPane.getDocument());
        int textHeight = 0;
        for (SQLJoin.Comparators aComparator : SQLJoin.Comparators.values()) {
            final PText tempText = new PText(aComparator.getComparator());
            tempText.translate(0.0, (double)textHeight);
            tempText.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent event) {
                    JoinLine.this.viewCom = tempText.getText();
                    JoinLine.this.editorPane.setText(JoinLine.this.viewCom);
                    JoinLine.this.symbolText.syncWithDocument();
                    if (JoinLine.this.isJoinedTablesSwapped) {
                        JoinLine.this.model.setComparator(JoinLine.this.getOppositeSymbol(JoinLine.this.viewCom));
                    } else {
                        JoinLine.this.model.setComparator(JoinLine.this.viewCom);
                    }
                    JoinLine.this.canvas.getLayer().removeChild(JoinLine.this.optionBox);
                    JoinLine.this.updateLine();
                }
            });
            this.optionBox.addChild((PNode)tempText);
            textHeight = (int)((double)textHeight + tempText.getHeight());
        }
        PPath optionBoxouterRect = PPath.createRectangle((float)-5.0f, (float)-5.0f, (float)((float)(this.optionBox.getFullBounds().getWidth() + 10.0)), (float)((float)(this.optionBox.getFullBounds().getHeight() + 10.0)));
        this.optionBox.addChild((PNode)optionBoxouterRect);
        this.optionBox.setBounds((Rectangle2D)optionBoxouterRect.getBounds());
        optionBoxouterRect.moveToBack();
        this.addChild((PNode)this.symbolText);
        this.updateLine();
        this.addInputEventListener(this.joinChangeListener);
        this.joinCombo = new PNode();
        this.joinCombo.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mouseExited(PInputEvent event) {
                if (!JoinLine.this.joinCombo.getBounds().contains(JoinLine.this.joinCombo.globalToLocal(event.getPosition())) && JoinLine.this.canvas.getLayer().getAllNodes().contains(JoinLine.this.joinCombo)) {
                    JoinLine.this.canvas.getLayer().removeChild(JoinLine.this.joinCombo);
                }
            }
        });
        this.optionBox.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mouseExited(PInputEvent event) {
                if (!JoinLine.this.optionBox.getBounds().contains(JoinLine.this.optionBox.globalToLocal(event.getPosition())) && JoinLine.this.canvas.getLayer().getAllNodes().contains(JoinLine.this.optionBox)) {
                    JoinLine.this.canvas.getLayer().removeChild(JoinLine.this.optionBox);
                }
            }
        });
        PText innerJoinComboItem = new PText("Inner Join");
        innerJoinComboItem.addAttribute(StyleConstants.FontFamily, (Object)UIManager.getFont("List.font").getFamily());
        this.joinCombo.addChild((PNode)innerJoinComboItem);
        innerJoinComboItem.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent event) {
                JoinLine.this.canvas.getLayer().removeChild(JoinLine.this.joinCombo);
                if (JoinLine.this.clickedOnLeftPath) {
                    JoinLine.this.model.setLeftColumnOuterJoin(false);
                } else {
                    JoinLine.this.model.setRightColumnOuterJoin(false);
                }
                JoinLine.this.updateLine();
            }
        });
        PText outerJoinComboItem = new PText("Outer Join");
        outerJoinComboItem.addAttribute(StyleConstants.FontFamily, (Object)UIManager.getFont("List.font").getFamily());
        outerJoinComboItem.translate(0.0, innerJoinComboItem.getHeight() + 5.0);
        this.joinCombo.addChild((PNode)outerJoinComboItem);
        outerJoinComboItem.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent event) {
                if (JoinLine.this.clickedOnLeftPath) {
                    JoinLine.this.model.setLeftColumnOuterJoin(true);
                } else {
                    JoinLine.this.model.setRightColumnOuterJoin(true);
                }
                JoinLine.this.canvas.getLayer().removeChild(JoinLine.this.joinCombo);
                JoinLine.this.updateLine();
            }
        });
        PPath outerRect = PPath.createRectangle((float)-5.0f, (float)-5.0f, (float)((float)(this.joinCombo.getFullBounds().getWidth() + 10.0)), (float)((float)(this.joinCombo.getFullBounds().getHeight() + 10.0)));
        this.joinCombo.addChild((PNode)outerRect);
        this.joinCombo.setBounds((Rectangle2D)outerRect.getBounds());
        outerRect.moveToBack();
        PNotificationCenter.defaultCenter().addListener((Object)this, "setFocusColour", "SELECTION_CHANGED_NOTIFICATION", null);
        this.setFocusColour(new PNotification(null, null, null));
        this.editorPane.setText(this.model.getComparator());
        this.symbolText.syncWithDocument();
        this.updateLine();
    }

    private void updateLine() {
        double midX;
        this.setBounds(0.0, 0.0, 0.0, 0.0);
        PBounds leftBounds = this.leftNode.getGlobalFullBounds();
        PBounds rightBounds = this.rightNode.getGlobalFullBounds();
        PBounds leftContainerBounds = this.leftContainerPane.getGlobalBounds();
        PBounds rightContainerBounds = this.rightContainerPane.getGlobalBounds();
        this.leftPath.reset();
        this.rightPath.reset();
        double leftY = leftBounds.getY() + leftBounds.getHeight() / 2.0;
        double rightY = rightBounds.getY() + rightBounds.getHeight() / 2.0;
        double midY = Math.abs(leftY - rightY) / 2.0 + Math.min(leftY, rightY);
        double leftX = leftContainerBounds.getX();
        double rightX = rightContainerBounds.getX();
        int rightContainerFirstControlPointDirection = -1;
        int leftContainerFirstControlPointDirection = 1;
        if (leftX + leftContainerBounds.getWidth() < rightX) {
            midX = (leftX += leftContainerBounds.getWidth()) + (rightX - leftX) / 2.0;
            rightContainerFirstControlPointDirection = 1;
            this.isJoinedTablesSwapped = false;
            logger.debug((Object)"Left container is to the left of the right container.");
        } else if (leftX < rightContainerBounds.getWidth() + rightContainerBounds.getX()) {
            midX = Math.max(50.0 + (leftX += leftContainerBounds.getWidth()), 50.0 + (rightX += rightContainerBounds.getWidth()));
            logger.debug((Object)"The containers are above or below eachother.");
        } else {
            midX = leftX + ((rightX += rightContainerBounds.getWidth()) - leftX) / 2.0;
            leftContainerFirstControlPointDirection = -1;
            this.isJoinedTablesSwapped = true;
            logger.debug((Object)"The right container is to the left of the left container.");
        }
        this.handleJoinedTablesSwapped();
        logger.debug((Object)("Left x position is " + leftX + " and mid x position is " + midX));
        this.leftPath.moveTo((float)leftX, (float)leftY);
        Point2D.Float leftControlPoint1 = new Point2D.Float((float)(leftX + (double)leftContainerFirstControlPointDirection * Math.max(50.0, Math.abs(rightX - leftX) / 6.0)), (float)leftY);
        Point2D.Float leftControlPoint2 = new Point2D.Float((float)midX, (float)(leftY + (rightY - leftY) / 6.0));
        this.leftPath.curveTo((float)((Point2D)leftControlPoint1).getX(), (float)((Point2D)leftControlPoint1).getY(), (float)((Point2D)leftControlPoint2).getX(), (float)((Point2D)leftControlPoint2).getY(), (float)midX, (float)midY);
        this.rightPath.moveTo((float)midX, (float)midY);
        Point2D.Float rightControlPoint1 = new Point2D.Float((float)midX, (float)(leftY + (rightY - leftY) * 5.0 / 6.0));
        Point2D.Float rightControlPoint2 = new Point2D.Float((float)(rightX - (double)rightContainerFirstControlPointDirection * Math.max(50.0, Math.abs(rightX - leftX) / 6.0)), (float)rightY);
        this.rightPath.curveTo((float)((Point2D)rightControlPoint1).getX(), (float)((Point2D)rightControlPoint1).getY(), (float)((Point2D)rightControlPoint2).getX(), (float)((Point2D)rightControlPoint2).getY(), (float)rightX, (float)rightY);
        float[] dash = new float[]{5.0f, 5.0f};
        if (this.model.isLeftColumnOuterJoin()) {
            this.leftPath.setStroke((Stroke)new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f));
        } else {
            this.leftPath.setStroke((Stroke)new BasicStroke());
        }
        if (this.model.isRightColumnOuterJoin()) {
            this.rightPath.setStroke((Stroke)new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f));
        } else {
            this.rightPath.setStroke((Stroke)new BasicStroke());
        }
        double textMidX = midX - this.symbolText.getWidth() / 2.0;
        double textMidY = midY - this.symbolText.getHeight() / 2.0;
        this.symbolText.setX(textMidX);
        this.symbolText.setY(textMidY);
        this.textCircle.setPathToEllipse((float)(textMidX - 5.0), (float)(textMidY - 5.0), (float)this.symbolText.getWidth() + 10.0f, (float)this.symbolText.getHeight() + 10.0f);
        logger.debug((Object)("The model's comparator is \"" + this.model.getComparator() + "\" looking for " + SQLJoin.Comparators.EQUAL_TO.getComparator()));
        this.selectedImageNode.setX(midX - this.selectedImageNode.getWidth() / 2.0);
        this.selectedImageNode.setY(midY - this.selectedImageNode.getHeight() / 2.0);
        this.unselectedImageNode.setX(midX - this.unselectedImageNode.getWidth() / 2.0);
        this.unselectedImageNode.setY(midY - this.unselectedImageNode.getHeight() / 2.0);
        if (this.model.getComparator().equals(SQLJoin.Comparators.EQUAL_TO.getComparator())) {
            this.textCircle.setVisible(false);
            this.symbolText.setVisible(false);
            this.setFocusColour(new PNotification(null, null, null));
        } else {
            this.selectedImageNode.setVisible(false);
            this.unselectedImageNode.setVisible(false);
            this.textCircle.setVisible(true);
            this.symbolText.setVisible(true);
        }
        Object boundUnion = this.textCircle.getBounds();
        boundUnion = ((Rectangle2D)boundUnion).createUnion((Rectangle2D)this.leftPath.getBounds());
        boundUnion = ((Rectangle2D)boundUnion).createUnion((Rectangle2D)this.rightPath.getBounds());
        this.setBounds((Rectangle2D)boundUnion);
    }

    public void handleJoinedTablesSwapped() {
        if (this.isJoinedTablesSwapped != this.oldIsJoinedTableSwapped) {
            this.viewCom = this.getOppositeSymbol(this.viewCom);
            this.editorPane.setText(this.viewCom);
            this.symbolText.syncWithDocument();
            this.oldIsJoinedTableSwapped = this.isJoinedTablesSwapped;
        }
    }

    public String getOppositeSymbol(String symbol) {
        if (symbol.equals(">")) {
            return "<";
        }
        if (symbol.equals(">=")) {
            return "<=";
        }
        if (symbol.equals("<")) {
            return ">";
        }
        if (symbol.equals("<=")) {
            return ">=";
        }
        return symbol;
    }

    private boolean checkClickOnPath(double mouseX, double mouseY, PPath path) {
        Rectangle mouseClickRectangle = new Rectangle((int)mouseX - 4, (int)mouseY - 4, 8, 8);
        PathIterator iter = path.getPathReference().getPathIterator((AffineTransform)path.getTransform(), 1.0);
        float[] linePoints = new float[2];
        iter.currentSegment(linePoints);
        iter.next();
        if (this.textCircle.getPathReference().contains(mouseX, mouseY)) {
            return true;
        }
        while (!iter.isDone()) {
            Point2D.Float oldPoints = new Point2D.Float(linePoints[0], linePoints[1]);
            iter.currentSegment(linePoints);
            if (mouseClickRectangle.intersectsLine(((Point2D)oldPoints).getX(), ((Point2D)oldPoints).getY(), linePoints[0], linePoints[1])) {
                return true;
            }
            iter.next();
        }
        return false;
    }

    public UnmodifiableItemPNode getLeftNode() {
        return this.leftNode;
    }

    public UnmodifiableItemPNode getRightNode() {
        return this.rightNode;
    }

    public SQLJoin getModel() {
        return this.model;
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    public void disconnectJoin() {
        this.model.removeAllListeners();
        this.leftNode.removeJoinedLine(this);
        this.rightNode.removeJoinedLine(this);
    }

    public boolean fullPick(PPickPath pickPath) {
        boolean superPick = super.fullPick(pickPath);
        if (superPick && (pickPath.getPickedNode() != this || this.checkClickOnPath(pickPath.getPickBounds().getX(), pickPath.getPickBounds().getY(), this.leftPath) || this.checkClickOnPath(pickPath.getPickBounds().getX(), pickPath.getPickBounds().getY(), this.rightPath))) {
            PNode picked = pickPath.getPickedNode();
            while (picked != this) {
                pickPath.popTransform(picked.getTransformReference(false));
                pickPath.popNode(picked);
                picked = pickPath.getPickedNode();
            }
            return true;
        }
        return false;
    }

    public void setFocusColour(PNotification notification) {
        boolean hasFocus = this.queryPen.getMultipleSelectEventHandler().getSelection().contains(this);
        if (hasFocus) {
            this.leftPath.setStrokePaint((Paint)QueryPen.SELECTED_CONTAINER_COLOUR);
            this.rightPath.setStrokePaint((Paint)QueryPen.SELECTED_CONTAINER_COLOUR);
            this.textCircle.setStrokePaint((Paint)QueryPen.SELECTED_CONTAINER_COLOUR);
            this.unselectedImageNode.setVisible(false);
            this.selectedImageNode.setVisible(true);
        } else {
            this.leftPath.setStrokePaint((Paint)QueryPen.UNSELECTED_CONTAINER_COLOUR);
            this.rightPath.setStrokePaint((Paint)QueryPen.UNSELECTED_CONTAINER_COLOUR);
            this.textCircle.setStrokePaint((Paint)QueryPen.UNSELECTED_CONTAINER_COLOUR);
            this.unselectedImageNode.setVisible(true);
            this.selectedImageNode.setVisible(false);
        }
    }

    @Override
    public void cleanup() {
        this.model.removeJoinChangeListener(this.joinListener);
        PNotificationCenter.defaultCenter().removeListener((Object)this);
    }
}

