/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.List;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.NativeTrade;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;

public class AIMessage {
    public static boolean askAttack(AIUnit aiUnit, Direction direction) {
        return aiUnit.getAIOwner().askServer().attack(aiUnit.getUnit(), direction);
    }

    public static boolean askBuildColony(AIUnit aiUnit, String name) {
        return aiUnit.getAIOwner().askServer().buildColony(name, aiUnit.getUnit());
    }

    public static boolean askCashInTreasureTrain(AIUnit aiUnit) {
        return aiUnit.getAIOwner().askServer().cashInTreasureTrain(aiUnit.getUnit());
    }

    public static boolean askChangeState(AIUnit aiUnit, Unit.UnitState state) {
        return aiUnit.getAIOwner().askServer().changeState(aiUnit.getUnit(), state);
    }

    public static boolean askChangeWorkType(AIUnit aiUnit, GoodsType type) {
        return aiUnit.getAIOwner().askServer().changeWorkType(aiUnit.getUnit(), type);
    }

    public static boolean askChangeWorkImprovementType(AIUnit aiUnit, TileImprovementType type) {
        return aiUnit.getAIOwner().askServer().changeWorkImprovementType(aiUnit.getUnit(), type);
    }

    public static boolean askChooseFoundingFather(AIPlayer aiPlayer, List<FoundingFather> fathers, FoundingFather father) {
        return aiPlayer.askServer().chooseFoundingFather(fathers, father);
    }

    public static boolean askClaimLand(Tile tile, AIColony aic, int price) {
        return aic.getAIOwner().askServer().claimTile(tile, aic.getColony(), price);
    }

    public static boolean askClaimLand(Tile tile, AIUnit aiUnit, int price) {
        return aiUnit.getAIOwner().askServer().claimTile(tile, aiUnit.getUnit(), price);
    }

    public static boolean askClearSpeciality(AIUnit aiUnit) {
        return aiUnit.getAIOwner().askServer().clearSpeciality(aiUnit.getUnit());
    }

    public static boolean askDiplomacy(AIPlayer aiPlayer, FreeColGameObject our, FreeColGameObject other, DiplomaticTrade dt) {
        return aiPlayer.askServer().diplomacy(our, other, dt);
    }

    public static boolean askDisband(AIUnit aiUnit) {
        return aiUnit.getAIOwner().askServer().disbandUnit(aiUnit.getUnit());
    }

    public static boolean askDisembark(AIUnit aiUnit) {
        return aiUnit.getAIOwner().askServer().disembark(aiUnit.getUnit());
    }

    public static boolean askEmbark(AIUnit aiUnit, Unit unit, Direction direction) {
        return aiUnit.getAIOwner().askServer().embark(unit, aiUnit.getUnit(), direction);
    }

    public static boolean askEmigrate(AIPlayer aiPlayer, int slot) {
        return aiPlayer.askServer().emigrate(slot);
    }

    public static boolean askEndTurn(AIPlayer aiPlayer) {
        return aiPlayer.askServer().endTurn();
    }

    public static boolean askEquipForRole(AIUnit aiUnit, Role role, int roleCount) {
        return aiUnit.getAIOwner().askServer().equipUnitForRole(aiUnit.getUnit(), role, roleCount);
    }

    public static boolean askEstablishMission(AIUnit aiUnit, Direction direction, boolean denounce) {
        return aiUnit.getAIOwner().askServer().missionary(aiUnit.getUnit(), direction, denounce);
    }

    public static boolean askFirstContact(AIPlayer aiPlayer, Player contactor, Player contactee, Tile tile, boolean ack) {
        return aiPlayer.askServer().firstContact(contactor, contactee, tile, ack);
    }

    public static boolean askIndianDemand(AIPlayer aiPlayer, Unit unit, Colony colony, GoodsType type, int amount, Constants.IndianDemandAction result) {
        return aiPlayer.askServer().indianDemand(unit, colony, type, amount, result);
    }

    public static boolean askLoadGoods(Location loc, GoodsType type, int amount, AIUnit aiUnit) {
        return aiUnit.getAIOwner().askServer().loadGoods(loc, type, amount, aiUnit.getUnit());
    }

    public static boolean askLoot(AIUnit aiUnit, String defenderId, List<Goods> goods) {
        return aiUnit.getAIOwner().askServer().loot(aiUnit.getUnit(), defenderId, goods);
    }

    public static boolean askMonarchAction(AIPlayer aiPlayer, Monarch.MonarchAction action, boolean accept) {
        return aiPlayer.askServer().answerMonarch(action, accept);
    }

    public static boolean askMove(AIUnit aiUnit, Direction direction) {
        return aiUnit.getAIOwner().askServer().move(aiUnit.getUnit(), direction);
    }

    public static boolean askMoveTo(AIUnit aiUnit, Location destination) {
        return aiUnit.getAIOwner().askServer().moveTo(aiUnit.getUnit(), destination);
    }

    public static boolean askNationSummary(AIPlayer owner, Player player) {
        return owner.askServer().nationSummary(owner.getPlayer(), player);
    }

    public static boolean askNativeGift(AIUnit aiUnit, Colony colony) {
        return aiUnit.getAIOwner().askServer().nativeGift(aiUnit.getUnit(), colony);
    }

    public static boolean askNativeTrade(AIPlayer aiPlayer, NativeTrade.NativeTradeAction action, NativeTrade nt) {
        return aiPlayer.askServer().nativeTrade(action, nt);
    }

    public static boolean askNewLandName(AIPlayer aiPlayer, Unit unit, String name) {
        return aiPlayer.askServer().newLandName(unit, name);
    }

    public static boolean askNewRegionName(AIPlayer aiPlayer, Region region, Tile tile, Unit unit, String name) {
        return aiPlayer.askServer().newRegionName(region, tile, unit, name);
    }

    public static boolean askPutOutsideColony(AIUnit aiUnit) {
        return aiUnit.getAIOwner().askServer().putOutsideColony(aiUnit.getUnit());
    }

    public static boolean askRearrangeColony(AIColony aiColony, List<Unit> workers, Colony scratch) {
        return aiColony.getAIOwner().askServer().rearrangeColony(aiColony.getColony(), workers, scratch);
    }

    public static boolean askScoutSpeakToChief(AIUnit aiUnit, IndianSettlement is) {
        return aiUnit.getAIOwner().askServer().scoutSpeakToChief(aiUnit.getUnit(), is);
    }

    public static boolean askSetBuildQueue(AIColony aiColony, List<BuildableType> queue) {
        return aiColony.getAIOwner().askServer().setBuildQueue(aiColony.getColony(), queue);
    }

    public static boolean askTrainUnitInEurope(AIPlayer aiPlayer, UnitType type) {
        return aiPlayer.askServer().trainUnitInEurope(type);
    }

    public static boolean askUnloadGoods(GoodsType type, int amount, AIUnit aiUnit) {
        return aiUnit.getAIOwner().askServer().unloadGoods(type, amount, aiUnit.getUnit());
    }

    public static boolean askWork(AIUnit aiUnit, WorkLocation workLocation) {
        return aiUnit.getAIOwner().askServer().work(aiUnit.getUnit(), workLocation);
    }
}

