/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.AttachChunkResult;
import com.intellij.indexing.shared.platform.api.ChunkDescriptor;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.impl.BundledSharedIndexesResolver;
import com.intellij.indexing.shared.platform.impl.ChunkManager;
import com.intellij.indexing.shared.platform.impl.DownloadIndexResult;
import com.intellij.indexing.shared.platform.impl.EmptyIndex;
import com.intellij.indexing.shared.platform.impl.ExcludedChunkList;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.HashBasedMapReduceIndex;
import com.intellij.indexing.shared.platform.impl.HashSuppliedIndexedFile;
import com.intellij.indexing.shared.platform.impl.SharedIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.indexing.shared.platform.impl.SharedIndexProjectSettings;
import com.intellij.indexing.shared.platform.impl.SharedIndexStorageHolder;
import com.intellij.indexing.shared.platform.impl.SharedIndexStorageUtil;
import com.intellij.indexing.shared.platform.impl.SharedIndexesFusCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.diagnostic.SharedIndexDiagnostic;
import com.intellij.util.indexing.diagnostic.dto.JsonPercentages;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SharedIndexChunkConfigurationImpl
implements SharedIndexChunkConfiguration,
Disposable {
    private static final Logger LOG = Logger.getInstance(SharedIndexChunkConfigurationImpl.class);
    static final String SHARED_INDEXES_ROOT = "shared_indexes";
    private final ReadWriteLock myConfigurationLock = new ReentrantReadWriteLock();
    @Nullable
    private FileBasedIndexInfrastructureExtension.InitializationResult myInitialized;
    private ChunkManager myChunkManager;
    private SimpleStringPersistentEnumerator myChunkDescriptorEnumerator;
    private Map<ID<?, ?>, Map<Integer, SharedIndex<?, ?>>> myChunkMap;
    private SharedIndexStorageHolder mySharedIndexStorage;
    private final ExcludedChunkList myExcludedChunkList = new ExcludedChunkList(SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot());
    private final Set<String> myDownloadingChunks = ConcurrentCollectionFactory.createConcurrentSet();

    public SharedIndexChunkConfigurationImpl() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.detachSharedIndexes(project), SharedIndexesBundle.message("shared.index.detach.message", new Object[0]), false, project);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void detachSharedIndexes(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                SharedIndexChunkConfigurationImpl.this.myConfigurationLock.writeLock().lock();
                try {
                    if (SharedIndexChunkConfigurationImpl.this.myInitialized != null) {
                        List<Integer> closedChunkIds = SharedIndexChunkConfigurationImpl.this.myChunkManager.disposeChunks(project);
                        for (Map<Integer, SharedIndex<?, ?>> sharedIndexes : SharedIndexChunkConfigurationImpl.this.myChunkMap.values()) {
                            for (int id : closedChunkIds) {
                                IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{sharedIndexes.remove(id)});
                            }
                        }
                    }
                }
                finally {
                    SharedIndexChunkConfigurationImpl.this.myConfigurationLock.writeLock().unlock();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/SharedIndexChunkConfigurationImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosing";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "detachSharedIndexes";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void dispose() {
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull FileBasedIndexInfrastructureExtension.InitializationResult initialize() {
        this.myConfigurationLock.writeLock().lock();
        if (this.myInitialized == null) {
            Ref result2 = Ref.create((Object)FileBasedIndexInfrastructureExtension.InitializationResult.SUCCESSFULLY);
            this.myChunkManager = new ChunkManager();
            this.myChunkMap = new HashMap();
            this.myChunkDescriptorEnumerator = new SimpleStringPersistentEnumerator(SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve("descriptors"));
            try {
                this.mySharedIndexStorage = SharedIndexStorageHolder.openStoragesOrReset(() -> {
                    LOG.info("Shared index chunk storage corrupted and will be rebuilt");
                    result2.set((Object)FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED);
                });
            }
            catch (Exception e) {
                LOG.error("Failed to initialize shared indexes infrastructure", (Throwable)e);
                result2.set((Object)FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED);
                this.shutdown();
            }
            this.myInitialized = (FileBasedIndexInfrastructureExtension.InitializationResult)result2.get();
        }
        FileBasedIndexInfrastructureExtension.InitializationResult initializationResult = this.myInitialized;
        FileBasedIndexInfrastructureExtension.InitializationResult initializationResult2 = initializationResult;
        if (initializationResult2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(0);
        }
        return initializationResult2;
        finally {
            this.myConfigurationLock.writeLock().unlock();
        }
    }

    @Override
    public void dropMutableChunkStorage() {
        this.myConfigurationLock.writeLock().lock();
        try {
            if (this.myInitialized != null) {
                IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySharedIndexStorage});
                this.mySharedIndexStorage = null;
            }
            try {
                SharedIndexStorageHolder.deleteMutableStorage();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (this.myInitialized != null) {
                try {
                    this.mySharedIndexStorage = SharedIndexStorageHolder.openStoragesOrReset(() -> {});
                }
                catch (Exception e) {
                    LOG.error("Failed to initialize shared index chunk storage after mutable storage reset", (Throwable)e);
                }
            }
        }
        finally {
            this.myConfigurationLock.writeLock().unlock();
        }
    }

    @Override
    public void shutdown() {
        this.myConfigurationLock.writeLock().lock();
        try {
            if (this.myInitialized != null) {
                Set<Integer> disposedChunkIds = this.myChunkManager.disposeChunks();
                this.myChunkManager = null;
                this.myChunkDescriptorEnumerator = null;
                SharedIndexChunkConfigurationImpl.shutDownChunks(this.myChunkMap, disposedChunkIds);
                this.myChunkMap = null;
                this.myInitialized = null;
                IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySharedIndexStorage});
                this.mySharedIndexStorage = null;
            }
        }
        finally {
            this.myConfigurationLock.writeLock().unlock();
        }
        LOG.trace("Shared index chunks shutdown was performed successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyChunk(boolean onlyOpen) {
        ProgressIndicatorUtils.awaitWithCheckCanceled((Lock)this.myConfigurationLock.readLock());
        try {
            boolean hasOpenChunks;
            if (this.myInitialized == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = hasOpenChunks = this.myChunkManager.getOpenChunkIds().size() > 0;
            if (onlyOpen) {
                boolean bl2 = hasOpenChunks;
                return bl2;
            }
            boolean bl3 = this.mySharedIndexStorage.getSharedIndexStats().getChunks() > 0 || !this.myChunkDescriptorEnumerator.isEmpty() || hasOpenChunks;
            return bl3;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    @Override
    public boolean isSharedIndexAcceptable(@NotNull ID<?, ?> indexId2, int chunkId, @NotNull IndexedFile indexedFile) {
        if (indexId2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(1);
        }
        if (indexedFile == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(2);
        }
        Boolean result2 = this.querySharedIndex(indexId2, chunkId, index2 -> {
            if (index2 instanceof HashBasedMapReduceIndex) {
                return ((HashBasedMapReduceIndex)index2).acceptsFile(indexedFile);
            }
            if (index2 instanceof EmptyIndex) {
                return true;
            }
            return false;
        });
        return Boolean.TRUE.equals(result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Key, Value> boolean hasSharedIndex(@NotNull ID<Key, Value> indexId2, int chunkId) {
        if (indexId2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(3);
        }
        if (chunkId == -1) {
            return false;
        }
        this.myConfigurationLock.readLock().lock();
        try {
            if (this.myInitialized == null) {
                boolean bl = false;
                return bl;
            }
            Map<Integer, SharedIndex<?, ?>> map = this.myChunkMap.get(indexId2);
            boolean bl = map != null && map.containsKey(chunkId);
            return bl;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Key, Value, E extends Exception> boolean processSharedIndexes(@NotNull ID<Key, Value> indexId2, @NotNull SharedIndexChunkConfiguration.SharedIndexProcessor<Key, Value, E> processor) throws E {
        if (indexId2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(5);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((Lock)this.myConfigurationLock.readLock());
        try {
            if (this.myInitialized == null) {
                boolean bl = true;
                return bl;
            }
            Map<Integer, SharedIndex<?, ?>> map = this.myChunkMap.get(indexId2);
            if (map == null) {
                boolean bl = true;
                return bl;
            }
            for (SharedIndex<?, ?> sharedIndex : map.values()) {
                if (processor.process(sharedIndex.getIndex())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <Key, Value, Result, E extends Exception> Result querySharedIndex(@NotNull ID<Key, Value> indexId2, int chunkId, @NotNull SharedIndexChunkConfiguration.SharedIndexQuery<Key, Value, Result, E> query) throws E {
        if (indexId2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(6);
        }
        if (query == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(7);
        }
        this.myConfigurationLock.readLock().lock();
        try {
            if (this.myInitialized == null) {
                Result Result = null;
                return Result;
            }
            Map<Integer, SharedIndex<?, ?>> chunkToIndex = this.myChunkMap.get(indexId2);
            if (chunkToIndex == null) {
                Result Result = null;
                return Result;
            }
            SharedIndex<?, ?> sharedIndex = chunkToIndex.get(chunkId);
            if (sharedIndex == null) {
                Result Result = null;
                return Result;
            }
            Result Result = query.calculate(sharedIndex.getIndex());
            return Result;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tryEnumerateContentHash(@NotNull IndexedFile indexedFile) {
        if (indexedFile == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(8);
        }
        if (indexedFile instanceof HashSuppliedIndexedFile) {
            return ((HashSuppliedIndexedFile)indexedFile).getHashId();
        }
        this.myConfigurationLock.readLock().lock();
        try {
            if (this.myInitialized == null) {
                long l = FileContentHashIndexExtension.NULL_HASH_ID;
                return l;
            }
            long l = this.myChunkManager.tryEnumerateContentHash(indexedFile);
            return l;
        }
        catch (IOException t) {
            LOG.debug("Failed to compute hash for " + indexedFile + ". " + t.getMessage(), (Throwable)t);
            long l = FileContentHashIndexExtension.NULL_HASH_ID;
            return l;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public DownloadIndexResult downloadChunk(@NotNull ChunkDescriptor descriptor, @Nullable Project project, @NotNull ProgressIndicator indicator) {
        DownloadIndexResult outcome;
        block22: {
            AttachChunkResult attachResult;
            if (descriptor == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(9);
            }
            if (indicator == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(10);
            }
            this.initialize();
            String chunkUniqueId = descriptor.getChunkUniqueId();
            if (this.myExcludedChunkList.isChunkExcluded(chunkUniqueId)) {
                LOG.info("Shared index (" + descriptor + ") download declined: chunk is in exclude list");
                DownloadIndexResult downloadIndexResult = DownloadIndexResult.DECLINED;
                if (downloadIndexResult == null) {
                    SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(11);
                }
                return downloadIndexResult;
            }
            Boolean isDownloadNeeded = this.isDownloadNeeded(chunkUniqueId);
            if (isDownloadNeeded == null) {
                LOG.info("Can't fetch shared index (" + descriptor + "): shared index storage is not initialized");
                DownloadIndexResult downloadIndexResult = DownloadIndexResult.FAILED;
                if (downloadIndexResult == null) {
                    SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(12);
                }
                return downloadIndexResult;
            }
            if (!this.myDownloadingChunks.add(chunkUniqueId)) {
                LOG.debug("Shared index (" + descriptor + ") download declined: chunk downloading is in progress already");
                DownloadIndexResult downloadIndexResult = DownloadIndexResult.DECLINED;
                if (downloadIndexResult == null) {
                    SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(13);
                }
                return downloadIndexResult;
            }
            if (isDownloadNeeded.booleanValue()) {
                LOG.debug("Fetching shared index (" + descriptor + ") ...");
                indicator.pushState();
                try {
                    indicator.setIndeterminate(true);
                    if (!this.doDownloadChunk(descriptor, indicator, project)) {
                        LOG.info("Failed to download shared index (" + descriptor + ")");
                        DownloadIndexResult downloadIndexResult = DownloadIndexResult.FAILED;
                        DownloadIndexResult downloadIndexResult2 = downloadIndexResult;
                        if (downloadIndexResult2 == null) {
                            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(14);
                        }
                        return downloadIndexResult2;
                    }
                    LOG.debug("Shared index (" + descriptor + ") has been fetched");
                    outcome = DownloadIndexResult.JUST_DOWNLOADED;
                }
                finally {
                    indicator.popState();
                }
            } else {
                LOG.debug("Shared index (" + descriptor + ") already exists");
                outcome = DownloadIndexResult.ALREADY_EXISTS;
            }
            if (project == null || (attachResult = this.openChunkForProject(descriptor, null, project, indicator)) != null && attachResult.isSuccess()) break block22;
            LOG.info("Shared index (" + descriptor + ") can't be attached to a project '" + project.getName() + "'");
            DownloadIndexResult downloadIndexResult = DownloadIndexResult.FAILED;
            DownloadIndexResult downloadIndexResult3 = downloadIndexResult;
            if (downloadIndexResult3 == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(15);
            }
            return downloadIndexResult3;
            finally {
                this.myDownloadingChunks.remove(chunkUniqueId);
            }
        }
        DownloadIndexResult downloadIndexResult = outcome;
        if (downloadIndexResult == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(16);
        }
        return downloadIndexResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Collection<String> getAttachedChunks(@NotNull Project project) {
        if (project == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(17);
        }
        this.myConfigurationLock.readLock().lock();
        if (this.myInitialized == null) {
            List<String> list = Collections.emptyList();
            List<String> list2 = list;
            if (list2 == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(18);
            }
            return list2;
        }
        Collection collection = this.myChunkManager.getOpenChunkIds().stream().filter(chunkId -> this.myChunkManager.isProjectAttachedToChunk((int)chunkId, project)).map(this::getChunkUniqueId).collect(Collectors.toList());
        Collection collection2 = collection;
        if (collection2 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(19);
        }
        return collection2;
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    @Nullable
    private Boolean isDownloadNeeded(@NotNull String chunkUniqueId) {
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(20);
        }
        try {
            this.myConfigurationLock.readLock().lock();
            if (this.myInitialized == null) {
                Boolean bl = null;
                return bl;
            }
            Boolean bl = this.mySharedIndexStorage.getChunkRoot(chunkUniqueId) == null;
            return bl;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDownloadChunk(@NotNull ChunkDescriptor descriptor, @NotNull ProgressIndicator indicator, @Nullable Project project) {
        String chunkUniqueId;
        Path chunkTempFile;
        if (descriptor == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(22);
        }
        if ((chunkTempFile = SharedIndexChunkConfigurationImpl.downloadChunkToTempFile(chunkUniqueId = descriptor.getChunkUniqueId(), descriptor, indicator, project)) == null) {
            return false;
        }
        try {
            SharedIndexStorageHolder storage;
            indicator.setText(SharedIndexesBundle.message("configuring.shared.indexes", new Object[0]));
            this.myConfigurationLock.readLock().lock();
            try {
                if (this.myInitialized == null) {
                    boolean bl = false;
                    return bl;
                }
                storage = this.mySharedIndexStorage;
            }
            finally {
                this.myConfigurationLock.readLock().unlock();
            }
            if (storage == null) {
                boolean bl = false;
                return bl;
            }
            try {
                long startTime = System.currentTimeMillis();
                storage.addChunk(chunkTempFile, chunkUniqueId, descriptor.getChunkStorageOption());
                LOG.debug("Chunk " + chunkUniqueId + " is appended into the store in " + (System.currentTimeMillis() - startTime) + " ms");
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) {
                    ExceptionUtil.rethrow((Throwable)e);
                }
                if (e instanceof IOException) {
                    this.myConfigurationLock.writeLock().lock();
                    try {
                        this.myExcludedChunkList.markChunksAsExcluded(chunkUniqueId, e);
                    }
                    finally {
                        this.myConfigurationLock.writeLock().unlock();
                    }
                }
                LOG.error("Failed to attach shared index " + descriptor + ". " + e.getMessage(), e);
                boolean bl = false;
                FileUtil.delete((File)chunkTempFile.toFile());
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            FileUtil.delete((File)chunkTempFile.toFile());
        }
    }

    @Nullable
    private static Path downloadChunkToTempFile(@NotNull String chunkUniqueId, @NotNull ChunkDescriptor descriptor, @NotNull ProgressIndicator indicator, @Nullable Project project) {
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(23);
        }
        if (descriptor == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(25);
        }
        Path chunkTempDir = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve("downloading");
        Path chunkTempFile = chunkTempDir.resolve(chunkUniqueId + "_" + System.currentTimeMillis() + "_temp.zip");
        try {
            Files.createDirectories(chunkTempDir, new FileAttribute[0]);
            if (!descriptor.downloadChunk(chunkTempFile, project, indicator)) {
                LOG.debug("Failed to download shared index " + descriptor + ".");
                return null;
            }
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            LOG.warn("Failed to download shared index " + descriptor + ". " + e.getMessage(), e);
            return null;
        }
        return chunkTempFile;
    }

    @Override
    public boolean attachExistingChunk(@NotNull Project project, @NotNull String chunkUniqueId) {
        AttachChunkResult result2;
        if (project == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(26);
        }
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(27);
        }
        return (result2 = this.openChunkForProject(null, chunkUniqueId, project, null)) != null && result2.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AttachChunkResult openChunkForProject(@Nullable ChunkDescriptor descriptor, @Nullable String chunkUniqueIdFallback, @NotNull Project project, @Nullable ProgressIndicator indicator) {
        AttachChunkResult attachChunkResult;
        String chunkUniqueId;
        if (project == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(28);
        }
        String string = chunkUniqueId = descriptor == null ? chunkUniqueIdFallback : descriptor.getChunkUniqueId();
        if (chunkUniqueId == null) {
            throw new IllegalArgumentException("Either descriptor or chunkUniqueIdFallback should be provided");
        }
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).waitUntilIndicesAreInitialized();
        this.myConfigurationLock.writeLock().lock();
        try {
            if (this.myInitialized == null) {
                AttachChunkResult attachChunkResult2 = null;
                return attachChunkResult2;
            }
            int chunkEnumeratedId = this.myChunkDescriptorEnumerator.enumerate(chunkUniqueId);
            if (indicator != null) {
                indicator.setText(SharedIndexesBundle.message("configuring.shared.indexes", new Object[0]));
                indicator.setIndeterminate(true);
            }
            attachChunkResult = this.registerChunk(chunkEnumeratedId, chunkUniqueId, project);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            if (e instanceof IOException) {
                this.myExcludedChunkList.markChunksAsExcluded(chunkUniqueId, e);
            }
            LOG.error("Failed to register shared indexes chunk: " + chunkUniqueId + ". " + e.getMessage(), e);
            AttachChunkResult attachChunkResult3 = null;
            return attachChunkResult3;
        }
        finally {
            this.myConfigurationLock.writeLock().unlock();
        }
        String kind2 = descriptor == null ? SharedIndexChunkConfigurationImpl.guessKindFromChunkUniqueId(chunkUniqueId) : descriptor.getKind();
        SharedIndexesFusCollector.reportIndexAttached(project, kind2, chunkUniqueId, attachChunkResult);
        if (attachChunkResult instanceof AttachChunkResult.Success) {
            AttachChunkResult.Success success = (AttachChunkResult.Success)attachChunkResult;
            String indexName = success.getMetadata().getIndexName();
            JsonPercentages fbMatch = new JsonPercentages((long)success.getMatchingFbIndexes().size(), (long)(success.getMatchingFbIndexes().size() + success.getMismatchingFbIndexes().size()));
            JsonPercentages stubMatch = new JsonPercentages((long)success.getMatchingStubIndexes().size(), (long)(success.getMatchingStubIndexes().size() + success.getMismatchingStubIndexes().size()));
            SharedIndexDiagnostic.INSTANCE.onIndexAttachSuccess(project, kind2, indexName, chunkUniqueId, fbMatch, stubMatch);
        } else if (attachChunkResult instanceof AttachChunkResult.Incompatible) {
            SharedIndexDiagnostic.INSTANCE.onIndexAttachIncompatible(project, kind2, chunkUniqueId);
        } else if (attachChunkResult instanceof AttachChunkResult.NotFound) {
            SharedIndexDiagnostic.INSTANCE.onIndexAttachNotFound(project, kind2, chunkUniqueId);
        } else if (attachChunkResult instanceof AttachChunkResult.Excluded) {
            SharedIndexDiagnostic.INSTANCE.onIndexAttachExcluded(project, kind2, chunkUniqueId);
        }
        return attachChunkResult;
    }

    @NotNull
    static String guessKindFromChunkUniqueId(@NotNull String chunkUniqueId) {
        String kind2;
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(29);
        }
        String string = StringUtil.isEmpty((String)(kind2 = StringUtil.substringBefore((String)chunkUniqueId, (String)"-"))) ? "unknown" : kind2;
        if (string == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Nullable
    private String getChunkUniqueId(int chunkId) {
        return this.myChunkDescriptorEnumerator.valueOf(chunkId);
    }

    @Override
    @NotNull
    public Collection<ID<?, ?>> attachExistingChunk(int chunkId, @NotNull Project project) {
        if (project == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(31);
        }
        LOG.assertTrue(chunkId != -1);
        String chunkUniqueId = this.getChunkUniqueId(chunkId);
        return chunkUniqueId == null ? Collections.emptyList() : this.attachExistingIndex(chunkUniqueId, chunkId, project);
    }

    @NotNull
    private List<ID<?, ?>> attachExistingIndex(@NotNull String chunkUniqueId, int chunkId, @NotNull Project project) {
        List<ID<?, ?>> list;
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(32);
        }
        if (project == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(33);
        }
        try {
            AttachChunkResult result2 = this.registerChunk(chunkId, chunkUniqueId, project);
            list = result2.getMatchingFbIndexes();
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            SharedIndexStorageUtil.logAttachError("Failed to attach a known chunkId = " + chunkId + ". " + e.getMessage(), e);
            List<ID<?, ?>> list2 = Collections.emptyList();
            if (list2 == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(35);
            }
            return list2;
        }
        if (list == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Override
    public boolean isAvailableChunk(@NotNull String chunkUniqueId) {
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(36);
        }
        this.initialize();
        this.myConfigurationLock.readLock().lock();
        try {
            if (this.myInitialized == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mySharedIndexStorage.isCompatibleChunk(chunkUniqueId);
            return bl;
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markOpenChunksAsExcluded(boolean keepBundledIndexes, @NotNull String reason) {
        List<String> chunkNames;
        if (reason == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(37);
        }
        this.myConfigurationLock.readLock().lock();
        try {
            chunkNames = this.myChunkManager.getOpenChunkIds().stream().map(chunkId -> {
                try {
                    return this.getChunkUniqueId((int)chunkId);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        finally {
            this.myConfigurationLock.readLock().unlock();
        }
        if (keepBundledIndexes) {
            List<String> bundledChunkIds = ((BundledSharedIndexesResolver)ApplicationManager.getApplication().getService(BundledSharedIndexesResolver.class)).listChunkIds();
            chunkNames.removeAll(bundledChunkIds);
        }
        this.myExcludedChunkList.markChunksAsExcluded(chunkNames, (Throwable)new Exception(reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private AttachChunkResult registerChunk(int chunkId, @NotNull String chunkUniqueId, @NotNull Project project) throws IOException {
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(38);
        }
        if (project == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(39);
        }
        if (this.myExcludedChunkList.isChunkExcluded(chunkUniqueId)) {
            SharedIndexProjectSettings.getInstance(project).recordNotAttachedChunk(chunkUniqueId);
            AttachChunkResult.Excluded excluded = AttachChunkResult.Excluded.INSTANCE;
            if (excluded == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(40);
            }
            return excluded;
        }
        this.myConfigurationLock.writeLock().lock();
        if (this.myInitialized == null) {
            throw new ProcessCanceledException();
        }
        AttachChunkResult indexAttachResult = this.myChunkManager.getIndexAttachResult(chunkId);
        if (indexAttachResult != null) {
            if (!this.myChunkManager.isProjectAttachedToChunk(chunkId, project)) {
                this.myChunkManager.attachProjectToChunk(chunkId, project);
                SharedIndexProjectSettings.getInstance(project).recordAttachedChunk(chunkUniqueId);
            }
            AttachChunkResult attachChunkResult = indexAttachResult;
            AttachChunkResult attachChunkResult2 = attachChunkResult;
            if (attachChunkResult2 == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(41);
            }
            return attachChunkResult2;
        }
        AttachChunkResult indexAttachChunkResult = this.openFileBasedIndexChunk(chunkId, chunkUniqueId);
        if (indexAttachChunkResult instanceof AttachChunkResult.Incompatible) {
            String message = "Chunk " + chunkUniqueId + " is incompatible and is not registered for project '" + project.getName() + "'";
            this.myExcludedChunkList.markChunksAsExcluded(chunkUniqueId, (Throwable)new Exception(message));
            LOG.warn(message);
            SharedIndexProjectSettings.getInstance(project).recordNotAttachedChunk(chunkUniqueId);
        } else if (indexAttachChunkResult instanceof AttachChunkResult.Success) {
            AttachChunkResult.Success successResult = (AttachChunkResult.Success)indexAttachChunkResult;
            this.myChunkManager.attachChunk(chunkId, successResult.getChunkRoot(), indexAttachChunkResult);
            this.myChunkManager.attachProjectToChunk(chunkId, project);
            SharedIndexProjectSettings.getInstance(project).recordAttachedChunk(chunkUniqueId);
            successResult.initializeIndexes();
            for (SharedIndex<?, ?> index2 : successResult.getAllMatchingIndexes()) {
                this.myChunkMap.computeIfAbsent(index2.getIndexName(), __ -> new HashMap()).putIfAbsent(index2.getChunkId(), index2);
            }
            LOG.info("Chunk " + chunkUniqueId + " is registered for project '" + project.getName() + ": " + indexAttachChunkResult.toLogMessage());
        } else if (indexAttachChunkResult instanceof AttachChunkResult.NotFound) {
            String message = "Chunk " + chunkUniqueId + " is not found and is not registered for project '" + project.getName() + "'";
            LOG.info(message);
            SharedIndexProjectSettings.getInstance(project).recordNotAttachedChunk(chunkUniqueId);
        }
        AttachChunkResult attachChunkResult = indexAttachChunkResult;
        AttachChunkResult attachChunkResult3 = attachChunkResult;
        if (attachChunkResult3 == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(42);
        }
        return attachChunkResult3;
        finally {
            this.myConfigurationLock.writeLock().unlock();
        }
    }

    @NotNull
    private AttachChunkResult openFileBasedIndexChunk(int chunkId, @NotNull String chunkUniqueId) throws IOException {
        Path chunkRoot;
        if (chunkUniqueId == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(43);
        }
        if ((chunkRoot = this.mySharedIndexStorage.getChunkRoot(chunkUniqueId)) == null) {
            AttachChunkResult.NotFound notFound = AttachChunkResult.NotFound.INSTANCE;
            if (notFound == null) {
                SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(44);
            }
            return notFound;
        }
        SharedIndexStats sharedIndexStats = this.mySharedIndexStorage.getSharedIndexStats();
        AttachChunkResult attachChunkResult = SharedIndexStorageUtil.openFileBasedIndexChunks(chunkId, chunkRoot, sharedIndexStats);
        if (attachChunkResult == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(45);
        }
        return attachChunkResult;
    }

    @NotNull
    static Path getSharedIndexConfigurationRoot() {
        Path root = PathManager.getIndexRoot().resolve(SHARED_INDEXES_ROOT);
        if (!Files.exists(root, new LinkOption[0])) {
            try {
                Files.createDirectories(root, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Path path = root;
        if (path == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(46);
        }
        return path;
    }

    private static void shutDownChunks(@NotNull Map<ID<?, ?>, Map<Integer, SharedIndex<?, ?>>> myChunkMap, @NotNull Set<Integer> expectedChunkIds) {
        if (myChunkMap == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(47);
        }
        if (expectedChunkIds == null) {
            SharedIndexChunkConfigurationImpl.$$$reportNull$$$0(48);
        }
        for (Map<Integer, SharedIndex<?, ?>> chunksForId : myChunkMap.values()) {
            for (Map.Entry<Integer, SharedIndex<?, ?>> entry : chunksForId.entrySet()) {
                Integer chunkId = entry.getKey();
                if (!expectedChunkIds.contains(chunkId)) {
                    LOG.error("Inconsistent shared index chunk configuration: chunkId " + chunkId + " can't be found among " + expectedChunkIds);
                }
                SharedIndex<?, ?> index2 = entry.getValue();
                IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{index2});
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 17, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33, 36, 37, 38, 39, 43, 47, 48 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/SharedIndexChunkConfigurationImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 9: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 36: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkUniqueId";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myChunkMap";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedChunkIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initialize";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/SharedIndexChunkConfigurationImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadChunk";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedChunks";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "guessKindFromChunkUniqueId";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "attachExistingIndex";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "registerChunk";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileBasedIndexChunk";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedIndexConfigurationRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSharedIndexAcceptable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasSharedIndex";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processSharedIndexes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "querySharedIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryEnumerateContentHash";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "downloadChunk";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedChunks";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDownloadNeeded";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadChunk";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "downloadChunkToTempFile";
                break;
            }
            case 26: 
            case 27: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "attachExistingChunk";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "openChunkForProject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "guessKindFromChunkUniqueId";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "attachExistingIndex";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableChunk";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "markOpenChunksAsExcluded";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "registerChunk";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "openFileBasedIndexChunk";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "shutDownChunks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 17, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33, 36, 37, 38, 39, 43, 47, 48 -> new IllegalArgumentException(string);
        };
    }
}

