/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.uiDesigner.HierarchyChangeListener;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NotNull;

public abstract class SelectionWatcher {
    private final MyPropertyChangeListener myChangeListener;
    private RadRootContainer myRootContainer;
    private final GuiEditor myEditor;
    private final HierarchyChangeListener myHierarchyChangeListener;

    public SelectionWatcher(final GuiEditor editor) {
        this.myEditor = editor;
        this.myChangeListener = new MyPropertyChangeListener();
        this.myRootContainer = editor.getRootContainer();
        this.myHierarchyChangeListener = new HierarchyChangeListener(){

            @Override
            public void hierarchyChanged() {
                if (SelectionWatcher.this.myRootContainer != editor.getRootContainer()) {
                    SelectionWatcher.this.deinstall(SelectionWatcher.this.myRootContainer);
                    SelectionWatcher.this.myRootContainer = editor.getRootContainer();
                    SelectionWatcher.this.install(SelectionWatcher.this.myRootContainer);
                }
            }
        };
    }

    public void setupListeners() {
        this.install(this.myRootContainer);
        this.myEditor.addHierarchyChangeListener(this.myHierarchyChangeListener);
    }

    public void dispose() {
        this.deinstall(this.myRootContainer);
        this.myEditor.removeHierarchyChangeListener(this.myHierarchyChangeListener);
    }

    private void install(@NotNull RadComponent component) {
        if (component == null) {
            SelectionWatcher.$$$reportNull$$$0(0);
        }
        component.addPropertyChangeListener(this.myChangeListener);
        if (component instanceof RadContainer) {
            RadContainer container = (RadContainer)component;
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                this.install(container.getComponent(i));
            }
        }
    }

    private void deinstall(@NotNull RadComponent component) {
        if (component == null) {
            SelectionWatcher.$$$reportNull$$$0(1);
        }
        component.removePropertyChangeListener(this.myChangeListener);
        if (component instanceof RadContainer) {
            RadContainer container = (RadContainer)component;
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                this.deinstall(container.getComponent(i));
            }
        }
    }

    protected abstract void selectionChanged(RadComponent var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "component";
        objectArray2[1] = "com/intellij/uiDesigner/SelectionWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deinstall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("selected".equals(e.getPropertyName())) {
                Boolean selected = (Boolean)e.getNewValue();
                SelectionWatcher.this.selectionChanged((RadComponent)e.getSource(), selected);
            } else if ("children".equals(e.getPropertyName())) {
                RadComponent[] oldChildren = (RadComponent[])e.getOldValue();
                for (int i = oldChildren.length - 1; i >= 0; --i) {
                    SelectionWatcher.this.deinstall(oldChildren[i]);
                }
                RadComponent[] newChildren = (RadComponent[])e.getNewValue();
                for (int i = newChildren.length - 1; i >= 0; --i) {
                    SelectionWatcher.this.install(newChildren[i]);
                }
            }
        }
    }
}

