/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.actions.GroupButtonsAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.IButtonGroup;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UngroupButtonsAction
extends AbstractGuiEditorAction {
    public UngroupButtonsAction() {
        super(true);
    }

    @Override
    protected void actionPerformed(GuiEditor editor, List<? extends RadComponent> selection, AnActionEvent e) {
        if (selection.size() == 1) {
            RadComponent component = selection.get(0);
            IButtonGroup iButtonGroup = FormEditingUtil.findGroupForComponent(editor.getRootContainer(), component);
            editor.getRootContainer().deleteGroup((RadButtonGroup)iButtonGroup);
        } else {
            for (RadComponent radComponent : selection) {
                editor.getRootContainer().setGroupForComponent(radComponent, null);
            }
        }
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<? extends RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            UngroupButtonsAction.$$$reportNull$$$0(0);
        }
        boolean visible = GroupButtonsAction.allButtons(selection);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && UngroupButtonsAction.canUngroup(editor, selection));
    }

    private static boolean canUngroup(GuiEditor editor, List<? extends RadComponent> selectedComponents) {
        if (selectedComponents.size() < 2) {
            return selectedComponents.size() == 1;
        }
        return UngroupButtonsAction.isSameGroup(editor, selectedComponents);
    }

    public static boolean isSameGroup(GuiEditor editor, List<? extends RadComponent> selectedComponents) {
        RadRootContainer rootContainer = editor.getRootContainer();
        IButtonGroup group = FormEditingUtil.findGroupForComponent(rootContainer, selectedComponents.get(0));
        if (group == null) {
            return false;
        }
        for (int i = 1; i < selectedComponents.size(); ++i) {
            if (FormEditingUtil.findGroupForComponent(rootContainer, selectedComponents.get(i)) == group) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/actions/UngroupButtonsAction", "update"));
    }
}

