/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.reference.SoftReference;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.Painter;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.lang.ref.Reference;

public final class CachedGridImage {
    private static final Object CACHED_GRID_IMAGE_KEY = new Object();
    private static final float[] ourDashes = new float[]{3.0f, 1.0f};
    private final Image myImage;
    private int[] myHorzGridLines;
    private int[] myVertGridLines;
    private int[] myRows;
    private int[] myRowSpans;
    private int[] myCols;
    private int[] myColSpans;

    private CachedGridImage(RadContainer container) {
        GraphicsConfiguration graphicsConfiguration = WindowManagerEx.getInstanceEx().getFrame(container.getProject()).getGraphicsConfiguration();
        if (container.getWidth() * container.getHeight() < 0x1000000) {
            this.myImage = graphicsConfiguration.createCompatibleImage(container.getWidth(), container.getHeight(), 2);
            this.update(container);
        } else {
            this.myImage = graphicsConfiguration.createCompatibleImage(16, 16, 2);
        }
    }

    private void update(RadContainer container) {
        if (container.getWidth() * container.getHeight() >= 0x1000000) {
            return;
        }
        int count = container.getComponentCount();
        int[] rows = new int[count];
        int[] rowSpans = new int[count];
        int[] cols = new int[count];
        int[] colSpans = new int[count];
        for (int i = 0; i < count; ++i) {
            GridConstraints c = container.getComponent(i).getConstraints();
            rows[i] = c.getRow();
            rowSpans[i] = c.getRowSpan();
            cols[i] = c.getColumn();
            colSpans[i] = c.getColSpan();
        }
        int[] horzGridLines = container.getGridLayoutManager().getHorizontalGridLines(container);
        int[] vertGridLines = container.getGridLayoutManager().getVerticalGridLines(container);
        if (!(CachedGridImage.arraysEqual(horzGridLines, this.myHorzGridLines) && CachedGridImage.arraysEqual(vertGridLines, this.myVertGridLines) && CachedGridImage.arraysEqual(rows, this.myRows) && CachedGridImage.arraysEqual(rowSpans, this.myRowSpans) && CachedGridImage.arraysEqual(cols, this.myCols) && CachedGridImage.arraysEqual(colSpans, this.myColSpans))) {
            this.myHorzGridLines = horzGridLines;
            this.myVertGridLines = vertGridLines;
            this.myRows = rows;
            this.myRowSpans = rowSpans;
            this.myCols = cols;
            this.myColSpans = colSpans;
            this.repaint(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaint(RadContainer container) {
        int height;
        int width = container.getWidth();
        if (width * (height = container.getHeight()) >= 0x1000000) {
            return;
        }
        Graphics2D g2d = (Graphics2D)this.myImage.getGraphics();
        try {
            int i;
            int lastLine;
            g2d.setComposite(AlphaComposite.Clear);
            g2d.fillRect(0, 0, width, height);
            g2d.setComposite(AlphaComposite.Src);
            if (container.isSelected()) {
                g2d.setColor(Painter.SELECTED_GRID_COLOR);
            } else {
                g2d.setColor(Painter.NON_SELECTED_GRID_COLOR);
            }
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, ourDashes, 0.0f));
            if (this.myHorzGridLines.length > 0) {
                lastLine = container.getDelegee().getHeight() - this.myHorzGridLines[this.myHorzGridLines.length - 1] > 4 ? this.myHorzGridLines.length : this.myHorzGridLines.length - 1;
                for (i = 1; i < lastLine; ++i) {
                    int y = this.myHorzGridLines[i];
                    g2d.drawLine(0, y, width, y);
                }
            }
            if (this.myVertGridLines.length > 0) {
                lastLine = container.getDelegee().getWidth() - this.myVertGridLines[this.myVertGridLines.length - 1] > 4 ? this.myVertGridLines.length : this.myVertGridLines.length - 1;
                for (i = 1; i < lastLine; ++i) {
                    int x = this.myVertGridLines[i];
                    g2d.drawLine(x, 0, x, height);
                }
            }
            g2d.setComposite(AlphaComposite.Clear);
            g2d.setStroke(new BasicStroke(1.0f));
            for (RadComponent childComponent : container.getComponents()) {
                GridConstraints constraints = childComponent.getConstraints();
                if (constraints.getColSpan() > 1) {
                    for (int col = constraints.getColumn() + 1; col < constraints.getColumn() + constraints.getColSpan(); ++col) {
                        this.drawVertGridLine(g2d, col, constraints.getRow(), constraints.getRowSpan());
                    }
                }
                if (constraints.getRowSpan() <= 1) continue;
                for (int row = constraints.getRow() + 1; row < constraints.getRow() + constraints.getRowSpan(); ++row) {
                    this.drawHorzGridLine(g2d, row, constraints.getColumn(), constraints.getColSpan());
                }
            }
        }
        finally {
            g2d.dispose();
        }
    }

    private void drawVertGridLine(Graphics2D g2d, int col, int row, int rowSpan) {
        if (col < 0 || col >= this.myVertGridLines.length || row < 0 || row + rowSpan >= this.myHorzGridLines.length) {
            return;
        }
        g2d.drawLine(this.myVertGridLines[col], this.myHorzGridLines[row] + 4, this.myVertGridLines[col], this.myHorzGridLines[row + rowSpan] - 4);
    }

    private void drawHorzGridLine(Graphics2D g2d, int row, int col, int colSpan) {
        if (col < 0 || col + colSpan >= this.myVertGridLines.length || row < 0 || row >= this.myHorzGridLines.length) {
            return;
        }
        g2d.drawLine(this.myVertGridLines[col] + 4, this.myHorzGridLines[row], this.myVertGridLines[col + colSpan] - 4, this.myHorzGridLines[row]);
    }

    private static boolean arraysEqual(int[] newArray, int[] oldArray) {
        if (oldArray == null || newArray.length != oldArray.length) {
            return false;
        }
        for (int i = 0; i < oldArray.length; ++i) {
            if (newArray[i] == oldArray[i]) continue;
            return false;
        }
        return true;
    }

    private boolean sizeEquals(RadContainer container) {
        return this.myImage.getWidth(null) == container.getWidth() && this.myImage.getHeight(null) == container.getHeight();
    }

    private Image getImage() {
        return this.myImage;
    }

    public static Image getGridImage(RadContainer container) {
        java.lang.ref.SoftReference imageRef = (java.lang.ref.SoftReference)container.getDelegee().getClientProperty(CACHED_GRID_IMAGE_KEY);
        CachedGridImage gridImage = (CachedGridImage)SoftReference.dereference((Reference)imageRef);
        if (gridImage != null && gridImage.sizeEquals(container)) {
            gridImage.update(container);
        } else {
            gridImage = new CachedGridImage(container);
            container.getDelegee().putClientProperty(CACHED_GRID_IMAGE_KEY, new java.lang.ref.SoftReference<CachedGridImage>(gridImage));
        }
        return gridImage.getImage();
    }
}

