/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.ColorChooserService;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.lw.ColorDescriptor;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ColorEditor
extends PropertyEditor<ColorDescriptor> {
    private final String myPropertyName;
    private final TextFieldWithBrowseButton myTextField = new TextFieldWithBrowseButton();
    private ColorDescriptor myValue;

    public ColorEditor(String propertyName) {
        this.myPropertyName = propertyName;
        this.myTextField.getTextField().setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.myTextField.getTextField().setEditable(false);
        this.myTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = UIDesignerBundle.message("color.chooser.title", ColorEditor.this.myPropertyName);
                Color color = ColorChooserService.getInstance().showDialog((Component)ColorEditor.this.myTextField, title, ColorEditor.this.myValue.getColor());
                if (color != null) {
                    ColorEditor.this.myValue = new ColorDescriptor(color);
                    ColorEditor.this.updateTextField();
                }
            }
        });
    }

    @Override
    public ColorDescriptor getValue() throws Exception {
        return this.myValue;
    }

    @Override
    public JComponent getComponent(RadComponent component, ColorDescriptor value, InplaceContext inplaceContext) {
        this.myValue = value != null ? value : new ColorDescriptor((Color)JBColor.BLACK);
        this.updateTextField();
        return this.myTextField;
    }

    private void updateTextField() {
        this.myTextField.setText(this.myValue == null ? "" : this.myValue.toString());
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)this.myTextField);
    }
}

