/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractIntProperty;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.FlowLayout;
import java.awt.LayoutManager;

public final class HGapProperty
extends AbstractIntProperty<RadContainer> {
    public static HGapProperty getInstance(Project project) {
        return (HGapProperty)project.getService(HGapProperty.class);
    }

    public HGapProperty() {
        super(null, "Horizontal Gap", -1);
    }

    @Override
    public Integer getValue(RadContainer component) {
        if (component.getLayout() instanceof BorderLayout) {
            BorderLayout layout = (BorderLayout)component.getLayout();
            return layout.getHgap();
        }
        if (component.getLayout() instanceof FlowLayout) {
            FlowLayout layout = (FlowLayout)component.getLayout();
            return layout.getHgap();
        }
        if (component.getLayout() instanceof CardLayout) {
            CardLayout layout = (CardLayout)component.getLayout();
            return layout.getHgap();
        }
        LayoutManager layoutManager = component.getLayout();
        if (layoutManager instanceof AbstractLayout) {
            AbstractLayout layoutManager2 = (AbstractLayout)layoutManager;
            return layoutManager2.getHGap();
        }
        return null;
    }

    @Override
    protected void setValueImpl(RadContainer component, Integer value) throws Exception {
        if (component.getLayout() instanceof BorderLayout) {
            BorderLayout layout = (BorderLayout)component.getLayout();
            layout.setHgap(value);
        } else if (component.getLayout() instanceof FlowLayout) {
            FlowLayout layout = (FlowLayout)component.getLayout();
            layout.setHgap(value);
        } else if (component.getLayout() instanceof CardLayout) {
            CardLayout layout = (CardLayout)component.getLayout();
            layout.setHgap(value);
        } else {
            AbstractLayout layoutManager = (AbstractLayout)component.getLayout();
            layoutManager.setHGap(value.intValue());
        }
    }

    @Override
    protected int getDefaultValue(RadContainer radContainer) {
        return HGapProperty.getDefaultGap(radContainer.getLayout());
    }

    static int getDefaultGap(LayoutManager layout) {
        if (layout instanceof FlowLayout) {
            return 5;
        }
        if (layout instanceof BorderLayout || layout instanceof CardLayout) {
            return 0;
        }
        return -1;
    }
}

