/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadComponentFactory;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RadScrollPane
extends RadContainer {
    public static final Class COMPONENT_CLASS = JScrollPane.class;
    private static final Logger LOG = Logger.getInstance(RadScrollPane.class);

    public RadScrollPane(ModuleProvider module, Class componentClass, String id) {
        super(module, componentClass, id);
    }

    public RadScrollPane(Class componentClass, String id, Palette palette) {
        super(componentClass, id, palette);
    }

    @Override
    @NotNull
    protected RadLayoutManager createInitialLayoutManager() {
        return new RadScrollPaneLayoutManager();
    }

    @Override
    public void write(XmlWriter writer) {
        writer.startElement("scrollpane");
        try {
            this.writeNoLayout(writer, JScrollPane.class.getName());
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    public RadComponent getActionTargetComponent(RadComponent child) {
        return this;
    }

    private class RadScrollPaneLayoutManager
    extends RadLayoutManager {
        private MyDropLocation myDropLocation = null;

        private RadScrollPaneLayoutManager() {
        }

        @Override
        @Nullable
        public String getName() {
            return null;
        }

        @Override
        public void writeChildConstraints(XmlWriter writer, RadComponent child) {
        }

        @Override
        @NotNull
        public ComponentDropLocation getDropLocation(RadContainer container, @Nullable Point location) {
            if (this.myDropLocation == null) {
                this.myDropLocation = new MyDropLocation();
            }
            MyDropLocation myDropLocation = this.myDropLocation;
            if (myDropLocation == null) {
                RadScrollPaneLayoutManager.$$$reportNull$$$0(0);
            }
            return myDropLocation;
        }

        @Override
        public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
            try {
                JScrollPane scrollPane = (JScrollPane)container.getDelegee();
                JComponent delegee = component.getDelegee();
                delegee.setLocation(0, 0);
                scrollPane.setViewportView(delegee);
            }
            catch (ClassCastException e) {
                LOG.info((Throwable)e);
                LOG.info("container classloader=" + container.getDelegee().getClass().getClassLoader());
                LOG.info("component classloader=" + component.getDelegee().getClass().getClassLoader());
                throw e;
            }
        }

        @Override
        public void removeComponentFromContainer(RadContainer container, RadComponent component) {
            JScrollPane scrollPane = (JScrollPane)container.getDelegee();
            scrollPane.setViewportView(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadScrollPane$RadScrollPaneLayoutManager", "getDropLocation"));
        }
    }

    private class MyDropLocation
    implements ComponentDropLocation {
        private MyDropLocation() {
        }

        @Override
        public RadContainer getContainer() {
            return RadScrollPane.this;
        }

        @Override
        public boolean canDrop(ComponentDragObject dragObject) {
            return dragObject.getComponentCount() == 1 && RadScrollPane.this.getComponentCount() == 0;
        }

        @Override
        public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
            feedbackLayer.putFeedback(RadScrollPane.this.getDelegee(), new Rectangle(0, 0, RadScrollPane.this.getWidth(), RadScrollPane.this.getHeight()), RadScrollPane.this.getDisplayName());
        }

        @Override
        public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
            RadScrollPane.this.addComponent(components[0]);
        }

        @Override
        @Nullable
        public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
            return null;
        }
    }

    public static class Factory
    extends RadComponentFactory {
        @Override
        public RadComponent newInstance(ModuleProvider module, Class aClass, String id) {
            return new RadScrollPane(module, aClass, id);
        }

        @Override
        public RadComponent newInstance(Class componentClass, String id, Palette palette) {
            return new RadScrollPane(componentClass, id, palette);
        }
    }
}

