/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.newUiOnboarding;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.ide.newUiOnboarding.NewUiOnboardingBean;
import com.intellij.platform.ide.newUiOnboarding.NewUiOnboardingCustomization;
import com.intellij.platform.ide.newUiOnboarding.NewUiOnboardingDialog;
import com.intellij.platform.ide.newUiOnboarding.NewUiOnboardingExecutor;
import com.intellij.platform.ide.newUiOnboarding.NewUiOnboardingStatistics;
import com.intellij.platform.ide.newUiOnboarding.NewUiOnboardingStep;
import com.intellij.util.KeyedLazyInstanceEP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001a\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\f0\bH\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/ide/newUiOnboarding/NewUiOnboardingService;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getDefaultStepsOrder", "", "", "getStepOrder", "getSteps", "Lkotlin/Pair;", "Lcom/intellij/platform/ide/newUiOnboarding/NewUiOnboardingStep;", "showOnboardingDialog", "", "startOnboarding", "Companion", "intellij.platform.ide.newUiOnboarding"})
@SourceDebugExtension(value={"SMAP\nNewUiOnboardingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewUiOnboardingService.kt\ncom/intellij/platform/ide/newUiOnboarding/NewUiOnboardingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1603#2,9:79\n1855#2:88\n1856#2:91\n1612#2:92\n1#3:89\n1#3:90\n*S KotlinDebug\n*F\n+ 1 NewUiOnboardingService.kt\ncom/intellij/platform/ide/newUiOnboarding/NewUiOnboardingService\n*L\n41#1:79,9\n41#1:88\n41#1:91\n41#1:92\n41#1:90\n*E\n"})
public final class NewUiOnboardingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;

    public NewUiOnboardingService(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
    }

    public final void showOnboardingDialog() {
        NewUiOnboardingDialog dialog2 = new NewUiOnboardingDialog(this.project);
        NewUiOnboardingStatistics.INSTANCE.logWelcomeDialogShown(this.project);
        boolean startTour = dialog2.showAndGet();
        if (startTour) {
            this.startOnboarding();
            NewUiOnboardingStatistics.INSTANCE.logOnboardingStarted(this.project, NewUiOnboardingStatistics.OnboardingStartingPlace.WELCOME_DIALOG);
        } else {
            ToolWindow toolWindow;
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Meet New UI");
            if (toolWindow2 != null) {
                toolWindow2.activate(null);
            }
            NewUiOnboardingStatistics.INSTANCE.logWelcomeDialogSkipPressed(this.project);
        }
    }

    public final void startOnboarding() {
        List<Pair<String, NewUiOnboardingStep>> steps = this.getSteps();
        NewUiOnboardingExecutor executor = new NewUiOnboardingExecutor(this.project, steps, this.cs, (Disposable)this.project);
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(executor, null){
            int label;
            final /* synthetic */ NewUiOnboardingExecutor $executor;
            {
                this.$executor = $executor;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$executor.start((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, NewUiOnboardingStep>> getSteps() {
        void $this$mapNotNullTo$iv$iv;
        List<String> stepIds = this.getStepOrder();
        KeyedLazyInstanceEP[] stepExtensions = (KeyedLazyInstanceEP[])NewUiOnboardingStep.Companion.getEP_NAME().getExtensions();
        Iterable $this$mapNotNull$iv = stepIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            NewUiOnboardingStep step2;
            KeyedLazyInstanceEP keyedLazyInstanceEP;
            String id;
            block2: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                id = (String)element$iv$iv;
                boolean bl2 = false;
                KeyedLazyInstanceEP[] keyedLazyInstanceEPArray = stepExtensions;
                int n = keyedLazyInstanceEPArray.length;
                for (int i = 0; i < n; ++i) {
                    KeyedLazyInstanceEP keyedLazyInstanceEP2;
                    KeyedLazyInstanceEP it = keyedLazyInstanceEP2 = keyedLazyInstanceEPArray[i];
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.key, (Object)id)) continue;
                    keyedLazyInstanceEP = keyedLazyInstanceEP2;
                    break block2;
                }
                keyedLazyInstanceEP = null;
            }
            NewUiOnboardingStep newUiOnboardingStep = step2 = keyedLazyInstanceEP != null ? (NewUiOnboardingStep)keyedLazyInstanceEP.getInstance() : null;
            if (((newUiOnboardingStep != null ? newUiOnboardingStep.isAvailable() : false) ? TuplesKt.to((Object)id, (Object)step2) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> getStepOrder() {
        List<String> defaultOrder = this.getDefaultStepsOrder();
        List<NewUiOnboardingCustomization> customizations = NewUiOnboardingBean.Companion.getInstance().getCustomizations();
        if (customizations.isEmpty()) {
            return defaultOrder;
        }
        List mutableSteps = CollectionsKt.toMutableList((Collection)defaultOrder);
        for (NewUiOnboardingCustomization customization : customizations) {
            customization.customize(mutableSteps);
        }
        return mutableSteps;
    }

    private final List<String> getDefaultStepsOrder() {
        Object[] objectArray = new String[]{"mainMenu", "projectWidget", "gitWidget", "runWidget", "codeWithMe", "toolWindowLayouts", "moreToolWindows", "navigationBar"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @JvmStatic
    @NotNull
    public static final NewUiOnboardingService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/ide/newUiOnboarding/NewUiOnboardingService$Companion;", "", "()V", "getInstance", "Lcom/intellij/platform/ide/newUiOnboarding/NewUiOnboardingService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.newUiOnboarding"})
    @SourceDebugExtension(value={"SMAP\nNewUiOnboardingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewUiOnboardingService.kt\ncom/intellij/platform/ide/newUiOnboarding/NewUiOnboardingService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,78:1\n30#2,3:79\n*S KotlinDebug\n*F\n+ 1 NewUiOnboardingService.kt\ncom/intellij/platform/ide/newUiOnboarding/NewUiOnboardingService$Companion\n*L\n76#1:79,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final NewUiOnboardingService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NewUiOnboardingService> serviceClass$iv = NewUiOnboardingService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (NewUiOnboardingService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

