/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.BooleanMap;
import io.kinference.ndarray.arrays.BooleanNDArray;
import io.kinference.ndarray.arrays.LongNDArray;
import io.kinference.ndarray.arrays.MutableBooleanNDArray;
import io.kinference.ndarray.arrays.MutableNDArray;
import io.kinference.ndarray.arrays.MutableNDArrayCore;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.NDArrayUtilsKt;
import io.kinference.ndarray.arrays.NDIndexer;
import io.kinference.ndarray.arrays.NDIndexerKt;
import io.kinference.ndarray.arrays.PadMode;
import io.kinference.ndarray.arrays.PrimitiveToPrimitiveFunction;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.pointers.BooleanPointer;
import io.kinference.ndarray.arrays.pointers.BooleanPointerKt;
import io.kinference.ndarray.arrays.pointers.LongPointer;
import io.kinference.ndarray.arrays.tiled.BooleanTiledArray;
import io.kinference.ndarray.arrays.tiled.LongTiledArray;
import io.kinference.ndarray.broadcasting.Broadcasting;
import io.kinference.ndarray.extensions.NDArrayExtensionsKt;
import io.kinference.ndarray.extensions.broadcasting.BroadcastTwoArgumentsBooleanKt;
import io.kinference.primitives.types.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0016\u0018\u0000 c2\u00020\u0001:\u0001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB#\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\rB\u0015\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0086D\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J!\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u0001H\u0016J\b\u0010'\u001a\u00020(H\u0016J'\u0010)\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020$H\u0016J\u0013\u00100\u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u000101H\u0096\u0002J\u0019\u00102\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\u0016\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u00106J\u0015\u00107\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u00108J\u0019\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010=J!\u00109\u001a\u00020$2\u0006\u0010;\u001a\u00020<2\u0006\u0010#\u001a\u00020>H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0011\u0010@\u001a\u00020AH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ\u0019\u0010C\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0086D\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J!\u0010C\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J=\u0010D\u001a\u00020\u00002\u0018\u0010E\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070G0F2\u0006\u0010H\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u00010,H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010KJ\u0019\u0010L\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010MJ\r\u0010N\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010OJH\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020R2\u0006\u0010T\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010U\u001a\u00020\u00032\u0006\u0010V\u001a\u00020\u00032\u0006\u0010W\u001a\u00020\u0003H\u0002J)\u0010P\u001a\u00020$2\u0006\u0010U\u001a\u00020\u00032\u0006\u0010V\u001a\u00020\u00032\u0006\u0010W\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010XJ\u0019\u0010Y\u001a\u00020\u00002\u0006\u0010Z\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\b\u0010[\u001a\u00020$H\u0016J\u0019\u0010\\\u001a\u00020\u00002\u0006\u0010]\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\u0011\u0010^\u001a\u00020\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ\u0010\u0010_\u001a\u00020\u00002\u0006\u0010]\u001a\u00020\u0003H\u0002J\u0014\u0010`\u001a\u00020\u00002\n\u0010a\u001a\u00020\u0003\"\u00020\u0007H\u0016J\u0019\u0010b\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0086D\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J!\u0010b\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\fR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006d"}, d2={"Lio/kinference/ndarray/arrays/BooleanNDArray;", "Lio/kinference/ndarray/arrays/NDArrayCore;", "shape", "", "([I)V", "init", "Lkotlin/Function1;", "", "", "([ILkotlin/jvm/functions/Function1;)V", "strides", "Lio/kinference/ndarray/arrays/Strides;", "(Lio/kinference/ndarray/arrays/Strides;)V", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/jvm/functions/Function1;)V", "array", "Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;", "(Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;Lio/kinference/ndarray/arrays/Strides;)V", "getArray", "()Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;", "setArray", "(Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;)V", "blocksInRow", "getBlocksInRow", "()I", "<set-?>", "getStrides", "()Lio/kinference/ndarray/arrays/Strides;", "setStrides", "type", "Lio/kinference/primitives/types/DataType;", "getType", "()Lio/kinference/primitives/types/DataType;", "and", "other", "(Lio/kinference/ndarray/arrays/BooleanNDArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "destination", "Lio/kinference/ndarray/arrays/MutableBooleanNDArray;", "(Lio/kinference/ndarray/arrays/BooleanNDArray;Lio/kinference/ndarray/arrays/MutableBooleanNDArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clone", "close", "", "concat", "others", "", "Lio/kinference/ndarray/arrays/NDArray;", "axis", "(Ljava/util/List;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copyIfNotMutable", "equals", "", "expand", "([ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "get", "index", "([I)Ljava/lang/Boolean;", "getLinear", "(I)Ljava/lang/Boolean;", "map", "Lio/kinference/ndarray/arrays/MutableNDArrayCore;", "function", "Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;", "(Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/kinference/ndarray/arrays/MutableNDArray;", "(Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;Lio/kinference/ndarray/arrays/MutableNDArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nonZero", "Lio/kinference/ndarray/arrays/LongNDArray;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "or", "pad", "pads", "", "Lkotlin/Pair;", "mode", "Lio/kinference/ndarray/arrays/PadMode;", "constantValue", "([Lkotlin/Pair;Lio/kinference/ndarray/arrays/PadMode;Lio/kinference/ndarray/arrays/NDArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reshape", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "singleValue", "()Ljava/lang/Boolean;", "slice", "dst", "Lio/kinference/ndarray/arrays/pointers/BooleanPointer;", "src", "offset", "starts", "ends", "steps", "([I[I[ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tile", "repeats", "toMutable", "transpose", "permutations", "transpose2D", "transposeByBlocks", "view", "axes", "xor", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nBooleanNDArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanNDArray.kt\nio/kinference/ndarray/arrays/BooleanNDArray\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 BooleanPointer.kt\nio/kinference/ndarray/arrays/pointers/BooleanPointerKt\n+ 6 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,587:1\n12895#2,4:588\n12313#2,2:638\n1#3:592\n1#3:605\n1789#4,3:593\n1549#4:596\n1620#4,2:597\n1789#4,3:599\n1622#4:602\n1855#4:603\n1856#4:636\n1283#5:604\n1285#5,30:606\n175#5,18:640\n26#6:637\n*S KotlinDebug\n*F\n+ 1 BooleanNDArray.kt\nio/kinference/ndarray/arrays/BooleanNDArray\n*L\n48#1:588,4\n285#1:638,2\n184#1:605\n176#1:593,3\n177#1:596\n177#1:597,2\n179#1:599,3\n177#1:602\n183#1:603\n183#1:636\n184#1:604\n184#1:606,30\n305#1:640,18\n206#1:637\n*E\n"})
public class BooleanNDArray
implements NDArrayCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BooleanTiledArray array;
    @NotNull
    private final DataType type;
    @NotNull
    private Strides strides;

    public BooleanNDArray(@NotNull BooleanTiledArray array, @NotNull Strides strides2) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
        this.array = array;
        this.type = DataType.BOOLEAN;
        this.strides = strides2;
    }

    @NotNull
    public final BooleanTiledArray getArray() {
        return this.array;
    }

    public final void setArray(@NotNull BooleanTiledArray booleanTiledArray) {
        Intrinsics.checkNotNullParameter((Object)booleanTiledArray, (String)"<set-?>");
        this.array = booleanTiledArray;
    }

    public BooleanNDArray(@NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this(BooleanTiledArray.Companion.invoke(shape), new Strides(shape));
    }

    public BooleanNDArray(@NotNull int[] shape, @NotNull Function1<? super Integer, Boolean> init) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(BooleanTiledArray.Companion.invoke(shape, init), new Strides(shape));
    }

    public BooleanNDArray(@NotNull Strides strides2) {
        Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
        this(BooleanTiledArray.Companion.invoke(strides2), strides2);
    }

    public BooleanNDArray(@NotNull Strides strides2, @NotNull Function1<? super Integer, Boolean> init) {
        Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(BooleanTiledArray.Companion.invoke(strides2, init), strides2);
    }

    @Override
    @NotNull
    public DataType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public final Strides getStrides() {
        return this.strides;
    }

    protected final void setStrides(@NotNull Strides strides2) {
        Intrinsics.checkNotNullParameter((Object)strides2, (String)"<set-?>");
        this.strides = strides2;
    }

    protected final int getBlocksInRow() {
        return this.strides.getLinearSize() == 0 ? 0 : (this.strides.getShape().length == 0 ? 1 : ArraysKt.last((int[])this.strides.getShape()) / this.array.getBlockSize());
    }

    @Override
    @NotNull
    public NDArrayCore clone() {
        return new BooleanNDArray(this.array.copyOf(), new Strides(this.getShape()));
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BooleanNDArray view(int ... axes2) {
        void $this$foldIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)axes2, (String)"axes");
        int n = axes2.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            int axis2 = axes2[i];
            if (this.getShape()[i2] > axis2) continue;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] nArray = axes2;
        int initial$iv22 = 0;
        int $i$f$foldIndexed = 0;
        int index$iv = 0;
        int accumulator$iv = initial$iv22;
        for (void element$iv : $this$foldIndexed$iv) {
            void i;
            void acc;
            int n2 = index$iv++;
            void var11_16 = element$iv;
            int n3 = accumulator$iv;
            int index = n2;
            boolean bl = false;
            accumulator$iv = acc + i * this.strides.getStrides()[index];
        }
        int offset = accumulator$iv;
        int[] initial$iv22 = this.getShape();
        $i$f$foldIndexed = axes2.length;
        index$iv = this.getShape().length;
        int[] newShape = ArraysKt.copyOfRange((int[])initial$iv22, (int)$i$f$foldIndexed, (int)index$iv);
        Strides newStrides = new Strides(newShape);
        if (this.array.getBlockSize() == 0) {
            return new BooleanNDArray(this.array, newStrides);
        }
        int offsetBlocks = offset / this.array.getBlockSize();
        int countBlocks = newStrides.getLinearSize() / this.array.getBlockSize();
        Object[] objectArray = (Object[])this.array.getBlocks();
        int n4 = offsetBlocks + countBlocks;
        boolean[][] copyBlocks = (boolean[][])ArraysKt.copyOfRange((Object[])objectArray, (int)offsetBlocks, (int)n4);
        BooleanTiledArray newArray = new BooleanTiledArray(copyBlocks);
        return new BooleanNDArray(newArray, newStrides);
    }

    @Override
    @NotNull
    public Boolean get(@NotNull int[] index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (!(index.length == this.getRank())) {
            boolean bl = false;
            String string = "Index size should contain " + this.getRank() + " elements, but " + index.length + " given";
            throw new IllegalArgumentException(string.toString());
        }
        int linearIndex = this.strides.offset(index);
        return this.array.get(linearIndex);
    }

    @Override
    @NotNull
    public Boolean getLinear(int index) {
        return this.array.get(index);
    }

    @Override
    @NotNull
    public Boolean singleValue() {
        if (!(NDArrayUtilsKt.isScalar(this) || this.array.getSize() == 1)) {
            boolean bl = false;
            String string = "NDArray contains more than 1 value";
            throw new IllegalArgumentException(string.toString());
        }
        return this.array.getBlocks()[0][0];
    }

    @Override
    @NotNull
    public MutableBooleanNDArray toMutable() {
        return new MutableBooleanNDArray(this.array.copyOf(), this.strides);
    }

    @Override
    @NotNull
    public MutableBooleanNDArray copyIfNotMutable() {
        return new MutableBooleanNDArray(this.array, this.strides);
    }

    @Nullable
    public Object map(@NotNull PrimitiveToPrimitiveFunction function, @NotNull MutableNDArray destination, @NotNull Continuation<? super MutableBooleanNDArray> $completion) {
        return BooleanNDArray.map$suspendImpl(this, function, destination, $completion);
    }

    static /* synthetic */ Object map$suspendImpl(BooleanNDArray $this, PrimitiveToPrimitiveFunction function, MutableNDArray destination, Continuation<? super MutableBooleanNDArray> $completion) {
        Intrinsics.checkNotNull((Object)function, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.BooleanMap");
        BooleanMap cfr_ignored_0 = (BooleanMap)function;
        Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableBooleanNDArray");
        MutableBooleanNDArray cfr_ignored_1 = (MutableBooleanNDArray)destination;
        int n = destination.getLinearSize();
        for (int index = 0; index < n; ++index) {
            ((MutableBooleanNDArray)destination).getArray().set(index, ((BooleanMap)function).apply($this.array.get(index)));
        }
        return destination;
    }

    @Override
    @Nullable
    public Object map(@NotNull PrimitiveToPrimitiveFunction function, @NotNull Continuation<? super MutableNDArrayCore> $completion) {
        return this.map(function, (MutableNDArray)new MutableBooleanNDArray(this.strides), (Continuation<? super MutableBooleanNDArray>)$completion);
    }

    @Nullable
    public Object slice(@NotNull int[] starts, @NotNull int[] ends, @NotNull int[] steps, @NotNull Continuation<? super MutableBooleanNDArray> $completion) {
        return BooleanNDArray.slice$suspendImpl(this, starts, ends, steps, $completion);
    }

    static /* synthetic */ Object slice$suspendImpl(BooleanNDArray $this, int[] starts, int[] ends, int[] steps, Continuation<? super MutableBooleanNDArray> $completion) {
        int n = $this.getShape().length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int length = Math.abs(ends[n2] - starts[n2]);
            int rest = length % Math.abs(steps[n2]);
            nArray[n2] = length / Math.abs(steps[n2]) + (rest != 0 ? 1 : 0);
        }
        int[] newShape = nArray;
        Strides newStrides = new Strides(newShape);
        BooleanTiledArray newArray = BooleanTiledArray.Companion.invoke(newStrides);
        if (newArray.getSize() > 0) {
            $this.slice(BooleanTiledArray.pointer$default(newArray, 0, 1, null), BooleanTiledArray.pointer$default($this.array, 0, 1, null), 0, 0, $this.getShape(), starts, ends, steps);
        }
        return new MutableBooleanNDArray(newArray, newStrides);
    }

    private final void slice(BooleanPointer dst, BooleanPointer src, int offset, int axis2, int[] shape, int[] starts, int[] ends, int[] steps) {
        IntProgression range2;
        int start2 = starts[axis2];
        int end2 = ends[axis2];
        int step2 = steps[axis2];
        IntProgression intProgression = range2 = step2 > 0 ? RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)start2, (int)end2)), (int)step2) : RangesKt.step((IntProgression)RangesKt.downTo((int)start2, (int)(end2 + 1)), (int)(-step2));
        if (axis2 == shape.length - 1) {
            int index = range2.getFirst();
            int n = range2.getLast();
            int n2 = range2.getStep();
            if (n2 > 0 && index <= n || n2 < 0 && n <= index) {
                while (true) {
                    src.setLinearIndex(offset + index);
                    dst.set(src.get());
                    dst.increment();
                    if (index != n) {
                        index += n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int dim = 1;
            int n = shape.length;
            for (int ind = axis2 + 1; ind < n; ++ind) {
                dim *= shape[ind];
            }
            int index = range2.getFirst();
            n = range2.getLast();
            int n3 = range2.getStep();
            if (n3 > 0 && index <= n || n3 < 0 && n <= index) {
                while (true) {
                    this.slice(dst, src, offset + index * dim, axis2 + 1, shape, starts, ends, steps);
                    if (index == n) break;
                    index += n3;
                }
            }
        }
    }

    @Nullable
    public final Object or(@NotNull BooleanNDArray other, @NotNull MutableBooleanNDArray destination, @NotNull Continuation<? super BooleanNDArray> $completion) {
        return BroadcastTwoArgumentsBooleanKt.broadcastTwoTensorsBoolean(this, other, destination, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)or.2.INSTANCE), $completion);
    }

    @Nullable
    public final Object or(@NotNull BooleanNDArray other, @NotNull Continuation<? super BooleanNDArray> $completion) {
        int[][] nArrayArray = new int[][]{this.getShape(), other.getShape()};
        return this.or(other, new MutableBooleanNDArray(NDArrayUtilsKt.broadcastShape(CollectionsKt.listOf((Object[])((Object[])nArrayArray)))), $completion);
    }

    @Nullable
    public final Object and(@NotNull BooleanNDArray other, @NotNull MutableBooleanNDArray destination, @NotNull Continuation<? super BooleanNDArray> $completion) {
        return BroadcastTwoArgumentsBooleanKt.broadcastTwoTensorsBoolean(this, other, destination, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)and.2.INSTANCE), $completion);
    }

    @Nullable
    public final Object and(@NotNull BooleanNDArray other, @NotNull Continuation<? super BooleanNDArray> $completion) {
        int[][] nArrayArray = new int[][]{this.getShape(), other.getShape()};
        return this.and(other, new MutableBooleanNDArray(NDArrayUtilsKt.broadcastShape(CollectionsKt.listOf((Object[])((Object[])nArrayArray)))), $completion);
    }

    @Nullable
    public final Object xor(@NotNull BooleanNDArray other, @NotNull MutableBooleanNDArray destination, @NotNull Continuation<? super BooleanNDArray> $completion) {
        return BroadcastTwoArgumentsBooleanKt.broadcastTwoTensorsBoolean(this, other, destination, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)xor.2.INSTANCE), $completion);
    }

    @Nullable
    public final Object xor(@NotNull BooleanNDArray other, @NotNull Continuation<? super BooleanNDArray> $completion) {
        int[][] nArrayArray = new int[][]{this.getShape(), other.getShape()};
        return this.xor(other, new MutableBooleanNDArray(NDArrayUtilsKt.broadcastShape(CollectionsKt.listOf((Object[])((Object[])nArrayArray)))), $completion);
    }

    @Nullable
    public Object concat(@NotNull List<? extends NDArray> others, int axis2, @NotNull Continuation<? super MutableBooleanNDArray> $completion) {
        return BooleanNDArray.concat$suspendImpl(this, others, axis2, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object concat$suspendImpl(BooleanNDArray $this, List<? extends NDArray> others, int axis2, Continuation<? super MutableBooleanNDArray> $completion) {
        void $this$mapTo$iv$iv;
        void $this$fold$iv;
        int n;
        Object object3;
        int actualAxis = NDArrayUtilsKt.indexAxis($this, axis2);
        List list = CollectionsKt.toMutableList((Collection)others);
        Iterable it = list;
        int n2 = 0;
        it.add(0, $this);
        List inputs = list;
        int[] nArray = $this.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(this, size)");
        int[] resultShape = nArray2;
        it = inputs;
        int n3 = actualAxis;
        Object object2 = resultShape;
        n2 = 0;
        for (Object object3 : it) {
            void it2;
            NDArray nDArray = (NDArray)object3;
            n = n2;
            boolean bl = false;
            int n4 = it2.getShape()[actualAxis];
            n2 = n + n4;
        }
        object2[n3] = n = n2;
        MutableBooleanNDArray result2 = new MutableBooleanNDArray(resultShape);
        BooleanPointer resultPointer = BooleanTiledArray.pointer$default(result2.getArray(), 0, 1, null);
        object3 = ArraysKt.take((int[])resultShape, (int)actualAxis);
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv22 = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            int n5 = ((Number)element$iv).intValue();
            int p0 = accumulator$iv22;
            boolean bl = false;
            accumulator$iv22 = p0 * p1;
        }
        int numIterations = accumulator$iv22;
        Iterable $this$map$iv = inputs;
        boolean $i$f$map = false;
        Iterable accumulator$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$fold$iv2;
            void initial$iv2;
            Object object4;
            void it3;
            NDArray bl = (NDArray)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl2 = false;
            if (!(it3 instanceof BooleanNDArray)) {
                object4 = "Failed requirement.";
                throw new IllegalArgumentException(object4.toString());
            }
            Iterable iterable = ArraysKt.drop((int[])it3.getShape(), (int)actualAxis);
            object4 = Boxing.boxInt((int)1);
            BooleanPointer booleanPointer = BooleanTiledArray.pointer$default(((BooleanNDArray)it3).array, 0, 1, null);
            boolean $i$f$fold2 = false;
            Integer accumulator$iv = initial$iv2;
            for (Object element$iv : $this$fold$iv2) {
                void p1;
                int n6 = ((Number)element$iv).intValue();
                int p0 = ((Number)accumulator$iv).intValue();
                boolean bl3 = false;
                accumulator$iv = Boxing.boxInt((int)(p0 * p1));
            }
            object2.add(TuplesKt.to((Object)booleanPointer, (Object)accumulator$iv));
        }
        List pointersToSteps = (List)destination$iv$iv;
        for (int i = 0; i < numIterations; ++i) {
            int it4 = i;
            boolean bl = false;
            Iterable $this$forEach$iv = pointersToSteps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean src;
                boolean bl4;
                Object object5;
                int end$iv;
                Pair pair = (Pair)element$iv;
                boolean bl5 = false;
                BooleanPointer pointer = (BooleanPointer)pair.component1();
                int numSteps = ((Number)pair.component2()).intValue();
                BooleanPointer $this$accept$iv = resultPointer;
                boolean $i$f$accept = false;
                if (!BooleanPointerKt.isCompatibleBySize($this$accept$iv, pointer, numSteps)) {
                    boolean $i$a$-require-BooleanPointerKt$accept$11$iv22 = false;
                    String $i$a$-require-BooleanPointerKt$accept$11$iv22 = "Pointers not compatible by available elements";
                    throw new IllegalArgumentException($i$a$-require-BooleanPointerKt$accept$11$iv22.toString());
                }
                if (BooleanPointerKt.isCompatibleWith($this$accept$iv, pointer)) {
                    int dstOffset$iv;
                    boolean[] dstBlock$iv;
                    for (end$iv = numSteps; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                        dstBlock$iv = $this$accept$iv.getCurrentBlock();
                        dstOffset$iv = $this$accept$iv.getIndexInBlock();
                        boolean[] srcBlock$iv = pointer.getCurrentBlock();
                        if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                            $this$accept$iv.blockIncrement();
                            pointer.blockIncrement();
                        } else {
                            $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                            pointer.setIndexInBlock(pointer.getIndexInBlock() + end$iv);
                        }
                        int index$iv = dstOffset$iv;
                        int n7 = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                        while (index$iv < n7) {
                            boolean cfr_ignored_0 = dstBlock$iv[index$iv];
                            boolean bl6 = srcBlock$iv[index$iv];
                            int n8 = index$iv++;
                            object5 = dstBlock$iv;
                            bl4 = false;
                            boolean bl7 = src;
                            object5[n8] = bl7;
                        }
                    }
                    continue;
                }
                while (end$iv > 0) {
                    $this$accept$iv.get();
                    src = pointer.getAndIncrement();
                    object5 = $this$accept$iv;
                    bl4 = false;
                    ((BooleanPointer)object5).set(Boxing.boxBoolean((boolean)src));
                    $this$accept$iv.increment();
                    --end$iv;
                }
            }
        }
        return result2;
    }

    @Nullable
    public Object expand(@NotNull int[] shape, @NotNull Continuation<? super MutableBooleanNDArray> $completion) {
        return BooleanNDArray.expand$suspendImpl(this, shape, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object expand$suspendImpl(BooleanNDArray var0, int[] var1_1, Continuation<? super MutableBooleanNDArray> var2_2) {
        if (!(var2_2 instanceof expand.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BooleanNDArray this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BooleanNDArray.expand$suspendImpl(this.this$0, null, (Continuation<? super MutableBooleanNDArray>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = new int[][]{$this.getShape(), shape};
                outputShape = NDArrayUtilsKt.broadcastShape(CollectionsKt.listOf((Object[])((Object[])var4_6)));
                output = new MutableBooleanNDArray(outputShape);
                $continuation.L$0 = output;
                $continuation.label = 1;
                v0 = Broadcasting.INSTANCE.applyWithBroadcast((List<? extends NDArrayCore>)CollectionsKt.listOf((Object)$this), output, (Function3<? super List<? extends NDArrayCore>, ? super MutableNDArrayCore, ? super Continuation<? super Unit>, ? extends Object>)((Function3)new Function3<List<? extends NDArray>, MutableNDArray, Continuation<? super Unit>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;
                    /* synthetic */ Object L$1;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                List inputs = (List)this.L$0;
                                MutableNDArray destination = (MutableNDArray)this.L$1;
                                Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableBooleanNDArray");
                                MutableBooleanNDArray cfr_ignored_0 = (MutableBooleanNDArray)destination;
                                E e = inputs.get(0);
                                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.BooleanNDArray");
                                BooleanNDArray input = (BooleanNDArray)e;
                                MutableNDArray.DefaultImpls.copyFrom$default(destination, 0, input, 0, 0, 12, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull List<? extends NDArray> p1, @NotNull MutableNDArray p2, @Nullable Continuation<? super Unit> p3) {
                        var var4_4 = new /* invalid duplicate definition of identical inner class */;
                        var4_4.L$0 = p1;
                        var4_4.L$1 = p2;
                        return var4_4.invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super MutableNDArrayCore>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                output = (MutableBooleanNDArray)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                return output;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object nonZero(@NotNull Continuation<? super LongNDArray> $completion) {
        return BooleanNDArray.nonZero$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object nonZero$suspendImpl(BooleanNDArray $this, Continuation<? super LongNDArray> $completion) {
        if (NDArrayUtilsKt.isScalar($this)) {
            LongNDArray longNDArray;
            boolean value = $this.singleValue();
            if (value) {
                boolean $i$f$emptyArray22 = false;
                int[] $i$f$emptyArray22 = new int[]{1, 0};
                LongNDArray longNDArray2 = new LongNDArray(new LongTiledArray(new long[0][]), new Strides($i$f$emptyArray22));
                longNDArray = longNDArray2;
            } else {
                int[] $i$f$emptyArray22 = new int[]{1, 1};
                LongNDArray longNDArray3 = new LongNDArray(new Strides($i$f$emptyArray22), (Function1<? super Integer, Long>)((Function1)nonZero.2.INSTANCE));
                longNDArray = longNDArray3;
            }
            return longNDArray;
        }
        int ndIndexSize = $this.getShape().length;
        Ref.IntRef totalElements = new Ref.IntRef();
        BooleanPointer inputPointer = BooleanTiledArray.pointer$default($this.array, 0, 1, null);
        int[] indicesArray = new int[$this.getLinearSize() * ndIndexSize];
        NDIndexerKt.ndIndices$default($this, null, null, (Function1)new Function1<int[], Unit>(inputPointer, indicesArray, totalElements, ndIndexSize){
            final /* synthetic */ BooleanPointer $inputPointer;
            final /* synthetic */ int[] $indicesArray;
            final /* synthetic */ Ref.IntRef $totalElements;
            final /* synthetic */ int $ndIndexSize;
            {
                this.$inputPointer = $inputPointer;
                this.$indicesArray = $indicesArray;
                this.$totalElements = $totalElements;
                this.$ndIndexSize = $ndIndexSize;
                super(1);
            }

            public final void invoke(@NotNull int[] ndIndex) {
                Intrinsics.checkNotNullParameter((Object)ndIndex, (String)"ndIndex");
                if (this.$inputPointer.getAndIncrement()) {
                    ArraysKt.copyInto$default((int[])ndIndex, (int[])this.$indicesArray, (int)(this.$totalElements.element * this.$ndIndexSize), (int)0, (int)0, (int)12, null);
                    int n = this.$totalElements.element;
                    this.$totalElements.element = n + 1;
                }
            }
        }, 3, null);
        int[] nArray = new int[]{ndIndexSize, totalElements.element};
        Strides nonZeroStrides = new Strides(nArray);
        LongTiledArray indicesByDim = LongTiledArray.Companion.invoke(nonZeroStrides);
        LongPointer resultPointer = LongTiledArray.pointer$default(indicesByDim, 0, 1, null);
        for (int i = 0; i < ndIndexSize; ++i) {
            int n = totalElements.element;
            for (int j = 0; j < n; ++j) {
                resultPointer.set(indicesArray[j * ndIndexSize + i]);
                resultPointer.increment();
            }
        }
        return new LongNDArray(indicesByDim, nonZeroStrides);
    }

    @Nullable
    public Object pad(@NotNull Pair<Integer, Integer>[] pads2, @NotNull PadMode mode2, @Nullable NDArray constantValue, @NotNull Continuation<? super BooleanNDArray> $completion) {
        return BooleanNDArray.pad$suspendImpl(this, pads2, mode2, constantValue, $completion);
    }

    static /* synthetic */ Object pad$suspendImpl(BooleanNDArray $this, Pair<Integer, Integer>[] pads2, PadMode mode2, NDArray constantValue, Continuation<? super BooleanNDArray> $completion) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public Object tile(@NotNull int[] repeats, @NotNull Continuation<? super BooleanNDArray> $completion) {
        return BooleanNDArray.tile$suspendImpl(this, repeats, $completion);
    }

    static /* synthetic */ Object tile$suspendImpl(BooleanNDArray $this, int[] repeats, Continuation<? super BooleanNDArray> $completion) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final BooleanNDArray transposeByBlocks(int[] permutations) {
        Object[] objectArray = (Object[])this.array.getBlocks();
        Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(this, size)");
        boolean[][] outputBlocks = (boolean[][])objectArray2;
        Strides outputStrides = this.strides.transpose(permutations);
        Ref.IntRef axisToStop = new Ref.IntRef();
        axisToStop.element = permutations.length;
        int n = permutations.length + -1;
        if (0 <= n) {
            do {
                int idx;
                if (permutations[idx = n--] == idx) continue;
                axisToStop.element = idx + 1;
                break;
            } while (0 <= n);
        }
        int countBlocksToCopy = NDArrayUtilsKt.computeBlockSize$default(this, axisToStop.element, 0, 2, null) / this.array.getBlockSize();
        BooleanNDArray.transposeByBlocks$transposeByBlocksRec(this, axisToStop, countBlocksToCopy, outputStrides, outputBlocks, permutations, 0, 0, 0);
        return new BooleanNDArray(new BooleanTiledArray(outputBlocks), outputStrides);
    }

    @Nullable
    public Object transpose(@NotNull int[] permutations, @NotNull Continuation<? super BooleanNDArray> $completion) {
        return BooleanNDArray.transpose$suspendImpl(this, permutations, $completion);
    }

    static /* synthetic */ Object transpose$suspendImpl(BooleanNDArray $this, int[] permutations, Continuation<? super BooleanNDArray> $completion) {
        boolean bl;
        block5: {
            if (!(permutations.length == $this.getRank())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int[] $this$all$iv = permutations;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (0 <= it ? it < permutations.length : false) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        if (!bl) {
            String $i$f$all = "Failed requirement.";
            throw new IllegalArgumentException($i$f$all.toString());
        }
        Strides outputStrides = $this.strides.transpose(permutations);
        if (NDArrayExtensionsKt.isTransposeReshape($this, permutations)) {
            return $this.reshape(outputStrides, $completion);
        }
        if (ArraysKt.getLastIndex((int[])permutations) == ArraysKt.last((int[])permutations)) {
            return $this.transposeByBlocks(permutations);
        }
        MutableBooleanNDArray outputArray2 = new MutableBooleanNDArray(outputStrides);
        BooleanNDArray.transpose$transposeRec($this, outputStrides, permutations, outputArray2, 0, 0, 0);
        return outputArray2;
    }

    @Nullable
    public Object transpose2D(@NotNull Continuation<? super BooleanNDArray> $completion) {
        return BooleanNDArray.transpose2D$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object transpose2D$suspendImpl(BooleanNDArray $this, Continuation<? super BooleanNDArray> $completion) {
        if (!($this.getRank() == 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] outputShape2 = ArraysKt.reversedArray((int[])$this.getShape());
        Strides outputStrides = new Strides(outputShape2);
        BooleanTiledArray outputArray2 = BooleanTiledArray.Companion.invoke(outputStrides);
        int newBlocksInRow = outputShape2[1] / outputArray2.getBlockSize();
        int blockNum = 0;
        int n = outputShape2[0];
        for (int row = 0; row < n; ++row) {
            Pair<Integer, Integer> pair = $this.array.indexFor(row);
            int blockOffset = ((Number)pair.component1()).intValue();
            int offset = ((Number)pair.component2()).intValue();
            int col = 0;
            for (int i = 0; i < newBlocksInRow; ++i) {
                boolean[] block = outputArray2.getBlocks()[blockNum++];
                int n2 = outputArray2.getBlockSize();
                for (int idx = 0; idx < n2; ++idx) {
                    block[idx] = $this.array.getBlocks()[blockOffset + col * $this.getBlocksInRow()][offset];
                    ++col;
                }
            }
        }
        return new BooleanNDArray(outputArray2, outputStrides);
    }

    @Nullable
    public Object reshape(@NotNull Strides strides2, @NotNull Continuation<? super BooleanNDArray> $completion) {
        return BooleanNDArray.reshape$suspendImpl(this, strides2, $completion);
    }

    static /* synthetic */ Object reshape$suspendImpl(BooleanNDArray $this, Strides strides2, Continuation<? super BooleanNDArray> $completion) {
        if (!(strides2.getLinearSize() == $this.strides.getLinearSize())) {
            boolean bl = false;
            String string = "Linear size must be equal";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(strides2.getShape().length == 0) && !($this.getShape().length == 0) && ArraysKt.last((int[])strides2.getShape()) != ArraysKt.last((int[])$this.getShape())) {
            BooleanTiledArray newArray = BooleanTiledArray.Companion.invoke(strides2);
            BooleanTiledArray.copyInto$default($this.array, newArray, 0, 0, 0, 14, null);
            return new BooleanNDArray(newArray, strides2);
        }
        return new BooleanNDArray($this.array, strides2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BooleanNDArray)) {
            return false;
        }
        if (this.getType() != ((BooleanNDArray)other).getType()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.strides, (Object)((BooleanNDArray)other).strides)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.array, (Object)((BooleanNDArray)other).array);
    }

    @Override
    @Nullable
    public Object reshape(@NotNull int[] shape, @NotNull Continuation<? super NDArrayCore> $completion) {
        return NDArrayCore.DefaultImpls.reshape(this, shape, $completion);
    }

    @Override
    @Nullable
    public Object squeeze(@NotNull int[] axes2, @NotNull Continuation<? super NDArrayCore> $completion) {
        return NDArrayCore.DefaultImpls.squeeze(this, axes2, $completion);
    }

    @Override
    @Nullable
    public Object unsqueeze(@NotNull int[] axes2, @NotNull Continuation<? super NDArray> $completion) {
        return NDArrayCore.DefaultImpls.unsqueeze(this, axes2, $completion);
    }

    @Override
    @Nullable
    public Object stack(@NotNull List<? extends NDArray> others, int axis2, @NotNull Continuation<? super MutableNDArrayCore> $completion) {
        return NDArrayCore.DefaultImpls.stack(this, others, axis2, $completion);
    }

    @Override
    @Nullable
    public Object split(int parts, int axis2, @NotNull Continuation<? super List<? extends NDArrayCore>> $completion) {
        return NDArrayCore.DefaultImpls.split((NDArrayCore)this, parts, axis2, $completion);
    }

    @Override
    @Nullable
    public Object split(@NotNull int[] split, int axis2, @NotNull Continuation<? super List<? extends NDArray>> $completion) {
        return NDArrayCore.DefaultImpls.split((NDArrayCore)this, split, axis2, $completion);
    }

    @Override
    @Nullable
    public Object gather(@NotNull NDArray indices, int axis2, int batchDims2, @NotNull Continuation<? super NDArrayCore> $completion) {
        return NDArrayCore.DefaultImpls.gather((NDArrayCore)this, indices, axis2, batchDims2, $completion);
    }

    @Override
    @Nullable
    public Object gather(@NotNull NDArray indices, int axis2, @NotNull MutableNDArrayCore dst, @NotNull Continuation<? super NDArrayCore> $completion) {
        return NDArrayCore.DefaultImpls.gather((NDArrayCore)this, indices, axis2, dst, $completion);
    }

    @Override
    public int getLinearSize() {
        return NDArrayCore.DefaultImpls.getLinearSize(this);
    }

    @Override
    public int getRank() {
        return NDArrayCore.DefaultImpls.getRank(this);
    }

    @Override
    @NotNull
    public int[] getShape() {
        return NDArrayCore.DefaultImpls.getShape(this);
    }

    private static final void transposeByBlocks$transposeByBlocksRec(BooleanNDArray this$0, Ref.IntRef axisToStop, int countBlocksToCopy, Strides outputStrides, boolean[][] outputBlocks, int[] $permutations, int axis2, int inputOffset, int outputOffset) {
        int n = axis2;
        if (n == ArraysKt.getLastIndex((int[])this$0.getShape()) ? true : n == axisToStop.element) {
            int inputStartBlockNum = inputOffset / this$0.array.getBlockSize();
            int outputStartBlockNum = outputOffset / this$0.array.getBlockSize();
            int n2 = 0;
            while (n2 < countBlocksToCopy) {
                int it = n2++;
                boolean bl = false;
                outputBlocks[outputStartBlockNum + it] = this$0.array.getBlocks()[inputStartBlockNum + it];
            }
        } else {
            int dims = outputStrides.getShape()[axis2];
            int n3 = 0;
            while (n3 < dims) {
                int dim = n3++;
                boolean bl = false;
                int additionalInputOffset = this$0.strides.getStrides()[$permutations[axis2]] * dim;
                int additionalOutputOffset = outputStrides.getStrides()[axis2] * dim;
                BooleanNDArray.transposeByBlocks$transposeByBlocksRec(this$0, axisToStop, countBlocksToCopy, outputStrides, outputBlocks, $permutations, axis2 + 1, inputOffset + additionalInputOffset, outputOffset + additionalOutputOffset);
            }
        }
    }

    private static final void transpose$transposeRec(BooleanNDArray this$0, Strides outputStrides, int[] $permutations, MutableBooleanNDArray outputArray2, int axis2, int inputOffset, int outputOffset) {
        if (axis2 == ArraysKt.getLastIndex((int[])this$0.getShape())) {
            int offset$iv;
            boolean[] block$iv;
            int dims = outputStrides.getShape()[axis2];
            int inputStride = this$0.strides.getStrides()[$permutations[axis2]];
            int index = 0;
            BooleanPointer $this$map$iv = outputArray2.getArray().pointer(outputOffset);
            boolean $i$f$map = false;
            for (int end$iv = dims; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                block$iv = $this$map$iv.getCurrentBlock();
                if (block$iv.length <= (offset$iv = $this$map$iv.getIndexInBlock()) + end$iv) {
                    $this$map$iv.blockIncrement();
                } else {
                    $this$map$iv.setIndexInBlock($this$map$iv.getIndexInBlock() + end$iv);
                }
                int index$iv = offset$iv;
                int n = Math.min(block$iv.length, offset$iv + end$iv);
                while (index$iv < n) {
                    boolean bl;
                    boolean cfr_ignored_0 = block$iv[index$iv];
                    int n2 = index$iv++;
                    boolean[] blArray = block$iv;
                    boolean bl2 = false;
                    int n3 = index;
                    index = n3 + 1;
                    blArray[n2] = bl = this$0.array.get(inputOffset + inputStride * n3);
                }
            }
        } else {
            int dims = outputStrides.getShape()[axis2];
            int n = 0;
            while (n < dims) {
                int dim = n++;
                boolean bl = false;
                int inputAdditionalOffset = this$0.strides.getStrides()[$permutations[axis2]] * dim;
                int outputAdditionalOffset = outputStrides.getStrides()[axis2] * dim;
                BooleanNDArray.transpose$transposeRec(this$0, outputStrides, $permutations, outputArray2, axis2 + 1, inputOffset + inputAdditionalOffset, outputOffset + outputAdditionalOffset);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ%\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u0086\u0002J\u0019\u0010\t\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0015\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u00020\u0006\"\u00020\bH\u0086\u0002J.\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u00020\u0006\"\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\rH\u0087\u0002\u00a2\u0006\u0002\b\u0011J.\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u00020\u0006\"\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u0087\u0002\u00a2\u0006\u0002\b\u0012J%\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000e\u00a8\u0006\u0015"}, d2={"Lio/kinference/ndarray/arrays/BooleanNDArray$Companion;", "", "()V", "eyeLike", "Lio/kinference/ndarray/arrays/BooleanNDArray;", "shape", "", "k", "", "invoke", "strides", "Lio/kinference/ndarray/arrays/Strides;", "init", "Lkotlin/Function1;", "", "array", "Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;", "invokeVarArg", "invokeNDVarArg", "scalar", "value", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nBooleanNDArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanNDArray.kt\nio/kinference/ndarray/arrays/BooleanNDArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,587:1\n1#2:588\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanNDArray scalar(boolean value) {
            return new BooleanNDArray(new BooleanTiledArray(1, 1, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(value){
                final /* synthetic */ boolean $value;
                {
                    this.$value = $value;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(int it) {
                    return this.$value;
                }
            })), Strides.Companion.getEMPTY());
        }

        @NotNull
        public final BooleanNDArray eyeLike(@NotNull int[] shape, int k2) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            if (!(shape.length == 2)) {
                boolean bl = false;
                String string = "EyeLike is only supported for tensors of rank=2, current shape rank: " + shape.length;
                throw new IllegalArgumentException(string.toString());
            }
            return Companion.invoke(shape, (Function1<? super int[], Boolean>)((Function1)new Function1<int[], Boolean>(k2){
                final /* synthetic */ int $k;
                {
                    this.$k = $k;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull int[] it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int row = it[0];
                    int column = it[1];
                    return column - this.$k == row;
                }
            }));
        }

        public static /* synthetic */ BooleanNDArray eyeLike$default(Companion companion, int[] nArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.eyeLike(nArray, n);
        }

        @NotNull
        public final BooleanNDArray invoke(@NotNull BooleanTiledArray array, @NotNull Strides strides2) {
            BooleanNDArray booleanNDArray;
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            if (blockSize == array.getBlockSize()) {
                booleanNDArray = new BooleanNDArray(array, strides2);
            } else {
                BooleanPointer pointer = new BooleanPointer(array, 0, 2, null);
                booleanNDArray = new BooleanNDArray(strides2, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(pointer){
                    final /* synthetic */ BooleanPointer $pointer;
                    {
                        this.$pointer = $pointer;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(int it) {
                        return this.$pointer.getAndIncrement();
                    }
                }));
            }
            return booleanNDArray;
        }

        @NotNull
        public final BooleanNDArray invoke(@NotNull Strides strides2, @NotNull Function1<? super int[], Boolean> init) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            NDIndexer iterator = new NDIndexer(strides2, null, null, 6, null);
            return new BooleanNDArray(strides2, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(init, iterator){
                final /* synthetic */ Function1<int[], Boolean> $init;
                final /* synthetic */ NDIndexer $iterator;
                {
                    this.$init = $init;
                    this.$iterator = $iterator;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(int it) {
                    return (Boolean)this.$init.invoke((Object)this.$iterator.next());
                }
            }));
        }

        @NotNull
        public final BooleanNDArray invoke(@NotNull int[] shape, @NotNull Function1<? super int[], Boolean> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.invoke(new Strides(shape), init);
        }

        @NotNull
        public final BooleanNDArray invoke(int ... shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return new BooleanNDArray(BooleanTiledArray.Companion.invoke(shape), new Strides(shape));
        }

        @JvmName(name="invokeVarArg")
        @NotNull
        public final BooleanNDArray invokeVarArg(@NotNull int[] shape, @NotNull Function1<? super Integer, Boolean> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return new BooleanNDArray(BooleanTiledArray.Companion.invoke(shape, init), new Strides(shape));
        }

        @JvmName(name="invokeNDVarArg")
        @NotNull
        public final BooleanNDArray invokeNDVarArg(@NotNull int[] shape, @NotNull Function1<? super int[], Boolean> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.invoke(shape, init);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

