/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLinesLexer;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006\u001a\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018\u001a`\u0010\u0019\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0\f0\u001a\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\f2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u00020\u000f0\u001fH\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010 \u001a\u00020!*\u00020\"2\u0006\u0010#\u001a\u00020$\u001a\u0014\u0010%\u001a\u0004\u0018\u00010&*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010'\u001a\u00020\u0002*\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0006\u001a\u0012\u0010(\u001a\u00020\u0002*\u00020\"2\u0006\u0010)\u001a\u00020\u0006\u001a\u0012\u0010*\u001a\u00020\u0002*\u00020\"2\u0006\u0010+\u001a\u00020\u0006\u001a\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\f*\u00020\"2\u0006\u0010-\u001a\u00020\u0001\u001a\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020.*\u00020/2\u0006\u0010-\u001a\u00020\u0001\u001a\u0014\u00100\u001a\u00020&*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a\u0012\u00101\u001a\u00020&*\u00020\u00162\u0006\u00102\u001a\u00020\u0002\u001a\u0014\u00103\u001a\u0004\u0018\u00010&*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0015\u00104\u001a\u00020\u000f*\u00020\u00012\u0006\u00105\u001a\u00020\u0001H\u0086\u0004\u001a\u001e\u00106\u001a\u00020!*\b\u0012\u0004\u0012\u00020\u0001072\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u001aH\u00108\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b\"\b\b\u0001\u00109*\u00020:*\u0002H92!\u0010;\u001a\u001d\u0012\u0013\u0012\u0011H9\u00a2\u0006\f\b=\u0012\b\b>\u0012\u0004\b\b(?\u0012\u0004\u0012\u0002H\u001b0<H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006A"}, d2={"contentLines", "Lkotlin/ranges/IntRange;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "getContentLines", "(Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;)Lkotlin/ranges/IntRange;", "firstContentLine", "", "getFirstContentLine", "(Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;)I", "lastContentLine", "getLastContentLine", "groupNeighborCells", "", "cells", "isLineVisible", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "line", "makeMarkersFromIntervals", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLinesLexer$Marker;", "document", "Lcom/intellij/openapi/editor/Document;", "intervals", "", "trimLists", "Lkotlin/Pair;", "T", "left", "right", "comparator", "Lkotlin/Function2;", "addEditorDocumentListener", "", "Lcom/intellij/openapi/editor/Editor;", "listener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "getBottomMarker", "", "getCell", "getCellByOffset", "offset", "getCellByOrdinal", "ordinal", "getCells", "lines", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines;", "getLineText", "getText", "interval", "getTopMarker", "hasIntersectionWith", "other", "mergeAndJoinIntersections", "", "use", "G", "Ljava/awt/Graphics;", "handler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "g", "(Ljava/awt/Graphics;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookVisualizationUiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookVisualizationUiUtil.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookVisualizationUiUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1#2:173\n*E\n"})
public final class NotebookVisualizationUiUtilKt {
    public static final boolean hasIntersectionWith(@NotNull IntRange $this$hasIntersectionWith, @NotNull IntRange other) {
        Intrinsics.checkNotNullParameter((Object)$this$hasIntersectionWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$hasIntersectionWith.getFirst() <= other.getLast() && $this$hasIntersectionWith.getLast() >= other.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T, G extends Graphics> T use(@NotNull G $this$use, @NotNull Function1<? super G, ? extends T> handler) {
        Object object;
        Intrinsics.checkNotNullParameter($this$use, (String)"<this>");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$use = false;
        try {
            object = handler.invoke($this$use);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$use.dispose();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Pair<List<T>, List<T>> trimLists(@NotNull List<? extends T> left, @NotNull List<? extends T> right, @NotNull Function2<? super T, ? super T, Boolean> comparator) {
        void $this$trimLists_u24lambda_u241;
        int trimRight;
        int trimLeft;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        boolean $i$f$trimLists = false;
        int minSize = Math.min(left.size(), right.size());
        for (trimLeft = 0; trimLeft < minSize && ((Boolean)comparator.invoke(left.get(trimLeft), right.get(trimLeft))).booleanValue(); ++trimLeft) {
        }
        for (trimRight = 0; trimRight < minSize - trimLeft && ((Boolean)comparator.invoke(left.get(left.size() - trimRight - 1), right.get(right.size() - trimRight - 1))).booleanValue(); ++trimRight) {
        }
        List<T> $this$trimLists_u24lambda_u240 = left;
        boolean bl = false;
        List<? extends T> list = $this$trimLists_u24lambda_u240.subList(trimLeft, $this$trimLists_u24lambda_u240.size() - trimRight);
        $this$trimLists_u24lambda_u240 = right;
        List<? extends T> list2 = list;
        boolean bl2 = false;
        return TuplesKt.to(list2, $this$trimLists_u24lambda_u241.subList(trimLeft, $this$trimLists_u24lambda_u241.size() - trimRight));
    }

    public static final void addEditorDocumentListener(@NotNull Editor $this$addEditorDocumentListener, @NotNull DocumentListener listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$addEditorDocumentListener, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (!($this$addEditorDocumentListener instanceof EditorImpl)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!((EditorImpl)$this$addEditorDocumentListener).isDisposed()) {
            ((EditorImpl)$this$addEditorDocumentListener).getDocument().addDocumentListener(listener2, ((EditorImpl)$this$addEditorDocumentListener).getDisposable());
        }
    }

    @NotNull
    public static final String getText(@NotNull Document $this$getText, @NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        String string = $this$getText.getText(new TextRange($this$getText.getLineStartOffset(interval.getLines().getFirst()), $this$getText.getLineEndOffset(interval.getLines().getLast())));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final String getLineText(Document $this$getLineText, int line2) {
        String string = $this$getLineText.getText(new TextRange($this$getLineText.getLineStartOffset(line2), $this$getLineText.getLineEndOffset(line2)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public static final NotebookCellLines.Interval getCell(@NotNull Editor $this$getCell, int line2) {
        Intrinsics.checkNotNullParameter((Object)$this$getCell, (String)"<this>");
        return NotebookCellLines.Companion.get($this$getCell).intervalsIterator(line2).next();
    }

    @NotNull
    public static final List<NotebookCellLines.Interval> getCells(@NotNull Editor $this$getCells, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)$this$getCells, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        return SequencesKt.toList(NotebookVisualizationUiUtilKt.getCells(NotebookCellLines.Companion.get($this$getCells), lines));
    }

    @NotNull
    public static final NotebookCellLines.Interval getCellByOrdinal(@NotNull Editor $this$getCellByOrdinal, int ordinal) {
        Intrinsics.checkNotNullParameter((Object)$this$getCellByOrdinal, (String)"<this>");
        return NotebookCellLines.Companion.get($this$getCellByOrdinal).getIntervals().get(ordinal);
    }

    @NotNull
    public static final NotebookCellLines.Interval getCellByOffset(@NotNull Editor $this$getCellByOffset, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$getCellByOffset, (String)"<this>");
        return NotebookVisualizationUiUtilKt.getCell($this$getCellByOffset, $this$getCellByOffset.getDocument().getLineNumber(offset));
    }

    @NotNull
    public static final Sequence<NotebookCellLines.Interval> getCells(@NotNull NotebookCellLines $this$getCells, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)$this$getCells, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        return SequencesKt.takeWhile((Sequence)SequencesKt.asSequence((Iterator)$this$getCells.intervalsIterator(lines.getFirst())), (Function1)((Function1)new Function1<NotebookCellLines.Interval, Boolean>(lines){
            final /* synthetic */ IntRange $lines;
            {
                this.$lines = $lines;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull NotebookCellLines.Interval it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getLines().getFirst() <= this.$lines.getLast();
            }
        }));
    }

    @Nullable
    public static final String getTopMarker(@NotNull NotebookCellLines.Interval $this$getTopMarker, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$getTopMarker, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return $this$getTopMarker.getMarkers().getHasTopLine() ? NotebookVisualizationUiUtilKt.getLineText(document, $this$getTopMarker.getLines().getFirst()) : null;
    }

    @Nullable
    public static final String getBottomMarker(@NotNull NotebookCellLines.Interval $this$getBottomMarker, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$getBottomMarker, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return $this$getBottomMarker.getMarkers().getHasBottomLine() ? NotebookVisualizationUiUtilKt.getLineText(document, $this$getBottomMarker.getLines().getLast()) : null;
    }

    public static final int getFirstContentLine(@NotNull NotebookCellLines.Interval $this$firstContentLine) {
        Intrinsics.checkNotNullParameter((Object)$this$firstContentLine, (String)"<this>");
        return $this$firstContentLine.getMarkers().getHasTopLine() ? $this$firstContentLine.getLines().getFirst() + 1 : $this$firstContentLine.getLines().getFirst();
    }

    public static final int getLastContentLine(@NotNull NotebookCellLines.Interval $this$lastContentLine) {
        Intrinsics.checkNotNullParameter((Object)$this$lastContentLine, (String)"<this>");
        return $this$lastContentLine.getMarkers().getHasBottomLine() ? $this$lastContentLine.getLines().getLast() - 1 : $this$lastContentLine.getLines().getLast();
    }

    @NotNull
    public static final IntRange getContentLines(@NotNull NotebookCellLines.Interval $this$contentLines) {
        Intrinsics.checkNotNullParameter((Object)$this$contentLines, (String)"<this>");
        return new IntRange(NotebookVisualizationUiUtilKt.getFirstContentLine($this$contentLines), NotebookVisualizationUiUtilKt.getLastContentLine($this$contentLines));
    }

    @NotNull
    public static final List<NotebookCellLinesLexer.Marker> makeMarkersFromIntervals(@NotNull Document document, @NotNull Iterable<NotebookCellLines.Interval> intervals) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(intervals, (String)"intervals");
        ArrayList<NotebookCellLinesLexer.Marker> markers = new ArrayList<NotebookCellLinesLexer.Marker>();
        for (NotebookCellLines.Interval interval : intervals) {
            if (interval.getMarkers().getHasTopLine()) {
                NotebookVisualizationUiUtilKt.makeMarkersFromIntervals$addMarker(document, markers, interval.getLines().getFirst(), interval.getType(), interval.getData());
            }
            if (!interval.getMarkers().getHasBottomLine()) continue;
            NotebookVisualizationUiUtilKt.makeMarkersFromIntervals$addMarker(document, markers, interval.getLines().getLast(), interval.getType(), interval.getData());
        }
        return markers;
    }

    @NotNull
    public static final List<List<NotebookCellLines.Interval>> groupNeighborCells(@NotNull List<NotebookCellLines.Interval> cells) {
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        SmartList groups = new SmartList();
        for (NotebookCellLines.Interval cell : cells) {
            boolean bl;
            Object object = (SmartList)CollectionsKt.lastOrNull((List)((List)groups));
            if (object != null && (object = (NotebookCellLines.Interval)CollectionsKt.last((List)((List)object))) != null) {
                Object it = object;
                boolean bl2 = false;
                bl = ((NotebookCellLines.Interval)it).getOrdinal() + 1 == cell.getOrdinal();
            } else {
                bl = false;
            }
            if (!bl) {
                groups.add((Object)new SmartList());
            }
            ((SmartList)CollectionsKt.last((List)((List)groups))).add((Object)cell);
        }
        return (List)groups;
    }

    public static final void mergeAndJoinIntersections(@NotNull List<IntRange> $this$mergeAndJoinIntersections, @NotNull List<IntRange> other) {
        Intrinsics.checkNotNullParameter($this$mergeAndJoinIntersections, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        List list = ContainerUtil.mergeSortedLists($this$mergeAndJoinIntersections, other, NotebookVisualizationUiUtilKt::mergeAndJoinIntersections$lambda$3, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mergeSortedLists(...)");
        List merged = list;
        $this$mergeAndJoinIntersections.clear();
        for (IntRange current : merged) {
            IntRange previous = (IntRange)CollectionsKt.removeLastOrNull($this$mergeAndJoinIntersections);
            if (previous == null) {
                Intrinsics.checkNotNull((Object)current);
                $this$mergeAndJoinIntersections.add(current);
                continue;
            }
            if (previous.getLast() + 1 >= current.getFirst()) {
                $this$mergeAndJoinIntersections.add(new IntRange(previous.getFirst(), Math.max(previous.getLast(), current.getLast())));
                continue;
            }
            $this$mergeAndJoinIntersections.add(previous);
            Intrinsics.checkNotNull((Object)current);
            $this$mergeAndJoinIntersections.add(current);
        }
    }

    public static final boolean isLineVisible(@NotNull EditorImpl editor, int line2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int lineY = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line2, (int)0)).y;
        Rectangle rectangle = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleAreaOnScrollingFinished(...)");
        Rectangle viewArea = rectangle;
        return viewArea.y <= lineY && lineY <= viewArea.y + viewArea.height;
    }

    private static final void makeMarkersFromIntervals$addMarker(Document $document, ArrayList<NotebookCellLinesLexer.Marker> markers, int line2, NotebookCellLines.CellType type, KeyFMap data2) {
        int startOffset = $document.getLineStartOffset(line2);
        int endOffset = line2 + 1 < $document.getLineCount() ? $document.getLineStartOffset(line2 + 1) : $document.getLineEndOffset(line2);
        int length = endOffset - startOffset;
        markers.add(new NotebookCellLinesLexer.Marker(markers.size(), type, startOffset, length, data2));
    }

    private static final int mergeAndJoinIntersections$lambda$3(IntRange o1, IntRange o2) {
        return o1.getFirst() - o2.getFirst();
    }
}

