/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.DataFrame;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.DataFrameImpl;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.Column;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.DoubleType;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.IntType;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.StringType;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrameCSVAdapter;", "", "()V", "ColumnInfo", "Companion", "intellij.notebooks.visualization"})
public final class DataFrameCSVAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrameCSVAdapter$ColumnInfo;", "", "name", "", "type", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Type;", "(Ljava/lang/String;Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Type;)V", "getName", "()Ljava/lang/String;", "getType", "()Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Type;", "setType", "(Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Type;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.notebooks.visualization"})
    public static final class ColumnInfo {
        @NotNull
        private final String name;
        @Nullable
        private Type<?> type;

        public ColumnInfo(@NotNull String name, @Nullable Type<?> type) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.type = type;
        }

        public /* synthetic */ ColumnInfo(String string, Type type, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                type = null;
            }
            this(string, type);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Type<?> getType() {
            return this.type;
        }

        public final void setType(@Nullable Type<?> type) {
            this.type = type;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final Type<?> component2() {
            return this.type;
        }

        @NotNull
        public final ColumnInfo copy(@NotNull String name, @Nullable Type<?> type) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ColumnInfo(name, type);
        }

        public static /* synthetic */ ColumnInfo copy$default(ColumnInfo columnInfo, String string, Type type, int n, Object object) {
            if ((n & 1) != 0) {
                string = columnInfo.name;
            }
            if ((n & 2) != 0) {
                type = columnInfo.type;
            }
            return columnInfo.copy(string, type);
        }

        @NotNull
        public String toString() {
            return "ColumnInfo(name=" + this.name + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColumnInfo)) {
                return false;
            }
            ColumnInfo columnInfo = (ColumnInfo)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)columnInfo.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.type, columnInfo.type);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J*\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J6\u0010\u000f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011`\u00122\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrameCSVAdapter$Companion;", "", "()V", "fromCsvString", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrame;", "data", "", "getCellType", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Type;", "getColumnType", "columnType", "cellType", "getColumnsInfo", "", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrameCSVAdapter$ColumnInfo;", "readData", "Ljava/util/ArrayList;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Column;", "Lkotlin/collections/ArrayList;", "columnsInfo", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        private final Type<?> getCellType(String data2) {
            return Intrinsics.areEqual((Object)data2, (Object)"null") ? null : (StringsKt.toIntOrNull((String)data2) != null ? (Type)IntType.INSTANCE : (StringsKt.toDoubleOrNull((String)data2) != null ? (Type)DoubleType.INSTANCE : (Type)StringType.INSTANCE));
        }

        private final Type<?> getColumnType(Type<?> columnType, Type<?> cellType) {
            if (columnType == null) {
                return cellType;
            }
            return columnType.upgrade(cellType);
        }

        private final List<ColumnInfo> getColumnsInfo(String data2) {
            ArrayList<ColumnInfo> columnsInfo = new ArrayList<ColumnInfo>();
            int previous = 0;
            int n = data2.length();
            for (int i = 0; i < n; ++i) {
                if (data2.charAt(i) != '\n' && data2.charAt(i) != '\t') continue;
                String string = data2.substring(previous, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                columnsInfo.add(new ColumnInfo(string, null, 2, null));
                previous = i + 1;
                if (data2.charAt(i) == '\n') break;
            }
            int column = 0;
            int linesCount = 0;
            int n2 = data2.length();
            for (int i = previous; i < n2; ++i) {
                if (data2.charAt(i) != '\n' && data2.charAt(i) != '\t') continue;
                Type<?> cellType = null;
                if (previous == i) {
                    cellType = null;
                } else {
                    String string = data2.substring(previous, i);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    cellType = this.getCellType(string);
                }
                Type<?> columnType = ((ColumnInfo)columnsInfo.get(column)).getType();
                if (!Intrinsics.areEqual(columnType, cellType)) {
                    ((ColumnInfo)columnsInfo.get(column)).setType(this.getColumnType(columnType, cellType));
                }
                previous = i + 1;
                if (data2.charAt(i) == '\n') {
                    column = 0;
                    ++linesCount;
                    continue;
                }
                ++column;
            }
            for (ColumnInfo columnInfo : columnsInfo) {
                if (columnInfo.getType() != null) continue;
                columnInfo.setType(StringType.INSTANCE);
            }
            return columnsInfo;
        }

        private final ArrayList<Column<?>> readData(String data2, List<ColumnInfo> columnsInfo) {
            ArrayList columns = new ArrayList(columnsInfo.size());
            for (ColumnInfo info : columnsInfo) {
                Type<?> type = info.getType();
                Intrinsics.checkNotNull(type);
                columns.add(type.createDataArray());
            }
            int previous = StringsKt.indexOf$default((CharSequence)data2, (char)'\n', (int)0, (boolean)false, (int)6, null) + 1;
            int column = 0;
            int n = data2.length();
            for (int i = previous; i < n; ++i) {
                if (data2.charAt(i) != '\n' && data2.charAt(i) != '\t') continue;
                Type<?> type = columnsInfo.get(column).getType();
                Intrinsics.checkNotNull(type);
                Object e = columns.get(column);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                ArrayList arrayList = (ArrayList)e;
                String string = data2.substring(previous, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                type.appendToDataArray(arrayList, string);
                previous = i + 1;
                if (data2.charAt(i) == '\n') {
                    while (column + 1 < columnsInfo.size()) {
                        Type<?> type2 = columnsInfo.get(++column).getType();
                        Intrinsics.checkNotNull(type2);
                        Object e2 = columns.get(column);
                        Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                        type2.appendToDataArray((ArrayList)e2, "");
                    }
                    column = 0;
                    continue;
                }
                ++column;
            }
            ArrayList realColumns = new ArrayList(columnsInfo.size());
            int n2 = columnsInfo.size();
            for (int i = 0; i < n2; ++i) {
                Type<?> type = columnsInfo.get(i).getType();
                Intrinsics.checkNotNull(type);
                String string = columnsInfo.get(i).getName();
                Object e = columns.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                realColumns.add(type.createDataColumn(string, (ArrayList)e));
            }
            return realColumns;
        }

        @NotNull
        public final DataFrame fromCsvString(@NotNull String data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Object innerData = data2;
            if (!(((CharSequence)data2).length() == 0) && data2.charAt(data2.length() - 1) != '\n') {
                innerData = (String)innerData + "\n";
            }
            List<ColumnInfo> columnsInfo = this.getColumnsInfo((String)innerData);
            ArrayList<Column<?>> res2 = this.readData((String)innerData, columnsInfo);
            return new DataFrameImpl(res2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

