/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.ui;

import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J)\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/ui/MaterialTableUtils;", "", "()V", "fitColumnWidth", "", "column", "", "table", "Ljavax/swing/JTable;", "maxWidth", "maxRows", "(ILjavax/swing/JTable;ILjava/lang/Integer;)V", "fitColumnsWidth", "(Ljavax/swing/JTable;ILjava/lang/Integer;)V", "fitRowHeight", "getColumnHeaderWidth", "getColumnWidth", "(Ljavax/swing/JTable;ILjava/lang/Integer;)I", "getRowHeight", "intellij.notebooks.visualization"})
public final class MaterialTableUtils {
    @NotNull
    public static final MaterialTableUtils INSTANCE = new MaterialTableUtils();

    private MaterialTableUtils() {
    }

    private final int getColumnHeaderWidth(JTable table, int column) {
        if (table.getTableHeader() == null || table.getColumnModel().getColumnCount() <= column) {
            return 0;
        }
        TableColumn tableColumn = table.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Object value = tableColumn.getHeaderValue();
        TableCellRenderer tableCellRenderer = renderer;
        Intrinsics.checkNotNull((Object)tableCellRenderer);
        Component c = tableCellRenderer.getTableCellRendererComponent(table, value, false, false, -1, column);
        return c.getPreferredSize().width;
    }

    private final int getColumnWidth(JTable table, int column, Integer maxRows) {
        int width = Math.max(JBUI.scale((int)65), this.getColumnHeaderWidth(table, column));
        Integer n = maxRows;
        int n2 = Math.min(table.getRowCount(), n != null ? n : Integer.MAX_VALUE);
        for (int row = 0; row < n2; ++row) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component comp = table.prepareRenderer(renderer, row, column);
            width = Math.max(comp.getPreferredSize().width + JBUI.scale((int)10), width);
        }
        return width;
    }

    static /* synthetic */ int getColumnWidth$default(MaterialTableUtils materialTableUtils, JTable jTable, int n, Integer n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return materialTableUtils.getColumnWidth(jTable, n, n2);
    }

    private final void fitColumnWidth(int column, JTable table, int maxWidth, Integer maxRows) {
        int width = this.getColumnWidth(table, column, maxRows);
        boolean bl = 1 <= maxWidth ? maxWidth < width : false;
        if (bl) {
            width = maxWidth;
        }
        table.getColumnModel().getColumn(column).setPreferredWidth(width);
    }

    static /* synthetic */ void fitColumnWidth$default(MaterialTableUtils materialTableUtils, int n, JTable jTable, int n2, Integer n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 350;
        }
        if ((n4 & 8) != 0) {
            n3 = null;
        }
        materialTableUtils.fitColumnWidth(n, jTable, n2, n3);
    }

    public final void fitColumnsWidth(@NotNull JTable table, int maxWidth, @Nullable Integer maxRows) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        int n = table.getColumnCount();
        for (int column = 0; column < n; ++column) {
            this.fitColumnWidth(column, table, maxWidth, maxRows);
        }
    }

    public static /* synthetic */ void fitColumnsWidth$default(MaterialTableUtils materialTableUtils, JTable jTable, int n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 350;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        materialTableUtils.fitColumnsWidth(jTable, n, n2);
    }

    private final int getRowHeight(JTable table) {
        int column = 0;
        int row = 0;
        TableCellRenderer renderer = table.getCellRenderer(row, column);
        Component component = table.prepareRenderer(renderer, row, column);
        return component.getPreferredSize().height;
    }

    public final void fitRowHeight(@NotNull JTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        table.getTableHeader().resizeAndRepaint();
        table.setRowHeight(this.getRowHeight(table));
    }
}

