/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.util.internal.GUtil;

public class DefaultComponentSelectorConverter
implements ComponentSelectorConverter {
    private static final ModuleVersionSelector UNKNOWN_MODULE_VERSION_SELECTOR = DefaultModuleVersionSelector.newSelector(DefaultModuleIdentifier.newId("", "unknown"), "");
    private final LocalComponentRegistry localComponentRegistry;

    public DefaultComponentSelectorConverter(LocalComponentRegistry localComponentRegistry) {
        this.localComponentRegistry = localComponentRegistry;
    }

    @Override
    public ModuleIdentifier getModule(ComponentSelector componentSelector) {
        if (componentSelector instanceof ModuleComponentSelector) {
            ModuleComponentSelector module = (ModuleComponentSelector)componentSelector;
            return module.getModuleIdentifier();
        }
        ModuleVersionSelector moduleVersionSelector = this.getSelector(componentSelector);
        return moduleVersionSelector.getModule();
    }

    @Override
    public ModuleVersionSelector getSelector(ComponentSelector selector) {
        DefaultProjectComponentSelector projectSelector;
        ProjectComponentIdentifier projectId;
        LocalComponentGraphResolveState projectComponent;
        if (selector instanceof ModuleComponentSelector) {
            return DefaultModuleVersionSelector.newSelector((ModuleComponentSelector)selector);
        }
        if (selector instanceof DefaultProjectComponentSelector && (projectComponent = this.localComponentRegistry.getComponent(projectId = (projectSelector = (DefaultProjectComponentSelector)selector).toIdentifier())) != null) {
            ModuleVersionIdentifier moduleVersionId = projectComponent.getModuleVersionId();
            return DefaultModuleVersionSelector.newSelector(moduleVersionId.getModule(), moduleVersionId.getVersion());
        }
        if (selector instanceof LibraryComponentSelector) {
            LibraryComponentSelector libraryComponentSelector = (LibraryComponentSelector)selector;
            String libraryName = GUtil.elvis(libraryComponentSelector.getLibraryName(), "");
            return DefaultModuleVersionSelector.newSelector(DefaultModuleIdentifier.newId(libraryComponentSelector.getProjectPath(), libraryName), "undefined");
        }
        return UNKNOWN_MODULE_VERSION_SELECTOR;
    }
}

