/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import org.gradle.cache.internal.CacheVersion;
import org.gradle.cache.internal.CacheVersionMapping;

public enum CacheLayout {
    ROOT(null, "modules", CacheVersionMapping.introducedIn("1.9-rc-1").incrementedIn("1.9-rc-2")),
    FILE_STORE(ROOT, "files", CacheVersionMapping.introducedIn("1.9-rc-1")),
    META_DATA(ROOT, "metadata", CacheVersionMapping.introducedIn("1.9-rc-2").changedTo(2, "1.11-rc-1").changedTo(6, "1.12-rc-1").changedTo(12, "2.0-rc-1").changedTo(13, "2.1-rc-3").changedTo(14, "2.2-rc-1").changedTo(15, "2.4-rc-1").changedTo(16, "2.8-rc-1").changedTo(17, "3.0-milestone-1").changedTo(21, "3.1-rc-1").changedTo(23, "3.2-rc-1").changedTo(24, "4.2-rc-1").changedTo(31, "4.3-rc-1").changedTo(36, "4.4-rc-1").changedTo(48, "4.5-rc-1").changedTo(51, "4.5.1").changedTo(53, "4.6-rc-1").changedTo(56, "4.7-rc-1").changedTo(58, "4.8-rc-1").changedTo(63, "4.10-rc-1").changedTo(68, "5.0-milestone-1").changedTo(69, "5.0-rc-1").changedTo(71, "5.3-rc-1").changedTo(79, "6.0-rc-1").changedTo(82, "6.0-rc-2").changedTo(95, "6.1-rc-1").changedTo(96, "6.4-rc-1").changedTo(97, "6.8-rc-1").changedTo(99, "7.5-rc-1").changedTo(101, "7.6.2").changedToWithConflict(100, "8.0-milestone-5").changedTo(105, "8.1-rc-2").changedTo(106, "8.2-milestone-1")),
    RESOURCES(ROOT, "resources", CacheVersionMapping.introducedIn("1.9-rc-1")),
    TRANSFORMS(null, "transforms", CacheVersionMapping.introducedIn("3.5-rc-1").changedTo(2, "5.1").changedTo(3, "6.8-rc-1"));

    private final String name;
    private final CacheVersionMapping versionMapping;

    private CacheLayout(CacheLayout parent, String name, CacheVersionMapping.Builder versionMappingBuilder) {
        this.name = name;
        this.versionMapping = parent == null ? versionMappingBuilder.build() : versionMappingBuilder.build(parent.getVersion());
    }

    public String getName() {
        return this.name;
    }

    public CacheVersion getVersion() {
        return this.versionMapping.getLatestVersion();
    }

    public String getKey() {
        return this.getName() + "-" + this.getVersion();
    }

    public CacheVersionMapping getVersionMapping() {
        return this.versionMapping;
    }

    public File getPath(File parentDir) {
        return new File(parentDir, this.getKey());
    }
}

