/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyMetadataConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.util.internal.CollectionUtils;

public abstract class AbstractDependencyMetadataConverter
implements DependencyMetadataConverter {
    private final ExcludeRuleConverter excludeRuleConverter;

    public AbstractDependencyMetadataConverter(ExcludeRuleConverter excludeRuleConverter) {
        this.excludeRuleConverter = excludeRuleConverter;
    }

    private String getExtension(DependencyArtifact artifact) {
        return artifact.getExtension() != null ? artifact.getExtension() : artifact.getType();
    }

    protected List<ExcludeMetadata> convertExcludeRules(Set<ExcludeRule> excludeRules) {
        return CollectionUtils.collect(excludeRules, this.excludeRuleConverter::convertExcludeRule);
    }

    protected List<IvyArtifactName> convertArtifacts(Set<DependencyArtifact> dependencyArtifacts) {
        if (dependencyArtifacts.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder names = ImmutableList.builder();
        for (DependencyArtifact dependencyArtifact : dependencyArtifacts) {
            DefaultIvyArtifactName name = new DefaultIvyArtifactName(dependencyArtifact.getName(), dependencyArtifact.getType(), this.getExtension(dependencyArtifact), dependencyArtifact.getClassifier());
            names.add((Object)name);
        }
        return names.build();
    }
}

