/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.PatternMatchers;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.CachingExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.ExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.LoggingExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.NormalizingExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.OptimizingExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple.DefaultExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class ModuleExclusions {
    private final CachingExcludeFactory.MergeCaches mergeCaches = new CachingExcludeFactory.MergeCaches();
    private final ExcludeFactory factory = new OptimizingExcludeFactory(new CachingExcludeFactory(LoggingExcludeFactory.maybeLog(new NormalizingExcludeFactory(new CachingExcludeFactory(new DefaultExcludeFactory(), this.mergeCaches))), this.mergeCaches));
    private final Map<ExcludeMetadata, ExcludeSpec> metadataToExcludeCache = Maps.newConcurrentMap();
    private final ExcludeSpec nothing = this.factory.nothing();

    public ExcludeSpec excludeAny(Collection<? extends ExcludeMetadata> excludes) {
        if (excludes.isEmpty()) {
            return this.nothing;
        }
        if (excludes.size() == 1) {
            return this.forExclude(excludes.iterator().next());
        }
        HashSet<ExcludeSpec> result2 = new HashSet<ExcludeSpec>();
        for (ExcludeMetadata excludeMetadata : excludes) {
            result2.add(this.forExclude(excludeMetadata));
        }
        return this.factory.anyOf(result2);
    }

    public ExcludeSpec nothing() {
        return this.nothing;
    }

    private ExcludeSpec forExclude(ExcludeMetadata r) {
        return this.metadataToExcludeCache.computeIfAbsent(r, rule -> {
            if (!PatternMatchers.isExactMatcher(rule.getMatcher())) {
                return this.factory.ivyPatternExclude(rule.getModuleId(), rule.getArtifact(), rule.getMatcher());
            }
            ModuleIdentifier moduleId = rule.getModuleId();
            IvyArtifactName artifact = rule.getArtifact();
            boolean anyOrganisation = ModuleExclusions.isWildcard(moduleId.getGroup());
            boolean anyModule = ModuleExclusions.isWildcard(moduleId.getName());
            if (artifact == null) {
                if (!anyOrganisation && !anyModule) {
                    return this.factory.moduleId(moduleId);
                }
                if (!anyModule) {
                    return this.factory.module(moduleId.getName());
                }
                if (!anyOrganisation) {
                    return this.factory.group(moduleId.getGroup());
                }
                return this.factory.everything();
            }
            return this.factory.ivyPatternExclude(moduleId, artifact, rule.getMatcher());
        });
    }

    private static boolean isWildcard(String attribute) {
        return "*".equals(attribute);
    }

    public ExcludeSpec excludeAny(ExcludeSpec one, ExcludeSpec two) {
        return this.factory.anyOf(one, two);
    }

    public ExcludeSpec excludeAll(ExcludeSpec one, ExcludeSpec two) {
        return this.factory.allOf(one, two);
    }

    public ExcludeSpec excludeAll(Set<ExcludeSpec> specs) {
        return this.factory.allOf(specs);
    }

    public ExcludeSpec excludeAny(Set<ExcludeSpec> specs) {
        return this.factory.anyOf(specs);
    }
}

