/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.collections.AbstractIterationOrderRetainingElementSource;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.base.Objects;

public class IterationOrderRetainingSetElementSource<T>
extends AbstractIterationOrderRetainingElementSource<T> {
    private static final Spec<AbstractIterationOrderRetainingElementSource.ValuePointer<?>> NO_DUPLICATES = pointer -> !pointer.getElement().isDuplicate(pointer.getIndex());
    private final Set<T> nonProvidedValues = new HashSet<T>();

    @Override
    public Iterator<T> iterator() {
        this.realizePending();
        return new AbstractIterationOrderRetainingElementSource.RealizedElementCollectionIterator(this, this.getInserted(), NO_DUPLICATES);
    }

    @Override
    public Iterator<T> iteratorNoFlush() {
        return new AbstractIterationOrderRetainingElementSource.RealizedElementCollectionIterator(this, this.getInserted(), NO_DUPLICATES);
    }

    @Override
    public boolean add(T element) {
        ++this.modCount;
        if (this.nonProvidedValues.add(element)) {
            this.getInserted().add(new AbstractIterationOrderRetainingElementSource.Element<T>(element));
            return true;
        }
        return false;
    }

    @Override
    public boolean addRealized(T value) {
        this.markDuplicates(value);
        return true;
    }

    @Override
    protected void clearCachedElement(AbstractIterationOrderRetainingElementSource.Element<T> element) {
        boolean wasRealized = element.isRealized();
        super.clearCachedElement(element);
        if (wasRealized) {
            for (T value : element.getValues()) {
                this.markDuplicates(value);
            }
        }
    }

    @Override
    public boolean remove(Object o) {
        this.nonProvidedValues.remove(o);
        return super.remove(o);
    }

    @Override
    public void clear() {
        this.nonProvidedValues.clear();
        super.clear();
    }

    private void markDuplicates(T value) {
        boolean seen = false;
        for (AbstractIterationOrderRetainingElementSource.Element element : this.getInserted()) {
            if (!element.isRealized()) continue;
            List collected = element.getValues();
            for (int index = 0; index < collected.size(); ++index) {
                if (!Objects.equal(collected.get(index), value)) continue;
                if (seen) {
                    element.setDuplicate(index);
                    continue;
                }
                seen = true;
            }
        }
    }

    @Override
    public boolean addPending(ProviderInternal<? extends T> provider) {
        ++this.modCount;
        AbstractIterationOrderRetainingElementSource.Element<? extends T> element = this.cachingElement(provider);
        if (!this.getInserted().contains(element)) {
            this.addPendingElement(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean addPendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        ++this.modCount;
        AbstractIterationOrderRetainingElementSource.Element<T> element = this.cachingElement(provider);
        if (!this.getInserted().contains(element)) {
            this.addPendingElement(element);
            return true;
        }
        return false;
    }
}

