/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.groovy.scripts.TextResourceScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.DependenciesAccessors;
import org.gradle.internal.management.DependencyResolutionManagementInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.TextFileResourceLoader;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.scripts.ProjectScopedScriptResolution;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.util.internal.NameValidator;

public class ProjectFactory
implements IProjectFactory {
    private final Instantiator instantiator;
    private final TextFileResourceLoader textFileResourceLoader;
    private final ProjectScopedScriptResolution scriptResolution;

    public ProjectFactory(Instantiator instantiator2, TextFileResourceLoader textFileResourceLoader, ProjectScopedScriptResolution scriptResolution) {
        this.instantiator = instantiator2;
        this.textFileResourceLoader = textFileResourceLoader;
        this.scriptResolution = scriptResolution;
    }

    @Override
    public ProjectInternal createProject(GradleInternal gradle, ProjectDescriptor projectDescriptor, ProjectState owner, @Nullable ProjectInternal parent, ServiceRegistryFactory serviceRegistryFactory2, ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope) {
        File buildFile = this.scriptResolution.resolveScriptsForProject(owner.getIdentityPath(), projectDescriptor::getBuildFile);
        TextResource resource = this.textFileResourceLoader.loadFile("build file", buildFile);
        TextResourceScriptSource source = new TextResourceScriptSource(resource);
        DefaultProject project = this.instantiator.newInstance(DefaultProject.class, projectDescriptor.getName(), parent, projectDescriptor.getProjectDir(), buildFile, source, gradle, owner, serviceRegistryFactory2, selfClassLoaderScope, baseClassLoaderScope);
        gradle.getServices().get(DependencyResolutionManagementInternal.class).configureProject(project);
        project.beforeEvaluate(p -> {
            NameValidator.validate(project.getName(), "project name", DefaultProjectDescriptor.INVALID_NAME_IN_INCLUDE_HINT);
            gradle.getServices().get(DependenciesAccessors.class).createExtensions(project);
        });
        gradle.getProjectRegistry().addProject(project);
        return project;
    }
}

