/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Method;
import java.util.List;
import org.gradle.api.internal.tasks.options.BooleanOptionElement;
import org.gradle.api.internal.tasks.options.MultipleValueOptionElement;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.api.internal.tasks.options.OptionValueNotationParserFactory;
import org.gradle.api.internal.tasks.options.PropertySetter;
import org.gradle.api.internal.tasks.options.SingleValueOptionElement;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.model.internal.type.ModelType;

abstract class AbstractOptionElement
implements OptionElement {
    private final String optionName;
    private final String description;
    private final Class<?> optionType;

    public AbstractOptionElement(String optionName, Option option, Class<?> optionType, Class<?> declaringClass) {
        this(AbstractOptionElement.readDescription(option, optionName, declaringClass), optionName, optionType);
    }

    protected AbstractOptionElement(String description, String optionName, Class<?> optionType) {
        this.description = description;
        this.optionName = optionName;
        this.optionType = optionType;
    }

    @Override
    public Class<?> getOptionType() {
        return this.optionType;
    }

    public static OptionElement of(String optionName, Option option, PropertySetter setter, OptionValueNotationParserFactory notationParserFactory) {
        if (setter.getRawType().equals(Boolean.class) || setter.getRawType().equals(Boolean.TYPE)) {
            return new BooleanOptionElement(optionName, option, setter);
        }
        if (setter.getRawType().equals(List.class)) {
            Class<?> elementType = ModelType.of(setter.getGenericType()).getTypeVariables().get(0).getRawClass();
            return new MultipleValueOptionElement(optionName, option, elementType, setter, notationParserFactory);
        }
        return new SingleValueOptionElement(optionName, option, setter.getRawType(), setter, notationParserFactory);
    }

    private static String readDescription(Option option, String optionName, Class<?> declaringClass) {
        try {
            return option.description();
        }
        catch (IncompleteAnnotationException ex) {
            throw new OptionValidationException(String.format("No description set on option '%s' at for class '%s'.", optionName, declaringClass.getName()));
        }
    }

    protected Object invokeMethod(Object object, Method method, Object ... parameterValues) {
        JavaMethod<Object, Object> javaMethod = JavaMethod.of(Object.class, method);
        return javaMethod.invoke(object, parameterValues);
    }

    @Override
    public String getOptionName() {
        return this.optionName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected static <T> NotationParser<CharSequence, T> createNotationParserOrFail(OptionValueNotationParserFactory optionValueNotationParserFactory, String optionName, Class<T> optionType, Class<?> declaringClass) {
        try {
            return optionValueNotationParserFactory.toComposite(optionType);
        }
        catch (OptionValidationException ex) {
            throw new OptionValidationException(String.format("Option '%s' cannot be cast to type '%s' in class '%s'.", optionName, optionType.getName(), declaringClass.getName()));
        }
    }

    protected static Class<?> calculateOptionType(Class<?> type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Void.TYPE;
        }
        return type;
    }
}

