/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.failure;

import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.testing.failure.TestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.ThrowableToTestFailureMapper;
import org.gradle.api.tasks.testing.TestFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultThrowableToTestFailureMapper
implements ThrowableToTestFailureMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultThrowableToTestFailureMapper.class);
    private final List<TestFailureMapper> mappers;

    public DefaultThrowableToTestFailureMapper(List<TestFailureMapper> mappers) {
        this.mappers = mappers;
    }

    @Override
    public TestFailure createFailure(Throwable throwable) {
        for (Throwable currentThrowable = throwable; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
            for (TestFailureMapper mapper : this.mappers) {
                if (!mapper.supports(currentThrowable.getClass())) continue;
                try {
                    return mapper.map(currentThrowable, this);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to map supported failure '{}' with mapper '{}': {}", new Object[]{currentThrowable, mapper, ex.getMessage()});
                }
            }
        }
        return TestFailure.fromTestFrameworkFailure(throwable);
    }
}

