/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publication;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.XmlProvider;
import org.gradle.api.internal.UserCodeAction;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyExtraInfoSpec;
import org.gradle.api.publish.ivy.IvyModuleDescriptorAuthor;
import org.gradle.api.publish.ivy.IvyModuleDescriptorDescription;
import org.gradle.api.publish.ivy.IvyModuleDescriptorLicense;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependency;
import org.gradle.api.publish.ivy.internal.dependency.IvyExcludeRule;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyExtraInfoSpec;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorAuthor;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorDescription;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorLicense;
import org.gradle.api.publish.ivy.internal.publication.IvyModuleDescriptorSpecInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationCoordinates;
import org.gradle.internal.MutableActionSet;

public abstract class DefaultIvyModuleDescriptorSpec
implements IvyModuleDescriptorSpecInternal {
    private final MutableActionSet<XmlProvider> xmlActions = new MutableActionSet();
    private final ObjectFactory objectFactory;
    private final IvyPublicationCoordinates ivyPublicationCoordinates;
    private String status;
    private String branch;
    private final IvyExtraInfoSpec extraInfo = new DefaultIvyExtraInfoSpec();
    private final List<IvyModuleDescriptorAuthor> authors = new ArrayList<IvyModuleDescriptorAuthor>();
    private final List<IvyModuleDescriptorLicense> licenses = new ArrayList<IvyModuleDescriptorLicense>();
    private IvyModuleDescriptorDescription description;

    @Inject
    public DefaultIvyModuleDescriptorSpec(ObjectFactory objectFactory, IvyPublicationCoordinates ivyPublicationCoordinates) {
        this.objectFactory = objectFactory;
        this.ivyPublicationCoordinates = ivyPublicationCoordinates;
    }

    @Override
    @Nullable
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(@Nullable String status) {
        this.status = status;
    }

    @Override
    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(@Nullable String branch) {
        this.branch = branch;
    }

    @Override
    public IvyExtraInfoSpec getExtraInfo() {
        return this.extraInfo;
    }

    @Override
    public void extraInfo(String namespace, String elementName, String value) {
        if (elementName == null) {
            throw new InvalidUserDataException("Cannot add an extra info element with null element name");
        }
        if (namespace == null) {
            throw new InvalidUserDataException("Cannot add an extra info element with null namespace");
        }
        this.extraInfo.add(namespace, elementName, value);
    }

    @Override
    public IvyPublicationCoordinates getCoordinates() {
        return this.ivyPublicationCoordinates;
    }

    @Override
    public void withXml(Action<? super XmlProvider> action) {
        this.xmlActions.add(new UserCodeAction<XmlProvider>("Could not apply withXml() to Ivy module descriptor", action));
    }

    @Override
    public Action<XmlProvider> getXmlAction() {
        return this.xmlActions;
    }

    @Override
    public abstract SetProperty<IvyConfiguration> getConfigurations();

    @Override
    public abstract SetProperty<IvyArtifact> getArtifacts();

    @Override
    public abstract SetProperty<IvyDependency> getDependencies();

    @Override
    public abstract SetProperty<IvyExcludeRule> getGlobalExcludes();

    @Override
    public void license(Action<? super IvyModuleDescriptorLicense> action) {
        this.configureAndAdd(DefaultIvyModuleDescriptorLicense.class, action, this.licenses);
    }

    @Override
    public List<IvyModuleDescriptorLicense> getLicenses() {
        return this.licenses;
    }

    @Override
    public void author(Action<? super IvyModuleDescriptorAuthor> action) {
        this.configureAndAdd(DefaultIvyModuleDescriptorAuthor.class, action, this.authors);
    }

    @Override
    public List<IvyModuleDescriptorAuthor> getAuthors() {
        return this.authors;
    }

    @Override
    public void description(Action<? super IvyModuleDescriptorDescription> action) {
        if (this.description == null) {
            this.description = this.objectFactory.newInstance(DefaultIvyModuleDescriptorDescription.class, this.objectFactory);
        }
        action.execute(this.description);
    }

    @Override
    public IvyModuleDescriptorDescription getDescription() {
        return this.description;
    }

    @Override
    public abstract Property<Boolean> getWriteGradleMetadataMarker();

    private <T> void configureAndAdd(Class<? extends T> clazz, Action<? super T> action, List<T> items) {
        T item = this.objectFactory.newInstance(clazz, this.objectFactory);
        action.execute(item);
        items.add(item);
    }
}

