/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.gradle.api.GradleException;
import org.gradle.cache.FileAccess;
import org.gradle.cache.ObjectHolder;
import org.gradle.internal.Factory;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.serialize.InputStreamBackedDecoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.internal.serialize.Serializer;

public class FileBackedObjectHolder<T>
implements ObjectHolder<T> {
    private final FileAccess fileAccess;
    private final Serializer<T> serializer;
    private final Chmod chmod;
    private final File cacheFile;

    public FileBackedObjectHolder(File cacheFile, FileAccess fileAccess, Serializer<T> serializer, Chmod chmod) {
        this.cacheFile = cacheFile;
        this.fileAccess = fileAccess;
        this.serializer = serializer;
        this.chmod = chmod;
    }

    @Override
    public T get() {
        return this.fileAccess.readFile(new Factory<T>(){

            @Override
            public T create() {
                return FileBackedObjectHolder.this.deserialize();
            }
        });
    }

    @Override
    public void set(final T newValue) {
        this.fileAccess.writeFile(new Runnable(){

            @Override
            public void run() {
                FileBackedObjectHolder.this.serialize(newValue);
            }
        });
    }

    @Override
    public T update(ObjectHolder.UpdateAction<T> updateAction) {
        class Updater
        implements Runnable {
            private final ObjectHolder.UpdateAction<T> updateAction;
            private T result;

            Updater(ObjectHolder.UpdateAction<T> updateAction) {
                this.updateAction = updateAction;
            }

            @Override
            public void run() {
                Object oldValue = FileBackedObjectHolder.this.deserialize();
                this.result = this.updateAction.update(oldValue);
                FileBackedObjectHolder.this.serialize(this.result);
            }
        }
        Updater updater = new Updater(updateAction);
        this.fileAccess.updateFile(updater);
        return (T)updater.result;
    }

    @Override
    public T maybeUpdate(ObjectHolder.UpdateAction<T> updateAction) {
        class MaybeUpdater
        implements Runnable {
            private final ObjectHolder.UpdateAction<T> updateAction;
            private T result;

            MaybeUpdater(ObjectHolder.UpdateAction<T> updateAction) {
                this.updateAction = updateAction;
            }

            @Override
            public void run() {
                Object oldValue = FileBackedObjectHolder.this.deserialize();
                this.result = this.updateAction.update(oldValue);
                if (!(oldValue == null && this.result == null || oldValue != null && this.result != null && oldValue.equals(this.result))) {
                    FileBackedObjectHolder.this.serialize(this.result);
                } else {
                    this.result = oldValue;
                }
            }
        }
        MaybeUpdater maybeUpdater = new MaybeUpdater(updateAction);
        this.fileAccess.updateFile(maybeUpdater);
        return (T)maybeUpdater.result;
    }

    private void serialize(T newValue) {
        try {
            if (!this.cacheFile.isFile()) {
                this.cacheFile.createNewFile();
            }
            this.chmod.chmod(this.cacheFile.getParentFile(), 448);
            this.chmod.chmod(this.cacheFile, 384);
            try (OutputStreamBackedEncoder encoder = new OutputStreamBackedEncoder(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));){
                this.serializer.write(encoder, newValue);
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not write cache value to '%s'.", this.cacheFile), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T deserialize() {
        if (!this.cacheFile.isFile()) {
            return null;
        }
        try (InputStreamBackedDecoder decoder = new InputStreamBackedDecoder(new BufferedInputStream(new FileInputStream(this.cacheFile)));){
            T t = this.serializer.read(decoder);
            return t;
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not read cache value from '%s'.", this.cacheFile), e);
        }
    }
}

