/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.composite.internal.BuildStateFactory;
import org.gradle.initialization.buildsrc.BuildSrcDetector;
import org.gradle.internal.build.BuildAddedListener;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildFactory;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.NestedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.NestedBuildTree;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.base.MoreObjects;
import org.gradle.util.Path;

public class DefaultIncludedBuildRegistry
implements BuildStateRegistry,
Stoppable {
    private final IncludedBuildFactory includedBuildFactory;
    private final BuildAddedListener buildAddedBroadcaster;
    private final BuildStateFactory buildStateFactory;
    private RootBuildState rootBuild;
    private final Map<BuildIdentifier, BuildState> buildsByIdentifier = new HashMap<BuildIdentifier, BuildState>();
    private final Map<BuildState, StandAloneNestedBuild> buildSrcBuildsByOwner = new HashMap<BuildState, StandAloneNestedBuild>();
    private final Map<File, IncludedBuildState> includedBuildsByRootDir = new LinkedHashMap<File, IncludedBuildState>();
    private final Map<File, NestedBuildState> nestedBuildsByRootDir = new LinkedHashMap<File, NestedBuildState>();
    private final Map<Path, File> nestedBuildDirectoriesByPath = new LinkedHashMap<Path, File>();
    private final Deque<IncludedBuildState> pendingIncludedBuilds = new ArrayDeque<IncludedBuildState>();

    public DefaultIncludedBuildRegistry(IncludedBuildFactory includedBuildFactory, ListenerManager listenerManager, BuildStateFactory buildStateFactory) {
        this.includedBuildFactory = includedBuildFactory;
        this.buildAddedBroadcaster = listenerManager.getBroadcaster(BuildAddedListener.class);
        this.buildStateFactory = buildStateFactory;
    }

    @Override
    public RootBuildState getRootBuild() {
        if (this.rootBuild == null) {
            throw new IllegalStateException("Root build is not defined.");
        }
        return this.rootBuild;
    }

    @Override
    public RootBuildState createRootBuild(BuildDefinition buildDefinition) {
        if (this.rootBuild != null) {
            throw new IllegalStateException("Root build already defined.");
        }
        this.rootBuild = this.buildStateFactory.createRootBuild(buildDefinition);
        this.addBuild(this.rootBuild);
        return this.rootBuild;
    }

    @Override
    public void attachRootBuild(RootBuildState rootBuild) {
        if (this.rootBuild != null) {
            throw new IllegalStateException("Root build already defined.");
        }
        this.rootBuild = rootBuild;
        this.addBuild(rootBuild);
    }

    private void addBuild(BuildState build2) {
        BuildState before = this.buildsByIdentifier.put(build2.getBuildIdentifier(), build2);
        if (before != null) {
            throw new IllegalArgumentException("Build is already registered: " + build2.getBuildIdentifier());
        }
        this.buildAddedBroadcaster.buildAdded(build2);
        this.maybeAddBuildSrcBuild(build2);
    }

    @Override
    public IncludedBuildState addIncludedBuild(BuildDefinition buildDefinition) {
        return this.registerBuild(buildDefinition, false, null);
    }

    @Override
    public IncludedBuildState addIncludedBuild(BuildDefinition buildDefinition, Path buildPath) {
        return this.registerBuild(buildDefinition, false, buildPath);
    }

    @Override
    public synchronized IncludedBuildState addImplicitIncludedBuild(BuildDefinition buildDefinition) {
        IncludedBuildState includedBuild = this.includedBuildsByRootDir.get(buildDefinition.getBuildRootDir());
        if (includedBuild == null) {
            includedBuild = this.registerBuild(buildDefinition, true, null);
        }
        return includedBuild;
    }

    public Collection<IncludedBuildState> getIncludedBuilds() {
        return this.includedBuildsByRootDir.values();
    }

    @Override
    public IncludedBuildState getIncludedBuild(BuildIdentifier buildIdentifier) {
        BuildState includedBuildState = this.findBuild(buildIdentifier);
        if (!(includedBuildState instanceof IncludedBuildState)) {
            throw new IllegalArgumentException("Could not find " + buildIdentifier);
        }
        return (IncludedBuildState)includedBuildState;
    }

    @Override
    public BuildState getBuild(BuildIdentifier buildIdentifier) {
        BuildState buildState = this.findBuild(buildIdentifier);
        if (buildState == null) {
            throw new IllegalArgumentException("Could not find " + buildIdentifier);
        }
        return buildState;
    }

    @Override
    public BuildState findBuild(BuildIdentifier buildIdentifier) {
        return this.buildsByIdentifier.get(buildIdentifier);
    }

    @Override
    public void finalizeIncludedBuilds() {
        while (!this.pendingIncludedBuilds.isEmpty()) {
            IncludedBuildState build2 = this.pendingIncludedBuilds.removeFirst();
            this.assertNameDoesNotClashWithRootSubproject(build2);
        }
    }

    @Override
    public StandAloneNestedBuild getBuildSrcNestedBuild(BuildState owner) {
        return this.buildSrcBuildsByOwner.get(owner);
    }

    private void maybeAddBuildSrcBuild(BuildState owner) {
        File buildSrcDir = new File(owner.getBuildRootDir(), "buildSrc");
        if (!BuildSrcDetector.isValidBuildSrcBuild(buildSrcDir)) {
            return;
        }
        BuildDefinition buildDefinition = this.buildStateFactory.buildDefinitionFor(buildSrcDir, owner);
        Path identityPath = this.assignPath(owner, buildDefinition.getName(), buildDefinition.getBuildRootDir());
        BuildIdentifier buildIdentifier = DefaultIncludedBuildRegistry.idFor(identityPath);
        StandAloneNestedBuild build2 = this.buildStateFactory.createNestedBuild(buildIdentifier, identityPath, buildDefinition, owner);
        this.buildSrcBuildsByOwner.put(owner, build2);
        this.nestedBuildsByRootDir.put(buildSrcDir, build2);
        this.addBuild(build2);
    }

    @Override
    public NestedBuildTree addNestedBuildTree(BuildDefinition buildDefinition, BuildState owner, @Nullable String buildName) {
        if (buildDefinition.getName() != null || buildDefinition.getBuildRootDir() != null) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        File dir = buildDefinition.getStartParameter().getCurrentDir();
        String name = (String)MoreObjects.firstNonNull((Object)buildName, (Object)dir.getName());
        DefaultIncludedBuildRegistry.validateNameIsNotBuildSrc(name, dir);
        Path identityPath = this.assignPath(owner, name, dir);
        BuildIdentifier buildIdentifier = DefaultIncludedBuildRegistry.idFor(identityPath);
        return this.buildStateFactory.createNestedTree(buildDefinition, buildIdentifier, identityPath, owner);
    }

    @Override
    public void visitBuilds(Consumer<? super BuildState> visitor) {
        ArrayList<BuildState> ordered = new ArrayList<BuildState>(this.buildsByIdentifier.values());
        ordered.sort(Comparator.comparing(BuildState::getIdentityPath));
        for (BuildState buildState : ordered) {
            visitor.accept(buildState);
        }
    }

    private static void validateNameIsNotBuildSrc(String name, File dir) {
        if ("buildSrc".equals(name)) {
            throw new GradleException("Included build " + dir + " has build name 'buildSrc' which cannot be used as it is a reserved name.");
        }
    }

    private IncludedBuildState registerBuild(BuildDefinition buildDefinition, boolean isImplicit, @Nullable Path buildPath) {
        File buildDir = buildDefinition.getBuildRootDir();
        if (buildDir == null) {
            throw new IllegalArgumentException("Included build must have a root directory defined");
        }
        IncludedBuildState includedBuild = this.includedBuildsByRootDir.get(buildDir);
        if (includedBuild == null) {
            if (this.rootBuild == null) {
                throw new IllegalStateException("No root build attached yet.");
            }
            String buildName = buildDefinition.getName();
            if (buildName == null) {
                throw new IllegalStateException("build name is required");
            }
            DefaultIncludedBuildRegistry.validateNameIsNotBuildSrc(buildName, buildDir);
            Path idPath = buildPath != null ? buildPath : this.assignPath(this.rootBuild, buildName, buildDir);
            BuildIdentifier buildIdentifier = DefaultIncludedBuildRegistry.idFor(idPath);
            includedBuild = this.includedBuildFactory.createBuild(buildIdentifier, buildDefinition, isImplicit, this.rootBuild);
            this.includedBuildsByRootDir.put(buildDir, includedBuild);
            this.nestedBuildsByRootDir.put(buildDir, includedBuild);
            this.pendingIncludedBuilds.add(includedBuild);
            this.addBuild(includedBuild);
        } else if (includedBuild.isImplicitBuild() != isImplicit) {
            throw new IllegalStateException("Unexpected state for build.");
        }
        return includedBuild;
    }

    private static BuildIdentifier idFor(Path absoluteBuildPath) {
        return new DefaultBuildIdentifier(absoluteBuildPath);
    }

    private Path assignPath(BuildState owner, String name, File dir) {
        Optional<Map.Entry> parentBuild = this.nestedBuildsByRootDir.entrySet().stream().filter(entry -> DefaultIncludedBuildRegistry.isPrefix((File)entry.getKey(), dir)).reduce((a, b) -> DefaultIncludedBuildRegistry.isPrefix((File)a.getKey(), (File)b.getKey()) ? b : a);
        Path requestedPath = parentBuild.map(entry -> ((NestedBuildState)entry.getValue()).getIdentityPath().append(Path.path(name))).orElseGet(() -> owner.getIdentityPath().append(Path.path(name)));
        File existingForPath = this.nestedBuildDirectoriesByPath.putIfAbsent(requestedPath, dir);
        if (existingForPath != null) {
            throw new GradleException("Included build " + dir + " has build path " + requestedPath + " which is the same as included build " + existingForPath);
        }
        return requestedPath;
    }

    private static boolean isPrefix(File prefix, File toCheck) {
        return toCheck.toPath().toAbsolutePath().startsWith(prefix.toPath().toAbsolutePath());
    }

    @Override
    public void resetStateForAllBuilds() {
        for (BuildState build2 : this.buildsByIdentifier.values()) {
            build2.resetModel();
        }
    }

    @Override
    public void stop() {
        CompositeStoppable.stoppable(this.buildsByIdentifier.values()).stop();
    }

    private void assertNameDoesNotClashWithRootSubproject(IncludedBuildState includedBuild) {
        if (this.rootBuild.getProjects().findProject(includedBuild.getIdentityPath()) != null) {
            throw new GradleException("Included build in " + includedBuild.getBuildRootDir() + " has name '" + includedBuild.getName() + "' which is the same as a project of the main build.");
        }
    }
}

