/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.configurationcache.DefaultConfigurationCacheKt;
import org.gradle.configurationcache.EncryptionService;
import org.gradle.configurationcache.KeyStoreKeySource;
import org.gradle.configurationcache.StateType;
import org.gradle.configurationcache.initialization.ConfigurationCacheStartParameter;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.EncryptionAlgorithm;
import org.gradle.util.internal.SupportedEncryptionAlgorithm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value=Scopes.BuildTree.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J\u001e\u0010#\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0*H\u0016J\b\u0010+\u001a\u00020,H\u0002J\u001e\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020%0*H\u0016J\b\u0010.\u001a\u00020\u0016H\u0002J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u00100\u001a\u00020 H\u0002J\u0010\u00101\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0002J\f\u00102\u001a\u000203*\u000204H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\f\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/gradle/configurationcache/DefaultEncryptionService;", "Lorg/gradle/configurationcache/EncryptionService;", "startParameter", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;", "cacheBuilderFactory", "Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;", "(Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;Lorg/gradle/cache/scopes/GlobalScopedCacheBuilderFactory;)V", "encryptionAlgorithm", "Lorg/gradle/util/internal/EncryptionAlgorithm;", "getEncryptionAlgorithm", "()Lorg/gradle/util/internal/EncryptionAlgorithm;", "encryptionAlgorithm$delegate", "Lkotlin/Lazy;", "encryptionKeyHashCode", "Lorg/gradle/internal/hash/HashCode;", "getEncryptionKeyHashCode", "()Lorg/gradle/internal/hash/HashCode;", "encryptionKeyHashCode$delegate", "isEncrypting", "", "()Z", "secretKey", "Ljavax/crypto/SecretKey;", "getSecretKey", "()Ljavax/crypto/SecretKey;", "secretKey$delegate", "assertKeyLength", "", "key", "cacheBuilderFor", "Lorg/gradle/cache/CacheBuilder;", "keySource", "Lorg/gradle/configurationcache/KeyStoreKeySource;", "decryptingInputStream", "Ljava/io/InputStream;", "inputStream", "encryptingOutputStream", "Ljava/io/OutputStream;", "outputStream", "stateType", "Lorg/gradle/configurationcache/StateType;", "input", "Lkotlin/Function0;", "newEncryptionSession", "Lorg/gradle/util/internal/EncryptionAlgorithm$Session;", "output", "produceSecretKey", "secretKeyFrom", "secretKeySource", "shouldEncryptStreams", "keyStoreFile", "Ljava/io/File;", "Lorg/gradle/cache/PersistentCache;", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nEncryptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionService.kt\norg/gradle/configurationcache/DefaultEncryptionService\n+ 2 AutoCloseableExtensions.kt\norg/gradle/configurationcache/extensions/AutoCloseableExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n21#2:261\n1#3:262\n1#3:263\n*S KotlinDebug\n*F\n+ 1 EncryptionService.kt\norg/gradle/configurationcache/DefaultEncryptionService\n*L\n104#1:261\n104#1:262\n*E\n"})
public final class DefaultEncryptionService
implements EncryptionService {
    @NotNull
    private final ConfigurationCacheStartParameter startParameter;
    @NotNull
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    @NotNull
    private final Lazy secretKey$delegate;
    @NotNull
    private final Lazy encryptionAlgorithm$delegate;
    @NotNull
    private final Lazy encryptionKeyHashCode$delegate;

    public DefaultEncryptionService(@NotNull ConfigurationCacheStartParameter startParameter, @NotNull GlobalScopedCacheBuilderFactory cacheBuilderFactory) {
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)cacheBuilderFactory, (String)"cacheBuilderFactory");
        this.startParameter = startParameter;
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.secretKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SecretKey>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SecretKey invoke() {
                SecretKey secretKey2;
                if (DefaultEncryptionService.access$getStartParameter$p(this.this$0).getEncryptionRequested()) {
                    secretKey2 = DefaultEncryptionService.access$produceSecretKey(this.this$0);
                } else {
                    DefaultConfigurationCacheKt.getLogger().warn("Encryption of the configuration cache is disabled.");
                    secretKey2 = null;
                }
                return secretKey2;
            }
        }));
        this.encryptionAlgorithm$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EncryptionAlgorithm>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EncryptionAlgorithm invoke() {
                EncryptionAlgorithm encryptionAlgorithm2 = SupportedEncryptionAlgorithm.byTransformation(DefaultEncryptionService.access$getStartParameter$p(this.this$0).getEncryptionAlgorithm());
                Intrinsics.checkNotNullExpressionValue((Object)encryptionAlgorithm2, (String)"byTransformation(startPa\u2026eter.encryptionAlgorithm)");
                return encryptionAlgorithm2;
            }
        }));
        this.encryptionKeyHashCode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HashCode>(this){
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HashCode invoke() {
                Serializable serializable;
                block3: {
                    block2: {
                        Hasher hasher;
                        serializable = DefaultEncryptionService.access$getSecretKey(this.this$0);
                        if (serializable == null) break block2;
                        SecretKey secretKey2 = serializable;
                        DefaultEncryptionService defaultEncryptionService = this.this$0;
                        SecretKey it = secretKey2;
                        boolean bl = false;
                        Hasher $this$invoke_u24lambda_u241_u24lambda_u240 = hasher = Hashing.sha512().newHasher();
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.putBytes(it.getEncoded());
                        $this$invoke_u24lambda_u241_u24lambda_u240.putString(defaultEncryptionService.getEncryptionAlgorithm().getTransformation());
                        HashCode hashCode = hasher.hash();
                        serializable = hashCode;
                        if (hashCode != null) break block3;
                    }
                    serializable = Hashing.newHasher().hash();
                }
                Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"secretKey?.let {\n       \u2026ashing.newHasher().hash()");
                return serializable;
            }
        }));
    }

    private final SecretKey getSecretKey() {
        Lazy lazy = this.secretKey$delegate;
        return (SecretKey)lazy.getValue();
    }

    private final SecretKey produceSecretKey() {
        SecretKey secretKey2;
        KeyStoreKeySource keySource = this.secretKeySource();
        boolean bl = false;
        try {
            SecretKey key = secretKey2 = this.secretKeyFrom(keySource);
            boolean bl2 = false;
            this.assertKeyLength(key);
        }
        catch (EncryptionAlgorithm.EncryptionException e) {
            if (e.getMessage() != null) {
                throw e;
            }
            throw new EncryptionAlgorithm.EncryptionException("Error loading encryption key from " + keySource.getSourceDescription(), e.getCause());
        }
        catch (Exception e) {
            throw new EncryptionAlgorithm.EncryptionException("Error loading encryption key from " + keySource.getSourceDescription(), e);
        }
        return secretKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SecretKey secretKeyFrom(KeyStoreKeySource keySource) {
        SecretKey secretKey2;
        AutoCloseable $this$useToRun$iv = this.cacheBuilderFor(keySource).withInitializer(new Action(keySource, this){
            final /* synthetic */ KeyStoreKeySource $keySource;
            final /* synthetic */ DefaultEncryptionService this$0;
            {
                this.$keySource = $keySource;
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull PersistentCache $this$withInitializer) {
                Intrinsics.checkNotNullParameter((Object)$this$withInitializer, (String)"$this$withInitializer");
                this.$keySource.createKeyStoreAndGenerateKey(DefaultEncryptionService.access$keyStoreFile(this.this$0, $this$withInitializer));
            }
        }).open();
        boolean $i$f$useToRun = false;
        AutoCloseable autoCloseable = $this$useToRun$iv;
        Throwable throwable = null;
        try {
            SecretKey secretKey3;
            AutoCloseable it$iv = autoCloseable;
            boolean bl = false;
            PersistentCache $this$secretKeyFrom_u24lambda_u242 = (PersistentCache)$this$useToRun$iv;
            boolean bl2 = false;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)$this$secretKeyFrom_u24lambda_u242, (String)"secretKeyFrom$lambda$2");
                secretKey3 = keySource.loadSecretKeyFromExistingKeystore(this.keyStoreFile($this$secretKeyFrom_u24lambda_u242));
            }
            catch (Exception loadException) {
                SecretKey secretKey4;
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)$this$secretKeyFrom_u24lambda_u242, (String)"secretKeyFrom$lambda$2");
                    secretKey4 = keySource.createKeyStoreAndGenerateKey(this.keyStoreFile($this$secretKeyFrom_u24lambda_u242));
                }
                catch (Exception e) {
                    ExceptionsKt.addSuppressed((Throwable)e, (Throwable)loadException);
                    throw e;
                }
                secretKey3 = secretKey4;
            }
            secretKey2 = secretKey3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return secretKey2;
    }

    private final CacheBuilder cacheBuilderFor(KeyStoreKeySource keySource) {
        GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory;
        GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory2;
        GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory3;
        GlobalScopedCacheBuilderFactory $this$cacheBuilderFor_u24lambda_u244 = this.cacheBuilderFactory;
        boolean bl = false;
        File file = keySource.getCustomKeyStoreDir();
        if (file != null) {
            File it = file;
            boolean bl2 = false;
            globalScopedCacheBuilderFactory3 = $this$cacheBuilderFor_u24lambda_u244.createCacheBuilderFactory(it);
        } else {
            globalScopedCacheBuilderFactory3 = null;
        }
        GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory4 = globalScopedCacheBuilderFactory2 = globalScopedCacheBuilderFactory3;
        if (globalScopedCacheBuilderFactory4 == null) {
            globalScopedCacheBuilderFactory = $this$cacheBuilderFor_u24lambda_u244;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)globalScopedCacheBuilderFactory4, (String)"keySource.customKeyStore\u2026lderFactory(it) } ?: this");
            globalScopedCacheBuilderFactory = globalScopedCacheBuilderFactory2;
        }
        CacheBuilder cacheBuilder = globalScopedCacheBuilderFactory.createCacheBuilder("cc-keystore").withDisplayName("Gradle Configuration Cache keystore");
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder, (String)"cacheBuilderFactory\n    \u2026guration Cache keystore\")");
        return cacheBuilder;
    }

    private final File keyStoreFile(PersistentCache $this$keyStoreFile) {
        return new File($this$keyStoreFile.getBaseDir(), "gradle.keystore");
    }

    private final void assertKeyLength(SecretKey key) {
        int keyLength = key.getEncoded().length;
        if (keyLength < 16) {
            throw new InvalidKeyException("Encryption key length is " + keyLength + " bytes, but must be at least 16 bytes long");
        }
    }

    @Override
    @NotNull
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        Lazy lazy = this.encryptionAlgorithm$delegate;
        return (EncryptionAlgorithm)lazy.getValue();
    }

    @Override
    public boolean isEncrypting() {
        return this.getSecretKey() != null;
    }

    @Override
    @NotNull
    public HashCode getEncryptionKeyHashCode() {
        Lazy lazy = this.encryptionKeyHashCode$delegate;
        return (HashCode)lazy.getValue();
    }

    private final boolean shouldEncryptStreams(StateType stateType) {
        return this.isEncrypting() && stateType.getEncryptable();
    }

    @Override
    @NotNull
    public OutputStream outputStream(@NotNull StateType stateType, @NotNull Function0<? extends OutputStream> output) {
        Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
        Intrinsics.checkNotNullParameter(output, (String)"output");
        return this.shouldEncryptStreams(stateType) ? this.encryptingOutputStream((OutputStream)output.invoke()) : (OutputStream)output.invoke();
    }

    @Override
    @NotNull
    public InputStream inputStream(@NotNull StateType stateType, @NotNull Function0<? extends InputStream> input) {
        Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return this.shouldEncryptStreams(stateType) ? this.decryptingInputStream((InputStream)input.invoke()) : (InputStream)input.invoke();
    }

    private final InputStream decryptingInputStream(InputStream inputStream) {
        Cipher cipher2 = this.newEncryptionSession().decryptingCipher(new EncryptionAlgorithm.IVLoader(inputStream){
            final /* synthetic */ InputStream $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void load(byte[] p0) {
                this.$tmp0.read(p0);
            }
        });
        return new CipherInputStream(inputStream, cipher2);
    }

    private final OutputStream encryptingOutputStream(OutputStream outputStream) {
        Cipher cipher2 = this.newEncryptionSession().encryptingCipher(new EncryptionAlgorithm.IVCollector(outputStream){
            final /* synthetic */ OutputStream $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void collect(byte[] p0) {
                this.$tmp0.write(p0);
            }
        });
        return new CipherOutputStream(outputStream, cipher2);
    }

    private final EncryptionAlgorithm.Session newEncryptionSession() {
        EncryptionAlgorithm.Session session = this.getEncryptionAlgorithm().newSession(this.getSecretKey());
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"encryptionAlgorithm.newSession(secretKey)");
        return session;
    }

    private final KeyStoreKeySource secretKeySource() {
        File file;
        String string2 = this.getEncryptionAlgorithm().getAlgorithm();
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encryptionAlgorithm.algorithm");
        String string4 = this.startParameter.getKeystoreDir();
        if (string4 != null) {
            String it = string4;
            String string5 = string3;
            boolean bl = false;
            file = new File(it);
            string3 = string5;
        } else {
            file = null;
        }
        String string6 = "gradle-secret";
        File file2 = file;
        String string7 = string3;
        return new KeyStoreKeySource(string7, file2, string6);
    }

    public static final /* synthetic */ File access$keyStoreFile(DefaultEncryptionService $this, PersistentCache $receiver) {
        return $this.keyStoreFile($receiver);
    }

    public static final /* synthetic */ ConfigurationCacheStartParameter access$getStartParameter$p(DefaultEncryptionService $this) {
        return $this.startParameter;
    }

    public static final /* synthetic */ SecretKey access$produceSecretKey(DefaultEncryptionService $this) {
        return $this.produceSecretKey();
    }

    public static final /* synthetic */ SecretKey access$getSecretKey(DefaultEncryptionService $this) {
        return $this.getSecretKey();
    }
}

