/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.commandline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Task;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.commandline.CommandLineTaskConfigurer;
import org.gradle.execution.selection.BuildTaskSelector;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Gradle.class)
public class CommandLineTaskParser {
    private final CommandLineTaskConfigurer taskConfigurer;
    private final BuildTaskSelector taskSelector;
    private final BuildState targetBuild;

    public CommandLineTaskParser(CommandLineTaskConfigurer commandLineTaskConfigurer, BuildTaskSelector taskSelector, BuildState targetBuild) {
        this.taskConfigurer = commandLineTaskConfigurer;
        this.taskSelector = taskSelector;
        this.targetBuild = targetBuild;
    }

    public List<TaskSelection> parseTasks(TaskExecutionRequest taskExecutionRequest) {
        ArrayList out = Lists.newArrayList();
        List<String> remainingPaths = new LinkedList<String>(taskExecutionRequest.getArgs());
        while (!remainingPaths.isEmpty()) {
            String path = (String)remainingPaths.remove(0);
            TaskSelection selection = this.taskSelector.resolveTaskName(taskExecutionRequest.getRootDir(), taskExecutionRequest.getProjectPath(), this.targetBuild, path);
            Set<Task> tasks = selection.getTasks();
            remainingPaths = this.taskConfigurer.configureTasks(tasks, remainingPaths);
            out.add(selection);
        }
        return out;
    }
}

