/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.SingleFileTreeElementMatcher;
import org.gradle.execution.plan.ValuedVfsHierarchy;
import org.gradle.internal.collect.PersistentList;
import org.gradle.internal.file.Stat;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.VfsRelativePath;

@ThreadSafe
public class ExecutionNodeAccessHierarchy {
    private volatile ValuedVfsHierarchy<NodeAccess> root;
    private final SingleFileTreeElementMatcher matcher;

    public ExecutionNodeAccessHierarchy(CaseSensitivity caseSensitivity, Stat stat) {
        this.root = ValuedVfsHierarchy.emptyHierarchy(caseSensitivity);
        this.matcher = new SingleFileTreeElementMatcher(stat);
    }

    public ImmutableSet<Node> getNodesAccessing(String location) {
        return this.visitValues(location, new CollectingNodeAccessVisitor());
    }

    public <T> T visitNodesAccessing(String location, final T initialValue, final BiFunction<T, ? super Node, T> visitor) {
        return this.visitValues(location, new AbstractNodeAccessVisitor<T>(){
            T currentValue;
            {
                this.currentValue = initialValue;
            }

            @Override
            void visit(NodeAccess value) {
                this.currentValue = visitor.apply(this.currentValue, value.getNode());
            }

            @Override
            T getResult() {
                return this.currentValue;
            }
        });
    }

    public ImmutableSet<Node> getNodesAccessing(final String location, final Spec<FileTreeElement> filter) {
        return this.visitValues(location, new CollectingNodeAccessVisitor(){

            @Override
            boolean acceptChildren(Supplier<String> relativePathSupplier) {
                String relativePathFromLocation = relativePathSupplier.get();
                return ExecutionNodeAccessHierarchy.this.matcher.elementWithRelativePathMatches(filter, new File(location, relativePathFromLocation), relativePathFromLocation);
            }
        });
    }

    public synchronized void recordNodeAccessingLocations(Node node, Iterable<String> accessedLocations) {
        for (String location : accessedLocations) {
            VfsRelativePath relativePath = VfsRelativePath.of(location);
            this.root = this.root.recordValue(relativePath, new DefaultNodeAccess(node));
        }
    }

    public synchronized void recordNodeAccessingFileTree(Node node, String fileTreeRoot, Spec<FileTreeElement> filter) {
        VfsRelativePath relativePath = VfsRelativePath.of(fileTreeRoot);
        this.root = this.root.recordValue(relativePath, new FilteredNodeAccess(node, filter));
    }

    public synchronized void clear() {
        this.root = this.root.empty();
    }

    private <T> T visitValues(String location, AbstractNodeAccessVisitor<T> visitor) {
        this.root.visitValues(location, visitor);
        return visitor.getResult();
    }

    private class FilteredNodeAccess
    implements NodeAccess {
        private final Node node;
        private final Spec<FileTreeElement> spec;

        public FilteredNodeAccess(Node node, Spec<FileTreeElement> spec) {
            this.node = node;
            this.spec = spec;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public boolean accessesChild(VfsRelativePath childPath) {
            return ExecutionNodeAccessHierarchy.this.matcher.elementWithRelativePathMatches(this.spec, new File(childPath.getAbsolutePath()), childPath.getAsString());
        }
    }

    private static class DefaultNodeAccess
    implements NodeAccess {
        private final Node node;

        public DefaultNodeAccess(Node node) {
            this.node = node;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public boolean accessesChild(VfsRelativePath childPath) {
            return true;
        }
    }

    private static interface NodeAccess {
        public Node getNode();

        public boolean accessesChild(VfsRelativePath var1);
    }

    private static class CollectingNodeAccessVisitor
    extends AbstractNodeAccessVisitor<ImmutableSet<Node>> {
        private final ImmutableSet.Builder<Node> builder = ImmutableSet.builder();

        private CollectingNodeAccessVisitor() {
        }

        @Override
        void visit(NodeAccess value) {
            this.builder.add((Object)value.getNode());
        }

        @Override
        ImmutableSet<Node> getResult() {
            return this.builder.build();
        }
    }

    private static abstract class AbstractNodeAccessVisitor<T>
    implements ValuedVfsHierarchy.ValueVisitor<NodeAccess> {
        private AbstractNodeAccessVisitor() {
        }

        @Override
        public void visitExact(NodeAccess value) {
            this.visit(value);
        }

        @Override
        public void visitAncestor(NodeAccess value, VfsRelativePath pathToVisitedLocation) {
            if (value.accessesChild(pathToVisitedLocation)) {
                this.visit(value);
            }
        }

        @Override
        public void visitChildren(PersistentList<NodeAccess> values, Supplier<String> relativePathSupplier) {
            if (this.acceptChildren(relativePathSupplier)) {
                values.forEach(this::visit);
            }
        }

        boolean acceptChildren(Supplier<String> relativePathSupplier) {
            return true;
        }

        abstract void visit(NodeAccess var1);

        abstract T getResult();
    }
}

