/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import java.util.List;
import java.util.function.Consumer;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.exceptions.CompilationFailedIndicator;
import org.gradle.internal.exceptions.ContextAwareException;
import org.gradle.internal.exceptions.ExceptionContextVisitor;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.exceptions.NonGradleCause;
import org.gradle.internal.exceptions.NonGradleCauseExceptionsHolder;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.BufferingStyledTextOutput;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.util.internal.GUtil;

public class BuildExceptionReporter
implements Action<Throwable> {
    public static final String RESOLUTION_LINE_PREFIX = "> ";
    public static final String LINE_PREFIX_LENGTH_SPACES = StringUtils.repeat((String)" ", (int)"> ".length());
    private final StyledTextOutputFactory textOutputFactory;
    private final LoggingConfiguration loggingConfiguration;
    private final BuildClientMetaData clientMetaData;
    private final GradleEnterprisePluginManager gradleEnterprisePluginManager;

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData clientMetaData, GradleEnterprisePluginManager gradleEnterprisePluginManager) {
        this.textOutputFactory = textOutputFactory;
        this.loggingConfiguration = loggingConfiguration;
        this.clientMetaData = clientMetaData;
        this.gradleEnterprisePluginManager = gradleEnterprisePluginManager;
    }

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData clientMetaData) {
        this(textOutputFactory, loggingConfiguration, clientMetaData, null);
    }

    public void buildFinished(BuildResult result2) {
        Throwable failure = result2.getFailure();
        if (failure == null) {
            return;
        }
        this.execute(failure);
    }

    @Override
    public void execute(Throwable failure) {
        if (failure instanceof MultipleBuildFailures) {
            this.renderMultipleBuildExceptions((MultipleBuildFailures)failure);
        } else {
            this.renderSingleBuildException(failure);
        }
    }

    private void renderMultipleBuildExceptions(MultipleBuildFailures failure) {
        String message = failure.getMessage();
        List<? extends Throwable> flattenedFailures = failure.getCauses();
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).format("FAILURE: %s", message);
        output.println();
        for (int i = 0; i < flattenedFailures.size(); ++i) {
            Throwable cause = flattenedFailures.get(i);
            FailureDetails details = this.constructFailureDetails("Task", cause);
            output.println();
            output.withStyle(StyledTextOutput.Style.Failure).format("%s: ", i + 1);
            details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
            output.println();
            output.text("-----------");
            this.writeFailureDetails(output, details);
            output.println("==============================================================================");
        }
    }

    private void renderSingleBuildException(Throwable failure) {
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        FailureDetails details = this.constructFailureDetails("Build", failure);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).text("FAILURE: ");
        details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
        output.println();
        this.writeFailureDetails(output, details);
    }

    private static boolean hasCauseAncestry(Throwable failure, Class<?> type) {
        for (Throwable cause = failure.getCause(); cause != null; cause = cause.getCause()) {
            if (!BuildExceptionReporter.hasCause(cause, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCause(Throwable cause, Class<?> type) {
        if (cause instanceof NonGradleCauseExceptionsHolder) {
            return ((NonGradleCauseExceptionsHolder)((Object)cause)).hasCause(type);
        }
        return false;
    }

    private ExceptionStyle getShowStackTraceOption() {
        if (this.loggingConfiguration.getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            return ExceptionStyle.FULL;
        }
        return ExceptionStyle.NONE;
    }

    private FailureDetails constructFailureDetails(String granularity, Throwable failure) {
        FailureDetails details = new FailureDetails(failure, this.getShowStackTraceOption());
        details.summary.format("%s failed with an exception.", granularity);
        this.fillInFailureResolution(details);
        if (failure instanceof ContextAwareException) {
            ((ContextAwareException)failure).accept(new ExceptionFormattingVisitor(details));
        } else {
            details.appendDetails();
        }
        details.renderStackTrace();
        return details;
    }

    private void fillInFailureResolution(FailureDetails details) {
        boolean isLessThanInfo;
        ContextImpl context = new ContextImpl(details.resolution);
        if (details.failure instanceof FailureResolutionAware) {
            ((FailureResolutionAware)((Object)details.failure)).appendResolutions(context);
        }
        BuildExceptionReporter.getResolutions(details.failure).stream().distinct().forEach(resolution -> context.appendResolution(output -> output.text(String.join((CharSequence)("\n " + LINE_PREFIX_LENGTH_SPACES), resolution.split("\n")))));
        boolean hasNonGradleSpecificCauseInAncestry = BuildExceptionReporter.hasCauseAncestry(details.failure, NonGradleCause.class);
        if (details.exceptionStyle == ExceptionStyle.NONE && !hasNonGradleSpecificCauseInAncestry) {
            context.appendResolution(output -> BuildExceptionReporter.runtWithOption(output, "stacktrace", " option to get the stack trace."));
        }
        boolean hasCompileError = hasNonGradleSpecificCauseInAncestry && BuildExceptionReporter.hasCauseAncestry(details.failure, CompilationFailedIndicator.class);
        LogLevel logLevel = this.loggingConfiguration.getLogLevel();
        boolean bl = isLessThanInfo = logLevel.ordinal() > LogLevel.INFO.ordinal();
        if (hasCompileError && isLessThanInfo) {
            context.appendResolution(output -> BuildExceptionReporter.runtWithOption(output, "info", " option to get more log output."));
        } else if (logLevel != LogLevel.DEBUG && !hasNonGradleSpecificCauseInAncestry) {
            context.appendResolution(output -> {
                output.text("Run with ");
                if (isLessThanInfo) {
                    output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "info");
                    output.text(" or ");
                }
                output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "debug");
                output.text(" option to get more log output.");
            });
        }
        if (!context.missingBuild && !this.isGradleEnterprisePluginApplied()) {
            this.addBuildScanMessage(context);
        }
        if (!hasNonGradleSpecificCauseInAncestry) {
            context.appendResolution(this::writeGeneralTips);
        }
    }

    private static void runtWithOption(StyledTextOutput output, String optionName, String text) {
        output.text("Run with ");
        output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", optionName);
        output.text(text);
    }

    private static List<String> getResolutions(Throwable throwable) {
        ImmutableList.Builder resolutions = ImmutableList.builder();
        if (throwable instanceof ResolutionProvider) {
            resolutions.addAll(((ResolutionProvider)((Object)throwable)).getResolutions());
        }
        for (Throwable throwable2 : BuildExceptionReporter.getCauses(throwable)) {
            resolutions.addAll(BuildExceptionReporter.getResolutions(throwable2));
        }
        return resolutions.build();
    }

    private static List<? extends Throwable> getCauses(Throwable cause) {
        if (cause instanceof MultiCauseException) {
            return ((MultiCauseException)((Object)cause)).getCauses();
        }
        Throwable nextCause = cause.getCause();
        return nextCause == null ? ImmutableList.of() : ImmutableList.of((Object)nextCause);
    }

    private void addBuildScanMessage(ContextImpl context) {
        context.appendResolution(output -> BuildExceptionReporter.runtWithOption(output, "scan", " to get full insights."));
    }

    private boolean isGradleEnterprisePluginApplied() {
        return this.gradleEnterprisePluginManager != null && this.gradleEnterprisePluginManager.isPresent();
    }

    private void writeGeneralTips(StyledTextOutput resolution) {
        resolution.text("Get more help at ");
        resolution.withStyle(StyledTextOutput.Style.UserInput).text("https://help.gradle.org");
        resolution.text(".");
    }

    private static String getMessage(Throwable throwable) {
        try {
            String message = throwable.getMessage();
            if (GUtil.isTrue(message)) {
                return message;
            }
            return String.format("%s (no error message)", throwable.getClass().getName());
        }
        catch (Throwable t) {
            return String.format("Unable to get message for failure of type %s due to %s", throwable.getClass().getSimpleName(), t.getMessage());
        }
    }

    private void writeFailureDetails(StyledTextOutput output, FailureDetails details) {
        BuildExceptionReporter.writeSection(details.location, output, "* Where:");
        BuildExceptionReporter.writeSection(details.details, output, "* What went wrong:");
        BuildExceptionReporter.writeSection(details.resolution, output, "* Try:");
        BuildExceptionReporter.writeSection(details.stackTrace, output, "* Exception is:");
    }

    private static void writeSection(BufferingStyledTextOutput textOutput, StyledTextOutput output, String sectionTitle) {
        if (textOutput.getHasContent()) {
            output.println();
            output.println(sectionTitle);
            textOutput.writeTo(output);
            output.println();
        }
    }

    static void renderStyledError(Throwable failure, StyledTextOutput details) {
        if (failure instanceof StyledException) {
            ((StyledException)failure).render(details);
        } else {
            details.text(BuildExceptionReporter.getMessage(failure));
        }
    }

    private class ContextImpl
    implements FailureResolutionAware.Context {
        private final BufferingStyledTextOutput resolution;
        private final DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        private boolean missingBuild;

        public ContextImpl(BufferingStyledTextOutput resolution) {
            this.resolution = resolution;
        }

        @Override
        public BuildClientMetaData getClientMetaData() {
            return BuildExceptionReporter.this.clientMetaData;
        }

        @Override
        public void doNotSuggestResolutionsThatRequireBuildDefinition() {
            this.missingBuild = true;
        }

        @Override
        public void appendResolution(Consumer<StyledTextOutput> resolutionProducer) {
            if (this.resolution.getHasContent()) {
                this.resolution.println();
            }
            this.resolution.style(StyledTextOutput.Style.Info).text(BuildExceptionReporter.RESOLUTION_LINE_PREFIX).style(StyledTextOutput.Style.Normal);
            resolutionProducer.accept(this.resolution);
        }

        @Override
        public void appendDocumentationResolution(String prefix, String userGuideId, String userGuideSection) {
            this.appendResolution(output -> output.text(this.documentationRegistry.getDocumentationRecommendationFor(prefix, userGuideId, userGuideSection)));
        }
    }

    private static class FailureDetails {
        Throwable failure;
        final BufferingStyledTextOutput summary = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput details = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput location = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput stackTrace = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput resolution = new BufferingStyledTextOutput();
        final ExceptionStyle exceptionStyle;

        public FailureDetails(Throwable failure, ExceptionStyle exceptionStyle) {
            this.failure = failure;
            this.exceptionStyle = exceptionStyle;
        }

        void appendDetails() {
            BuildExceptionReporter.renderStyledError(this.failure, this.details);
        }

        void renderStackTrace() {
            if (this.exceptionStyle == ExceptionStyle.FULL) {
                try {
                    this.stackTrace.exception(this.failure);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static class ExceptionFormattingVisitor
    extends ExceptionContextVisitor {
        private final FailureDetails failureDetails;
        private int depth;

        private ExceptionFormattingVisitor(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
        }

        @Override
        protected void visitCause(Throwable cause) {
            this.failureDetails.failure = cause;
            this.failureDetails.appendDetails();
        }

        @Override
        protected void visitLocation(String location) {
            this.failureDetails.location.text(location);
        }

        @Override
        public void node(Throwable node) {
            LinePrefixingStyledTextOutput output = this.getLinePrefixingStyledTextOutput(this.failureDetails);
            BuildExceptionReporter.renderStyledError(node, output);
        }

        @Override
        public void startChildren() {
            ++this.depth;
        }

        @Override
        public void endChildren() {
            --this.depth;
        }

        private LinePrefixingStyledTextOutput getLinePrefixingStyledTextOutput(FailureDetails details) {
            details.details.format("%n", new Object[0]);
            StringBuilder prefix = new StringBuilder(StringUtils.repeat((String)"   ", (int)(this.depth - 1)));
            details.details.text(prefix);
            prefix.append("  ");
            details.details.style(StyledTextOutput.Style.Info).text(BuildExceptionReporter.RESOLUTION_LINE_PREFIX).style(StyledTextOutput.Style.Normal);
            return new LinePrefixingStyledTextOutput(details.details, prefix, false);
        }
    }

    private static enum ExceptionStyle {
        NONE,
        FULL;

    }
}

