/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import org.gradle.internal.Cast;
import org.gradle.internal.lazy.Lazy;

public class MethodHandleUtils {
    public static MethodHandle findStaticOrThrowError(Class<?> refc, String name, MethodType methodType) {
        try {
            return MethodHandles.lookup().findStatic(refc, name, methodType);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public static <T> T invokeKotlinStaticDefault(Lazy<MethodHandle> handle, int mask, Object ... args) throws Throwable {
        Object[] argsWithDefaultMaskAndFlag = Arrays.copyOf(args, args.length + 2);
        argsWithDefaultMaskAndFlag[args.length] = mask;
        argsWithDefaultMaskAndFlag[args.length + 1] = null;
        return Cast.uncheckedCast(((MethodHandle)handle.get()).invokeWithArguments(argsWithDefaultMaskAndFlag));
    }

    public static Lazy<MethodHandle> lazyKotlinStaticDefaultHandle(Class<?> owner, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return Lazy.locking().of(() -> MethodHandleUtils.findStaticOrThrowError(owner, name + "$default", MethodHandleUtils.kotlinDefaultMethodType(returnType, parameterTypes)));
    }

    private static MethodType kotlinDefaultMethodType(Class<?> returnType, Class<?> ... parameterTypes) {
        Class<?>[] defaultParameterTypes = Arrays.copyOf(parameterTypes, parameterTypes.length + 2);
        defaultParameterTypes[parameterTypes.length] = Integer.TYPE;
        defaultParameterTypes[parameterTypes.length + 1] = Object.class;
        return MethodType.methodType(returnType, defaultParameterTypes);
    }
}

