/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.exceptions;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.api.tasks.VerificationException;
import org.gradle.groovy.scripts.ScriptCompilationException;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.exceptions.MultiCauseException;

public final class ExceptionMetadataHelper {
    private static final String METADATA_KEY_TASK_PATH = "taskPath";
    private static final String METADATA_KEY_SCRIPT_LINE_NUMBER = "scriptLineNumber";
    private static final String METADATA_KEY_SCRIPT_FILE = "scriptFile";
    private static final String METADATA_KEY_SOURCE_DISPLAY_NAME = "sourceDisplayName";
    private static final String METADATA_KEY_LOCATION = "location";
    private static final String METADATA_KEY_LINE_NUMBER = "lineNumber";
    private static final String METADATA_KEY_IS_MULTICAUSE = "isMultiCause";
    private static final String METADATA_KEY_IS_VERIFICATION_EXCEPTION = "isVerificationException";

    public static Map<String, String> getMetadata(Throwable t) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        if (t instanceof TaskExecutionException) {
            TaskExecutionException taskExecutionException = (TaskExecutionException)t;
            String taskPath = ((TaskInternal)taskExecutionException.getTask()).getIdentityPath().getPath();
            metadata.put(METADATA_KEY_TASK_PATH, taskPath);
        }
        if (t instanceof ScriptCompilationException) {
            ScriptCompilationException sce = (ScriptCompilationException)t;
            metadata.put(METADATA_KEY_SCRIPT_FILE, sce.getScriptSource().getFileName());
            Integer sceLineNumber = sce.getLineNumber();
            if (sceLineNumber != null) {
                metadata.put(METADATA_KEY_SCRIPT_LINE_NUMBER, sceLineNumber.toString());
            }
        }
        if (t instanceof LocationAwareException) {
            LocationAwareException lae = (LocationAwareException)t;
            metadata.put(METADATA_KEY_SOURCE_DISPLAY_NAME, lae.getSourceDisplayName());
            Integer laeLineNumber = lae.getLineNumber();
            if (laeLineNumber != null) {
                metadata.put(METADATA_KEY_LINE_NUMBER, laeLineNumber.toString());
            }
            metadata.put(METADATA_KEY_LOCATION, lae.getLocation());
        }
        if (t instanceof MultiCauseException) {
            metadata.put(METADATA_KEY_IS_MULTICAUSE, String.valueOf(true));
        }
        if (t instanceof VerificationException) {
            metadata.put(METADATA_KEY_IS_VERIFICATION_EXCEPTION, String.valueOf(true));
        }
        return metadata;
    }

    public static List<? extends Throwable> extractCauses(Throwable t) {
        if (t instanceof MultiCauseException) {
            MultiCauseException mce = (MultiCauseException)((Object)t);
            List<? extends Throwable> mceCauses = mce.getCauses();
            if (mceCauses != null && !mceCauses.isEmpty()) {
                return mceCauses;
            }
            return Collections.emptyList();
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            return Collections.singletonList(cause);
        }
        return Collections.emptyList();
    }

    private ExceptionMetadataHelper() {
    }
}

