/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.CompareStrategy;
import org.gradle.internal.execution.history.changes.DefaultFileChange;
import org.gradle.internal.execution.history.changes.FingerprintCompareStrategy;
import org.gradle.internal.execution.history.changes.TrivialChangeDetector;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;

public abstract class AbstractFingerprintCompareStrategy
extends CompareStrategy<FileCollectionFingerprint, FileSystemLocationFingerprint>
implements FingerprintCompareStrategy {
    public static final CompareStrategy.ChangeFactory<FileSystemLocationFingerprint> FINGERPRINT_CHANGE_FACTORY = new CompareStrategy.ChangeFactory<FileSystemLocationFingerprint>(){

        @Override
        public Change added(String path, String propertyTitle, FileSystemLocationFingerprint current) {
            return DefaultFileChange.added(path, propertyTitle, current.getType(), current.getNormalizedPath());
        }

        @Override
        public Change removed(String path, String propertyTitle, FileSystemLocationFingerprint previous) {
            return DefaultFileChange.removed(path, propertyTitle, previous.getType(), previous.getNormalizedPath());
        }

        @Override
        public Change modified(String path, String propertyTitle, FileSystemLocationFingerprint previous, FileSystemLocationFingerprint current) {
            return DefaultFileChange.modified(path, propertyTitle, previous.getType(), current.getType(), current.getNormalizedPath());
        }
    };
    private static final TrivialChangeDetector.ItemComparator<FileSystemLocationFingerprint> ITEM_COMPARATOR = new TrivialChangeDetector.ItemComparator<FileSystemLocationFingerprint>(){

        @Override
        public boolean hasSamePath(FileSystemLocationFingerprint previous, FileSystemLocationFingerprint current) {
            return previous.getNormalizedPath().equals(current.getNormalizedPath());
        }

        @Override
        public boolean hasSameContent(FileSystemLocationFingerprint previous, FileSystemLocationFingerprint current) {
            return previous.getNormalizedContentHash().equals(current.getNormalizedContentHash());
        }
    };

    public AbstractFingerprintCompareStrategy(CompareStrategy.ChangeDetector<FileSystemLocationFingerprint> changeDetector) {
        super(FileCollectionFingerprint::getFingerprints, FileCollectionFingerprint::getRootHashes, new TrivialChangeDetector<FileSystemLocationFingerprint>(ITEM_COMPARATOR, FINGERPRINT_CHANGE_FACTORY, changeDetector));
    }
}

