/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.util.internal.GUtil;

public class OutputEventTransformer
implements OutputEventListener {
    private final Map<OperationIdentifier, OperationIdentifier> effectiveProgressOperation = new ConcurrentHashMap<OperationIdentifier, OperationIdentifier>();
    private final Set<OperationIdentifier> forwarded = Collections.newSetFromMap(new ConcurrentHashMap());
    private final OutputEventListener listener;
    private final Object lock;

    public OutputEventTransformer(OutputEventListener listener2, Object lock) {
        this.listener = listener2;
        this.lock = lock;
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            ProgressStartEvent startEvent = (ProgressStartEvent)event;
            if (!startEvent.isBuildOperationStart()) {
                OperationIdentifier mappedId;
                this.forwarded.add(startEvent.getProgressOperationId());
                OperationIdentifier parentProgressOperationId = startEvent.getParentProgressOperationId();
                if (parentProgressOperationId != null && (mappedId = this.effectiveProgressOperation.get(parentProgressOperationId)) != null) {
                    startEvent = startEvent.withParentProgressOperation(mappedId);
                }
                this.invokeListener(startEvent);
                return;
            }
            if (startEvent.getParentProgressOperationId() == null || GUtil.isTrue(startEvent.getLoggingHeader()) || GUtil.isTrue(startEvent.getStatus()) || startEvent.getBuildOperationCategory() != BuildOperationCategory.UNCATEGORIZED) {
                OperationIdentifier mappedId;
                this.forwarded.add(startEvent.getProgressOperationId());
                OperationIdentifier parentProgressOperationId = startEvent.getParentProgressOperationId();
                if (parentProgressOperationId != null && (mappedId = this.effectiveProgressOperation.get(parentProgressOperationId)) != null) {
                    startEvent = startEvent.withParentProgressOperation(mappedId);
                }
                this.invokeListener(startEvent);
            } else {
                OperationIdentifier mappedParent = this.effectiveProgressOperation.get(startEvent.getParentProgressOperationId());
                if (mappedParent == null) {
                    mappedParent = startEvent.getParentProgressOperationId();
                }
                this.effectiveProgressOperation.put(startEvent.getProgressOperationId(), mappedParent);
            }
        } else if (event instanceof ProgressCompleteEvent) {
            ProgressCompleteEvent completeEvent = (ProgressCompleteEvent)event;
            OperationIdentifier mappedEvent = this.effectiveProgressOperation.remove(completeEvent.getProgressOperationId());
            if (mappedEvent == null && this.forwarded.remove(completeEvent.getProgressOperationId())) {
                this.invokeListener(event);
            }
        } else if (event instanceof ProgressEvent) {
            ProgressEvent progressEvent = (ProgressEvent)event;
            if (this.forwarded.contains(progressEvent.getProgressOperationId())) {
                this.invokeListener(event);
            }
        } else if (event instanceof RenderableOutputEvent) {
            OperationIdentifier mappedId;
            RenderableOutputEvent outputEvent = (RenderableOutputEvent)event;
            OperationIdentifier operationId = outputEvent.getBuildOperationId();
            if (operationId != null && (mappedId = this.effectiveProgressOperation.get(operationId)) != null) {
                outputEvent = outputEvent.withBuildOperationId(mappedId);
            }
            this.invokeListener(outputEvent);
        } else {
            this.invokeListener(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeListener(OutputEvent event) {
        Object object = this.lock;
        synchronized (object) {
            this.listener.onOutput(event);
        }
    }
}

