/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.model;

import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Project;
import org.gradle.api.internal.initialization.RootScriptDomainObjectContext;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Try;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.internal.resources.ProjectLeaseRegistry;

@ThreadSafe
public class CalculatedValueContainer<T, S extends ValueCalculator<? extends T>>
implements CalculatedValue<T>,
WorkNodeAction {
    private final DisplayName displayName;
    @Nullable
    private volatile CalculationState<T, S> calculationState;
    @Nullable
    private volatile Try<T> result;

    CalculatedValueContainer(DisplayName displayName, S supplier, ProjectLeaseRegistry projectLeaseRegistry, NodeExecutionContext defaultContext) {
        this.displayName = displayName;
        this.calculationState = new CalculationState(displayName, supplier, projectLeaseRegistry, defaultContext);
    }

    CalculatedValueContainer(DisplayName displayName, T value) {
        this.displayName = displayName;
        this.result = Try.successful(value);
    }

    public String toString() {
        return this.displayName.getCapitalizedDisplayName();
    }

    @Override
    public T get() throws IllegalStateException {
        return this.getValue().get();
    }

    @Override
    public T getOrNull() {
        Try<T> result2 = this.result;
        if (result2 != null) {
            return result2.get();
        }
        return null;
    }

    @Override
    public Try<T> getValue() throws IllegalStateException {
        Try<T> result2 = this.result;
        if (result2 == null) {
            throw new IllegalStateException(String.format("Value for %s has not been calculated yet.", this.displayName));
        }
        return result2;
    }

    @Override
    public boolean isFinalized() {
        return this.result != null;
    }

    public S getSupplier() throws IllegalStateException {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState == null) {
            throw new IllegalStateException(String.format("Value for %s has already been calculated.", this.displayName));
        }
        return calculationState.supplier;
    }

    @Override
    public boolean usesMutableProjectState() {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState != null) {
            return calculationState.supplier.usesMutableProjectState();
        }
        return false;
    }

    @Override
    public Project getOwningProject() {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState != null) {
            return calculationState.supplier.getOwningProject();
        }
        return null;
    }

    @Override
    public ModelContainer<?> getResourceToLock() {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState != null && calculationState.supplier.usesMutableProjectState()) {
            return calculationState.supplier.getOwningProject().getOwner();
        }
        return RootScriptDomainObjectContext.INSTANCE.getModel();
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState != null) {
            calculationState.supplier.visitDependencies(context);
        }
    }

    @Override
    @Nullable
    public WorkNodeAction getPreExecutionNode() {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState != null) {
            return calculationState.supplier.getPreExecutionAction();
        }
        return null;
    }

    @Override
    public void run(NodeExecutionContext context) {
        this.finalizeIfNotAlready(context);
    }

    @Override
    public void finalizeIfNotAlready() {
        this.finalizeIfNotAlready(null);
    }

    private void finalizeIfNotAlready(@Nullable NodeExecutionContext context) {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState == null) {
            return;
        }
        calculationState.attachValue(this, context);
    }

    private static class CalculationState<T, S extends ValueCalculator<? extends T>> {
        final ReentrantLock lock = new ReentrantLock();
        final DisplayName displayName;
        final S supplier;
        final ProjectLeaseRegistry projectLeaseRegistry;
        final NodeExecutionContext defaultContext;
        boolean done;

        public CalculationState(DisplayName displayName, S supplier, ProjectLeaseRegistry projectLeaseRegistry, NodeExecutionContext defaultContext) {
            this.displayName = displayName;
            this.supplier = supplier;
            this.projectLeaseRegistry = projectLeaseRegistry;
            this.defaultContext = defaultContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attachValue(CalculatedValueContainer<T, ?> owner, @Nullable NodeExecutionContext context) {
            this.acquireLock();
            try {
                if (this.done) {
                    return;
                }
                this.done = true;
                Try<Object> result2 = Try.ofFailable(() -> {
                    Object value;
                    NodeExecutionContext effectiveContext = context;
                    if (effectiveContext == null) {
                        effectiveContext = this.defaultContext;
                    }
                    if ((value = this.supplier.calculateValue(effectiveContext)) == null) {
                        throw new IllegalStateException(String.format("Calculated value for %s cannot be null.", this.displayName));
                    }
                    return value;
                });
                ((CalculatedValueContainer)owner).result = result2;
                ((CalculatedValueContainer)owner).calculationState = null;
            }
            finally {
                this.releaseLock();
            }
        }

        private void acquireLock() {
            if (this.lock.tryLock()) {
                return;
            }
            this.projectLeaseRegistry.blocking(this.lock::lock);
        }

        private void releaseLock() {
            this.lock.unlock();
        }
    }
}

