/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.health.DaemonHealthStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthExpirationStrategy
implements DaemonExpirationStrategy {
    public static final String ENABLE_PERFORMANCE_MONITORING = "org.gradle.daemon.performance.enable-monitoring";
    public static final String DISABLE_PERFORMANCE_LOGGING = "org.gradle.daemon.performance.disable-logging";
    public static final String EXPIRE_DAEMON_MESSAGE = "The Daemon will expire ";
    private DaemonExpirationStatus mostSevereStatus = DaemonExpirationStatus.DO_NOT_EXPIRE;
    private final Lock statusLock = new ReentrantLock();
    private final DaemonHealthStats stats;
    private final GarbageCollectorMonitoringStrategy strategy;
    private final Logger logger;

    public HealthExpirationStrategy(DaemonHealthStats stats, GarbageCollectorMonitoringStrategy strategy) {
        this(stats, strategy, LoggerFactory.getLogger(HealthExpirationStrategy.class));
    }

    HealthExpirationStrategy(DaemonHealthStats stats, GarbageCollectorMonitoringStrategy strategy, Logger logger) {
        this.stats = stats;
        this.strategy = strategy;
        this.logger = logger;
    }

    @Override
    public DaemonExpirationResult checkExpiration() {
        GarbageCollectionStats nonHeapStats;
        if (!Boolean.parseBoolean(System.getProperty(ENABLE_PERFORMANCE_MONITORING, "true"))) {
            return DaemonExpirationResult.NOT_TRIGGERED;
        }
        DaemonExpirationStatus expirationStatus = DaemonExpirationStatus.DO_NOT_EXPIRE;
        ArrayList<String> reasons = new ArrayList<String>();
        GarbageCollectionStats heapStats = this.stats.getHeapStats();
        if (heapStats.isValid() && heapStats.getEventCount() >= 5L && this.strategy.isAboveHeapUsageThreshold(heapStats.getUsedPercent())) {
            if (this.strategy.isAboveGcThrashingThreshold(heapStats.getGcRate())) {
                reasons.add("since the JVM garbage collector is thrashing");
                expirationStatus = DaemonExpirationStatus.highestPriorityOf(DaemonExpirationStatus.IMMEDIATE_EXPIRE, expirationStatus);
            } else if (this.strategy.isAboveGcRateThreshold(heapStats.getGcRate())) {
                reasons.add("after running out of JVM heap space");
                expirationStatus = DaemonExpirationStatus.highestPriorityOf(DaemonExpirationStatus.GRACEFUL_EXPIRE, expirationStatus);
            }
        }
        if ((nonHeapStats = this.stats.getNonHeapStats()).isValid() && nonHeapStats.getEventCount() >= 5L && this.strategy.isAboveNonHeapUsageThreshold(nonHeapStats.getUsedPercent())) {
            reasons.add("after running out of JVM Metaspace");
            expirationStatus = DaemonExpirationStatus.highestPriorityOf(DaemonExpirationStatus.GRACEFUL_EXPIRE, expirationStatus);
        }
        if (expirationStatus == DaemonExpirationStatus.DO_NOT_EXPIRE) {
            return DaemonExpirationResult.NOT_TRIGGERED;
        }
        String reason = Joiner.on((String)" and ").join(reasons);
        if (this.shouldPrintLog(expirationStatus)) {
            String when = expirationStatus == DaemonExpirationStatus.GRACEFUL_EXPIRE ? "after the build" : "immediately";
            String extraInfo = expirationStatus == DaemonExpirationStatus.GRACEFUL_EXPIRE ? "The daemon will restart for the next build, which may increase subsequent build times" : "The memory settings for this project must be adjusted to avoid this failure";
            String maxHeap = heapStats.isValid() ? NumberUtil.formatBytes(heapStats.getMaxSizeInBytes()) : "unknown";
            String maxMetaspace = nonHeapStats.isValid() ? NumberUtil.formatBytes(nonHeapStats.getMaxSizeInBytes()) : "unknown";
            String url = new DocumentationRegistry().getDocumentationRecommendationFor("information on how to set these values", "build_environment", "sec:configuring_jvm_memory");
            this.logger.warn(EXPIRE_DAEMON_MESSAGE + when + " " + reason + ".\nThe project memory settings are likely not configured or are configured to an insufficient value.\n" + extraInfo + ".\nThese settings can be adjusted by setting 'org.gradle.jvmargs' in 'gradle.properties'.\nThe currently configured max heap space is '" + maxHeap + "' and the configured max metaspace is '" + maxMetaspace + "'.\n" + url + "\nTo disable this warning, set '" + DISABLE_PERFORMANCE_LOGGING + "=true'.");
        }
        this.logger.debug("Daemon health: {}", (Object)this.stats.getHealthInfo());
        return new DaemonExpirationResult(expirationStatus, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldPrintLog(DaemonExpirationStatus newStatus) {
        if (Boolean.getBoolean(DISABLE_PERFORMANCE_LOGGING)) {
            return false;
        }
        try {
            this.statusLock.lock();
            DaemonExpirationStatus previous = this.mostSevereStatus;
            this.mostSevereStatus = DaemonExpirationStatus.highestPriorityOf(previous, newStatus);
            boolean bl = previous != this.mostSevereStatus;
            return bl;
        }
        finally {
            this.statusLock.unlock();
        }
    }
}

