/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

@NonNullApi
public class AlreadyOnClasspathIgnoringPluginResolver
implements PluginResolver {
    private final PluginResolver delegate;
    private final PluginDescriptorLocator pluginDescriptorLocator;

    public AlreadyOnClasspathIgnoringPluginResolver(PluginResolver delegate, PluginDescriptorLocator pluginDescriptorLocator) {
        this.delegate = delegate;
        this.pluginDescriptorLocator = pluginDescriptorLocator;
    }

    @Override
    public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result2) {
        PluginId pluginId = pluginRequest.getId();
        if (!this.isPresentOnClasspath(pluginId)) {
            this.delegate.resolve(pluginRequest, result2);
        } else {
            result2.alreadyApplied();
        }
    }

    private boolean isPresentOnClasspath(PluginId pluginId) {
        return this.pluginDescriptorLocator.findPluginDescriptor(pluginId.toString()) != null;
    }
}

