/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import java.util.Collections;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Container;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.Output;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.internal.ClassFoldersCreator;
import org.gradle.plugins.ide.eclipse.model.internal.EclipseDependenciesCreator;
import org.gradle.plugins.ide.eclipse.model.internal.SourceFoldersCreator;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.resolver.GradleApiSourcesResolver;

public class ClasspathFactory {
    private final EclipseClasspath classpath;
    private final EclipseDependenciesCreator dependenciesCreator;

    public ClasspathFactory(EclipseClasspath classpath, IdeArtifactRegistry ideArtifactRegistry, GradleApiSourcesResolver gradleApiSourcesResolver, boolean inferModulePath) {
        this.classpath = classpath;
        this.dependenciesCreator = new EclipseDependenciesCreator(classpath, ideArtifactRegistry, gradleApiSourcesResolver, inferModulePath);
    }

    public List<ClasspathEntry> createEntries() {
        ImmutableList.Builder entries = ImmutableList.builder();
        entries.add((Object)this.createOutput());
        entries.addAll(this.createSourceFolders());
        entries.addAll(this.createContainers());
        entries.addAll(this.createDependencies());
        entries.addAll(this.createClassFolders());
        return entries.build();
    }

    private ClasspathEntry createOutput() {
        return new Output(this.classpath.getProject().relativePath(this.classpath.getDefaultOutputDir()));
    }

    private List<SourceFolder> createSourceFolders() {
        return new SourceFoldersCreator().createSourceFolders(this.classpath);
    }

    private List<ClasspathEntry> createContainers() {
        return (List)this.classpath.getContainers().stream().map(Container::new).collect(ImmutableList.toImmutableList());
    }

    private List<AbstractClasspathEntry> createDependencies() {
        return this.dependenciesCreator.createDependencyEntries();
    }

    private List<? extends ClasspathEntry> createClassFolders() {
        return this.classpath.isProjectDependenciesOnly() ? Collections.emptyList() : new ClassFoldersCreator().create(this.classpath);
    }
}

