/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusSnapshot;

public class CGroupMemoryInfo
implements OsMemoryInfo {
    private static final String CGROUP_MEM_USAGE_FILE = "/sys/fs/cgroup/memory/memory.usage_in_bytes";
    private static final String CGROUP_MEM_TOTAL_FILE = "/sys/fs/cgroup/memory/memory.limit_in_bytes";

    @Override
    public OsMemoryStatus getOsSnapshot() {
        String memUsageString = this.readStringFromFile(new File(CGROUP_MEM_USAGE_FILE));
        String memTotalString = this.readStringFromFile(new File(CGROUP_MEM_TOTAL_FILE));
        return this.getOsSnapshotFromCgroup(memUsageString, memTotalString);
    }

    private String readStringFromFile(File file) {
        try {
            return Files.asCharSource((File)file, (Charset)Charset.defaultCharset()).readFirstLine();
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Unable to read system memory from " + file.getAbsoluteFile(), e);
        }
    }

    @VisibleForTesting
    OsMemoryStatusSnapshot getOsSnapshotFromCgroup(String memUsageString, String memTotalString) {
        long memAvailable;
        long memTotal;
        try {
            long memUsage = Long.parseLong(memUsageString);
            memTotal = Long.parseLong(memTotalString);
            memAvailable = Math.max(0L, memTotal - memUsage);
        }
        catch (NumberFormatException e) {
            throw new UnsupportedOperationException("Unable to read system memory", e);
        }
        return new OsMemoryStatusSnapshot(memTotal, memAvailable);
    }
}

